/*
 * Decompiled with CFR 0.152.
 */
package org.japura.gui;

import java.io.Serializable;
import java.util.Vector;
import javax.swing.ComboBoxModel;
import javax.swing.JComboBox;
import org.japura.gui.model.DefaultPriorityComboBoxModel;
import org.japura.gui.model.PriorityComboBoxModel;
import org.japura.gui.renderer.PriorityComboBoxRenderer;

public class PriorityComboBox
extends JComboBox {
    public PriorityComboBox() {
        super(new DefaultPriorityComboBoxModel());
        this.init();
    }

    public PriorityComboBox(Object[] items) {
        super(new DefaultPriorityComboBoxModel(items));
        this.init();
    }

    public PriorityComboBox(Vector<?> items) {
        super(new DefaultPriorityComboBoxModel(items));
        this.init();
    }

    private void init() {
        this.setRenderer(new PriorityComboBoxRenderer());
        this.setKeySelectionManager(new PriorityKeySelectionManager());
    }

    public PriorityComboBoxModel getModel() {
        return (PriorityComboBoxModel)super.getModel();
    }

    private static class PriorityKeySelectionManager
    implements JComboBox.KeySelectionManager,
    Serializable {
        private PriorityKeySelectionManager() {
        }

        public int selectionForKey(char aKey, ComboBoxModel aModel) {
            String v;
            Object elem;
            int i;
            int c;
            PriorityComboBoxModel model = (PriorityComboBoxModel)aModel;
            int currentSelection = -1;
            Object selectedItem = aModel.getSelectedItem();
            if (selectedItem != null) {
                c = aModel.getSize();
                for (i = 0; i < c; ++i) {
                    if (selectedItem != aModel.getElementAt(i) || i <= model.getPriorityItemsSize()) continue;
                    currentSelection = i;
                    break;
                }
            }
            String pattern = ("" + aKey).toLowerCase();
            aKey = pattern.charAt(0);
            c = aModel.getSize();
            for (i = ++currentSelection; i < c; ++i) {
                elem = aModel.getElementAt(i);
                if (elem == null || elem.toString() == null || (v = elem.toString().toLowerCase()).length() <= 0 || v.charAt(0) != aKey || i <= model.getPriorityItemsSize()) continue;
                return i;
            }
            for (i = 0; i < currentSelection; ++i) {
                elem = aModel.getElementAt(i);
                if (elem == null || elem.toString() == null || (v = elem.toString().toLowerCase()).length() <= 0 || v.charAt(0) != aKey || i <= model.getPriorityItemsSize()) continue;
                return i;
            }
            return -1;
        }
    }
}

