/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.components;

import java.awt.Graphics;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ResourceBundle;
import javax.swing.SwingWorker;
import org.apache.commons.lang3.StringUtils;
import org.tinymediamanager.core.ImageCache;
import org.tinymediamanager.core.entities.Person;
import org.tinymediamanager.ui.UTF8Control;
import org.tinymediamanager.ui.components.ImageLabel;

public class ActorImageLabel
extends ImageLabel {
    private static final long serialVersionUID = -1768796209645569296L;
    private static final ResourceBundle BUNDLE = ResourceBundle.getBundle("messages", new UTF8Control());
    protected SwingWorker<Void, Void> actorWorker = null;
    protected Person actor = null;

    public ActorImageLabel() {
        this.setAlternativeText(BUNDLE.getString("image.notfound.thumb"));
    }

    public void setActor(Person actor) {
        if (actor != null && actor != this.actor) {
            this.actor = actor;
            this.scaledImage = null;
            this.repaint();
        }
    }

    @Override
    public void setImageUrl(String newValue) {
        String oldValue = this.imageUrl;
        this.imageUrl = newValue;
        this.firePropertyChange("imageUrl", oldValue, newValue);
        if (this.worker != null && !this.worker.isDone()) {
            this.worker.cancel(true);
        }
        this.scaledImage = null;
        this.repaint();
        if (StringUtils.isEmpty((CharSequence)newValue)) {
            return;
        }
        if (this.isShowing()) {
            if (this.worker != null && !this.worker.isDone()) {
                this.worker.cancel(true);
            }
            this.worker = new ImageLabel.ImageFetcher(this, this.getSize());
            this.worker.execute();
        } else {
            this.scaledImage = null;
        }
    }

    @Override
    protected void paintComponent(Graphics g) {
        if (this.isShowing() && this.scaledImage == null && this.actor != null) {
            if (this.actorWorker != null && !this.actorWorker.isDone()) {
                this.actorWorker.cancel(true);
            }
            this.actorWorker = new ActorImageLoader(this.actor);
            this.actorWorker.execute();
        } else if (this.isShowing() && this.scaledImage == null && StringUtils.isNotBlank((CharSequence)this.imageUrl)) {
            this.worker = new ImageLabel.ImageFetcher(this, this.getSize());
            this.worker.execute();
            return;
        }
        super.paintComponent(g);
    }

    protected class ActorImageLoader
    extends SwingWorker<Void, Void> {
        private Person actor;
        private Path imagePath = null;

        public ActorImageLoader(Person actor) {
            this.actor = actor;
        }

        @Override
        protected Void doInBackground() throws Exception {
            Path p;
            if (StringUtils.isNotBlank((CharSequence)this.actor.getEntityRoot()) && (p = ImageCache.getCachedFile(this.actor.getStoragePath())) != null && Files.exists(p, new LinkOption[0])) {
                this.imagePath = p;
                return null;
            }
            if (ActorImageLabel.this.isShowing() && (p = ImageCache.getCachedFile(this.actor.getThumbUrl())) != null) {
                this.imagePath = p;
            }
            return null;
        }

        @Override
        protected void done() {
            if (this.isCancelled()) {
                return;
            }
            if (this.imagePath != null) {
                ActorImageLabel.this.setImagePath(this.imagePath.toString());
            } else if (StringUtils.isNotBlank((CharSequence)ActorImageLabel.this.imageUrl)) {
                ActorImageLabel.this.setImageUrl(this.actor.getThumbUrl());
            }
        }
    }
}

