/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.LoggerContext;
import com.jgoodies.forms.factories.FormFactory;
import com.jgoodies.forms.layout.ColumnSpec;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.forms.layout.RowSpec;
import com.sun.jna.Platform;
import java.awt.AWTEvent;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.LayoutManager;
import java.awt.Toolkit;
import java.awt.event.AWTEventListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLayeredPane;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import javax.swing.Timer;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import javax.swing.text.JTextComponent;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.SystemUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.Globals;
import org.tinymediamanager.core.Message;
import org.tinymediamanager.core.MessageManager;
import org.tinymediamanager.core.TmmModuleManager;
import org.tinymediamanager.core.UpdaterTask;
import org.tinymediamanager.core.Utils;
import org.tinymediamanager.core.WolDevice;
import org.tinymediamanager.core.threading.TmmTaskManager;
import org.tinymediamanager.thirdparty.MediaInfo;
import org.tinymediamanager.thirdparty.upnp.Upnp;
import org.tinymediamanager.ui.LightBox;
import org.tinymediamanager.ui.TmmUIHelper;
import org.tinymediamanager.ui.TmmUIMessageCollector;
import org.tinymediamanager.ui.UTF8Control;
import org.tinymediamanager.ui.actions.AboutAction;
import org.tinymediamanager.ui.actions.BugReportAction;
import org.tinymediamanager.ui.actions.ClearDatabaseAction;
import org.tinymediamanager.ui.actions.ClearImageCacheAction;
import org.tinymediamanager.ui.actions.DonateAction;
import org.tinymediamanager.ui.actions.ExitAction;
import org.tinymediamanager.ui.actions.FaqAction;
import org.tinymediamanager.ui.actions.FeedbackAction;
import org.tinymediamanager.ui.actions.ForumAction;
import org.tinymediamanager.ui.actions.LaunchUpdaterAction;
import org.tinymediamanager.ui.actions.RebuildImageCacheAction;
import org.tinymediamanager.ui.actions.RegisterDonatorVersionAction;
import org.tinymediamanager.ui.actions.SettingsAction;
import org.tinymediamanager.ui.actions.WikiAction;
import org.tinymediamanager.ui.components.StatusBar;
import org.tinymediamanager.ui.components.TextFieldPopupMenu;
import org.tinymediamanager.ui.components.VerticalTextIcon;
import org.tinymediamanager.ui.dialogs.LogDialog;
import org.tinymediamanager.ui.dialogs.MessageHistoryDialog;
import org.tinymediamanager.ui.dialogs.UpdateDialog;
import org.tinymediamanager.ui.images.Logo;
import org.tinymediamanager.ui.movies.MoviePanel;
import org.tinymediamanager.ui.moviesets.MovieSetPanel;
import org.tinymediamanager.ui.tvshows.TvShowPanel;

public class MainWindow
extends JFrame {
    private static final ResourceBundle BUNDLE = ResourceBundle.getBundle("messages", new UTF8Control());
    private static final Logger LOGGER = LoggerFactory.getLogger(MainWindow.class);
    private static final long serialVersionUID = 1L;
    public static final List<Image> LOGOS = MainWindow.createLogos();
    private static MainWindow instance;
    private JPanel panelMovies;
    private JPanel panelMovieSets;
    private JPanel panelTvShows;
    private JPanel panelStatusBar;

    public MainWindow(String name) {
        super(name);
        this.setName("mainWindow");
        this.setMinimumSize(new Dimension(1000, 700));
        instance = this;
        JMenuBar menuBar = new JMenuBar();
        this.setJMenuBar(menuBar);
        JMenu mnTmm = new JMenu("tinyMediaManager");
        mnTmm.setMnemonic(84);
        menuBar.add(mnTmm);
        if (!Globals.isDonator()) {
            mnTmm.add(new RegisterDonatorVersionAction());
        }
        mnTmm.add(new SettingsAction());
        mnTmm.addSeparator();
        mnTmm.add(new LaunchUpdaterAction());
        mnTmm.addSeparator();
        mnTmm.add(new ExitAction());
        this.initialize();
        JMenu tools = new JMenu(BUNDLE.getString("tmm.tools"));
        tools.setMnemonic(79);
        tools.add(new ClearDatabaseAction());
        JMenu cache = new JMenu(BUNDLE.getString("tmm.cache"));
        cache.setMnemonic(67);
        tools.add(cache);
        JMenuItem clearImageCache = new JMenuItem(new ClearImageCacheAction());
        clearImageCache.setMnemonic(73);
        cache.add(clearImageCache);
        JMenuItem rebuildImageCache = new JMenuItem(new RebuildImageCacheAction());
        rebuildImageCache.setMnemonic(82);
        cache.add(rebuildImageCache);
        JMenuItem tmmFolder = new JMenuItem(BUNDLE.getString("tmm.gotoinstalldir"));
        tmmFolder.setMnemonic(73);
        tools.add(tmmFolder);
        tmmFolder.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                Path path = Paths.get(System.getProperty("user.dir"), new String[0]);
                try {
                    if (Files.exists(path, new LinkOption[0])) {
                        TmmUIHelper.openFile(path);
                    }
                }
                catch (Exception ex) {
                    LOGGER.error("open filemanager", (Throwable)ex);
                    MessageManager.instance.pushMessage(new Message(Message.MessageLevel.ERROR, (Object)path, "message.erroropenfolder", new String[]{":", ex.getLocalizedMessage()}));
                }
            }
        });
        JMenuItem tmmLogs = new JMenuItem(BUNDLE.getString("tmm.errorlogs"));
        tmmLogs.setMnemonic(76);
        tools.add(tmmLogs);
        tmmLogs.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                LogDialog logDialog = new LogDialog();
                logDialog.setLocationRelativeTo(MainWindow.getActiveInstance());
                ((Dialog)logDialog).setVisible(true);
            }
        });
        JMenuItem tmmMessages = new JMenuItem(BUNDLE.getString("tmm.messages"));
        tmmMessages.setMnemonic(76);
        tools.add(tmmMessages);
        tmmMessages.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                MessageHistoryDialog messageDialog = MessageHistoryDialog.getInstance();
                ((Dialog)messageDialog).setVisible(true);
            }
        });
        tools.addSeparator();
        final JMenu menuWakeOnLan = new JMenu(BUNDLE.getString("tmm.wakeonlan"));
        menuWakeOnLan.setMnemonic(87);
        menuWakeOnLan.addMenuListener(new MenuListener(){

            @Override
            public void menuCanceled(MenuEvent arg0) {
            }

            @Override
            public void menuDeselected(MenuEvent arg0) {
            }

            @Override
            public void menuSelected(MenuEvent arg0) {
                menuWakeOnLan.removeAll();
                for (final WolDevice device : Globals.settings.getWolDevices()) {
                    JMenuItem item = new JMenuItem(device.getName());
                    item.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent arg0) {
                            Utils.sendWakeOnLanPacket(device.getMacAddress());
                        }
                    });
                    menuWakeOnLan.add(item);
                }
            }
        });
        tools.add(menuWakeOnLan);
        tools.addMenuListener(new MenuListener(){

            @Override
            public void menuSelected(MenuEvent e) {
                if (Globals.settings.getWolDevices().size() > 0) {
                    menuWakeOnLan.setEnabled(true);
                } else {
                    menuWakeOnLan.setEnabled(false);
                }
            }

            @Override
            public void menuDeselected(MenuEvent e) {
            }

            @Override
            public void menuCanceled(MenuEvent e) {
            }
        });
        if (Globals.isDebug()) {
            JMenu debugMenu = new JMenu("Debug");
            JMenuItem trace = new JMenuItem("set Logger to TRACE");
            trace.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    LoggerContext lc = (LoggerContext)LoggerFactory.getILoggerFactory();
                    lc.getLogger("org.tinymediamanager").setLevel(Level.TRACE);
                    MessageManager.instance.pushMessage(new Message("Trace levels set!", ""));
                    LOGGER.trace("if you see that, we're now on TRACE logging level ;)");
                }
            });
            debugMenu.add(trace);
            tools.add(debugMenu);
        }
        menuBar.add(tools);
        mnTmm = new JMenu(BUNDLE.getString("tmm.contact"));
        mnTmm.setMnemonic(67);
        mnTmm.add(new FeedbackAction()).setMnemonic(70);
        mnTmm.add(new BugReportAction()).setMnemonic(66);
        menuBar.add(mnTmm);
        mnTmm = new JMenu(BUNDLE.getString("tmm.help"));
        mnTmm.setMnemonic(72);
        menuBar.add(mnTmm);
        mnTmm.add(new WikiAction()).setMnemonic(87);
        mnTmm.add(new FaqAction()).setMnemonic(70);
        mnTmm.add(new ForumAction()).setMnemonic(79);
        mnTmm.addSeparator();
        mnTmm.add(new AboutAction()).setMnemonic(65);
        menuBar.add(Box.createGlue());
        if (!Globals.isDonator()) {
            JButton btnDonate = new JButton(new DonateAction());
            btnDonate.setBorderPainted(false);
            btnDonate.setFocusPainted(false);
            btnDonate.setContentAreaFilled(false);
            menuBar.add(btnDonate);
        }
        this.checkForUpdate();
    }

    private static List<Image> createLogos() {
        ArrayList<Image> logos = new ArrayList<Image>();
        logos.add(new Logo(48).getImage());
        logos.add(new Logo(64).getImage());
        logos.add(new Logo(96).getImage());
        logos.add(new Logo(128).getImage());
        logos.add(new Logo(256).getImage());
        return logos;
    }

    private void checkForUpdate() {
        try {
            final UpdaterTask updateWorker = new UpdaterTask();
            updateWorker.addPropertyChangeListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    if ("state".equals(evt.getPropertyName()) && evt.getNewValue() == SwingWorker.StateValue.DONE) {
                        try {
                            boolean update = (Boolean)updateWorker.get();
                            LOGGER.debug("update result was: " + update);
                            if (update) {
                                if (updateWorker.isForcedUpdate()) {
                                    LOGGER.info("Updating (forced)...");
                                    MainWindow.this.closeTmmAndStart(Utils.getPBforTMMupdate());
                                    return;
                                }
                                if (StringUtils.isNotBlank((CharSequence)updateWorker.getChangelog())) {
                                    UpdateDialog dialog = new UpdateDialog(updateWorker.getChangelog());
                                    dialog.setVisible(true);
                                } else {
                                    int answer = JOptionPane.showConfirmDialog(null, BUNDLE.getString("tmm.update.message"), BUNDLE.getString("tmm.update.title"), 0);
                                    if (answer == 0) {
                                        LOGGER.info("Updating...");
                                        MainWindow.this.closeTmmAndStart(Utils.getPBforTMMupdate());
                                    }
                                }
                            }
                        }
                        catch (Exception e) {
                            LOGGER.error("Update task failed!" + e.getMessage());
                        }
                    }
                }
            });
            Timer timer = new Timer(5000, new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    updateWorker.execute();
                }
            });
            timer.setRepeats(false);
            timer.start();
        }
        catch (Exception e) {
            LOGGER.error("Update task failed!" + e.getMessage());
        }
    }

    private void initialize() {
        this.setIconImages(LOGOS);
        this.setBounds(5, 5, 1100, 727);
        this.setDefaultCloseOperation(0);
        this.getContentPane().setLayout(new BorderLayout(0, 0));
        JLayeredPane content = new JLayeredPane();
        content.setLayout((LayoutManager)new FormLayout(new ColumnSpec[]{ColumnSpec.decode((String)"default:grow"), FormFactory.RELATED_GAP_COLSPEC, ColumnSpec.decode((String)"right:270px")}, new RowSpec[]{RowSpec.decode((String)"fill:max(500px;default):grow")}));
        this.getContentPane().add((Component)content, "Center");
        JPanel mainPanel = new JPanel();
        mainPanel.setLayout((LayoutManager)new FormLayout(new ColumnSpec[]{ColumnSpec.decode((String)"default:grow")}, new RowSpec[]{RowSpec.decode((String)"fill:max(500px;default):grow")}));
        content.add((Component)mainPanel, "1, 1, 3, 1, fill, fill");
        content.setLayer(mainPanel, 1);
        JTabbedPane tabbedPane = VerticalTextIcon.createTabbedPane(2);
        tabbedPane.setTabPlacement(2);
        mainPanel.add((Component)tabbedPane, "1, 1, fill, fill");
        this.panelStatusBar = new StatusBar();
        this.getContentPane().add((Component)this.panelStatusBar, "South");
        this.panelMovies = new MoviePanel();
        VerticalTextIcon.addTab(tabbedPane, BUNDLE.getString("tmm.movies"), this.panelMovies);
        this.panelMovieSets = new MovieSetPanel();
        VerticalTextIcon.addTab(tabbedPane, BUNDLE.getString("tmm.moviesets"), this.panelMovieSets);
        this.panelTvShows = new TvShowPanel();
        VerticalTextIcon.addTab(tabbedPane, BUNDLE.getString("tmm.tvshows"), this.panelTvShows);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                MainWindow.this.closeTmm();
            }
        });
        MessageManager.instance.addListener(TmmUIMessageCollector.instance);
        Toolkit.getDefaultToolkit().addAWTEventListener(new AWTEventListener(){

            @Override
            public void eventDispatched(AWTEvent arg0) {
                if (arg0 instanceof MouseEvent && 502 == arg0.getID() && arg0.getSource() instanceof JTextComponent) {
                    MouseEvent me = (MouseEvent)arg0;
                    JTextComponent tc = (JTextComponent)arg0.getSource();
                    if (me.isPopupTrigger() && tc.getComponentPopupMenu() == null) {
                        TextFieldPopupMenu.buildCutCopyPaste().show(tc, me.getX(), me.getY());
                    }
                }
            }
        }, 16L);
        if (SystemUtils.IS_JAVA_1_6) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    JOptionPane.showMessageDialog(MainWindow.this, BUNDLE.getString("tmm.java6"));
                }
            });
        }
        if (Platform.isLinux() && StringUtils.isBlank((CharSequence)MediaInfo.version())) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    JOptionPane.showMessageDialog(MainWindow.this, BUNDLE.getString("mediainfo.failed.linux"));
                }
            });
        }
    }

    public void closeTmm() {
        this.closeTmmAndStart(null);
    }

    public void closeTmmAndStart(ProcessBuilder pb) {
        int confirm = 0;
        if (TmmTaskManager.getInstance().poolRunning()) {
            confirm = JOptionPane.showOptionDialog(null, BUNDLE.getString("tmm.exit.runningtasks"), BUNDLE.getString("tmm.exit.confirmation"), 0, 3, null, null, null);
        }
        if (confirm == 0) {
            LOGGER.info("bye bye");
            try {
                Utils.trackEvent("shutdown");
                Upnp.getInstance().shutdown();
                TmmTaskManager.getInstance().shutdown();
                Globals.settings.saveSettings();
                TmmTaskManager.getInstance().shutdownNow();
                TmmModuleManager.getInstance().shutDown();
            }
            catch (Exception ex) {
                LOGGER.warn("", (Throwable)ex);
            }
            this.dispose();
            if (pb != null) {
                try {
                    LOGGER.info("Going to execute: " + pb.command());
                    pb.start();
                }
                catch (IOException e) {
                    LOGGER.error("Cannot spawn process:", (Throwable)e);
                }
            }
            System.exit(0);
        }
    }

    public static MainWindow getActiveInstance() {
        return instance;
    }

    public MoviePanel getMoviePanel() {
        return (MoviePanel)this.panelMovies;
    }

    public MovieSetPanel getMovieSetPanel() {
        return (MovieSetPanel)this.panelMovieSets;
    }

    public TvShowPanel getTvShowPanel() {
        return (TvShowPanel)this.panelTvShows;
    }

    public static JFrame getFrame() {
        return instance;
    }

    public void createLightbox(String pathToFile, String urlToFile) {
        LightBox.showLightBox(instance, pathToFile, urlToFile);
    }
}

