/*
 * Decompiled with CFR 0.152.
 */
package net.jcores.jre.cores;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.concurrent.atomic.AtomicReferenceArray;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.jcores.jre.CommonCore;
import net.jcores.jre.annotations.SupportsOption;
import net.jcores.jre.cores.Core;
import net.jcores.jre.cores.CoreClass;
import net.jcores.jre.cores.CoreMap;
import net.jcores.jre.cores.CoreNumber;
import net.jcores.jre.cores.CoreString;
import net.jcores.jre.cores.adapter.AbstractAdapter;
import net.jcores.jre.cores.adapter.ArrayAdapter;
import net.jcores.jre.cores.adapter.CollectionAdapter;
import net.jcores.jre.cores.adapter.EmptyAdapter;
import net.jcores.jre.cores.adapter.ListAdapter;
import net.jcores.jre.interfaces.functions.F0;
import net.jcores.jre.interfaces.functions.F1;
import net.jcores.jre.interfaces.functions.F1Object2Bool;
import net.jcores.jre.interfaces.functions.F2DeltaObjects;
import net.jcores.jre.interfaces.functions.F2ReduceObjects;
import net.jcores.jre.interfaces.functions.Fn;
import net.jcores.jre.managers.ManagerDebugGUI;
import net.jcores.jre.managers.ManagerDeveloperFeedback;
import net.jcores.jre.options.Args;
import net.jcores.jre.options.InvertSelection;
import net.jcores.jre.options.KillSwitch;
import net.jcores.jre.options.MapType;
import net.jcores.jre.options.MessageType;
import net.jcores.jre.options.Option;
import net.jcores.jre.utils.Async;
import net.jcores.jre.utils.internal.Objects;
import net.jcores.jre.utils.internal.Options;
import net.jcores.jre.utils.internal.Streams;
import net.jcores.jre.utils.internal.processing.Folder;
import net.jcores.jre.utils.internal.processing.Mapper;
import net.jcores.jre.utils.internal.wrapper.Wrapper;
import net.jcores.jre.utils.map.Compound;

public class CoreObject<T>
extends Core
implements Iterable<T> {
    private static final long serialVersionUID = -6436821141631907999L;
    protected final AbstractAdapter<T> adapter;

    public CoreObject(CommonCore commonCore, Class<?> clazz, T t) {
        super(commonCore);
        this.adapter = t != null ? new ArrayAdapter<Object>(t) : new EmptyAdapter();
    }

    public CoreObject(CommonCore commonCore, T ... TArray) {
        super(commonCore);
        this.adapter = new ArrayAdapter<T>(TArray);
    }

    public CoreObject(CommonCore commonCore, List<T> list) {
        super(commonCore);
        this.adapter = list instanceof ArrayList ? new ListAdapter<T>(list) : new CollectionAdapter<T, T>(list);
    }

    public CoreObject(CommonCore commonCore, Collection<T> collection) {
        super(commonCore);
        this.adapter = collection instanceof ArrayList ? new ListAdapter((List)collection) : new CollectionAdapter<T, T>(collection);
    }

    public CoreObject(CommonCore commonCore, CoreObject<T> coreObject) {
        super(commonCore);
        this.adapter = coreObject.adapter;
    }

    public CoreObject(CommonCore commonCore, AbstractAdapter<T> abstractAdapter) {
        super(commonCore);
        this.adapter = abstractAdapter;
    }

    public CoreObject<T> add(CoreObject<T> coreObject) {
        if (this.size() == 0) {
            return coreObject;
        }
        if (coreObject.size() == 0) {
            return this;
        }
        Class<?> clazz = this.adapter.clazz();
        Object[] objectArray = (Object[])Array.newInstance(clazz, this.size() + coreObject.size());
        ?[] objArray = this.adapter.array(clazz);
        ?[] objArray2 = coreObject.adapter.array(clazz);
        System.arraycopy(objArray, 0, objectArray, 0, objArray.length);
        System.arraycopy(objArray2, 0, objectArray, objArray.length, objArray2.length);
        return new CoreObject<Object>(this.commonCore, objectArray);
    }

    public CoreObject<T> add(T ... TArray) {
        return this.add(new CoreObject<T>(this.commonCore, TArray));
    }

    public <N> N[] array(Class<N> clazz) {
        return this.adapter.array(clazz);
    }

    public <C extends Core> C as(Class<C> clazz) {
        try {
            Constructor<?>[] constructorArray = clazz.getConstructors();
            Constructor<?> constructor = null;
            for (Constructor<?> constructor2 : constructorArray) {
                if (constructor2.getParameterTypes().length != 2 || !constructor2.getParameterTypes()[0].equals(CommonCore.class) || !constructor2.getParameterTypes()[1].equals(AbstractAdapter.class)) continue;
                if (constructor != null) {
                    System.err.println("There should only be one constructor with (CommonCore.class, AbstractAdapter.class) per core! And here comes your exception ... ;-)");
                }
                constructor = constructor2;
            }
            return (C)((Core)constructor.newInstance(this.commonCore, this.adapter));
        }
        catch (SecurityException securityException) {
            securityException.printStackTrace();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            illegalArgumentException.printStackTrace();
        }
        catch (InstantiationException instantiationException) {
            instantiationException.printStackTrace();
        }
        catch (IllegalAccessException illegalAccessException) {
            illegalAccessException.printStackTrace();
        }
        catch (InvocationTargetException invocationTargetException) {
            invocationTargetException.printStackTrace();
        }
        catch (NullPointerException nullPointerException) {
            this.commonCore.report(MessageType.EXCEPTION, "No constructor found for " + clazz);
            System.err.println("No suitable constructor found!");
        }
        return null;
    }

    @SupportsOption(options={KillSwitch.class})
    public <R> Async<R> async(final F1<T, R> f1, Option ... optionArray) {
        final Async.Queue queue = Async.Queue();
        Async async = new Async(this.commonCore, queue);
        final Options options = Options.$(this.commonCore, optionArray);
        final KillSwitch killSwitch = options.killswitch();
        this.commonCore.sys.oneTime(new F0(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void f() {
                try {
                    for (Object e : CoreObject.this) {
                        if (killSwitch != null && killSwitch.terminated()) {
                            return;
                        }
                        try {
                            queue.add(Async.QEntry(f1.f(e)));
                        }
                        catch (Exception exception) {
                            CoreObject.this.commonCore.report(MessageType.EXCEPTION, "Exception when processing " + e + " ... " + exception.getMessage());
                            options.failure(e, exception, "for/f", "Unknown exception when processing element");
                        }
                    }
                }
                finally {
                    queue.close();
                }
            }
        }, 0L, optionArray);
        return async;
    }

    public <N> CoreObject<N> cast(final Class<N> clazz) {
        return this.map(new F1<T, N>(){

            @Override
            public N f(T t) {
                if (clazz.isAssignableFrom(t.getClass())) {
                    return t;
                }
                return null;
            }
        }, MapType.TYPE(clazz));
    }

    public CoreObject<Object> call(final String string, final Object ... objectArray) {
        String string2;
        int n;
        int n2 = objectArray == null ? 0 : objectArray.length;
        final Class[] classArray = new Class[n2];
        final CommonCore commonCore = this.commonCore;
        for (n = 0; n < n2; ++n) {
            classArray[n] = objectArray[n].getClass();
        }
        n = string.endsWith("()") ? 1 : 0;
        String string3 = string2 = n != 0 ? string.substring(0, string.length() - 2) : string;
        if (n != 0) {
            return this.map(new F1<T, Object>(){

                @Override
                public Object f(T t) {
                    try {
                        Method method = t.getClass().getDeclaredMethod(string2, classArray);
                        method.setAccessible(true);
                        return method.invoke(t, objectArray);
                    }
                    catch (SecurityException securityException) {
                        commonCore.report(MessageType.EXCEPTION, "SecurityException for " + t + " (method was " + string + ")");
                    }
                    catch (NoSuchMethodException noSuchMethodException) {
                        commonCore.report(MessageType.EXCEPTION, "NoSuchMethodException for " + t + " (method was " + string + ")");
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        commonCore.report(MessageType.EXCEPTION, "IllegalArgumentException for " + t + " (method was " + string + ")");
                    }
                    catch (IllegalAccessException illegalAccessException) {
                        commonCore.report(MessageType.EXCEPTION, "IllegalAccessException for " + t + " (method was " + string + ")");
                    }
                    catch (InvocationTargetException invocationTargetException) {
                        commonCore.report(MessageType.EXCEPTION, "InvocationTargetException for " + t + " (method was " + string + ")");
                    }
                    return null;
                }
            }, new Option[0]);
        }
        return this.map(new F1<T, Object>(){

            @Override
            public Object f(T t) {
                try {
                    Field field = t.getClass().getDeclaredField(string2);
                    field.setAccessible(true);
                    return field.get(t);
                }
                catch (SecurityException securityException) {
                    commonCore.report(MessageType.EXCEPTION, "SecurityException for " + t + " (method was " + string + ")");
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    commonCore.report(MessageType.EXCEPTION, "IllegalArgumentException for " + t + " (method was " + string + ")");
                }
                catch (IllegalAccessException illegalAccessException) {
                    commonCore.report(MessageType.EXCEPTION, "IllegalAccessException for " + t + " (method was " + string + ")");
                }
                catch (NoSuchFieldException noSuchFieldException) {
                    noSuchFieldException.printStackTrace();
                }
                return null;
            }
        }, new Option[0]);
    }

    @SupportsOption(options={})
    public CoreObject<T> serialize(String string, Option ... optionArray) {
        try {
            Streams.serializeCore(this, new FileOutputStream(new File(string)));
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
        }
        return this;
    }

    public <W> CoreObject<W> wrap(final Class<W> clazz) {
        final CoreClass coreClass = new CoreClass(this.commonCore, clazz);
        return this.forEach(new F1<T, W>(){

            @Override
            public W f(T t) {
                if (clazz.isAssignableFrom(t.getClass())) {
                    return t;
                }
                return coreClass.spawn(Args.WRAP(t)).get(false);
            }
        }, new Option[0]);
    }

    public CoreClass<T> clazz() {
        return new CoreClass(this.commonCore, this.map(new F1<T, Class<T>>(){

            @Override
            public Class<T> f(T t) {
                return t.getClass();
            }
        }, new Option[0]).array(Class.class));
    }

    public CoreObject<T> compact() {
        if (this.size() == 0) {
            return this;
        }
        T[] TArray = this.adapter.array();
        int n = 0;
        for (Object e : this) {
            if (e == null) continue;
            TArray[n++] = e;
        }
        return new CoreObject<T>(this.commonCore, new ArrayAdapter<T>(n, TArray));
    }

    public Compound compound() {
        return Compound.create(this.adapter.array());
    }

    public boolean contains(T t) {
        for (Object e : this) {
            if (e != null && e.equals(t)) {
                return true;
            }
            if (e != null || t != null) continue;
            return true;
        }
        return false;
    }

    public CoreMap<T, Integer> count() {
        HashMap hashMap = new HashMap();
        for (Object e : this) {
            if (e == null) continue;
            if (hashMap.containsKey(e)) {
                hashMap.put(e, (Integer)hashMap.get(e) + 1);
                continue;
            }
            hashMap.put(e, 1);
        }
        return new CoreMap(this.commonCore, Wrapper.convert(hashMap));
    }

    public CoreObject<T> debug() {
        System.out.println(this.fingerprint(false));
        ManagerDebugGUI managerDebugGUI = this.commonCore.manager(ManagerDebugGUI.class);
        return this;
    }

    @SupportsOption(options={MapType.class})
    public <R> CoreObject<R> delta(final F2DeltaObjects<T, R> f2DeltaObjects, Option ... optionArray) {
        final int n = this.size();
        Mapper mapper = new Mapper<T, R>(this, optionArray){

            @Override
            public void handle(int n2) {
                if (n2 == n - 1) {
                    return;
                }
                Object[] objectArray = (Object[])this.returnArray.get();
                Object t = CoreObject.this.adapter.get(n2);
                Object t2 = CoreObject.this.adapter.get(n2 + 1);
                if (t == null || t2 == null) {
                    return;
                }
                Object y = f2DeltaObjects.f(t, t2);
                if (y == null) {
                    return;
                }
                if (objectArray == null) {
                    objectArray = this.updateReturnArray((Object[])Array.newInstance(y.getClass(), n));
                }
                objectArray[n2] = y;
            }
        };
        this.map(mapper, optionArray);
        return new CoreObject(this.commonCore, new ArrayAdapter(n - 1, mapper.getFinalReturnArray()));
    }

    public <X> X each(Class<X> clazz) {
        if (clazz == null || !clazz.isInterface()) {
            System.err.println("You must pass an interface.");
            return null;
        }
        final CoreObject<X> coreObject = this.cast(clazz);
        return (X)Objects.getProxy(new InvocationHandler(){

            @Override
            public Object invoke(Object object, final Method method, final Object[] objectArray) throws Throwable {
                coreObject.map(new F1<X, Object>(){

                    @Override
                    public Object f(X x) {
                        try {
                            method.invoke(x, objectArray);
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            illegalArgumentException.printStackTrace();
                        }
                        catch (IllegalAccessException illegalAccessException) {
                            illegalAccessException.printStackTrace();
                        }
                        catch (InvocationTargetException invocationTargetException) {
                            invocationTargetException.printStackTrace();
                        }
                        return null;
                    }
                }, new Option[0]);
                return null;
            }
        }, clazz);
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof CoreObject)) {
            return false;
        }
        CoreObject coreObject = (CoreObject)object;
        if (this.size() != coreObject.size()) {
            return false;
        }
        Iterator iterator = this.adapter.iterator();
        Iterator iterator2 = coreObject.adapter.iterator();
        while (iterator.hasNext()) {
            boolean bl;
            Object e = iterator.next();
            Object e2 = iterator2.next();
            if (e == null && e2 != null) {
                return false;
            }
            if (e == null && e2 == null || (bl = e.equals(e2))) continue;
            return false;
        }
        return true;
    }

    public <N> CoreObject<N> expand(Class<N> clazz) {
        int n = 0;
        if (this.size() == 0) {
            return new CoreObject<Object>(this.commonCore, clazz, null);
        }
        for (Object e : this) {
            if (e == null) continue;
            if (e instanceof Collection) {
                n += ((Collection)e).size();
                continue;
            }
            if (e instanceof CoreObject) {
                n += ((CoreObject)e).size();
                continue;
            }
            try {
                n += Array.getLength(e);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                ++n;
            }
        }
        Object[] objectArray = (Object[])Array.newInstance(clazz, n);
        int n2 = 0;
        for (Object e : this) {
            if (e == null) continue;
            if (e instanceof Collection) {
                Object[] objectArray2 = ((Collection)e).toArray();
                System.arraycopy(objectArray2, 0, objectArray, n2, objectArray2.length);
                n2 += objectArray2.length;
                continue;
            }
            if (e instanceof CoreObject) {
                Object[] objectArray3 = ((CoreObject)e).array(Object.class);
                System.arraycopy(objectArray3, 0, objectArray, n2, objectArray3.length);
                n2 += objectArray3.length;
                continue;
            }
            try {
                int n3 = Array.getLength(e);
                System.arraycopy(e, 0, objectArray, n2, n3);
                n2 += n3;
                continue;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                indexOutOfBoundsException.printStackTrace();
            }
            catch (ArrayStoreException arrayStoreException) {
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            Array.set(objectArray, n2++, e);
        }
        return new CoreObject<Object>(this.commonCore, objectArray);
    }

    public void featurerequest(String string) {
        this.commonCore.manager(ManagerDeveloperFeedback.class).featurerequest(string, this.getClass(), this.fingerprint(true));
    }

    public CoreObject<T> fill(T t) {
        if (this.size() == 0) {
            return this;
        }
        T[] TArray = this.adapter.array();
        for (int i = 0; i < TArray.length; ++i) {
            TArray[i] = TArray[i] == null ? t : TArray[i];
        }
        return new CoreObject<T>(this.commonCore, TArray);
    }

    @SupportsOption(options={InvertSelection.class})
    public CoreObject<T> filter(final F1Object2Bool<T> f1Object2Bool, Option ... optionArray) {
        final boolean bl = Options.$(this.commonCore, optionArray).invert();
        CoreObject coreObject = this.map(new F1<T, T>(){

            @Override
            public T f(T t) {
                boolean bl2 = f1Object2Bool.f(t);
                if (!bl && bl2 || bl == !bl2) {
                    return t;
                }
                return null;
            }
        }, new Option[0]);
        return coreObject.compact();
    }

    public CoreObject<T> filter(String string, Option ... optionArray) {
        final Pattern pattern = Pattern.compile(string);
        return this.filter(new F1Object2Bool<T>(){

            @Override
            public boolean f(T t) {
                Matcher matcher = pattern.matcher(t.toString());
                return matcher.matches();
            }
        }, optionArray);
    }

    public T first() {
        for (Object e : this) {
            if (e == null) continue;
            return (T)e;
        }
        return null;
    }

    protected String fingerprint(boolean bl) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("@(");
        stringBuilder.append(this.getClass().getSimpleName());
        stringBuilder.append("; outerSize:");
        stringBuilder.append(this.size());
        stringBuilder.append("; innerSize:");
        Object object = null;
        int n = 0;
        for (Object e : this) {
            if (e == null) continue;
            ++n;
            if (object != null) continue;
            object = e;
        }
        stringBuilder.append(n);
        if (object != null && bl) {
            stringBuilder.append("; firstElement:");
            stringBuilder.append(object.getClass().getSimpleName());
        }
        if (this.size() <= 16) {
            stringBuilder.append("; fingerprint:");
            for (Object e : this) {
                if (e != null) {
                    stringBuilder.append(e.getClass().getSimpleName().charAt(0));
                    continue;
                }
                stringBuilder.append(".");
            }
        }
        stringBuilder.append(")");
        return stringBuilder.toString();
    }

    @SupportsOption(options={MapType.class})
    public CoreObject<T> fold(final F2ReduceObjects<T> f2ReduceObjects, Option ... optionArray) {
        if (this.size() <= 1) {
            return this;
        }
        final AtomicReferenceArray<T> atomicReferenceArray = new AtomicReferenceArray<T>(this.adapter.array());
        Folder folder = new Folder<T>(this){

            @Override
            public void handle(int n, int n2, int n3) {
                Object e = atomicReferenceArray.get(n);
                Object e2 = atomicReferenceArray.get(n2);
                if (e == null && e2 == null) {
                    return;
                }
                if (e == null && e2 != null) {
                    atomicReferenceArray.set(n3, e2);
                    return;
                }
                if (e != null && e2 == null) {
                    atomicReferenceArray.set(n3, e);
                    return;
                }
                atomicReferenceArray.set(n3, f2ReduceObjects.f(e, e2));
            }
        };
        this.fold(folder, optionArray);
        Object[] objectArray = (Object[])Array.newInstance(this.adapter.clazz(), 1);
        objectArray[0] = atomicReferenceArray.get(0);
        return new CoreObject<Object>(this.commonCore, objectArray);
    }

    public <R> CoreObject<R> forEach(F1<T, R> f1, Option ... optionArray) {
        Mapper mapper = this.mapper(f1, optionArray);
        for (int i = 0; i < this.size(); ++i) {
            mapper.handle(i);
        }
        return new CoreObject(this.commonCore, mapper.getFinalReturnArray());
    }

    public <R> CoreObject<R> forEach(Fn<T, R> fn, int n) {
        if (this.size() == 0) {
            return new CoreObject<Object>(this.commonCore, null, null);
        }
        Object[] objectArray = null;
        Object[] objectArray2 = (Object[])Array.newInstance(this.adapter.clazz(), n);
        int n2 = 0;
        int n3 = 0;
        for (int i = 0; i < this.size(); ++i) {
            T t = this.adapter.get(i);
            if (t == null) continue;
            objectArray2[n2++] = t;
            if (n2 < n) continue;
            R r = fn.f(objectArray2);
            if (objectArray == null && r != null) {
                objectArray = (Object[])Array.newInstance(r.getClass(), this.size() / n);
            }
            if (objectArray != null) {
                objectArray[n3] = r;
            }
            ++n3;
            n2 = 0;
        }
        return new CoreObject<T>(this.commonCore, objectArray);
    }

    public T get(double d, T t) {
        if (Double.isNaN(d)) {
            return t;
        }
        if (d < 0.0) {
            return t;
        }
        if (d > 1.0) {
            return t;
        }
        if (this.size() == 0) {
            return t;
        }
        int n = (int)(d * (double)this.size());
        if (n >= this.size()) {
            return t;
        }
        return this.adapter.get(n);
    }

    public T get(double d) {
        return this.get(d, null);
    }

    public <X extends T> X get(Class<X> clazz, X x) {
        for (Object e : this.adapter) {
            if (e == null || !clazz.isAssignableFrom(e.getClass())) continue;
            return (X)e;
        }
        return x;
    }

    public T get(int n) {
        int n2 = this.indexToOffset(n);
        if (n2 < 0 || n2 > this.size()) {
            return null;
        }
        return this.adapter.get(n2);
    }

    public T get(int n, T t) {
        int n2 = this.get((T)n);
        return n2 == null ? t : (T)n2;
    }

    public T get(T t) {
        return this.get(0, t);
    }

    public int hashCode() {
        return this.adapter.hashCode();
    }

    public boolean hasAll() {
        if (this.size() == 0) {
            return false;
        }
        for (Object e : this) {
            if (e != null) continue;
            return false;
        }
        return true;
    }

    public boolean hasAny() {
        for (Object e : this) {
            if (e == null) continue;
            return true;
        }
        return false;
    }

    public CoreObject<T> ifAll(F0 f0) {
        if (this.hasAll()) {
            f0.f();
        }
        return this;
    }

    public CoreNumber index(T ... TArray) {
        if (TArray == null) {
            return new CoreNumber(this.commonCore, new Number[0]);
        }
        Number[] numberArray = new Integer[TArray.length];
        block0: for (int i = 0; i < TArray.length; ++i) {
            T t = TArray[i];
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                int n = iterator.nextIndex();
                Object e = iterator.next();
                if (t != null && t.equals(e)) {
                    numberArray[i] = n;
                    continue block0;
                }
                if (t != null || e != null) continue;
                numberArray[i] = n;
                continue block0;
            }
        }
        return new CoreNumber(this.commonCore, numberArray);
    }

    public CoreObject<T> intersect(CoreObject<T> coreObject) {
        if (this.size() == 0) {
            return this;
        }
        if (coreObject.size() == 0) {
            return coreObject;
        }
        T[] TArray = this.adapter.array();
        for (int i = 0; i < TArray.length; ++i) {
            T t = TArray[i];
            if (t == null) continue;
            boolean bl = false;
            for (Object e : coreObject) {
                if (e == null || !e.equals(t)) continue;
                bl = true;
                break;
            }
            if (bl) continue;
            TArray[i] = null;
        }
        return new CoreObject<T>(this.commonCore, TArray).compact();
    }

    public CoreObject<T> intersect(T ... TArray) {
        return this.intersect(new CoreObject<T>(this.commonCore, TArray));
    }

    public List<T> list() {
        return new ArrayList<T>(this.adapter.unsafelist());
    }

    @SupportsOption(options={MapType.class})
    public <R> CoreObject<R> map(F1<T, R> f1, Option ... optionArray) {
        Mapper mapper = this.mapper(f1, optionArray);
        this.map(mapper, optionArray);
        return new CoreObject(this.commonCore, mapper.getFinalReturnArray());
    }

    public CoreObject<T> print() {
        if (this.size() == 0) {
            return this;
        }
        for (Object e : this) {
            if (e == null) continue;
            System.out.println(e);
        }
        return this;
    }

    public CoreObject<T> print(String string) {
        System.out.println(this.string().join(string));
        return this;
    }

    public T random() {
        int n = this.size();
        if (n == 0) {
            return null;
        }
        return this.adapter.get(this.commonCore.random().nextInt(n));
    }

    public CoreObject<T> random(double d) {
        double d2 = Math.max(Math.min(1.0, d), 0.0);
        return this.random((int)(d2 * (double)this.size()));
    }

    public CoreObject<T> random(int n) {
        int n2 = this.size();
        if (n2 == 0) {
            return this;
        }
        T[] TArray = this.adapter.array();
        for (int i = TArray.length - 1; i >= 1; --i) {
            int n3 = this.commonCore.random().nextInt(i + 1);
            T t = TArray[n3];
            TArray[n3] = TArray[i];
            TArray[i] = t;
        }
        return new CoreObject<T>(this.commonCore, Arrays.copyOfRange(TArray, 0, n));
    }

    @SupportsOption(options={MapType.class})
    public CoreObject<T> reduce(F2ReduceObjects<T> f2ReduceObjects, Option ... optionArray) {
        Object object = null;
        for (Object e : this) {
            if (e == null) continue;
            if (object == null) {
                object = e;
                continue;
            }
            object = f2ReduceObjects.f(object, e);
        }
        Class<?> clazz = object != null ? object.getClass() : null;
        return new CoreObject<Object>(this.commonCore, clazz, object);
    }

    public CoreObject<T> reverse() {
        int n = this.size();
        if (n == 0) {
            return this;
        }
        T[] TArray = this.adapter.array();
        for (int i = 0; i < n; ++i) {
            TArray[n - i] = this.adapter.get(i);
        }
        return new CoreObject<T>(this.commonCore, TArray);
    }

    @Override
    public int size() {
        return this.adapter.size();
    }

    public CoreObject<T> slice(int n, int n2) {
        List<T> list;
        int n3;
        if (this.size() == 0) {
            return this;
        }
        if (n2 == 0) {
            return new CoreObject(this.commonCore, new EmptyAdapter());
        }
        int n4 = this.indexToOffset(n);
        int n5 = n3 = n2 > 0 ? n2 : this.indexToOffset(n2) - n4 + 1;
        if (n4 < 0 || n4 >= this.size()) {
            this.commonCore.report(MessageType.MISUSE, "slice() - converted parameter start(" + n + " -> " + n4 + ") is outside bounds. Returning empty slice.");
            return new CoreObject(this.commonCore, new EmptyAdapter());
        }
        if (n3 < 0 || n4 + n3 > this.size()) {
            if (n3 < 0) {
                this.commonCore.report(MessageType.MISUSE, "slice() - converted parameter length(" + n2 + " -> " + n3 + ") is outside bounds. Returning empty slice.");
                return new CoreObject(this.commonCore, new EmptyAdapter());
            }
            this.commonCore.report(MessageType.MISUSE, "slice() - converted parameter length(" + n2 + " -> " + n3 + ") is outside bounds. Truncating.");
            n3 -= n4 + n3 - this.size();
        }
        if ((list = this.adapter.slice(n4, n4 + n3)) instanceof AbstractAdapter) {
            return new CoreObject<T>(this.commonCore, (AbstractAdapter)((Object)list));
        }
        return new CoreObject<T>(this.commonCore, list);
    }

    public CoreObject<T> slice(double d, double d2) {
        if (this.size() == 0) {
            return this;
        }
        if (d > d2) {
            return this.slice(0, 0);
        }
        double d3 = this.commonCore.alg.limit(0.0, d, 1.0);
        double d4 = this.commonCore.alg.limit(0.0, d2, 1.0);
        int n = this.size();
        int n2 = (int)(d3 * (double)n);
        int n3 = (int)(d4 * (double)n);
        return this.slice(n2, n3 - n2);
    }

    public CoreObject<T> sort(Comparator<T> comparator) {
        if (this.size() == 0) {
            return this;
        }
        T[] TArray = this.adapter.array();
        Arrays.sort(TArray, comparator);
        return new CoreObject<T>(this.commonCore, TArray);
    }

    public CoreObject<T> sort() {
        if (this.size() == 0) {
            return this;
        }
        Object[] objectArray = this.adapter.array();
        try {
            Arrays.sort(objectArray);
        }
        catch (ClassCastException classCastException) {
            this.commonCore.report(MessageType.EXCEPTION, "Unable to sort core, elements not comparable: " + this.fingerprint(true));
            return this;
        }
        catch (NullPointerException nullPointerException) {
            this.commonCore.report(MessageType.PERFORMANCE, "Make sure cores are compact() before sorting them: " + this.fingerprint(true));
            return this.compact().sort();
        }
        return new CoreObject<Object>(this.commonCore, objectArray);
    }

    public CoreString string() {
        return this.map(new F1<T, String>(){

            @Override
            public String f(T t) {
                return t.toString();
            }
        }, new Option[0]).as(CoreString.class);
    }

    public CoreObject<T> subtract(CoreObject<T> coreObject) {
        if (this.size() == 0 || coreObject.size() == 0) {
            return this;
        }
        T[] TArray = this.adapter.array();
        for (int i = 0; i < coreObject.size(); ++i) {
            int n = coreObject.get(i);
            if (n == null) continue;
            for (int j = 0; j < TArray.length; ++j) {
                T t = TArray[j];
                if (t == null || !t.equals(n)) continue;
                TArray[j] = null;
            }
        }
        return new CoreObject<T>(this.commonCore, TArray);
    }

    public CoreObject<T> subtract(T ... TArray) {
        return this.subtract(new CoreObject<T>(this.commonCore, TArray));
    }

    public CoreObject<T> unique() {
        if (this.size() == 0) {
            return this;
        }
        T[] TArray = this.adapter.array();
        block0: for (int i = 1; i < TArray.length; ++i) {
            if (TArray[i] == null) continue;
            for (int j = 0; j < i; ++j) {
                if (!TArray[i].equals(TArray[j])) continue;
                TArray[i] = null;
                continue block0;
            }
        }
        return new CoreObject<T>(this.commonCore, TArray).compact();
    }

    public T[] unsafearray() {
        return this.adapter.unsafearray();
    }

    public List<T> unsafelist() {
        return this.adapter.unsafelist();
    }

    public AbstractAdapter<T> unsafeadapter() {
        return this.adapter;
    }

    protected final int indexToOffset(int n) {
        int n2 = this.size();
        if (n >= n2) {
            return -1;
        }
        if (n < 0) {
            if (-n > n2) {
                return -1;
            }
            return n2 + n;
        }
        return n;
    }

    protected final <R> Mapper mapper(final F1<T, R> f1, Option ... optionArray) {
        return new Mapper<T, R>(this, optionArray){

            @Override
            public void handle(int n) {
                Object y;
                Object[] objectArray = (Object[])this.returnArray.get();
                Object t = CoreObject.this.adapter.get(n);
                if (t == null) {
                    return;
                }
                if (this.options.indexer != null) {
                    this.options.indexer.i(n);
                }
                if ((y = f1.f(t)) == null) {
                    return;
                }
                if (objectArray == null) {
                    objectArray = this.updateReturnArray((Object[])Array.newInstance(y.getClass(), this.core.size()));
                }
                objectArray[n] = y;
            }
        };
    }

    @Override
    public ListIterator<T> iterator() {
        return this.adapter.iterator();
    }
}

