/*
 * Decompiled with CFR 0.152.
 */
package com.uwetrottmann.trakt5.services;

import com.uwetrottmann.trakt5.entities.BaseMovie;
import com.uwetrottmann.trakt5.entities.BaseShow;
import com.uwetrottmann.trakt5.entities.Followed;
import com.uwetrottmann.trakt5.entities.Follower;
import com.uwetrottmann.trakt5.entities.Friend;
import com.uwetrottmann.trakt5.entities.HistoryEntry;
import com.uwetrottmann.trakt5.entities.ListEntry;
import com.uwetrottmann.trakt5.entities.RatedEpisode;
import com.uwetrottmann.trakt5.entities.RatedMovie;
import com.uwetrottmann.trakt5.entities.RatedSeason;
import com.uwetrottmann.trakt5.entities.RatedShow;
import com.uwetrottmann.trakt5.entities.Settings;
import com.uwetrottmann.trakt5.entities.SyncItems;
import com.uwetrottmann.trakt5.entities.SyncResponse;
import com.uwetrottmann.trakt5.entities.TraktList;
import com.uwetrottmann.trakt5.entities.User;
import com.uwetrottmann.trakt5.entities.UserSlug;
import com.uwetrottmann.trakt5.entities.WatchlistedEpisode;
import com.uwetrottmann.trakt5.entities.WatchlistedSeason;
import com.uwetrottmann.trakt5.enums.Extended;
import com.uwetrottmann.trakt5.enums.HistoryType;
import com.uwetrottmann.trakt5.enums.RatingsFilter;
import java.util.List;
import org.joda.time.DateTime;
import retrofit2.Call;
import retrofit2.http.Body;
import retrofit2.http.DELETE;
import retrofit2.http.GET;
import retrofit2.http.POST;
import retrofit2.http.PUT;
import retrofit2.http.Path;
import retrofit2.http.Query;

public interface Users {
    @GET(value="users/settings")
    public Call<Settings> settings();

    @GET(value="users/{username}")
    public Call<User> profile(@Path(value="username") UserSlug var1, @Query(value="extended", encoded=true) Extended var2);

    @GET(value="users/{username}/collection/movies")
    public Call<List<BaseMovie>> collectionMovies(@Path(value="username") UserSlug var1, @Query(value="extended", encoded=true) Extended var2);

    @GET(value="users/{username}/collection/shows")
    public Call<List<BaseShow>> collectionShows(@Path(value="username") UserSlug var1, @Query(value="extended", encoded=true) Extended var2);

    @GET(value="users/{username}/lists")
    public Call<List<TraktList>> lists(@Path(value="username") UserSlug var1);

    @POST(value="users/{username}/lists")
    public Call<TraktList> createList(@Path(value="username") UserSlug var1, @Body TraktList var2);

    @PUT(value="users/{username}/lists/{id}")
    public Call<TraktList> updateList(@Path(value="username") UserSlug var1, @Path(value="id") String var2, @Body TraktList var3);

    @DELETE(value="users/{username}/lists/{id}")
    public Call<Void> deleteList(@Path(value="username") UserSlug var1, @Path(value="id") String var2);

    @GET(value="users/{username}/lists/{id}/items")
    public Call<List<ListEntry>> listItems(@Path(value="username") UserSlug var1, @Path(value="id") String var2, @Query(value="extended", encoded=true) Extended var3);

    @POST(value="users/{username}/lists/{id}/items")
    public Call<SyncResponse> addListItems(@Path(value="username") UserSlug var1, @Path(value="id") String var2, @Body SyncItems var3);

    @POST(value="users/{username}/lists/{id}/items/remove")
    public Call<SyncResponse> deleteListItems(@Path(value="username") UserSlug var1, @Path(value="id") String var2, @Body SyncItems var3);

    @POST(value="users/{username}/follow")
    public Call<Followed> follow(@Path(value="username") UserSlug var1);

    @DELETE(value="users/{username}/follow")
    public Call<Void> unfollow(@Path(value="username") UserSlug var1);

    @GET(value="users/{username}/followers")
    public Call<List<Follower>> followers(@Path(value="username") UserSlug var1, @Query(value="extended", encoded=true) Extended var2);

    @GET(value="users/{username}/following")
    public Call<List<Follower>> following(@Path(value="username") UserSlug var1, @Query(value="extended", encoded=true) Extended var2);

    @GET(value="users/{username}/friends")
    public Call<List<Friend>> friends(@Path(value="username") UserSlug var1, @Query(value="extended", encoded=true) Extended var2);

    @GET(value="users/{username}/history")
    public Call<List<HistoryEntry>> history(@Path(value="username") UserSlug var1, @Query(value="page") Integer var2, @Query(value="limit") Integer var3, @Query(value="extended", encoded=true) Extended var4, @Query(value="start_at") DateTime var5, @Query(value="end_at") DateTime var6);

    @GET(value="users/{username}/history/{type}")
    public Call<List<HistoryEntry>> history(@Path(value="username") UserSlug var1, @Path(value="type") HistoryType var2, @Query(value="page") Integer var3, @Query(value="limit") Integer var4, @Query(value="extended", encoded=true) Extended var5, @Query(value="start_at") DateTime var6, @Query(value="end_at") DateTime var7);

    @GET(value="users/{username}/history/{type}/{id}")
    public Call<List<HistoryEntry>> history(@Path(value="username") UserSlug var1, @Path(value="type") HistoryType var2, @Path(value="id") int var3, @Query(value="page") Integer var4, @Query(value="limit") Integer var5, @Query(value="extended", encoded=true) Extended var6, @Query(value="start_at") DateTime var7, @Query(value="end_at") DateTime var8);

    @GET(value="users/{username}/ratings/movies{rating}")
    public Call<List<RatedMovie>> ratingsMovies(@Path(value="username") UserSlug var1, @Path(value="rating", encoded=true) RatingsFilter var2, @Query(value="extended", encoded=true) Extended var3);

    @GET(value="users/{username}/ratings/shows{rating}")
    public Call<List<RatedShow>> ratingsShows(@Path(value="username") UserSlug var1, @Path(value="rating", encoded=true) RatingsFilter var2, @Query(value="extended", encoded=true) Extended var3);

    @GET(value="users/{username}/ratings/seasons{rating}")
    public Call<List<RatedSeason>> ratingsSeasons(@Path(value="username") UserSlug var1, @Path(value="rating", encoded=true) RatingsFilter var2, @Query(value="extended", encoded=true) Extended var3);

    @GET(value="users/{username}/ratings/episodes{rating}")
    public Call<List<RatedEpisode>> ratingsEpisodes(@Path(value="username") UserSlug var1, @Path(value="rating", encoded=true) RatingsFilter var2, @Query(value="extended", encoded=true) Extended var3);

    @GET(value="users/{username}/watchlist/movies")
    public Call<List<BaseMovie>> watchlistMovies(@Path(value="username") UserSlug var1, @Query(value="extended", encoded=true) Extended var2);

    @GET(value="users/{username}/watchlist/shows")
    public Call<List<BaseShow>> watchlistShows(@Path(value="username") UserSlug var1, @Query(value="extended", encoded=true) Extended var2);

    @GET(value="users/{username}/watchlist/seasons")
    public Call<List<WatchlistedSeason>> watchlistSeasons(@Path(value="username") UserSlug var1, @Query(value="extended", encoded=true) Extended var2);

    @GET(value="users/{username}/watchlist/episodes")
    public Call<List<WatchlistedEpisode>> watchlistEpisodes(@Path(value="username") UserSlug var1, @Query(value="extended", encoded=true) Extended var2);

    @GET(value="users/{username}/watched/movies")
    public Call<List<BaseMovie>> watchedMovies(@Path(value="username") UserSlug var1, @Query(value="extended", encoded=true) Extended var2);

    @GET(value="users/{username}/watched/shows")
    public Call<List<BaseShow>> watchedShows(@Path(value="username") UserSlug var1, @Query(value="extended", encoded=true) Extended var2);
}

