/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.scraper.http;

import java.io.File;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.util.concurrent.TimeUnit;
import okhttp3.Authenticator;
import okhttp3.Cache;
import okhttp3.ConnectionPool;
import okhttp3.Credentials;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.Route;
import org.apache.commons.lang3.StringUtils;
import org.tinymediamanager.scraper.http.ProxySettings;

public class TmmHttpClient {
    public static final String CACHE_DIR = "cache";
    private static Cache CACHE = new Cache(new File("cache"), 0x500000L);
    private static OkHttpClient client = TmmHttpClient.createHttpClient();

    private static OkHttpClient createHttpClient() {
        OkHttpClient.Builder builder = new OkHttpClient.Builder();
        builder.connectionPool(new ConnectionPool(5, 5000L, TimeUnit.MILLISECONDS));
        builder.connectTimeout(10L, TimeUnit.SECONDS);
        builder.writeTimeout(10L, TimeUnit.SECONDS);
        builder.readTimeout(30L, TimeUnit.SECONDS);
        if (ProxySettings.INSTANCE.useProxy()) {
            TmmHttpClient.setProxy(builder);
        }
        return builder.build();
    }

    public static OkHttpClient.Builder newBuilder() {
        return TmmHttpClient.newBuilder(false);
    }

    public static OkHttpClient.Builder newBuilder(boolean withCache) {
        OkHttpClient.Builder builder = client.newBuilder();
        if (withCache) {
            builder.cache(CACHE);
        }
        return builder;
    }

    public static OkHttpClient getHttpClient() {
        return client;
    }

    static void changeProxy() {
        client = TmmHttpClient.createHttpClient();
    }

    private static void setProxy(OkHttpClient.Builder builder) {
        Proxy proxyHost;
        if (ProxySettings.INSTANCE.getPort() > 0) {
            proxyHost = new Proxy(Proxy.Type.HTTP, InetSocketAddress.createUnresolved(ProxySettings.INSTANCE.getHost(), ProxySettings.INSTANCE.getPort()));
        } else if (StringUtils.isNotBlank((CharSequence)ProxySettings.INSTANCE.getHost())) {
            proxyHost = new Proxy(Proxy.Type.HTTP, InetSocketAddress.createUnresolved(ProxySettings.INSTANCE.getHost(), 80));
        } else {
            return;
        }
        builder.proxy(proxyHost);
        if (StringUtils.isNotBlank((CharSequence)ProxySettings.INSTANCE.getUsername()) && StringUtils.isNotBlank((CharSequence)ProxySettings.INSTANCE.getPassword())) {
            builder.authenticator(new Authenticator(){

                public Request authenticate(Route route, Response response) throws IOException {
                    String credential = Credentials.basic((String)ProxySettings.INSTANCE.getUsername(), (String)ProxySettings.INSTANCE.getPassword());
                    return response.request().newBuilder().header("Proxy-Authorization", credential).build();
                }
            });
        }
    }
}

