/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.wizard;

import com.jgoodies.forms.layout.ColumnSpec;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.forms.layout.FormSpecs;
import com.jgoodies.forms.layout.RowSpec;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JPanel;
import org.tinymediamanager.Globals;
import org.tinymediamanager.core.movie.tasks.MovieUpdateDatasourceTask2;
import org.tinymediamanager.core.threading.TmmTaskManager;
import org.tinymediamanager.core.threading.TmmThreadPool;
import org.tinymediamanager.core.tvshow.tasks.TvShowUpdateDatasourceTask2;
import org.tinymediamanager.ui.EqualsLayout;
import org.tinymediamanager.ui.UTF8Control;
import org.tinymediamanager.ui.dialogs.TmmDialog;
import org.tinymediamanager.ui.wizard.EntrancePanel;
import org.tinymediamanager.ui.wizard.MovieScraperPanel;
import org.tinymediamanager.ui.wizard.MovieSourcePanel;
import org.tinymediamanager.ui.wizard.TvShowScraperPanel;
import org.tinymediamanager.ui.wizard.TvShowSourcePanel;

public class TinyMediaManagerWizard
extends TmmDialog {
    private static final long serialVersionUID = 1112053710541745443L;
    private static final ResourceBundle BUNDLE = ResourceBundle.getBundle("messages", new UTF8Control());
    private List<JPanel> panels;
    private int activePanelIndex = 0;
    private JButton btnBack;
    private JButton btnNext;
    private JButton btnCancel;
    private JPanel panelContent;

    public TinyMediaManagerWizard() {
        super("tinyMediaManager Setup Wizard", "wizard");
        this.setBounds(100, 100, 577, 71);
        this.initComponents();
        this.panels = new ArrayList<JPanel>();
        this.panels.add(new EntrancePanel());
        this.panels.add(new MovieSourcePanel());
        this.panels.add(new MovieScraperPanel());
        this.panels.add(new TvShowSourcePanel());
        this.panels.add(new TvShowScraperPanel());
        for (int i = 0; i < this.panels.size(); ++i) {
            JPanel panel = this.panels.get(i);
            this.panelContent.add((Component)panel, "" + i);
        }
        this.btnBack.setEnabled(false);
    }

    private void initComponents() {
        JPanel panelSizing = new JPanel();
        panelSizing.setLayout((LayoutManager)new FormLayout(new ColumnSpec[]{ColumnSpec.decode((String)"450dlu:grow")}, new RowSpec[]{RowSpec.decode((String)"300dlu:grow")}));
        this.getContentPane().add((Component)panelSizing, "Center");
        this.panelContent = new JPanel();
        this.panelContent.setLayout(new CardLayout());
        panelSizing.add((Component)this.panelContent, "1, 1, fill, fill");
        JPanel panelSouth = new JPanel();
        panelSouth.setLayout((LayoutManager)new FormLayout(new ColumnSpec[]{ColumnSpec.decode((String)"default:grow"), FormSpecs.DEFAULT_COLSPEC, FormSpecs.RELATED_GAP_COLSPEC}, new RowSpec[]{FormSpecs.LINE_GAP_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC, FormSpecs.LINE_GAP_ROWSPEC}));
        JPanel panelButtons = new JPanel();
        EqualsLayout layout = new EqualsLayout(5);
        layout.setMinWidth(75);
        layout.setAlignment(4);
        panelButtons.setLayout(layout);
        panelSouth.add((Component)panelButtons, "2, 2, fill, fill");
        this.getContentPane().add((Component)panelSouth, "South");
        this.btnBack = new JButton();
        this.btnBack.setAction(new BackAction());
        panelButtons.add(this.btnBack);
        this.btnNext = new JButton();
        this.btnNext.setAction(new NextAction());
        panelButtons.add(this.btnNext);
        this.btnCancel = new JButton();
        this.btnCancel.setAction(new FinishAction());
        panelButtons.add(this.btnCancel);
    }

    @Override
    public void setVisible(boolean visible) {
        if (!visible) {
            Globals.settings.saveSettings();
        }
        super.setVisible(visible);
    }

    private class FinishAction
    extends AbstractAction {
        private static final long serialVersionUID = 8047070989186510289L;

        public FinishAction() {
            this.putValue("Name", BUNDLE.getString("wizard.finish"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            TmmThreadPool task;
            TinyMediaManagerWizard.this.setVisible(false);
            if (!Globals.settings.getMovieSettings().getMovieDataSource().isEmpty()) {
                task = new MovieUpdateDatasourceTask2();
                TmmTaskManager.getInstance().addMainTask(task);
            }
            if (!Globals.settings.getTvShowSettings().getTvShowDataSource().isEmpty()) {
                task = new TvShowUpdateDatasourceTask2();
                TmmTaskManager.getInstance().addMainTask(task);
            }
        }
    }

    private class NextAction
    extends AbstractAction {
        private static final long serialVersionUID = -7813935881525980050L;

        public NextAction() {
            this.putValue("Name", BUNDLE.getString("wizard.next"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            TinyMediaManagerWizard.this.activePanelIndex++;
            if (TinyMediaManagerWizard.this.panels.size() == TinyMediaManagerWizard.this.activePanelIndex + 1) {
                TinyMediaManagerWizard.this.btnNext.setEnabled(false);
            }
            TinyMediaManagerWizard.this.btnBack.setEnabled(true);
            CardLayout cl = (CardLayout)TinyMediaManagerWizard.this.panelContent.getLayout();
            cl.show(TinyMediaManagerWizard.this.panelContent, "" + TinyMediaManagerWizard.this.activePanelIndex);
        }
    }

    private class BackAction
    extends AbstractAction {
        private static final long serialVersionUID = -510135441507847318L;

        public BackAction() {
            this.putValue("Name", BUNDLE.getString("wizard.back"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            TinyMediaManagerWizard.this.activePanelIndex--;
            if (TinyMediaManagerWizard.this.activePanelIndex == 0) {
                TinyMediaManagerWizard.this.btnBack.setEnabled(false);
            }
            TinyMediaManagerWizard.this.btnNext.setEnabled(true);
            CardLayout cl = (CardLayout)TinyMediaManagerWizard.this.panelContent.getLayout();
            cl.show(TinyMediaManagerWizard.this.panelContent, "" + TinyMediaManagerWizard.this.activePanelIndex);
        }
    }
}

