/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.tvshows;

import java.text.RuleBasedCollator;
import java.util.Collections;
import java.util.Comparator;
import java.util.Locale;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import org.tinymediamanager.core.tvshow.entities.TvShow;
import org.tinymediamanager.ui.tvshows.TvShowTreeNode;

public class TvShowRootTreeNode
extends DefaultMutableTreeNode {
    private static final long serialVersionUID = 6510900885675830369L;
    private RuleBasedCollator stringCollator = (RuleBasedCollator)RuleBasedCollator.getInstance();
    private Comparator<TreeNode> nodeComparator = new Comparator<TreeNode>(){

        @Override
        public int compare(TreeNode o1, TreeNode o2) {
            if (o1 instanceof TvShowTreeNode && o2 instanceof TvShowTreeNode) {
                TvShowTreeNode node1 = (TvShowTreeNode)o1;
                TvShow tvShow1 = (TvShow)node1.getUserObject();
                TvShowTreeNode node2 = (TvShowTreeNode)o2;
                TvShow tvShow2 = (TvShow)node2.getUserObject();
                if (TvShowRootTreeNode.this.stringCollator != null) {
                    return TvShowRootTreeNode.this.stringCollator.compare(tvShow1.getTitleSortable().toLowerCase(Locale.ROOT), tvShow2.getTitleSortable().toLowerCase(Locale.ROOT));
                }
                return tvShow1.getTitleSortable().compareToIgnoreCase(tvShow2.getTitleSortable());
            }
            return o1.toString().compareToIgnoreCase(o2.toString());
        }
    };

    public TvShowRootTreeNode() {
        super("TvShows");
    }

    @Override
    public String toString() {
        if (this.getUserObject() instanceof TvShow) {
            TvShow tvShow = (TvShow)this.getUserObject();
            return tvShow.getTitle();
        }
        return super.toString();
    }

    @Override
    public synchronized void insert(MutableTreeNode newChild, int childIndex) {
        if (this.children != null) {
            int index = Collections.binarySearch(this.children, newChild, this.nodeComparator);
            if (index < 0) {
                super.insert(newChild, -index - 1);
            } else if (index >= 0) {
                super.insert(newChild, index);
            }
        } else {
            super.insert(newChild, childIndex);
        }
    }
}

