/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.moviesets.actions;

import java.awt.event.ActionEvent;
import java.util.Iterator;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.AbstractAction;
import org.tinymediamanager.core.movie.entities.MovieSet;
import org.tinymediamanager.ui.IconManager;
import org.tinymediamanager.ui.UTF8Control;
import org.tinymediamanager.ui.moviesets.MovieSetUIModule;
import org.tinymediamanager.ui.moviesets.dialogs.MovieSetEditorDialog;

public class MovieSetEditAction
extends AbstractAction {
    private static final long serialVersionUID = 1848573591741154631L;
    private static final ResourceBundle BUNDLE = ResourceBundle.getBundle("messages", new UTF8Control());

    public MovieSetEditAction(boolean withTitle) {
        if (withTitle) {
            this.putValue("Name", BUNDLE.getString("movieset.edit"));
        }
        this.putValue("SwingLargeIconKey", IconManager.EDIT);
        this.putValue("SmallIcon", IconManager.EDIT);
        this.putValue("ShortDescription", BUNDLE.getString("movieset.edit"));
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        MovieSet movieSet;
        MovieSetEditorDialog editor;
        List<MovieSet> selectedMovieSets = MovieSetUIModule.getInstance().getSelectionModel().getSelectedMovieSets();
        Iterator<MovieSet> i$ = selectedMovieSets.iterator();
        while (i$.hasNext() && (editor = new MovieSetEditorDialog(movieSet = i$.next(), selectedMovieSets.size() > 1)).showDialog()) {
        }
    }
}

