/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.movies.dialogs;

import com.jgoodies.forms.layout.ColumnSpec;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.forms.layout.FormSpecs;
import com.jgoodies.forms.layout.RowSpec;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ResourceBundle;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.apache.commons.lang3.StringUtils;
import org.tinymediamanager.core.MediaSource;
import org.tinymediamanager.core.movie.MovieList;
import org.tinymediamanager.core.movie.MovieModuleManager;
import org.tinymediamanager.ui.EqualsLayout;
import org.tinymediamanager.ui.IconManager;
import org.tinymediamanager.ui.UTF8Control;
import org.tinymediamanager.ui.dialogs.TmmDialog;

public class MovieCreateOfflineDialog
extends TmmDialog {
    private static final long serialVersionUID = -8515248604267318279L;
    private static final ResourceBundle BUNDLE = ResourceBundle.getBundle("messages", new UTF8Control());
    private MovieList movieList = MovieList.getInstance();

    public MovieCreateOfflineDialog() {
        super(BUNDLE.getString("movie.createoffline"), "movieCreateOffline");
        this.setBounds(5, 5, 350, 230);
        this.getContentPane().setLayout(new BorderLayout(0, 0));
        JPanel panelContent = new JPanel();
        this.getContentPane().add((Component)panelContent, "North");
        panelContent.setLayout((LayoutManager)new FormLayout(new ColumnSpec[]{FormSpecs.RELATED_GAP_COLSPEC, FormSpecs.DEFAULT_COLSPEC, FormSpecs.RELATED_GAP_COLSPEC, ColumnSpec.decode((String)"100dlu:grow"), FormSpecs.RELATED_GAP_COLSPEC, FormSpecs.DEFAULT_COLSPEC, FormSpecs.RELATED_GAP_COLSPEC}, new RowSpec[]{FormSpecs.RELATED_GAP_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC, FormSpecs.RELATED_GAP_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC, FormSpecs.RELATED_GAP_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC, FormSpecs.PARAGRAPH_GAP_ROWSPEC}));
        JLabel lblTitle = new JLabel(BUNDLE.getString("metatag.title"));
        panelContent.add((Component)lblTitle, "2, 2, right, default");
        final JTextField tfMovieName = new JTextField();
        panelContent.add((Component)tfMovieName, "4, 2, fill, default");
        tfMovieName.setColumns(10);
        JLabel lblMediaSource = new JLabel(BUNDLE.getString("metatag.source"));
        panelContent.add((Component)lblMediaSource, "2, 4, right, default");
        final JComboBox<MediaSource> cbMediaSource = new JComboBox<MediaSource>();
        cbMediaSource.addItem(MediaSource.UNKNOWN);
        cbMediaSource.addItem(MediaSource.DVD);
        cbMediaSource.addItem(MediaSource.BLURAY);
        cbMediaSource.addItem(MediaSource.HDDVD);
        cbMediaSource.addItem(MediaSource.VHS);
        panelContent.add(cbMediaSource, "4, 4, fill, default");
        JLabel lblDatasource = new JLabel(BUNDLE.getString("metatag.datasource"));
        panelContent.add((Component)lblDatasource, "2, 6, right, default");
        final JComboBox<String> cbDatasource = new JComboBox<String>();
        panelContent.add(cbDatasource, "4, 6, fill, default");
        JButton btnAdd = new JButton(IconManager.LIST_ADD);
        btnAdd.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String title = tfMovieName.getText();
                String datasource = (String)cbDatasource.getSelectedItem();
                MediaSource mediaSource = (MediaSource)((Object)cbMediaSource.getSelectedItem());
                if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{title, datasource})) {
                    MovieCreateOfflineDialog.this.movieList.addOfflineMovie(title, datasource, mediaSource);
                }
            }
        });
        panelContent.add((Component)btnAdd, "6, 2, right, default");
        JPanel panelBottom = new JPanel();
        this.getContentPane().add((Component)panelBottom, "South");
        panelBottom.setLayout((LayoutManager)new FormLayout(new ColumnSpec[]{FormSpecs.RELATED_GAP_COLSPEC, ColumnSpec.decode((String)"default:grow"), FormSpecs.RELATED_GAP_COLSPEC}, new RowSpec[]{FormSpecs.RELATED_GAP_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC, FormSpecs.RELATED_GAP_ROWSPEC}));
        JPanel panelButtons = new JPanel();
        EqualsLayout layout = new EqualsLayout(5);
        layout.setMinWidth(100);
        panelButtons.setLayout(layout);
        panelBottom.add((Component)panelButtons, "2, 2, right, fill");
        JButton btnClose = new JButton(BUNDLE.getString("Button.close"));
        btnClose.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MovieCreateOfflineDialog.this.setVisible(false);
            }
        });
        panelButtons.add(btnClose);
        for (String datasource : MovieModuleManager.MOVIE_SETTINGS.getMovieDataSource()) {
            cbDatasource.addItem(datasource);
        }
    }
}

