/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.core.entities;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.awt.Dimension;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.BasicFileAttributes;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.commons.lang3.StringUtils;
import org.tinymediamanager.core.AbstractModelObject;
import org.tinymediamanager.core.MediaFileType;
import org.tinymediamanager.core.entities.MediaFile;
import org.tinymediamanager.scraper.entities.MediaArtwork;

public abstract class MediaEntity
extends AbstractModelObject {
    protected UUID dbId = UUID.randomUUID();
    @JsonProperty
    protected HashMap<String, Object> ids = new HashMap(0);
    @JsonProperty
    protected String title = "";
    @JsonProperty
    protected String originalTitle = "";
    @JsonProperty
    protected String year = "";
    @JsonProperty
    protected String plot = "";
    @JsonProperty
    protected float rating = 0.0f;
    @JsonProperty
    protected int votes = 0;
    @JsonProperty
    protected String path = "";
    @JsonProperty
    protected Date dateAdded = new Date();
    @JsonProperty
    protected String productionCompany = "";
    @JsonProperty
    protected boolean scraped = false;
    @JsonProperty
    private List<MediaFile> mediaFiles = new ArrayList<MediaFile>();
    @JsonProperty
    protected Map<MediaFileType, String> artworkUrlMap = new HashMap<MediaFileType, String>();
    protected boolean newlyAdded = false;
    protected boolean duplicate = false;
    protected ReadWriteLock readWriteLock = new ReentrantReadWriteLock();

    public void merge(MediaEntity other) {
        if (other == null) {
            return;
        }
        this.title = StringUtils.isEmpty((CharSequence)this.title) ? other.getTitle() : this.title;
        this.originalTitle = StringUtils.isEmpty((CharSequence)this.originalTitle) ? other.getOriginalTitle() : this.originalTitle;
        this.year = StringUtils.isEmpty((CharSequence)this.year) ? other.getYear() : this.year;
        this.plot = StringUtils.isEmpty((CharSequence)this.plot) ? other.getPlot() : this.plot;
        this.productionCompany = StringUtils.isEmpty((CharSequence)this.productionCompany) ? other.getProductionCompany() : this.productionCompany;
        this.votes = this.votes == 0 ? other.getVotes() : this.votes;
        this.rating = Float.compare(this.rating, 0.0f) == 0 ? other.getRating() : this.rating;
        for (String string : other.getIds().keySet()) {
            if (this.ids.containsKey(string)) continue;
            this.ids.put(string, other.getId(string));
        }
        for (MediaFileType mediaFileType : other.getArtworkUrls().keySet()) {
            if (this.artworkUrlMap.containsKey((Object)mediaFileType)) continue;
            this.artworkUrlMap.put(mediaFileType, other.getArtworkUrl(mediaFileType));
        }
    }

    public void initializeAfterLoading() {
        this.sortMediaFiles();
    }

    protected void sortMediaFiles() {
        Comparator<MediaFile> mediaFileComparator = this.getMediaFileComparator();
        if (mediaFileComparator != null) {
            Collections.sort(this.mediaFiles, mediaFileComparator);
        } else {
            Collections.sort(this.mediaFiles);
        }
    }

    public UUID getDbId() {
        return this.dbId;
    }

    public void setDbId(UUID id) {
        this.dbId = id;
    }

    public HashMap<String, Object> getIds() {
        return this.ids;
    }

    public String getTitle() {
        return this.title;
    }

    public String getOriginalTitle() {
        return this.originalTitle;
    }

    public String getPlot() {
        return this.plot;
    }

    @Deprecated
    public String getPath() {
        return this.path;
    }

    public Path getPathNIO() {
        if (StringUtils.isBlank((CharSequence)this.path)) {
            return null;
        }
        return Paths.get(this.path, new String[0]).toAbsolutePath();
    }

    public Dimension getArtworkDimension(MediaFileType type) {
        List<MediaFile> mediaFiles = this.getMediaFiles(type);
        if (mediaFiles.size() > 0) {
            MediaFile mediaFile = mediaFiles.get(0);
            return new Dimension(mediaFile.getVideoWidth(), mediaFile.getVideoHeight());
        }
        return new Dimension(0, 0);
    }

    public String getArtworkFilename(MediaFileType type) {
        List<MediaFile> thumbs = this.getMediaFiles(type);
        if (thumbs.size() > 0) {
            return thumbs.get(0).getFile().getPath();
        }
        return "";
    }

    public float getRating() {
        return this.rating;
    }

    public String getYear() {
        return this.year;
    }

    public void setIds(Map<String, Object> ids) {
        for (Map.Entry<String, Object> entry : ids.entrySet()) {
            if (!StringUtils.isNotBlank((CharSequence)entry.getKey()) || entry.getValue() == null) continue;
            this.setId(entry.getKey(), entry.getValue());
            this.firePropertyChange(entry.getKey(), null, entry.getValue());
        }
    }

    public void setTitle(String newValue) {
        String oldValue = this.title;
        this.title = newValue == null ? "" : newValue.trim();
        this.firePropertyChange("title", oldValue, newValue);
    }

    public void setOriginalTitle(String newValue) {
        String oldValue = this.originalTitle;
        this.originalTitle = newValue == null ? "" : newValue.trim();
        this.firePropertyChange("originalTitle", oldValue, newValue);
    }

    public void setPlot(String newValue) {
        String oldValue = this.plot;
        this.plot = newValue == null ? "" : newValue.trim();
        this.firePropertyChange("plot", oldValue, newValue);
    }

    public void setPath(String newValue) {
        String oldValue = this.path;
        this.path = newValue;
        this.firePropertyChange("path", oldValue, newValue);
    }

    public void setRating(float newValue) {
        float oldValue = this.rating;
        this.rating = newValue;
        this.firePropertyChange("rating", Float.valueOf(oldValue), Float.valueOf(newValue));
    }

    public int getVotes() {
        return this.votes;
    }

    public void setVotes(int newValue) {
        int oldValue = this.votes;
        this.votes = newValue;
        this.firePropertyChange("votes", oldValue, newValue);
    }

    public void setYear(String newValue) {
        String oldValue = this.year;
        this.year = newValue == null ? "" : newValue.trim();
        this.firePropertyChange("year", oldValue, newValue);
    }

    public void setArtworkUrl(String url, MediaFileType type) {
        String oldValue = this.getArtworkFilename(type);
        switch (type) {
            case POSTER: 
            case FANART: 
            case BANNER: 
            case THUMB: 
            case CLEARART: 
            case DISCART: 
            case LOGO: 
            case CLEARLOGO: {
                this.artworkUrlMap.put(type, url);
                break;
            }
            default: {
                return;
            }
        }
        this.firePropertyChange(type.name().toLowerCase(Locale.ROOT) + "Url", oldValue, url);
    }

    public String getArtworkUrl(MediaFileType type) {
        String url = this.artworkUrlMap.get((Object)type);
        return url == null ? "" : url;
    }

    public Map<MediaFileType, String> getArtworkUrls() {
        return this.artworkUrlMap;
    }

    public void setArtwork(Path file, MediaFileType type) {
        List<MediaFile> images = this.getMediaFiles(type);
        MediaFile mediaFile = null;
        if (images.size() > 0) {
            mediaFile = images.get(0);
            mediaFile.setFile(file);
            mediaFile.gatherMediaInformation(true);
        } else {
            mediaFile = new MediaFile(file, type);
            mediaFile.gatherMediaInformation();
            this.addToMediaFiles(mediaFile);
        }
        this.firePropertyChange("mediaInformation", false, true);
    }

    public Map<MediaFileType, MediaFile> getArtworkMap() {
        HashMap<MediaFileType, MediaFile> artworkMap = new HashMap<MediaFileType, MediaFile>();
        List<MediaFile> mediaFiles = this.getMediaFiles();
        for (MediaFile mf : mediaFiles) {
            if (!mf.isGraphic() || artworkMap.containsKey((Object)mf.getType())) continue;
            artworkMap.put(mf.getType(), mf);
        }
        return artworkMap;
    }

    public Date getDateAdded() {
        return this.dateAdded;
    }

    public String getDateAddedAsString() {
        if (this.dateAdded == null) {
            return "";
        }
        return SimpleDateFormat.getDateTimeInstance(2, 2, Locale.getDefault()).format(this.dateAdded);
    }

    public void setDateAdded(Date newValue) {
        Date oldValue = this.dateAdded;
        this.dateAdded = newValue;
        this.firePropertyChange("dateAdded", oldValue, newValue);
        this.firePropertyChange("dateAddedAsString", oldValue, newValue);
    }

    public void setDateAddedFromMediaFile(MediaFile mf) {
        try {
            BasicFileAttributes view = Files.readAttributes(mf.getFileAsPath(), BasicFileAttributes.class, new LinkOption[0]);
            Date creDat = new Date(view.creationTime().toMillis());
            Date modDat = new Date(view.lastModifiedTime().toMillis());
            if (creDat.compareTo(this.dateAdded) < 0) {
                this.setDateAdded(creDat);
            }
            if (modDat.compareTo(this.dateAdded) < 0) {
                this.setDateAdded(modDat);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public String getProductionCompany() {
        return this.productionCompany;
    }

    public void setProductionCompany(String newValue) {
        String oldValue = this.productionCompany;
        this.productionCompany = newValue;
        this.firePropertyChange("productionCompany", oldValue, newValue);
    }

    protected void setScraped(boolean newValue) {
        this.scraped = newValue;
        this.firePropertyChange("scraped", false, newValue);
    }

    public boolean isScraped() {
        return this.scraped;
    }

    public void setDuplicate() {
        this.duplicate = true;
    }

    public void clearDuplicate() {
        this.duplicate = false;
    }

    public boolean isDuplicate() {
        return this.duplicate;
    }

    public void setId(String key, Object value) {
        String v = String.valueOf(value);
        if ("".equals(v) || "0".equals(v) || "null".equals(v)) {
            this.ids.remove(key);
        } else {
            this.ids.put(key, value);
        }
        this.firePropertyChange(key, null, value);
        if ("tmdb".equals(key) || "imdb".equals(key) || "tvdb".equals(key) || "trakt".equals(key)) {
            this.firePropertyChange(key + "Id", null, value);
        }
    }

    public void removeId(String key) {
        Object obj = this.ids.remove(key);
        if (obj != null) {
            this.firePropertyChange(key, obj, null);
        }
    }

    public Object getId(String key) {
        return this.ids.get(key);
    }

    public String getIdAsString(String key) {
        Object obj = this.ids.get(key);
        if (obj == null) {
            return "";
        }
        return String.valueOf(obj);
    }

    public int getIdAsInt(String key) {
        int id = 0;
        try {
            id = Integer.parseInt(String.valueOf(this.ids.get(key)));
        }
        catch (Exception e) {
            return 0;
        }
        return id;
    }

    public void addToMediaFiles(MediaFile mediaFile) {
        MediaFile oldMf;
        int i;
        this.readWriteLock.writeLock().lock();
        if (this.mediaFiles.contains(mediaFile) && (i = this.mediaFiles.indexOf(mediaFile)) >= 0 && (oldMf = this.mediaFiles.get(i)).getType() != mediaFile.getType()) {
            this.mediaFiles.remove(i);
        }
        if (!this.mediaFiles.contains(mediaFile)) {
            this.mediaFiles.add(mediaFile);
            this.sortMediaFiles();
        }
        this.readWriteLock.writeLock().unlock();
        this.firePropertyChange("mediaFiles", null, this.mediaFiles);
        this.fireAddedEventForMediaFile(mediaFile);
    }

    public void addToMediaFiles(List<MediaFile> mediaFiles) {
        for (MediaFile mediaFile : mediaFiles) {
            this.addToMediaFiles(mediaFile);
        }
    }

    private void fireAddedEventForMediaFile(MediaFile mediaFile) {
        switch (mediaFile.getType()) {
            case FANART: {
                this.firePropertyChange("fanart", null, mediaFile.getFile().getPath());
                this.firePropertyChange("hasImages", false, true);
                break;
            }
            case POSTER: {
                this.firePropertyChange("poster", null, mediaFile.getFile().getPath());
                this.firePropertyChange("hasImages", false, true);
                break;
            }
            case BANNER: {
                this.firePropertyChange("banner", null, mediaFile.getFile().getPath());
                this.firePropertyChange("hasImages", false, true);
                break;
            }
            case THUMB: {
                this.firePropertyChange("thumb", null, mediaFile.getFile().getPath());
                this.firePropertyChange("hasImages", false, true);
                break;
            }
        }
    }

    private void fireRemoveEventForMediaFile(MediaFile mediaFile) {
        switch (mediaFile.getType()) {
            case FANART: {
                this.firePropertyChange("fanart", null, "");
                this.firePropertyChange("hasImages", true, false);
                break;
            }
            case POSTER: {
                this.firePropertyChange("poster", null, "");
                this.firePropertyChange("hasImages", true, false);
                break;
            }
            case BANNER: {
                this.firePropertyChange("banner", null, "");
                this.firePropertyChange("hasImages", true, false);
                break;
            }
            case THUMB: {
                this.firePropertyChange("thumb", null, "");
                this.firePropertyChange("hasImages", true, false);
                break;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<MediaFile> getMediaFiles() {
        ArrayList<MediaFile> mf = new ArrayList<MediaFile>();
        this.readWriteLock.readLock().lock();
        try {
            mf.addAll(this.mediaFiles);
        }
        finally {
            this.readWriteLock.readLock().unlock();
        }
        return mf;
    }

    public List<MediaFile> getMediaFiles(MediaFileType ... types) {
        ArrayList<MediaFile> mf = new ArrayList<MediaFile>();
        this.readWriteLock.readLock().lock();
        for (MediaFile mediaFile : this.mediaFiles) {
            boolean match = false;
            for (MediaFileType type : types) {
                if (!mediaFile.getType().equals((Object)type)) continue;
                match = true;
            }
            if (!match) continue;
            mf.add(mediaFile);
        }
        this.readWriteLock.readLock().unlock();
        return mf;
    }

    public MediaFile getBiggestMediaFile(MediaFileType ... types) {
        MediaFile mf = null;
        this.readWriteLock.readLock().lock();
        for (MediaFile mediaFile : this.mediaFiles) {
            for (MediaFileType type : types) {
                if (!mediaFile.getType().equals((Object)type) || mf != null && mediaFile.getFilesize() < mf.getFilesize()) continue;
                mf = mediaFile;
            }
        }
        this.readWriteLock.readLock().unlock();
        return mf;
    }

    public MediaFile getNewestMediaFilesOfType(MediaFileType ... types) {
        MediaFile mf = null;
        this.readWriteLock.readLock().lock();
        for (MediaFile mediaFile : this.mediaFiles) {
            for (MediaFileType type : types) {
                if (!mediaFile.getType().equals((Object)type) || mf != null && mediaFile.getFiledate() < mf.getFiledate()) continue;
                mf = new MediaFile(mediaFile);
            }
        }
        this.readWriteLock.readLock().unlock();
        return mf;
    }

    public List<MediaFile> getMediaFilesExceptType(MediaFileType ... types) {
        ArrayList<MediaFile> mf = new ArrayList<MediaFile>();
        this.readWriteLock.readLock().lock();
        for (MediaFile mediaFile : this.mediaFiles) {
            boolean match = false;
            for (MediaFileType type : types) {
                if (!mediaFile.getType().equals((Object)type)) continue;
                match = true;
            }
            if (match) continue;
            mf.add(mediaFile);
        }
        this.readWriteLock.readLock().unlock();
        return mf;
    }

    public void removeAllMediaFiles() {
        ArrayList<MediaFile> changedMediafiles = new ArrayList<MediaFile>(this.mediaFiles);
        this.readWriteLock.writeLock().lock();
        for (int i = this.mediaFiles.size() - 1; i >= 0; --i) {
            this.mediaFiles.remove(i);
        }
        this.readWriteLock.writeLock().unlock();
        for (MediaFile mediaFile : changedMediafiles) {
            this.fireRemoveEventForMediaFile(mediaFile);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeFromMediaFiles(MediaFile mediaFile) {
        this.readWriteLock.writeLock().lock();
        try {
            this.mediaFiles.remove(mediaFile);
        }
        finally {
            this.readWriteLock.writeLock().unlock();
        }
        this.firePropertyChange("mediaFiles", null, this.mediaFiles);
        this.fireRemoveEventForMediaFile(mediaFile);
    }

    public void removeAllMediaFilesExceptType(MediaFileType type) {
        ArrayList<MediaFile> changedMediafiles = new ArrayList<MediaFile>();
        this.readWriteLock.writeLock().lock();
        for (int i = this.mediaFiles.size() - 1; i >= 0; --i) {
            MediaFile mediaFile = this.mediaFiles.get(i);
            if (mediaFile.getType().equals((Object)type)) continue;
            this.mediaFiles.remove(i);
            changedMediafiles.add(mediaFile);
        }
        this.readWriteLock.writeLock().unlock();
        for (MediaFile mediaFile : changedMediafiles) {
            this.fireRemoveEventForMediaFile(mediaFile);
        }
    }

    public void removeAllMediaFiles(MediaFileType type) {
        ArrayList<MediaFile> changedMediafiles = new ArrayList<MediaFile>();
        this.readWriteLock.writeLock().lock();
        for (int i = this.mediaFiles.size() - 1; i >= 0; --i) {
            MediaFile mediaFile = this.mediaFiles.get(i);
            if (!mediaFile.getType().equals((Object)type)) continue;
            this.mediaFiles.remove(i);
            changedMediafiles.add(mediaFile);
        }
        this.readWriteLock.writeLock().unlock();
        for (MediaFile mediaFile : changedMediafiles) {
            this.fireRemoveEventForMediaFile(mediaFile);
        }
    }

    public void updateMediaFilePath(Path oldPath, Path newPath) {
        this.readWriteLock.readLock().lock();
        ArrayList<MediaFile> mfs = new ArrayList<MediaFile>(this.mediaFiles);
        this.readWriteLock.readLock().unlock();
        for (MediaFile mf : mfs) {
            mf.replacePathForRenamedFolder(oldPath, newPath);
        }
    }

    public void gatherMediaFileInformation(boolean force) {
        this.readWriteLock.readLock().lock();
        ArrayList<MediaFile> mediaFiles = new ArrayList<MediaFile>(this.mediaFiles);
        this.readWriteLock.readLock().unlock();
        for (MediaFile mediaFile : mediaFiles) {
            mediaFile.gatherMediaInformation(force);
        }
        this.firePropertyChange("mediaInformation", false, true);
    }

    public void fireEventForChangedMediaInformation() {
        this.firePropertyChange("mediaInformation", false, true);
    }

    public boolean isNewlyAdded() {
        return this.newlyAdded;
    }

    public void setNewlyAdded(boolean newValue) {
        boolean oldValue = this.newlyAdded;
        this.newlyAdded = newValue;
        this.firePropertyChange("newlyAdded", oldValue, newValue);
    }

    public abstract void saveToDb();

    public abstract void deleteFromDb();

    public abstract void callbackForWrittenArtwork(MediaArtwork.MediaArtworkType var1);

    protected abstract Comparator<MediaFile> getMediaFileComparator();
}

