/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.classworlds;

import java.net.URL;
import java.util.Set;
import java.util.TreeSet;
import org.codehaus.classworlds.ClassRealm;
import org.codehaus.classworlds.ClassWorld;
import org.codehaus.classworlds.Entry;
import org.codehaus.classworlds.NoSuchRealmException;
import org.codehaus.classworlds.RealmClassLoader;
import org.codehaus.classworlds.UberJarRealmClassLoader;
import org.codehaus.classworlds.UrlUtils;

class DefaultClassRealm
implements ClassRealm {
    private ClassWorld world;
    private String id;
    private Set imports;
    private RealmClassLoader classLoader;
    private ClassRealm parent;

    DefaultClassRealm(ClassWorld world, String id) {
        this(world, id, ClassLoader.getSystemClassLoader());
    }

    DefaultClassRealm(ClassWorld world, String id, ClassLoader parentClassLoader) {
        this.world = world;
        this.id = id;
        this.imports = new TreeSet();
        try {
            this.classLoader = "true".equals(System.getProperty("classworlds.bootstrapped")) ? new UberJarRealmClassLoader(this) : new RealmClassLoader(this, parentClassLoader);
        }
        catch (SecurityException e) {
            this.classLoader = new RealmClassLoader(this);
        }
    }

    public ClassRealm getParent() {
        return this.parent;
    }

    @Override
    public void setParent(ClassRealm parent) {
        this.parent = parent;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public ClassWorld getWorld() {
        return this.world;
    }

    @Override
    public void importFrom(String realmId, String pkgName) throws NoSuchRealmException {
        this.imports.add(new Entry(this.getWorld().getRealmImpl(realmId), pkgName));
    }

    @Override
    public void addConstituent(URL constituent) {
        this.classLoader.addConstituent(constituent);
    }

    DefaultClassRealm locateSourceRealm(String classname) {
        for (Entry eachEntry : this.imports) {
            if (!eachEntry.matches(classname)) continue;
            return eachEntry.getRealm();
        }
        return this;
    }

    @Override
    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    @Override
    public Class loadClass(String name) throws ClassNotFoundException {
        if (name.startsWith("org.codehaus.classworlds.")) {
            return this.getWorld().loadClass(name);
        }
        DefaultClassRealm sourceRealm = this.locateSourceRealm(name);
        if (sourceRealm == this) {
            return this.loadClassDirect(name);
        }
        return sourceRealm.loadClass(name);
    }

    Class loadClassDirect(String name) throws ClassNotFoundException {
        Class<?> clazz = null;
        try {
            clazz = this.classLoader.loadClassDirect(name);
        }
        catch (ClassNotFoundException cnfe1) {
            if (this.getParent() != null) {
                clazz = this.getParent().getClassLoader().loadClass(name);
            }
            throw cnfe1;
        }
        return clazz;
    }

    @Override
    public URL getResource(String name) {
        DefaultClassRealm sourceRealm = this.locateSourceRealm(name = UrlUtils.normalizeUrlPath(name));
        if (sourceRealm == this) {
            return this.loadResourceDirect(name);
        }
        return sourceRealm.getResource(name);
    }

    URL loadResourceDirect(String name) {
        URL resource = this.classLoader.findResource(name);
        if (resource == null && this.getParent() != null) {
            resource = this.getParent().getResource(name);
        }
        return resource;
    }

    @Override
    public ClassRealm createChildRealm(String id) {
        DefaultClassRealm childRealm = new DefaultClassRealm(this.getWorld(), id);
        childRealm.setParent(this);
        return childRealm;
    }
}

