/*
 * Decompiled with CFR 0.152.
 */
package net.jcores.jre.utils.internal;

import java.util.Collection;
import java.util.LinkedList;
import net.jcores.jre.CommonCore;
import net.jcores.jre.CoreKeeper;
import net.jcores.jre.options.Args;
import net.jcores.jre.options.Debug;
import net.jcores.jre.options.ID;
import net.jcores.jre.options.InvertSelection;
import net.jcores.jre.options.KillSwitch;
import net.jcores.jre.options.MessageType;
import net.jcores.jre.options.OnFailure;
import net.jcores.jre.options.Option;

public class Options {
    private final CommonCore commonCore;
    private final Option[] options;
    Collection<OnFailure> onFailures;
    KillSwitch killswitch;
    boolean invert = false;
    ID id = null;
    Object[] args;
    private boolean debug = false;

    private static Options $(Option ... optionArray) {
        return new Options(CoreKeeper.$, optionArray);
    }

    public static Options $(CommonCore commonCore, Option ... optionArray) {
        return new Options(commonCore, optionArray);
    }

    Options(CommonCore commonCore, Option ... optionArray) {
        this.commonCore = commonCore;
        Option[] optionArray2 = this.options = optionArray == null ? new Option[]{} : optionArray;
        if (this.options.length > 0) {
            this.onFailures = new LinkedList<OnFailure>();
            for (Option option : this.options) {
                if (option instanceof OnFailure) {
                    this.onFailures.add((OnFailure)option);
                }
                if (option instanceof InvertSelection) {
                    boolean bl = this.invert = !this.invert;
                }
                if (option instanceof KillSwitch) {
                    this.killswitch = (KillSwitch)option;
                }
                if (option instanceof ID) {
                    this.id = (ID)option;
                }
                if (option instanceof Args) {
                    this.args = ((Args)option).getArgs();
                }
                if (!(option instanceof Debug)) continue;
                this.debug = true;
            }
        }
    }

    public void failure(Object object, Exception exception, String string, String string2) {
        if (this.onFailures == null || this.onFailures.size() == 0) {
            this.commonCore.report(MessageType.EXCEPTION, string2 + " (" + string2 + ", " + exception.getMessage() + ")");
            return;
        }
        for (OnFailure onFailure : this.onFailures) {
            onFailure.getListener().onFailure(object, exception, string, string2);
        }
    }

    public boolean invert() {
        return this.invert;
    }

    public KillSwitch killswitch() {
        return this.killswitch;
    }

    public ID ID() {
        return this.id;
    }

    public Object[] args() {
        return this.args;
    }

    public boolean debug() {
        return this.debug;
    }
}

