/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.scraper.opensubtitles;

import de.timroes.axmlrpc.Call;
import de.timroes.axmlrpc.XMLRPCException;
import de.timroes.axmlrpc.XMLRPCServerException;
import de.timroes.axmlrpc.XMLUtil;
import de.timroes.axmlrpc.serializer.SerializerHandler;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import okhttp3.OkHttpClient;
import okhttp3.OkUrlFactory;
import org.tinymediamanager.scraper.http.TmmHttpClient;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class TmmXmlRpcClient {
    private static OkHttpClient client;
    private URL url;
    private String userAgent = "";
    private ResponseParser responseParser;

    public TmmXmlRpcClient(URL url, String userAgent) {
        this.url = url;
        this.userAgent = userAgent;
        SerializerHandler.initialize(2);
        this.responseParser = new ResponseParser();
        if (client == null) {
            client = TmmHttpClient.getHttpClient();
        }
    }

    public Object call(String method, Object ... params) throws XMLRPCException {
        return new Caller().call(method, params);
    }

    private class ResponseParser {
        private static final String FAULT_CODE = "faultCode";
        private static final String FAULT_STRING = "faultString";
        private static final String METHOD_RESPONSE = "methodResponse";
        private static final String PARAMS = "params";
        private static final String PARAM = "param";
        private static final String FAULT = "fault";

        private ResponseParser() {
        }

        public Object parse(InputStream response) throws XMLRPCException {
            try {
                DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
                factory.setNamespaceAware(true);
                DocumentBuilder builder = factory.newDocumentBuilder();
                Document dom = builder.parse(response);
                Element e = dom.getDocumentElement();
                if (!e.getNodeName().equals(METHOD_RESPONSE)) {
                    throw new XMLRPCException("MethodResponse root tag is missing.");
                }
                if ((e = XMLUtil.getOnlyChildElement(e.getChildNodes())).getNodeName().equals(PARAMS)) {
                    if (!(e = XMLUtil.getOnlyChildElement(e.getChildNodes())).getNodeName().equals(PARAM)) {
                        throw new XMLRPCException("The params tag must contain a param tag.");
                    }
                    return this.getReturnValueFromElement(e);
                }
                if (e.getNodeName().equals(FAULT)) {
                    Map o = (Map)this.getReturnValueFromElement(e);
                    throw new XMLRPCServerException((String)o.get(FAULT_STRING), (Integer)o.get(FAULT_CODE));
                }
                throw new XMLRPCException("The methodResponse tag must contain a fault or params tag.");
            }
            catch (Exception ex) {
                if (ex instanceof XMLRPCServerException) {
                    throw (XMLRPCServerException)ex;
                }
                throw new XMLRPCException("Error getting result from server.", ex);
            }
        }

        private Object getReturnValueFromElement(Element element) throws XMLRPCException {
            element = XMLUtil.getOnlyChildElement(element.getChildNodes());
            return SerializerHandler.getDefault().deserialize(element);
        }
    }

    private class Caller {
        private static final String HTTP_POST = "POST";
        private static final String USER_AGENT = "User-Agent";

        public Object call(String methodName, Object[] params) throws XMLRPCException {
            try {
                Call c = new Call(methodName, params);
                HttpURLConnection http = new OkUrlFactory(client).open(TmmXmlRpcClient.this.url);
                http.setRequestProperty(USER_AGENT, TmmXmlRpcClient.this.userAgent);
                http.setRequestMethod(HTTP_POST);
                http.setDoOutput(true);
                http.setDoInput(true);
                OutputStreamWriter stream = new OutputStreamWriter(http.getOutputStream());
                stream.write(c.getXML());
                stream.flush();
                stream.close();
                int statusCode = http.getResponseCode();
                if (statusCode != 200) {
                    throw new XMLRPCException("The status code of the http response must be 200.");
                }
                if (statusCode == 403 || statusCode == 401) {
                    throw new XMLRPCException("Invalid status code '" + statusCode + "' returned from server.");
                }
                return TmmXmlRpcClient.this.responseParser.parse(http.getInputStream());
            }
            catch (Exception ex) {
                throw new XMLRPCException(ex);
            }
        }
    }
}

