/*
 * Decompiled with CFR 0.152.
 */
package org.fourthline.cling.support.messagebox.model;

import org.fourthline.cling.support.messagebox.model.DateTime;
import org.fourthline.cling.support.messagebox.model.Message;
import org.fourthline.cling.support.messagebox.model.NumberName;
import org.fourthline.cling.support.messagebox.parser.MessageElement;

public class MessageScheduleReminder
extends Message {
    private final DateTime startTime;
    private final NumberName owner;
    private final String subject;
    private final DateTime endTime;
    private final String location;
    private final String body;

    public MessageScheduleReminder(DateTime startTime, NumberName owner, String subject, DateTime endTime, String location, String body) {
        this(Message.DisplayType.MAXIMUM, startTime, owner, subject, endTime, location, body);
    }

    public MessageScheduleReminder(Message.DisplayType displayType, DateTime startTime, NumberName owner, String subject, DateTime endTime, String location, String body) {
        super(Message.Category.SCHEDULE_REMINDER, displayType);
        this.startTime = startTime;
        this.owner = owner;
        this.subject = subject;
        this.endTime = endTime;
        this.location = location;
        this.body = body;
    }

    public DateTime getStartTime() {
        return this.startTime;
    }

    public NumberName getOwner() {
        return this.owner;
    }

    public String getSubject() {
        return this.subject;
    }

    public DateTime getEndTime() {
        return this.endTime;
    }

    public String getLocation() {
        return this.location;
    }

    public String getBody() {
        return this.body;
    }

    @Override
    public void appendMessageElements(MessageElement parent) {
        this.getStartTime().appendMessageElements((MessageElement)parent.createChild("StartTime"));
        this.getOwner().appendMessageElements((MessageElement)parent.createChild("Owner"));
        ((MessageElement)parent.createChild("Subject")).setContent(this.getSubject());
        this.getEndTime().appendMessageElements((MessageElement)parent.createChild("EndTime"));
        ((MessageElement)parent.createChild("Location")).setContent(this.getLocation());
        ((MessageElement)parent.createChild("Body")).setContent(this.getBody());
    }
}

