/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.tvshows.dialogs;

import ca.odell.glazedlists.swing.AutoCompleteSupport;
import com.jgoodies.forms.factories.FormFactory;
import com.jgoodies.forms.layout.ColumnSpec;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.forms.layout.FormSpecs;
import com.jgoodies.forms.layout.RowSpec;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import javax.swing.AbstractAction;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.SpinnerDateModel;
import javax.swing.SpinnerNumberModel;
import javax.swing.SwingWorker;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.commons.lang3.LocaleUtils;
import org.apache.commons.lang3.StringUtils;
import org.jdesktop.beansbinding.AutoBinding;
import org.jdesktop.beansbinding.BeanProperty;
import org.jdesktop.beansbinding.Property;
import org.jdesktop.observablecollections.ObservableCollections;
import org.jdesktop.swingbinding.JListBinding;
import org.jdesktop.swingbinding.JTableBinding;
import org.jdesktop.swingbinding.SwingBindings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.core.MediaFileType;
import org.tinymediamanager.core.MediaSource;
import org.tinymediamanager.core.TmmProperties;
import org.tinymediamanager.core.Utils;
import org.tinymediamanager.core.entities.MediaFile;
import org.tinymediamanager.core.tvshow.TvShowList;
import org.tinymediamanager.core.tvshow.TvShowModuleManager;
import org.tinymediamanager.core.tvshow.entities.TvShowActor;
import org.tinymediamanager.core.tvshow.entities.TvShowEpisode;
import org.tinymediamanager.scraper.MediaMetadata;
import org.tinymediamanager.scraper.MediaScrapeOptions;
import org.tinymediamanager.scraper.MediaScraper;
import org.tinymediamanager.scraper.entities.MediaArtwork;
import org.tinymediamanager.scraper.entities.MediaCastMember;
import org.tinymediamanager.scraper.entities.MediaEpisode;
import org.tinymediamanager.scraper.entities.MediaType;
import org.tinymediamanager.scraper.mediaprovider.ITvShowMetadataProvider;
import org.tinymediamanager.ui.EqualsLayout;
import org.tinymediamanager.ui.IconManager;
import org.tinymediamanager.ui.TmmFontHelper;
import org.tinymediamanager.ui.TmmUIHelper;
import org.tinymediamanager.ui.UTF8Control;
import org.tinymediamanager.ui.components.AutocompleteComboBox;
import org.tinymediamanager.ui.components.ImageLabel;
import org.tinymediamanager.ui.components.MediaScraperComboBox;
import org.tinymediamanager.ui.components.datepicker.DatePicker;
import org.tinymediamanager.ui.dialogs.TmmDialog;
import org.tinymediamanager.ui.panels.MediaFileEditorPanel;
import org.tinymediamanager.ui.tvshows.dialogs.TvShowEpisodeChooserDialog;

public class TvShowEpisodeEditorDialog
extends TmmDialog
implements ActionListener {
    private static final long serialVersionUID = 7702248909791283043L;
    private static final ResourceBundle BUNDLE = ResourceBundle.getBundle("messages", new UTF8Control());
    private static final Logger LOGGER = LoggerFactory.getLogger(TvShowEpisodeEditorDialog.class);
    private static final Date INITIAL_DATE = new Date(0L);
    private static final String DIALOG_ID = "tvShowEpisodeScraper";
    private TvShowList tvShowList = TvShowList.getInstance();
    private TvShowEpisode episodeToEdit;
    private List<TvShowActor> cast = ObservableCollections.observableList(new ArrayList());
    private List<String> tags = ObservableCollections.observableList(new ArrayList());
    private List<MediaFile> mediaFiles = new ArrayList<MediaFile>();
    private boolean continueQueue = true;
    private int voteCount = 0;
    private JTextField tfTitle;
    private JLabel lblFilename;
    private JSpinner spEpisode;
    private JSpinner spSeason;
    private JSpinner spRating;
    private JSpinner spDvdSeason;
    private JSpinner spDvdEpisode;
    private JCheckBox cbDvdOrder;
    private JSpinner spDisplaySeason;
    private JSpinner spDisplayEpisode;
    private DatePicker dpFirstAired;
    private JSpinner spDateAdded;
    private JCheckBox chckbxWatched;
    private ImageLabel lblThumb;
    private JTextArea taPlot;
    private JTextField tfDirector;
    private JTextField tfWriter;
    private JTable tableGuests;
    private AutocompleteComboBox<String> cbTags;
    private AutoCompleteSupport<String> cbTagsAutoCompleteSupport;
    private JList<String> listTags;
    private JComboBox<MediaSource> cbMediaSource;
    private MediaFileEditorPanel mediaFilesPanel;
    private MediaScraperComboBox cbScraper;
    private JTableBinding<TvShowActor, List<TvShowActor>, JTable> jTableBinding;
    private JListBinding<String, List<String>, JList> jListBinding;

    public TvShowEpisodeEditorDialog(TvShowEpisode episode, boolean inQueue) {
        super(BUNDLE.getString("tvshowepisode.scrape"), DIALOG_ID);
        this.setBounds(5, 5, 964, 632);
        for (MediaFile mf : episode.getMediaFiles()) {
            this.mediaFiles.add(new MediaFile(mf));
        }
        this.episodeToEdit = episode;
        this.getContentPane().setLayout(new BorderLayout());
        JPanel panelFilename = new JPanel();
        this.getContentPane().add((Component)panelFilename, "North");
        panelFilename.setLayout((LayoutManager)new FormLayout(new ColumnSpec[]{FormFactory.RELATED_GAP_COLSPEC, FormFactory.DEFAULT_COLSPEC, FormFactory.DEFAULT_COLSPEC, FormFactory.RELATED_GAP_COLSPEC, FormFactory.DEFAULT_COLSPEC, FormFactory.RELATED_GAP_COLSPEC}, new RowSpec[]{FormFactory.LINE_GAP_ROWSPEC, RowSpec.decode((String)"15px"), FormFactory.RELATED_GAP_ROWSPEC}));
        JLabel lblFilenameT = new JLabel(BUNDLE.getString("metatag.path"));
        panelFilename.add((Component)lblFilenameT, "2, 2, left, top");
        this.lblFilename = new JLabel("");
        TmmFontHelper.changeFont(this.lblFilename, 1.166, 1);
        panelFilename.add((Component)this.lblFilename, "5, 2, left, top");
        JTabbedPane tabbedPane = new JTabbedPane(1);
        this.getContentPane().add((Component)tabbedPane, "Center");
        JPanel detailsPanel = new JPanel();
        tabbedPane.addTab(BUNDLE.getString("metatag.details"), detailsPanel);
        detailsPanel.setLayout((LayoutManager)new FormLayout(new ColumnSpec[]{FormSpecs.LABEL_COMPONENT_GAP_COLSPEC, FormSpecs.DEFAULT_COLSPEC, FormSpecs.RELATED_GAP_COLSPEC, ColumnSpec.decode((String)"40dlu:grow"), FormSpecs.RELATED_GAP_COLSPEC, ColumnSpec.decode((String)"7dlu:grow"), FormSpecs.RELATED_GAP_COLSPEC, FormSpecs.DEFAULT_COLSPEC, FormSpecs.RELATED_GAP_COLSPEC, ColumnSpec.decode((String)"20dlu"), FormSpecs.RELATED_GAP_COLSPEC, ColumnSpec.decode((String)"30dlu:grow"), FormSpecs.RELATED_GAP_COLSPEC, FormSpecs.DEFAULT_COLSPEC, FormSpecs.RELATED_GAP_COLSPEC, FormSpecs.DEFAULT_COLSPEC, FormSpecs.RELATED_GAP_COLSPEC, ColumnSpec.decode((String)"7dlu:grow"), FormSpecs.RELATED_GAP_COLSPEC, FormSpecs.DEFAULT_COLSPEC, FormSpecs.RELATED_GAP_COLSPEC, ColumnSpec.decode((String)"100dlu:grow"), FormSpecs.LABEL_COMPONENT_GAP_COLSPEC}, new RowSpec[]{FormSpecs.LINE_GAP_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC, FormSpecs.RELATED_GAP_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC, FormSpecs.RELATED_GAP_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC, FormSpecs.RELATED_GAP_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC, FormSpecs.RELATED_GAP_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC, FormSpecs.RELATED_GAP_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC, FormSpecs.RELATED_GAP_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC, FormSpecs.RELATED_GAP_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC, FormSpecs.RELATED_GAP_ROWSPEC, RowSpec.decode((String)"35dlu:grow"), FormSpecs.RELATED_GAP_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC, FormSpecs.RELATED_GAP_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC, FormSpecs.RELATED_GAP_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC, FormSpecs.RELATED_GAP_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC, FormSpecs.RELATED_GAP_ROWSPEC, RowSpec.decode((String)"default:grow"), FormSpecs.RELATED_GAP_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC, FormSpecs.RELATED_GAP_ROWSPEC}));
        JLabel lblTitle = new JLabel(BUNDLE.getString("metatag.title"));
        detailsPanel.add((Component)lblTitle, "2, 4, right, default");
        this.tfTitle = new JTextField();
        detailsPanel.add((Component)this.tfTitle, "4, 4, 19, 1");
        this.tfTitle.setColumns(10);
        JLabel lblSeason = new JLabel(BUNDLE.getString("metatag.season"));
        detailsPanel.add((Component)lblSeason, "2, 6, right, default");
        this.spSeason = new JSpinner();
        detailsPanel.add((Component)this.spSeason, "4, 6");
        JLabel lblEpisode = new JLabel(BUNDLE.getString("metatag.episode"));
        detailsPanel.add((Component)lblEpisode, "8, 6, right, default");
        this.spEpisode = new JSpinner();
        detailsPanel.add((Component)this.spEpisode, "10, 6");
        JLabel lblDvdSeason = new JLabel(BUNDLE.getString("metatag.dvdseason"));
        detailsPanel.add((Component)lblDvdSeason, "2, 8, right, default");
        this.spDvdSeason = new JSpinner();
        detailsPanel.add((Component)this.spDvdSeason, "4, 8");
        JLabel lblDvdEpisode = new JLabel(BUNDLE.getString("metatag.dvdepisode"));
        detailsPanel.add((Component)lblDvdEpisode, "8, 8, right, default");
        this.spDvdEpisode = new JSpinner();
        detailsPanel.add((Component)this.spDvdEpisode, "10, 8");
        JLabel lblDvdOrder = new JLabel(BUNDLE.getString("metatag.dvdorder"));
        detailsPanel.add((Component)lblDvdOrder, "14, 8, right, default");
        this.cbDvdOrder = new JCheckBox("");
        detailsPanel.add((Component)this.cbDvdOrder, "16, 8");
        this.cbDvdOrder.setSelected(this.episodeToEdit.isDvdOrder());
        JLabel lblDisplaySeason = new JLabel(BUNDLE.getString("metatag.displayseason"));
        detailsPanel.add((Component)lblDisplaySeason, "2, 10, right, default");
        this.spDisplaySeason = new JSpinner();
        detailsPanel.add((Component)this.spDisplaySeason, "4, 10");
        JLabel lblDisplayEpisode = new JLabel(BUNDLE.getString("metatag.displayepisode"));
        detailsPanel.add((Component)lblDisplayEpisode, "8, 10, right, default");
        this.spDisplayEpisode = new JSpinner();
        detailsPanel.add((Component)this.spDisplayEpisode, "10, 10");
        JLabel lblRating = new JLabel(BUNDLE.getString("metatag.rating"));
        detailsPanel.add((Component)lblRating, "2, 12, right, default");
        this.spRating = new JSpinner();
        detailsPanel.add((Component)this.spRating, "4, 12");
        JLabel lblFirstAired = new JLabel(BUNDLE.getString("metatag.aired"));
        detailsPanel.add((Component)lblFirstAired, "8, 12, right, default");
        this.dpFirstAired = new DatePicker(episode.getFirstAired());
        detailsPanel.add((Component)this.dpFirstAired, "10, 12, 3, 1, fill, default");
        JLabel lblWatched = new JLabel(BUNDLE.getString("metatag.watched"));
        detailsPanel.add((Component)lblWatched, "2, 14, right, default");
        this.chckbxWatched = new JCheckBox("");
        detailsPanel.add((Component)this.chckbxWatched, "4, 14");
        JLabel lblDateAdded = new JLabel(BUNDLE.getString("metatag.dateadded"));
        detailsPanel.add((Component)lblDateAdded, "8, 14, right, default");
        this.spDateAdded = new JSpinner(new SpinnerDateModel());
        detailsPanel.add((Component)this.spDateAdded, "10, 14, 3, 1, fill, default");
        JLabel lblMediasource = new JLabel(BUNDLE.getString("metatag.source"));
        detailsPanel.add((Component)lblMediasource, "2, 16, right, default");
        this.cbMediaSource = new JComboBox<MediaSource>(MediaSource.values());
        detailsPanel.add(this.cbMediaSource, "4, 16, 4, 1, fill, default");
        JLabel lblPlot = new JLabel(BUNDLE.getString("metatag.plot"));
        detailsPanel.add((Component)lblPlot, "2, 18, right, top");
        JScrollPane scrollPane = new JScrollPane();
        detailsPanel.add((Component)scrollPane, "4, 18, 13, 1, fill, fill");
        this.taPlot = new JTextArea();
        this.taPlot.setLineWrap(true);
        this.taPlot.setWrapStyleWord(true);
        scrollPane.setViewportView(this.taPlot);
        this.lblThumb = new ImageLabel();
        this.lblThumb.setAlternativeText(BUNDLE.getString("image.notfound.thumb"));
        this.lblThumb.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                String path = TmmProperties.getInstance().getProperty("tvShowEpisodeScraper.path");
                Path file = TmmUIHelper.selectFile(BUNDLE.getString("image.choose"), path);
                if (file != null && Utils.isRegularFile(file)) {
                    String fileName = file.toAbsolutePath().toString();
                    TvShowEpisodeEditorDialog.this.lblThumb.setImageUrl("file:/" + fileName);
                    TmmProperties.getInstance().putProperty("tvShowEpisodeScraper.path", fileName);
                }
            }
        });
        this.lblThumb.setCursor(Cursor.getPredefinedCursor(12));
        detailsPanel.add((Component)this.lblThumb, "20, 6, 3, 13");
        JLabel lblDirector = new JLabel(BUNDLE.getString("metatag.director"));
        detailsPanel.add((Component)lblDirector, "2, 20, right, default");
        this.tfDirector = new JTextField();
        this.tfDirector.setText(null);
        this.tfDirector.setColumns(10);
        detailsPanel.add((Component)this.tfDirector, "4, 20, 13, 1, fill, default");
        JLabel lblWriter = new JLabel(BUNDLE.getString("metatag.writer"));
        detailsPanel.add((Component)lblWriter, "2, 22, right, default");
        this.tfWriter = new JTextField();
        this.tfWriter.setText(null);
        this.tfWriter.setColumns(10);
        detailsPanel.add((Component)this.tfWriter, "4, 22, 13, 1, fill, default");
        JLabel lblGuests = new JLabel(BUNDLE.getString("metatag.guests"));
        detailsPanel.add((Component)lblGuests, "2, 24, right, top");
        JScrollPane scrollPaneGuests = new JScrollPane();
        detailsPanel.add((Component)scrollPaneGuests, "4, 24, 13, 7, fill, fill");
        this.tableGuests = new JTable();
        this.tableGuests.putClientProperty("terminateEditOnFocusLost", Boolean.TRUE);
        scrollPaneGuests.setViewportView(this.tableGuests);
        JLabel lblTags = new JLabel(BUNDLE.getString("metatag.tags"));
        detailsPanel.add((Component)lblTags, "20, 24, default, top");
        JScrollPane scrollPaneTags = new JScrollPane();
        detailsPanel.add((Component)scrollPaneTags, "22, 24, 1, 5, fill, fill");
        this.listTags = new JList();
        scrollPaneTags.setViewportView(this.listTags);
        JButton btnAddActor = new JButton("");
        btnAddActor.setMargin(new Insets(2, 2, 2, 2));
        btnAddActor.setAction(new AddActorAction());
        btnAddActor.setIcon(IconManager.LIST_ADD);
        detailsPanel.add((Component)btnAddActor, "2, 26, right, top");
        JButton btnAddTag = new JButton("");
        btnAddTag.setMargin(new Insets(2, 2, 2, 2));
        btnAddTag.setAction(new AddTagAction());
        btnAddTag.setIcon(IconManager.LIST_ADD);
        detailsPanel.add((Component)btnAddTag, "20, 26, right, top");
        JButton btnRemoveActor = new JButton("");
        btnRemoveActor.setMargin(new Insets(2, 2, 2, 2));
        btnRemoveActor.setAction(new RemoveActorAction());
        btnRemoveActor.setIcon(IconManager.LIST_REMOVE);
        detailsPanel.add((Component)btnRemoveActor, "2, 28, right, top");
        JButton btnRemoveTag = new JButton("");
        btnRemoveTag.setMargin(new Insets(2, 2, 2, 2));
        btnRemoveTag.setAction(new RemoveTagAction());
        btnRemoveTag.setIcon(IconManager.LIST_REMOVE);
        detailsPanel.add((Component)btnRemoveTag, "20, 28, right, top");
        this.cbTags = new AutocompleteComboBox<String>(this.tvShowList.getTagsInEpisodes());
        this.cbTags.setEditable(true);
        this.cbTagsAutoCompleteSupport = this.cbTags.getAutoCompleteSupport();
        InputMap im = this.cbTags.getInputMap(1);
        Object enterAction = im.get(KeyStroke.getKeyStroke(10, 0));
        this.cbTags.getActionMap().put(enterAction, new AddTagAction());
        detailsPanel.add(this.cbTags, "22, 30, fill, default");
        this.mediaFilesPanel = new MediaFileEditorPanel(this.mediaFiles);
        tabbedPane.addTab(BUNDLE.getString("metatag.mediafiles"), null, this.mediaFilesPanel, null);
        JPanel bottomPanel = new JPanel();
        this.getContentPane().add((Component)bottomPanel, "South");
        bottomPanel.setLayout((LayoutManager)new FormLayout(new ColumnSpec[]{FormFactory.LABEL_COMPONENT_GAP_COLSPEC, FormFactory.DEFAULT_COLSPEC, FormFactory.RELATED_GAP_COLSPEC, FormFactory.DEFAULT_COLSPEC, FormFactory.RELATED_GAP_COLSPEC, ColumnSpec.decode((String)"default:grow"), FormFactory.RELATED_GAP_COLSPEC, FormFactory.DEFAULT_COLSPEC, FormFactory.RELATED_GAP_COLSPEC}, new RowSpec[]{FormFactory.LINE_GAP_ROWSPEC, RowSpec.decode((String)"25px"), FormFactory.RELATED_GAP_ROWSPEC}));
        this.cbScraper = new MediaScraperComboBox(this.tvShowList.getAvailableMediaScrapers());
        MediaScraper defaultScraper = this.tvShowList.getDefaultMediaScraper();
        this.cbScraper.setSelectedItem(defaultScraper);
        bottomPanel.add((Component)this.cbScraper, "2, 2, fill, default");
        JButton btnScrape = new JButton(BUNDLE.getString("Button.scrape"));
        btnScrape.setPreferredSize(new Dimension(100, 23));
        btnScrape.setMaximumSize(new Dimension(0, 0));
        btnScrape.setMinimumSize(new Dimension(100, 23));
        btnScrape.setActionCommand("Scrape");
        btnScrape.addActionListener(this);
        bottomPanel.add((Component)btnScrape, "4, 2, left, fill");
        JButton btnSearch = new JButton(BUNDLE.getString("tvshowepisodechooser.search"));
        btnSearch.setActionCommand("Search");
        btnSearch.addActionListener(this);
        btnSearch.setIcon(IconManager.SEARCH);
        bottomPanel.add((Component)btnSearch, "6, 2, left, fill");
        JPanel buttonPane = new JPanel();
        bottomPanel.add((Component)buttonPane, "8, 2, fill, fill");
        EqualsLayout layout = new EqualsLayout(5);
        layout.setMinWidth(100);
        buttonPane.setLayout(layout);
        JButton okButton = new JButton(BUNDLE.getString("Button.ok"));
        okButton.setToolTipText(BUNDLE.getString("tvshow.change"));
        okButton.setIcon(IconManager.APPLY);
        buttonPane.add(okButton);
        okButton.setActionCommand("OK");
        okButton.addActionListener(this);
        JButton cancelButton = new JButton(BUNDLE.getString("Button.cancel"));
        cancelButton.setToolTipText(BUNDLE.getString("edit.discard"));
        cancelButton.setIcon(IconManager.CANCEL);
        buttonPane.add(cancelButton);
        cancelButton.setActionCommand("Cancel");
        cancelButton.addActionListener(this);
        if (inQueue) {
            JButton abortButton = new JButton(BUNDLE.getString("Button.abortqueue"));
            abortButton.setToolTipText(BUNDLE.getString("tvshow.edit.abortqueue.desc"));
            abortButton.setIcon(IconManager.PROCESS_STOP);
            buttonPane.add(abortButton);
            abortButton.setActionCommand("Abort");
            abortButton.addActionListener(this);
        }
        this.initDataBindings();
        MediaFile mediaFile = this.episodeToEdit.getMediaFiles().get(0);
        this.lblFilename.setText(mediaFile.getFileAsPath().toString());
        this.tfTitle.setText(this.episodeToEdit.getTitle());
        this.spSeason.setModel(new SpinnerNumberModel(this.episodeToEdit.getAiredSeason(), -1, Integer.MAX_VALUE, 1));
        this.spEpisode.setModel(new SpinnerNumberModel(this.episodeToEdit.getAiredEpisode(), -1, Integer.MAX_VALUE, 1));
        this.spDvdSeason.setModel(new SpinnerNumberModel(this.episodeToEdit.getDvdSeason(), -1, Integer.MAX_VALUE, 1));
        this.spDvdEpisode.setModel(new SpinnerNumberModel(this.episodeToEdit.getDvdEpisode(), -1, Integer.MAX_VALUE, 1));
        this.spDisplaySeason.setModel(new SpinnerNumberModel(this.episodeToEdit.getDisplaySeason(), -1, Integer.MAX_VALUE, 1));
        this.spDisplayEpisode.setModel(new SpinnerNumberModel(this.episodeToEdit.getDisplayEpisode(), -1, Integer.MAX_VALUE, 1));
        this.spDateAdded.setValue(this.episodeToEdit.getDateAdded());
        this.lblThumb.setImagePath(this.episodeToEdit.getArtworkFilename(MediaFileType.THUMB));
        this.spRating.setModel(new SpinnerNumberModel(this.episodeToEdit.getRating(), 0.0, 10.0, 0.1));
        this.spRating.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                TvShowEpisodeEditorDialog.this.voteCount = 1;
            }
        });
        this.voteCount = this.episodeToEdit.getVotes();
        this.chckbxWatched.setSelected(this.episodeToEdit.isWatched());
        this.taPlot.setText(this.episodeToEdit.getPlot());
        this.taPlot.setCaretPosition(0);
        this.tfDirector.setText(this.episodeToEdit.getDirector());
        this.tfWriter.setText(this.episodeToEdit.getWriter());
        this.cbMediaSource.setSelectedItem((Object)this.episodeToEdit.getMediaSource());
        for (TvShowActor origCast : this.episodeToEdit.getGuests()) {
            TvShowActor actor = new TvShowActor();
            actor.setName(origCast.getName());
            actor.setCharacter(origCast.getCharacter());
            actor.setThumbUrl(origCast.getThumbUrl());
            this.cast.add(actor);
        }
        for (String tag : this.episodeToEdit.getTags()) {
            this.tags.add(tag);
        }
        this.tableGuests.getColumnModel().getColumn(0).setHeaderValue(BUNDLE.getString("metatag.name"));
        this.tableGuests.getColumnModel().getColumn(1).setHeaderValue(BUNDLE.getString("metatag.role"));
    }

    public boolean showDialog() {
        this.setVisible(true);
        return this.continueQueue;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if ("OK".equals(e.getActionCommand())) {
            this.episodeToEdit.setTitle(this.tfTitle.getText());
            this.episodeToEdit.setDvdOrder(this.cbDvdOrder.isSelected());
            this.episodeToEdit.setAiredSeason((Integer)this.spSeason.getValue());
            this.episodeToEdit.setAiredEpisode((Integer)this.spEpisode.getValue());
            this.episodeToEdit.setDvdSeason((Integer)this.spDvdSeason.getValue());
            this.episodeToEdit.setDvdEpisode((Integer)this.spDvdEpisode.getValue());
            this.episodeToEdit.setDisplaySeason((Integer)this.spDisplaySeason.getValue());
            this.episodeToEdit.setDisplayEpisode((Integer)this.spDisplayEpisode.getValue());
            this.episodeToEdit.setMediaSource((MediaSource)((Object)this.cbMediaSource.getSelectedItem()));
            this.episodeToEdit.setPlot(this.taPlot.getText());
            MediaFileEditorPanel.syncMediaFiles(this.mediaFiles, this.episodeToEdit.getMediaFiles());
            this.episodeToEdit.fireEventForChangedMediaInformation();
            double tempRating = (Double)this.spRating.getValue();
            float rating = (float)tempRating;
            if (this.episodeToEdit.getRating() != rating) {
                this.episodeToEdit.setRating(rating);
                this.episodeToEdit.setVotes(this.voteCount);
            }
            this.episodeToEdit.setDateAdded((Date)this.spDateAdded.getValue());
            this.episodeToEdit.setFirstAired(this.dpFirstAired.getDate());
            this.episodeToEdit.setWatched(this.chckbxWatched.isSelected());
            this.episodeToEdit.setDirector(this.tfDirector.getText());
            this.episodeToEdit.setWriter(this.tfWriter.getText());
            this.episodeToEdit.setActors(this.cast);
            if (StringUtils.isNotEmpty((CharSequence)this.lblThumb.getImageUrl()) && (!this.lblThumb.getImageUrl().equals(this.episodeToEdit.getArtworkUrl(MediaFileType.THUMB)) || StringUtils.isBlank((CharSequence)this.episodeToEdit.getArtworkUrl(MediaFileType.THUMB)))) {
                this.episodeToEdit.setArtworkUrl(this.lblThumb.getImageUrl(), MediaFileType.THUMB);
                this.episodeToEdit.writeThumbImage();
            }
            this.episodeToEdit.setTags(this.tags);
            this.episodeToEdit.writeNFO();
            this.episodeToEdit.saveToDb();
            this.setVisible(false);
        }
        if ("Cancel".equals(e.getActionCommand())) {
            this.setVisible(false);
        }
        if ("Abort".equals(e.getActionCommand())) {
            this.continueQueue = false;
            this.setVisible(false);
        }
        if ("Scrape".equals(e.getActionCommand())) {
            MediaScraper scraper = (MediaScraper)this.cbScraper.getSelectedItem();
            ScrapeTask task = new ScrapeTask(scraper);
            task.execute();
        }
        if ("Search".equals(e.getActionCommand())) {
            MediaScraper scraper = (MediaScraper)this.cbScraper.getSelectedItem();
            TvShowEpisodeChooserDialog dialog = new TvShowEpisodeChooserDialog(this.episodeToEdit, scraper);
            dialog.setLocationRelativeTo(this);
            dialog.setVisible(true);
            MediaEpisode metadata = dialog.getMetadata();
            if (metadata != null && StringUtils.isNotBlank((CharSequence)metadata.title)) {
                this.tfTitle.setText(metadata.title);
                this.taPlot.setText(metadata.plot);
                this.spEpisode.setValue(metadata.episode);
                this.spSeason.setValue(metadata.season);
                for (MediaArtwork ma : metadata.artwork) {
                    if (ma.getType() != MediaArtwork.MediaArtworkType.THUMB) continue;
                    this.lblThumb.setImageUrl(ma.getDefaultUrl());
                    break;
                }
            }
        }
    }

    protected void initDataBindings() {
        this.jTableBinding = SwingBindings.createJTableBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ, this.cast, (JTable)this.tableGuests);
        BeanProperty movieCastBeanProperty = BeanProperty.create((String)"name");
        this.jTableBinding.addColumnBinding((Property)movieCastBeanProperty);
        BeanProperty movieCastBeanProperty_1 = BeanProperty.create((String)"character");
        this.jTableBinding.addColumnBinding((Property)movieCastBeanProperty_1);
        this.jTableBinding.bind();
        this.jListBinding = SwingBindings.createJListBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ, this.tags, this.listTags);
        this.jListBinding.bind();
    }

    @Override
    public void dispose() {
        super.dispose();
        this.jTableBinding.unbind();
        this.jListBinding.unbind();
        this.mediaFilesPanel.unbindBindings();
        this.dpFirstAired.cleanup();
    }

    @Override
    public void pack() {
    }

    private class RemoveActorAction
    extends AbstractAction {
        private static final long serialVersionUID = 6970920169867315771L;

        public RemoveActorAction() {
            this.putValue("ShortDescription", BUNDLE.getString("cast.actor.remove"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int row = TvShowEpisodeEditorDialog.this.tableGuests.getSelectedRow();
            if (row > -1) {
                row = TvShowEpisodeEditorDialog.this.tableGuests.convertRowIndexToModel(row);
                TvShowEpisodeEditorDialog.this.cast.remove(row);
            }
        }
    }

    private class AddActorAction
    extends AbstractAction {
        private static final long serialVersionUID = -5879601617842300526L;

        public AddActorAction() {
            this.putValue("ShortDescription", BUNDLE.getString("cast.actor.add"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            TvShowActor actor = new TvShowActor(BUNDLE.getString("cast.actor.unknown"), BUNDLE.getString("cast.role.unknown"));
            TvShowEpisodeEditorDialog.this.cast.add(0, actor);
        }
    }

    private class RemoveTagAction
    extends AbstractAction {
        private static final long serialVersionUID = -4799506776650330500L;

        public RemoveTagAction() {
            this.putValue("ShortDescription", BUNDLE.getString("tag.remove"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            List selectedTags = TvShowEpisodeEditorDialog.this.listTags.getSelectedValuesList();
            for (String tag : selectedTags) {
                TvShowEpisodeEditorDialog.this.tags.remove(tag);
            }
        }
    }

    private class AddTagAction
    extends AbstractAction {
        private static final long serialVersionUID = 5968029647764173330L;

        public AddTagAction() {
            this.putValue("ShortDescription", BUNDLE.getString("tag.add"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JTextField tf;
            String selectedText;
            String newTag = (String)TvShowEpisodeEditorDialog.this.cbTags.getSelectedItem();
            if (StringUtils.isBlank((CharSequence)newTag)) {
                return;
            }
            Component editorComponent = TvShowEpisodeEditorDialog.this.cbTags.getEditor().getEditorComponent();
            if (editorComponent instanceof JTextField && (selectedText = (tf = (JTextField)editorComponent).getSelectedText()) != null) {
                tf.setSelectionStart(0);
                tf.setSelectionEnd(0);
                tf.setCaretPosition(tf.getText().length());
                return;
            }
            boolean tagFound = false;
            for (String tag : TvShowEpisodeEditorDialog.this.tags) {
                if (!tag.equals(newTag)) continue;
                tagFound = true;
                break;
            }
            if (!tagFound) {
                TvShowEpisodeEditorDialog.this.tags.add(newTag);
                if (editorComponent instanceof JTextField) {
                    TvShowEpisodeEditorDialog.this.cbTagsAutoCompleteSupport.setFirstItem((Object)"");
                    TvShowEpisodeEditorDialog.this.cbTags.setSelectedIndex(0);
                    TvShowEpisodeEditorDialog.this.cbTagsAutoCompleteSupport.removeFirstItem();
                }
            }
        }
    }

    private class ScrapeTask
    extends SwingWorker<Void, Void> {
        MediaScraper mediaScraper;

        public ScrapeTask(MediaScraper mediaScraper) {
            this.mediaScraper = mediaScraper;
        }

        @Override
        protected Void doInBackground() throws Exception {
            block13: {
                TvShowEpisodeEditorDialog.this.setCursor(Cursor.getPredefinedCursor(3));
                MediaScrapeOptions options = new MediaScrapeOptions(MediaType.TV_EPISODE);
                options.setLanguage(LocaleUtils.toLocale((String)TvShowModuleManager.SETTINGS.getScraperLanguage().name()));
                options.setCountry(TvShowModuleManager.SETTINGS.getCertificationCountry());
                for (Map.Entry<String, Object> entry : TvShowEpisodeEditorDialog.this.episodeToEdit.getTvShow().getIds().entrySet()) {
                    options.setId(entry.getKey(), entry.getValue().toString());
                }
                options.setId("seasonNr", TvShowEpisodeEditorDialog.this.spSeason.getValue().toString());
                options.setId("episodeNr", TvShowEpisodeEditorDialog.this.spEpisode.getValue().toString());
                options.setId("dvdSeasonNr", TvShowEpisodeEditorDialog.this.spDvdSeason.getValue().toString());
                options.setId("dvdEpisodeNr", TvShowEpisodeEditorDialog.this.spDvdEpisode.getValue().toString());
                try {
                    LOGGER.info("=====================================================");
                    LOGGER.info("Scraper metadata with scraper: " + this.mediaScraper.getMediaProvider().getProviderInfo().getId() + ", " + this.mediaScraper.getMediaProvider().getProviderInfo().getVersion());
                    LOGGER.info(options.toString());
                    LOGGER.info("=====================================================");
                    MediaMetadata metadata = ((ITvShowMetadataProvider)this.mediaScraper.getMediaProvider()).getMetadata(options);
                    if (metadata == null || StringUtils.isBlank((CharSequence)metadata.getTitle())) {
                        JOptionPane.showMessageDialog(TvShowEpisodeEditorDialog.this, BUNDLE.getString("message.scrape.tvshowepisodefailed"));
                        break block13;
                    }
                    TvShowEpisodeEditorDialog.this.tfTitle.setText(metadata.getTitle());
                    TvShowEpisodeEditorDialog.this.taPlot.setText(metadata.getPlot());
                    TvShowEpisodeEditorDialog.this.dpFirstAired.setDate(metadata.getReleaseDate());
                    TvShowEpisodeEditorDialog.this.spRating.setValue(new Double(metadata.getRating()));
                    TvShowEpisodeEditorDialog.this.voteCount = metadata.getVoteCount();
                    TvShowEpisodeEditorDialog.this.spSeason.setValue(metadata.getSeasonNumber());
                    TvShowEpisodeEditorDialog.this.spEpisode.setValue(metadata.getEpisodeNumber());
                    TvShowEpisodeEditorDialog.this.spDvdSeason.setValue(metadata.getDvdSeasonNumber());
                    TvShowEpisodeEditorDialog.this.spDvdEpisode.setValue(metadata.getDvdEpisodeNumber());
                    TvShowEpisodeEditorDialog.this.spDisplayEpisode.setValue(metadata.getDisplayEpisodeNumber());
                    TvShowEpisodeEditorDialog.this.spDisplaySeason.setValue(metadata.getDisplaySeasonNumber());
                    ArrayList<TvShowActor> actors = new ArrayList<TvShowActor>();
                    String director = "";
                    String writer = "";
                    for (MediaCastMember member : metadata.getCastMembers()) {
                        switch (member.getType()) {
                            case ACTOR: {
                                TvShowActor actor = new TvShowActor();
                                actor.setName(member.getName());
                                actor.setCharacter(member.getCharacter());
                                actor.setThumbUrl(member.getImageUrl());
                                actors.add(actor);
                                break;
                            }
                            case DIRECTOR: {
                                if (!StringUtils.isEmpty((CharSequence)director)) {
                                    director = director + ", ";
                                }
                                director = director + member.getName();
                                break;
                            }
                            case WRITER: {
                                if (!StringUtils.isEmpty((CharSequence)writer)) {
                                    writer = writer + ", ";
                                }
                                writer = writer + member.getName();
                                break;
                            }
                        }
                    }
                    TvShowEpisodeEditorDialog.this.cast.clear();
                    TvShowEpisodeEditorDialog.this.cast.addAll(actors);
                    TvShowEpisodeEditorDialog.this.tfDirector.setText(director);
                    TvShowEpisodeEditorDialog.this.tfWriter.setText(writer);
                    for (MediaArtwork ma : metadata.getFanart()) {
                        if (ma.getType() != MediaArtwork.MediaArtworkType.THUMB) continue;
                        TvShowEpisodeEditorDialog.this.lblThumb.setImageUrl(ma.getDefaultUrl());
                        break;
                    }
                }
                catch (Exception e) {
                    LOGGER.warn("Error getting metadata " + e.getMessage());
                }
            }
            TvShowEpisodeEditorDialog.this.setCursor(Cursor.getPredefinedCursor(0));
            return null;
        }
    }
}

