/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.tvshows.dialogs;

import ca.odell.glazedlists.BasicEventList;
import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.FilterList;
import ca.odell.glazedlists.GlazedLists;
import ca.odell.glazedlists.ObservableElementList;
import ca.odell.glazedlists.SortedList;
import ca.odell.glazedlists.TextFilterator;
import ca.odell.glazedlists.gui.TableFormat;
import ca.odell.glazedlists.matchers.MatcherEditor;
import ca.odell.glazedlists.swing.AdvancedTableModel;
import ca.odell.glazedlists.swing.DefaultEventSelectionModel;
import ca.odell.glazedlists.swing.GlazedListsSwing;
import ca.odell.glazedlists.swing.TextComponentMatcherEditor;
import com.jgoodies.forms.factories.FormFactory;
import com.jgoodies.forms.layout.ColumnSpec;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.forms.layout.FormSpecs;
import com.jgoodies.forms.layout.RowSpec;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JViewport;
import javax.swing.ListSelectionModel;
import javax.swing.SwingWorker;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableModel;
import javax.swing.text.JTextComponent;
import org.apache.commons.lang3.LocaleUtils;
import org.tinymediamanager.core.tvshow.TvShowEpisodeAndSeasonParser;
import org.tinymediamanager.core.tvshow.TvShowModuleManager;
import org.tinymediamanager.core.tvshow.entities.TvShowEpisode;
import org.tinymediamanager.scraper.MediaScrapeOptions;
import org.tinymediamanager.scraper.MediaScraper;
import org.tinymediamanager.scraper.entities.MediaEpisode;
import org.tinymediamanager.scraper.entities.MediaType;
import org.tinymediamanager.scraper.mediaprovider.ITvShowMetadataProvider;
import org.tinymediamanager.ui.EqualsLayout;
import org.tinymediamanager.ui.IconManager;
import org.tinymediamanager.ui.UTF8Control;
import org.tinymediamanager.ui.components.EnhancedTextField;
import org.tinymediamanager.ui.dialogs.TmmDialog;
import org.tinymediamanager.ui.tvshows.TvShowEpisodeChooserModel;

public class TvShowEpisodeChooserDialog
extends TmmDialog
implements ActionListener {
    private static final long serialVersionUID = 3317576458848699068L;
    private static final ResourceBundle BUNDLE = ResourceBundle.getBundle("messages", new UTF8Control());
    private TvShowEpisode episode;
    private MediaScraper mediaScraper;
    private MediaEpisode metadata;
    private ObservableElementList<TvShowEpisodeChooserModel> episodeEventList;
    private final List<TvShowEpisodeChooserModel> selectedEpisodes;
    private final SortedList<TvShowEpisodeChooserModel> sortedEpisodes;
    private JTable table;
    private JTextArea taPlot;
    private JTextField textField;

    public TvShowEpisodeChooserDialog(TvShowEpisode ep, MediaScraper mediaScraper) {
        super(BUNDLE.getString("tvshowepisode.choose"), "episodeChooser");
        this.setBounds(5, 5, 600, 400);
        this.episode = ep;
        this.mediaScraper = mediaScraper;
        this.metadata = new MediaEpisode(mediaScraper.getId());
        this.episodeEventList = new ObservableElementList((EventList)GlazedLists.threadSafeList((EventList)new BasicEventList()), GlazedLists.beanConnector(TvShowEpisodeChooserModel.class));
        this.sortedEpisodes = new SortedList((EventList)GlazedListsSwing.swingThreadProxyList(this.episodeEventList), (Comparator)new EpisodeComparator());
        this.getContentPane().setLayout((LayoutManager)new FormLayout(new ColumnSpec[]{FormSpecs.RELATED_GAP_COLSPEC, ColumnSpec.decode((String)"590px:grow"), FormSpecs.RELATED_GAP_COLSPEC}, new RowSpec[]{FormSpecs.RELATED_GAP_ROWSPEC, RowSpec.decode((String)"200dlu:grow"), FormSpecs.RELATED_GAP_ROWSPEC, RowSpec.decode((String)"fill:37px"), FormSpecs.RELATED_GAP_ROWSPEC}));
        JSplitPane splitPane = new JSplitPane();
        this.getContentPane().add((Component)splitPane, "2, 2, fill, fill");
        JPanel panelLeft = new JPanel();
        panelLeft.setLayout((LayoutManager)new FormLayout(new ColumnSpec[]{FormSpecs.RELATED_GAP_COLSPEC, ColumnSpec.decode((String)"150dlu:grow"), FormSpecs.RELATED_GAP_COLSPEC}, new RowSpec[]{FormSpecs.LINE_GAP_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC, FormSpecs.RELATED_GAP_ROWSPEC, RowSpec.decode((String)"default:grow"), FormSpecs.RELATED_GAP_ROWSPEC}));
        this.textField = EnhancedTextField.createSearchTextField();
        panelLeft.add((Component)this.textField, "2, 2, fill, default");
        this.textField.setColumns(10);
        JScrollPane scrollPane = new JScrollPane();
        scrollPane.setMinimumSize(new Dimension(200, 23));
        panelLeft.add((Component)scrollPane, "2, 4, fill, fill");
        splitPane.setLeftComponent(panelLeft);
        TextComponentMatcherEditor textMatcherEditor = new TextComponentMatcherEditor((JTextComponent)this.textField, (TextFilterator)new TvShowEpisodeChooserModelFilterator());
        FilterList textFilteredEpisodes = new FilterList(this.sortedEpisodes, (MatcherEditor)textMatcherEditor);
        AdvancedTableModel episodeTableModel = GlazedListsSwing.eventTableModelWithThreadProxyList((EventList)textFilteredEpisodes, (TableFormat)new EpisodeTableFormat());
        DefaultEventSelectionModel selectionModel = new DefaultEventSelectionModel((EventList)textFilteredEpisodes);
        this.selectedEpisodes = selectionModel.getSelected();
        selectionModel.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (e.getValueIsAdjusting()) {
                    return;
                }
                if (!TvShowEpisodeChooserDialog.this.selectedEpisodes.isEmpty()) {
                    TvShowEpisodeChooserModel episode = (TvShowEpisodeChooserModel)TvShowEpisodeChooserDialog.this.selectedEpisodes.get(0);
                    TvShowEpisodeChooserDialog.this.taPlot.setText(episode.getOverview());
                } else {
                    TvShowEpisodeChooserDialog.this.taPlot.setText("");
                }
                TvShowEpisodeChooserDialog.this.taPlot.setCaretPosition(0);
            }
        });
        this.table = new JTable((TableModel)episodeTableModel);
        this.table.setSelectionModel((ListSelectionModel)selectionModel);
        scrollPane.setViewportView(this.table);
        JPanel panelRight = new JPanel();
        panelRight.setLayout((LayoutManager)new FormLayout(new ColumnSpec[]{FormSpecs.RELATED_GAP_COLSPEC, ColumnSpec.decode((String)"150dlu:grow"), FormSpecs.RELATED_GAP_COLSPEC}, new RowSpec[]{FormSpecs.LINE_GAP_ROWSPEC, RowSpec.decode((String)"default:grow"), FormSpecs.RELATED_GAP_ROWSPEC}));
        JScrollPane scrollPane_1 = new JScrollPane();
        panelRight.add((Component)scrollPane_1, "2, 2, fill, fill");
        splitPane.setRightComponent(panelRight);
        this.taPlot = new JTextArea();
        this.taPlot.setEditable(false);
        this.taPlot.setWrapStyleWord(true);
        this.taPlot.setLineWrap(true);
        scrollPane_1.setViewportView(this.taPlot);
        splitPane.setDividerLocation(300);
        JPanel bottomPanel = new JPanel();
        this.getContentPane().add((Component)bottomPanel, "2, 4, fill, top");
        bottomPanel.setLayout((LayoutManager)new FormLayout(new ColumnSpec[]{FormFactory.LABEL_COMPONENT_GAP_COLSPEC, FormFactory.DEFAULT_COLSPEC, FormFactory.RELATED_GAP_COLSPEC, ColumnSpec.decode((String)"default:grow"), FormFactory.DEFAULT_COLSPEC, FormFactory.RELATED_GAP_COLSPEC}, new RowSpec[]{FormFactory.LINE_GAP_ROWSPEC, RowSpec.decode((String)"25px"), FormFactory.RELATED_GAP_ROWSPEC}));
        JPanel buttonPane = new JPanel();
        bottomPanel.add((Component)buttonPane, "5, 2, fill, fill");
        EqualsLayout layout = new EqualsLayout(5);
        layout.setMinWidth(100);
        buttonPane.setLayout(layout);
        final JButton okButton = new JButton(BUNDLE.getString("Button.ok"));
        okButton.setToolTipText(BUNDLE.getString("tvshow.change"));
        okButton.setIcon(IconManager.APPLY);
        buttonPane.add(okButton);
        okButton.setActionCommand("OK");
        okButton.addActionListener(this);
        JButton cancelButton = new JButton(BUNDLE.getString("Button.cancel"));
        cancelButton.setToolTipText(BUNDLE.getString("edit.discard"));
        cancelButton.setIcon(IconManager.CANCEL);
        buttonPane.add(cancelButton);
        cancelButton.setActionCommand("Cancel");
        cancelButton.addActionListener(this);
        this.table.getColumnModel().getColumn(0).setMaxWidth(50);
        this.table.getColumnModel().getColumn(1).setMaxWidth(50);
        SearchTask task = new SearchTask();
        task.execute();
        MouseListener mouseListener = new MouseListener(){

            @Override
            public void mouseReleased(MouseEvent e) {
            }

            @Override
            public void mousePressed(MouseEvent e) {
            }

            @Override
            public void mouseExited(MouseEvent e) {
            }

            @Override
            public void mouseEntered(MouseEvent e) {
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() >= 2 && !e.isConsumed() && e.getButton() == 1) {
                    TvShowEpisodeChooserDialog.this.actionPerformed(new ActionEvent(okButton, 1001, "OK"));
                }
            }
        };
        this.table.addMouseListener(mouseListener);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if ("OK".equals(e.getActionCommand()) && !this.selectedEpisodes.isEmpty()) {
            TvShowEpisodeChooserModel episode = this.selectedEpisodes.get(0);
            if (episode != TvShowEpisodeChooserModel.emptyResult) {
                this.metadata = episode.getMediaEpisode();
            }
            this.setVisible(false);
        }
        if ("Cancel".equals(e.getActionCommand())) {
            this.setVisible(false);
        }
    }

    public MediaEpisode getMetadata() {
        return this.metadata;
    }

    private class EpisodeTableFormat
    implements TableFormat<TvShowEpisodeChooserModel> {
        private EpisodeTableFormat() {
        }

        public int getColumnCount() {
            return 3;
        }

        public String getColumnName(int column) {
            switch (column) {
                case 0: {
                    return BUNDLE.getString("metatag.season");
                }
                case 1: {
                    return BUNDLE.getString("metatag.episode");
                }
                case 2: {
                    return BUNDLE.getString("metatag.title");
                }
            }
            return null;
        }

        public Object getColumnValue(TvShowEpisodeChooserModel baseObject, int column) {
            switch (column) {
                case 0: {
                    return baseObject.getSeason();
                }
                case 1: {
                    return baseObject.getEpisode();
                }
                case 2: {
                    return baseObject.getTitle();
                }
            }
            return null;
        }
    }

    private class EpisodeComparator
    implements Comparator<TvShowEpisodeChooserModel> {
        private EpisodeComparator() {
        }

        @Override
        public int compare(TvShowEpisodeChooserModel o1, TvShowEpisodeChooserModel o2) {
            if (o1.getSeason() < o2.getSeason()) {
                return -1;
            }
            if (o1.getSeason() > o2.getSeason()) {
                return 1;
            }
            if (o1.getEpisode() < o2.getEpisode()) {
                return -1;
            }
            if (o1.getEpisode() > o2.getEpisode()) {
                return 1;
            }
            return 0;
        }
    }

    private class TvShowEpisodeChooserModelFilterator
    implements TextFilterator<TvShowEpisodeChooserModel> {
        private TvShowEpisodeChooserModelFilterator() {
        }

        public void getFilterStrings(List<String> baseList, TvShowEpisodeChooserModel model) {
            baseList.add(model.getTitle());
            baseList.add(model.getOverview());
        }
    }

    private class SearchTask
    extends SwingWorker<Void, Void> {
        private SearchTask() {
        }

        @Override
        public Void doInBackground() {
            MediaScrapeOptions options = new MediaScrapeOptions(MediaType.TV_EPISODE);
            options.setLanguage(LocaleUtils.toLocale((String)TvShowModuleManager.SETTINGS.getScraperLanguage().name()));
            options.setCountry(TvShowModuleManager.SETTINGS.getCertificationCountry());
            for (Map.Entry<String, Object> entry : TvShowEpisodeChooserDialog.this.episode.getTvShow().getIds().entrySet()) {
                options.setId(entry.getKey(), entry.getValue().toString());
            }
            try {
                for (MediaEpisode episode : ((ITvShowMetadataProvider)TvShowEpisodeChooserDialog.this.mediaScraper.getMediaProvider()).getEpisodeList(options)) {
                    TvShowEpisodeChooserDialog.this.episodeEventList.add((Object)new TvShowEpisodeChooserModel(TvShowEpisodeChooserDialog.this.mediaScraper, episode));
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return null;
        }

        @Override
        protected void done() {
            if (TvShowEpisodeChooserDialog.this.textField.getText().isEmpty()) {
                TvShowEpisodeChooserModel model;
                int i;
                int index = -1;
                for (i = 0; i < TvShowEpisodeChooserDialog.this.sortedEpisodes.size(); ++i) {
                    model = (TvShowEpisodeChooserModel)TvShowEpisodeChooserDialog.this.sortedEpisodes.get(i);
                    if (!this.equals(TvShowEpisodeAndSeasonParser.cleanEpisodeTitle(TvShowEpisodeChooserDialog.this.episode.getVideoBasenameWithoutStacking(), TvShowEpisodeChooserDialog.this.episode.getTvShow().getTitle()), model.getTitle())) continue;
                    index = i;
                    break;
                }
                if (index == 0) {
                    for (i = 0; i < TvShowEpisodeChooserDialog.this.sortedEpisodes.size(); ++i) {
                        model = (TvShowEpisodeChooserModel)TvShowEpisodeChooserDialog.this.sortedEpisodes.get(i);
                        if (!this.equals(TvShowEpisodeAndSeasonParser.cleanEpisodeTitle(TvShowEpisodeChooserDialog.this.episode.getTitle(), TvShowEpisodeChooserDialog.this.episode.getTvShow().getTitle()), model.getTitle())) continue;
                        index = i;
                        break;
                    }
                }
                if (index > -1) {
                    TvShowEpisodeChooserDialog.this.table.getSelectionModel().setSelectionInterval(index, index);
                    this.scrollToVisible(index, 0);
                }
            }
        }

        private boolean equals(String title1, String title2) {
            String cleaned1 = title1.replaceAll("[!?,._-]", " ").replaceAll("\\s+", " ").trim();
            String cleaned2 = title2.replaceAll("[!?,._-]", " ").replaceAll("\\s+", " ").trim();
            return cleaned1.equalsIgnoreCase(cleaned2);
        }

        private void scrollToVisible(int rowIndex, int vColIndex) {
            if (!(TvShowEpisodeChooserDialog.this.table.getParent() instanceof JViewport)) {
                return;
            }
            if (TvShowEpisodeChooserDialog.this.table.getRowCount() < 1) {
                return;
            }
            Dimension viewportExtentSize = ((JViewport)TvShowEpisodeChooserDialog.this.table.getParent()).getExtentSize();
            Dimension cellDimension = new Dimension(0, 0);
            Rectangle rect = TvShowEpisodeChooserDialog.this.table.getCellRect(rowIndex, vColIndex, true);
            if (rowIndex + 1 < TvShowEpisodeChooserDialog.this.table.getRowCount()) {
                if (vColIndex + 1 < TvShowEpisodeChooserDialog.this.table.getColumnCount()) {
                    ++vColIndex;
                }
                Rectangle rectOne = TvShowEpisodeChooserDialog.this.table.getCellRect(rowIndex + 1, vColIndex, true);
                cellDimension.width = rectOne.x - rect.x;
                cellDimension.height = rectOne.y - rect.y;
            }
            rect.setLocation(rect.x + viewportExtentSize.width - cellDimension.width, rect.y + viewportExtentSize.height - cellDimension.height);
            TvShowEpisodeChooserDialog.this.table.scrollRectToVisible(rect);
        }
    }
}

