/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.tvshows;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JTree;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.tinymediamanager.core.AbstractModelObject;
import org.tinymediamanager.core.tvshow.TvShowList;
import org.tinymediamanager.core.tvshow.entities.TvShow;
import org.tinymediamanager.core.tvshow.entities.TvShowEpisode;
import org.tinymediamanager.core.tvshow.entities.TvShowSeason;
import org.tinymediamanager.ui.tvshows.TvShowEpisodeTreeNode;
import org.tinymediamanager.ui.tvshows.TvShowExtendedMatcher;
import org.tinymediamanager.ui.tvshows.TvShowRootTreeNode;
import org.tinymediamanager.ui.tvshows.TvShowSeasonTreeNode;
import org.tinymediamanager.ui.tvshows.TvShowTreeNode;

public class TvShowTreeModel
implements TreeModel {
    private TvShowRootTreeNode root = new TvShowRootTreeNode();
    private List<TreeModelListener> listeners = new ArrayList<TreeModelListener>();
    private Map<Object, TreeNode> nodeMap = Collections.synchronizedMap(new HashMap());
    private TvShowList tvShowList = TvShowList.getInstance();
    private PropertyChangeListener propertyChangeListener;
    private TvShowExtendedMatcher matcher = new TvShowExtendedMatcher();

    public TvShowTreeModel(List<TvShow> tvShows) {
        this.propertyChangeListener = new PropertyChangeListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                DefaultMutableTreeNode parent;
                int index;
                DefaultMutableTreeNode node;
                TvShowEpisode episode;
                TvShow tvShow;
                if ("addedTvShow".equals(evt.getPropertyName()) && evt.getNewValue() instanceof TvShow) {
                    tvShow = (TvShow)evt.getNewValue();
                    TvShowTreeModel.this.addTvShow(tvShow);
                }
                if ("removedTvShow".equals(evt.getPropertyName()) && evt.getNewValue() instanceof TvShow) {
                    tvShow = (TvShow)evt.getNewValue();
                    TvShowTreeModel.this.removeTvShow(tvShow);
                }
                if ("season".equals(evt.getPropertyName()) && evt.getNewValue() instanceof TvShowSeason) {
                    TvShowSeason season = (TvShowSeason)evt.getNewValue();
                    TvShowRootTreeNode tvShowRootTreeNode = TvShowTreeModel.this.root;
                    synchronized (tvShowRootTreeNode) {
                        TvShowTreeModel.this.addTvShowSeason(season, season.getTvShow());
                    }
                }
                if ("addedEpisode".equals(evt.getPropertyName()) && evt.getNewValue() instanceof TvShowEpisode) {
                    episode = (TvShowEpisode)evt.getNewValue();
                    TvShowTreeModel.this.addTvShowEpisode(episode, episode.getTvShow().getSeasonForEpisode(episode));
                }
                if ("removedEpisode".equals(evt.getPropertyName()) && evt.getNewValue() instanceof TvShowEpisode) {
                    episode = (TvShowEpisode)evt.getNewValue();
                    TvShowTreeModel.this.removeTvShowEpisode(episode);
                }
                if (("season".equals(evt.getPropertyName()) || "episode".equals(evt.getPropertyName())) && evt.getSource() instanceof TvShowEpisode) {
                    episode = (TvShowEpisode)evt.getSource();
                    TvShowTreeModel.this.removeTvShowEpisode(episode);
                    TvShowTreeModel.this.addTvShowEpisode(episode, episode.getTvShow().getSeasonForEpisode(episode));
                }
                if (evt.getSource() instanceof TvShow && ("title".equals(evt.getPropertyName()) || "hasNfoFile".equals(evt.getPropertyName()) || "hasImages".equals(evt.getPropertyName()))) {
                    TreeModelEvent event = new TreeModelEvent((Object)this, TvShowTreeModel.this.root.getPath(), null, null);
                    for (TreeModelListener listener : TvShowTreeModel.this.listeners) {
                        listener.treeNodesChanged(event);
                    }
                }
                if (evt.getSource() instanceof TvShowEpisode && (node = (DefaultMutableTreeNode)TvShowTreeModel.this.nodeMap.get(evt.getSource())) != null && (index = (parent = (DefaultMutableTreeNode)node.getParent()).getIndex(node)) >= 0) {
                    TreeModelEvent event = new TreeModelEvent((Object)this, parent.getPath(), new int[]{index}, new Object[]{node});
                    for (TreeModelListener listener : TvShowTreeModel.this.listeners) {
                        try {
                            listener.treeNodesChanged(event);
                        }
                        catch (ArrayIndexOutOfBoundsException | NullPointerException ignored) {}
                    }
                }
            }
        };
        this.tvShowList.addPropertyChangeListener(this.propertyChangeListener);
        for (TvShow tvShow : tvShows) {
            this.addTvShow(tvShow);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addTvShow(TvShow tvShow) {
        TvShowRootTreeNode tvShowRootTreeNode = this.root;
        synchronized (tvShowRootTreeNode) {
            TvShowTreeNode tvShowNode = new TvShowTreeNode(tvShow);
            this.root.add(tvShowNode);
            this.nodeMap.put(tvShow, tvShowNode);
            for (TvShowSeason season : new ArrayList<TvShowSeason>(tvShow.getSeasons())) {
                TvShowSeasonTreeNode seasonNode = (TvShowSeasonTreeNode)this.nodeMap.get(season);
                if (seasonNode == null) {
                    this.addTvShowSeason(season, tvShow);
                }
                for (TvShowEpisode episode : new ArrayList<TvShowEpisode>(season.getEpisodes())) {
                    this.addTvShowEpisode(episode, season);
                }
            }
            int index = this.getIndexOfChild(this.root, tvShowNode);
            if (index > -1) {
                TreeModelEvent event = new TreeModelEvent((Object)this, this.root.getPath(), new int[]{index}, new Object[]{tvShow});
                for (TreeModelListener listener : this.listeners) {
                    try {
                        listener.treeNodesInserted(event);
                    }
                    catch (ArrayIndexOutOfBoundsException | NullPointerException ignored) {}
                }
            }
        }
        tvShow.addPropertyChangeListener(this.propertyChangeListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeTvShow(TvShow tvShow) {
        TvShowRootTreeNode tvShowRootTreeNode = this.root;
        synchronized (tvShowRootTreeNode) {
            TvShowTreeNode child = (TvShowTreeNode)this.nodeMap.get(tvShow);
            TvShowRootTreeNode parent = this.root;
            if (child != null) {
                int index = this.getIndexOfChild(parent, child);
                this.nodeMap.remove(tvShow);
                for (TvShowEpisode episode : new ArrayList<TvShowEpisode>(tvShow.getEpisodes())) {
                    this.nodeMap.remove(episode);
                    episode.removePropertyChangeListener(this.propertyChangeListener);
                }
                tvShow.removePropertyChangeListener(this.propertyChangeListener);
                child.removeAllChildren();
                child.removeFromParent();
                if (index > -1) {
                    TreeModelEvent event = new TreeModelEvent((Object)this, parent.getPath(), new int[]{index}, new Object[]{child});
                    for (TreeModelListener listener : this.listeners) {
                        try {
                            listener.treeNodesRemoved(event);
                        }
                        catch (ArrayIndexOutOfBoundsException | NullPointerException npe) {}
                    }
                }
            }
        }
    }

    private void addTvShowSeason(TvShowSeason season, TvShow tvShow) {
        if (this.nodeMap.get(season) != null) {
            return;
        }
        TvShowTreeNode parent = (TvShowTreeNode)this.nodeMap.get(tvShow);
        TvShowSeasonTreeNode child = new TvShowSeasonTreeNode(season);
        if (parent != null) {
            TreeModelEvent event;
            parent.add(child);
            this.nodeMap.put(season, child);
            int index = this.getIndexOfChild(parent, child);
            if (index > -1) {
                event = new TreeModelEvent((Object)this, parent.getPath(), new int[]{index}, new Object[]{child});
                for (TreeModelListener listener : this.listeners) {
                    try {
                        listener.treeNodesInserted(event);
                    }
                    catch (ArrayIndexOutOfBoundsException | NullPointerException ignored) {}
                }
            }
            event = new TreeModelEvent((Object)this, this.root.getPath(), null, null);
            for (TreeModelListener listener : this.listeners) {
                try {
                    listener.treeNodesChanged(event);
                }
                catch (ArrayIndexOutOfBoundsException | NullPointerException ignored) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addTvShowEpisode(TvShowEpisode episode, TvShowSeason season) {
        TvShowRootTreeNode tvShowRootTreeNode = this.root;
        synchronized (tvShowRootTreeNode) {
            TvShowSeasonTreeNode parent = (TvShowSeasonTreeNode)this.nodeMap.get(season);
            if (parent == null) {
                this.addTvShowSeason(season, episode.getTvShow());
                parent = (TvShowSeasonTreeNode)this.nodeMap.get(season);
            }
            TvShowEpisodeTreeNode child = new TvShowEpisodeTreeNode(episode);
            if (parent != null) {
                TreeModelEvent event;
                parent.add(child);
                this.nodeMap.put(episode, child);
                int index = this.getIndexOfChild(parent, child);
                if (index > -1) {
                    event = new TreeModelEvent((Object)this, parent.getPath(), new int[]{index}, new Object[]{child});
                    for (TreeModelListener listener : this.listeners) {
                        try {
                            listener.treeNodesInserted(event);
                        }
                        catch (ArrayIndexOutOfBoundsException | NullPointerException ignored) {}
                    }
                }
                event = new TreeModelEvent((Object)this, this.root.getPath(), null, null);
                for (TreeModelListener listener : this.listeners) {
                    try {
                        listener.treeNodesChanged(event);
                    }
                    catch (ArrayIndexOutOfBoundsException | NullPointerException ignored) {}
                }
            }
        }
        episode.addPropertyChangeListener(this.propertyChangeListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeTvShowEpisode(TvShowEpisode episode) {
        TvShowRootTreeNode tvShowRootTreeNode = this.root;
        synchronized (tvShowRootTreeNode) {
            TvShowEpisodeTreeNode child = (TvShowEpisodeTreeNode)this.nodeMap.get(episode);
            TvShowSeasonTreeNode parent = null;
            if (child != null) {
                parent = (TvShowSeasonTreeNode)child.getParent();
            }
            if (parent != null && child != null) {
                int index = this.getIndexOfChild(parent, child);
                parent.remove(child);
                this.nodeMap.remove(episode);
                episode.removePropertyChangeListener(this.propertyChangeListener);
                if (index > -1) {
                    TreeModelEvent event = new TreeModelEvent((Object)this, parent.getPath(), new int[]{index}, new Object[]{child});
                    for (TreeModelListener listener : this.listeners) {
                        try {
                            listener.treeNodesRemoved(event);
                        }
                        catch (ArrayIndexOutOfBoundsException | NullPointerException ignored) {}
                    }
                }
                if (parent.getChildCount() == 0) {
                    TvShowSeason season = null;
                    for (Map.Entry<Object, TreeNode> entry : this.nodeMap.entrySet()) {
                        if (entry.getValue() != parent) continue;
                        season = (TvShowSeason)entry.getKey();
                    }
                    if (season != null) {
                        this.removeTvShowSeason(season);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeTvShowSeason(TvShowSeason season) {
        TvShowRootTreeNode tvShowRootTreeNode = this.root;
        synchronized (tvShowRootTreeNode) {
            TvShowSeasonTreeNode child = (TvShowSeasonTreeNode)this.nodeMap.get(season);
            TvShowTreeNode parent = null;
            if (child != null) {
                parent = (TvShowTreeNode)child.getParent();
            }
            if (parent != null && child != null) {
                int index = this.getIndexOfChild(parent, child);
                parent.remove(child);
                this.nodeMap.remove(season);
                if (index > -1) {
                    TreeModelEvent event = new TreeModelEvent((Object)this, parent.getPath(), new int[]{index}, new Object[]{child});
                    for (TreeModelListener listener : this.listeners) {
                        try {
                            listener.treeNodesRemoved(event);
                        }
                        catch (ArrayIndexOutOfBoundsException | NullPointerException ignored) {}
                    }
                }
            }
        }
    }

    @Override
    public void addTreeModelListener(TreeModelListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public Object getChild(Object parent, int index) {
        int count = 0;
        int childCount = this.getChildCountInternal(parent);
        for (int i = 0; i < childCount; ++i) {
            Object child = this.getChildInternal(parent, i);
            if (!this.matches(child)) continue;
            if (count == index) {
                return child;
            }
            ++count;
        }
        return null;
    }

    @Override
    public int getChildCount(Object parent) {
        int count = 0;
        int childCount = this.getChildCountInternal(parent);
        for (int i = 0; i < childCount; ++i) {
            Object child = this.getChildInternal(parent, i);
            if (!this.matches(child)) continue;
            ++count;
        }
        return count;
    }

    @Override
    public int getIndexOfChild(Object parent, Object childToFind) {
        int childCount = this.getChildCountInternal(parent);
        for (int i = 0; i < childCount; ++i) {
            Object child = this.getChildInternal(parent, i);
            if (!this.matches(child) || !childToFind.equals(child)) continue;
            return i;
        }
        return -1;
    }

    private boolean matches(Object node) {
        AbstractModelObject bean = null;
        if (node instanceof TvShowTreeNode) {
            bean = (TvShow)((TvShowTreeNode)node).getUserObject();
        }
        if (node instanceof TvShowSeasonTreeNode) {
            bean = (TvShowSeason)((TvShowSeasonTreeNode)node).getUserObject();
        }
        if (node instanceof TvShowEpisodeTreeNode) {
            bean = (TvShowEpisode)((TvShowEpisodeTreeNode)node).getUserObject();
        }
        if (bean == null) {
            return true;
        }
        return this.matcher.matches(bean);
    }

    @Override
    public Object getRoot() {
        return this.root;
    }

    @Override
    public boolean isLeaf(Object node) {
        if (node == this.root) {
            return false;
        }
        if (node instanceof TvShowTreeNode || node instanceof TvShowSeasonTreeNode) {
            return false;
        }
        if (node instanceof TvShowEpisodeTreeNode) {
            return true;
        }
        return this.getChildCount(node) == 0;
    }

    @Override
    public void removeTreeModelListener(TreeModelListener listener) {
        this.listeners.remove(listener);
    }

    @Override
    public void valueForPathChanged(TreePath arg0, Object arg1) {
    }

    private int getChildCountInternal(Object node) {
        if (node == null) {
            return 0;
        }
        return ((TreeNode)node).getChildCount();
    }

    private Object getChildInternal(Object parent, int index) {
        return ((TreeNode)parent).getChildAt(index);
    }

    public void setFilter(TvShowExtendedMatcher.SearchOptions option, Object filterArg) {
        if (this.matcher.searchOptions.containsKey((Object)option)) {
            this.matcher.searchOptions.remove((Object)option);
        }
        this.matcher.searchOptions.put(option, filterArg);
    }

    public void removeFilter(TvShowExtendedMatcher.SearchOptions option) {
        if (this.matcher.searchOptions.containsKey((Object)option)) {
            this.matcher.searchOptions.remove((Object)option);
        }
    }

    public void filter(JTree tree) {
        TreePath selection = tree.getSelectionPath();
        List<TreePath> currOpen = this.getCurrExpandedPaths(tree);
        this.reload();
        this.reExpandPaths(tree, currOpen);
        this.restoreSelection(selection, tree);
        boolean newState = this.matcher.searchOptions.isEmpty();
        tree.firePropertyChange("filterChanged", newState, !newState);
    }

    private List<TreePath> getCurrExpandedPaths(JTree tree) {
        ArrayList<TreePath> paths = new ArrayList<TreePath>();
        Enumeration<TreePath> expandEnum = tree.getExpandedDescendants(new TreePath(this.root.getPath()));
        if (expandEnum == null) {
            return null;
        }
        while (expandEnum.hasMoreElements()) {
            paths.add(expandEnum.nextElement());
        }
        return paths;
    }

    private void reExpandPaths(JTree tree, List<TreePath> expPaths) {
        if (expPaths == null) {
            return;
        }
        for (TreePath tp : expPaths) {
            tree.expandPath(tp);
        }
    }

    private void reload() {
        TreeModelEvent event = new TreeModelEvent((Object)this, this.root.getPath(), null, null);
        for (TreeModelListener listener : this.listeners) {
            listener.treeStructureChanged(event);
        }
    }

    private void restoreSelection(TreePath path, JTree tree) {
        DefaultMutableTreeNode child;
        DefaultMutableTreeNode parent;
        if (path != null && this.getIndexOfChild(parent = (DefaultMutableTreeNode)(child = (DefaultMutableTreeNode)path.getLastPathComponent()).getParent(), child) > -1) {
            tree.setSelectionPath(path);
            return;
        }
        DefaultMutableTreeNode root = (DefaultMutableTreeNode)this.getRoot();
        for (int i = 0; i < root.getChildCount(); ++i) {
            DefaultMutableTreeNode child2 = (DefaultMutableTreeNode)root.getChildAt(i);
            if (this.getIndexOfChild(root, child2) <= -1) continue;
            tree.setSelectionPath(new TreePath(child2.getPath()));
            break;
        }
    }
}

