/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.movies.dialogs;

import ca.odell.glazedlists.BasicEventList;
import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.swing.AutoCompleteSupport;
import com.jgoodies.forms.factories.FormFactory;
import com.jgoodies.forms.layout.ColumnSpec;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.forms.layout.FormSpecs;
import com.jgoodies.forms.layout.RowSpec;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import javax.swing.AbstractAction;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.KeyStroke;
import javax.swing.SpinnerDateModel;
import javax.swing.SpinnerNumberModel;
import javax.swing.border.EmptyBorder;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import org.apache.commons.lang3.StringUtils;
import org.jdesktop.beansbinding.AutoBinding;
import org.jdesktop.beansbinding.BeanProperty;
import org.jdesktop.beansbinding.Property;
import org.jdesktop.observablecollections.ObservableCollections;
import org.jdesktop.swingbinding.JListBinding;
import org.jdesktop.swingbinding.JTableBinding;
import org.jdesktop.swingbinding.SwingBindings;
import org.tinymediamanager.core.MediaFileType;
import org.tinymediamanager.core.MediaSource;
import org.tinymediamanager.core.entities.MediaFile;
import org.tinymediamanager.core.movie.MovieEdition;
import org.tinymediamanager.core.movie.MovieList;
import org.tinymediamanager.core.movie.MovieModuleManager;
import org.tinymediamanager.core.movie.entities.Movie;
import org.tinymediamanager.core.movie.entities.MovieActor;
import org.tinymediamanager.core.movie.entities.MovieProducer;
import org.tinymediamanager.core.movie.entities.MovieSet;
import org.tinymediamanager.core.movie.entities.MovieTrailer;
import org.tinymediamanager.core.threading.TmmTaskManager;
import org.tinymediamanager.scraper.ScraperType;
import org.tinymediamanager.scraper.entities.Certification;
import org.tinymediamanager.scraper.entities.CountryCode;
import org.tinymediamanager.scraper.entities.MediaGenres;
import org.tinymediamanager.scraper.entities.MediaType;
import org.tinymediamanager.scraper.trakttv.SyncTraktTvTask;
import org.tinymediamanager.ui.EqualsLayout;
import org.tinymediamanager.ui.IconManager;
import org.tinymediamanager.ui.MainWindow;
import org.tinymediamanager.ui.TmmFontHelper;
import org.tinymediamanager.ui.UTF8Control;
import org.tinymediamanager.ui.components.AutocompleteComboBox;
import org.tinymediamanager.ui.components.ImageLabel;
import org.tinymediamanager.ui.components.MediaIdTable;
import org.tinymediamanager.ui.components.datepicker.DatePicker;
import org.tinymediamanager.ui.components.datepicker.YearSpinner;
import org.tinymediamanager.ui.dialogs.ImageChooserDialog;
import org.tinymediamanager.ui.dialogs.TmmDialog;
import org.tinymediamanager.ui.panels.MediaFileEditorPanel;

public class MovieEditorDialog
extends TmmDialog {
    private static final long serialVersionUID = -286251957529920347L;
    private static final ResourceBundle BUNDLE = ResourceBundle.getBundle("messages", new UTF8Control());
    private Movie movieToEdit;
    private MovieList movieList = MovieList.getInstance();
    private List<MovieActor> cast = ObservableCollections.observableList(new ArrayList());
    private List<MovieProducer> producers = ObservableCollections.observableList(new ArrayList());
    private List<MediaGenres> genres = ObservableCollections.observableList(new ArrayList());
    private List<MovieTrailer> trailers = ObservableCollections.observableList(new ArrayList());
    private List<String> tags = ObservableCollections.observableList(new ArrayList());
    private EventList<MediaIdTable.MediaId> ids = new BasicEventList();
    private List<MediaFile> mediaFiles = new ArrayList<MediaFile>();
    private List<String> extrathumbs = new ArrayList<String>();
    private List<String> extrafanarts = new ArrayList<String>();
    private boolean continueQueue = true;
    private final JPanel details1Panel = new JPanel();
    private final JPanel details2Panel = new JPanel();
    private JTextField tfTitle;
    private JTextField tfOriginalTitle;
    private YearSpinner spYear;
    private JTextPane tpPlot;
    private JTextField tfDirector;
    private JTable tableActors;
    private JLabel lblMoviePath;
    private ImageLabel lblPoster;
    private ImageLabel lblFanart;
    private JTextField tfWriter;
    private JSpinner spRuntime;
    private JTextPane tfProductionCompanies;
    private JList<MediaGenres> listGenres;
    private AutocompleteComboBox<MediaGenres> cbGenres;
    private AutoCompleteSupport<MediaGenres> cbGenresAutoCompleteSupport;
    private JSpinner spRating;
    private JComboBox cbCertification;
    private JCheckBox cbWatched;
    private JTextPane tpTagline;
    private JTable tableTrailer;
    private JTable tableProducers;
    private AutocompleteComboBox<String> cbTags;
    private AutoCompleteSupport<String> cbTagsAutoCompleteSupport;
    private JList<String> listTags;
    private JSpinner spDateAdded;
    private JComboBox cbMovieSet;
    private JTextField tfSorttitle;
    private JTextField tfSpokenLanguages;
    private JTextField tfCountry;
    private DatePicker dpReleaseDate;
    private JSpinner spTop250;
    private JComboBox cbSource;
    private JCheckBox chckbxVideo3D;
    private JTable tableIds;
    private MediaFileEditorPanel mediaFilesPanel;
    private JComboBox cbEdition;
    private ImageLabel lblLogo;
    private ImageLabel lblClearlogo;
    private ImageLabel lblBanner;
    private ImageLabel lblClearart;
    private ImageLabel lblThumb;
    private ImageLabel lblDisc;
    private JTableBinding<MovieActor, List<MovieActor>, JTable> jTableBinding;
    private JListBinding<MediaGenres, List<MediaGenres>, JList> jListBinding;
    private JTableBinding<MovieTrailer, List<MovieTrailer>, JTable> jTableBinding_1;
    private JListBinding<String, List<String>, JList> jListBinding_1;
    private JTableBinding<MovieProducer, List<MovieProducer>, JTable> jTableBinding_2;

    public MovieEditorDialog(Movie movie, boolean inQueue) {
        super(BUNDLE.getString("movie.edit"), "movieEditor");
        this.setBounds(5, 5, 950, 650);
        this.movieToEdit = movie;
        this.ids = MediaIdTable.convertIdMapToEventList(this.movieToEdit.getIds());
        for (MediaFile mf : movie.getMediaFiles()) {
            this.mediaFiles.add(new MediaFile(mf));
        }
        this.getContentPane().setLayout(new BorderLayout());
        JPanel panelPath = new JPanel();
        this.getContentPane().add((Component)panelPath, "North");
        panelPath.setLayout((LayoutManager)new FormLayout(new ColumnSpec[]{FormFactory.RELATED_GAP_COLSPEC, FormFactory.DEFAULT_COLSPEC, FormFactory.DEFAULT_COLSPEC, FormFactory.RELATED_GAP_COLSPEC, FormFactory.DEFAULT_COLSPEC, FormFactory.RELATED_GAP_COLSPEC}, new RowSpec[]{FormFactory.LINE_GAP_ROWSPEC, RowSpec.decode((String)"15px"), FormFactory.RELATED_GAP_ROWSPEC}));
        JLabel lblMoviePathT = new JLabel(BUNDLE.getString("metatag.path"));
        panelPath.add((Component)lblMoviePathT, "2, 2, left, top");
        this.lblMoviePath = new JLabel("");
        TmmFontHelper.changeFont(this.lblMoviePath, 1.166, 1);
        panelPath.add((Component)this.lblMoviePath, "5, 2, left, top");
        JTabbedPane tabbedPane = new JTabbedPane(1);
        this.getContentPane().add((Component)tabbedPane, "Center");
        this.details1Panel.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.details1Panel.setLayout((LayoutManager)new FormLayout(new ColumnSpec[]{FormSpecs.RELATED_GAP_COLSPEC, ColumnSpec.decode((String)"max(40dlu;default)"), FormSpecs.RELATED_GAP_COLSPEC, FormSpecs.DEFAULT_COLSPEC, FormSpecs.RELATED_GAP_COLSPEC, ColumnSpec.decode((String)"7dlu:grow"), FormSpecs.RELATED_GAP_COLSPEC, FormSpecs.DEFAULT_COLSPEC, FormSpecs.RELATED_GAP_COLSPEC, ColumnSpec.decode((String)"25dlu:grow"), FormSpecs.RELATED_GAP_COLSPEC, ColumnSpec.decode((String)"24dlu"), FormSpecs.RELATED_GAP_COLSPEC, ColumnSpec.decode((String)"7dlu:grow"), FormSpecs.RELATED_GAP_COLSPEC, FormSpecs.DEFAULT_COLSPEC, FormSpecs.RELATED_GAP_COLSPEC, FormSpecs.DEFAULT_COLSPEC, FormSpecs.RELATED_GAP_COLSPEC, FormSpecs.UNRELATED_GAP_COLSPEC, FormSpecs.RELATED_GAP_COLSPEC, FormSpecs.DEFAULT_COLSPEC, FormSpecs.RELATED_GAP_COLSPEC, ColumnSpec.decode((String)"100dlu:grow(2)"), FormSpecs.RELATED_GAP_COLSPEC}, new RowSpec[]{FormSpecs.RELATED_GAP_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC, FormSpecs.LABEL_COMPONENT_GAP_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC, FormSpecs.LABEL_COMPONENT_GAP_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC, FormSpecs.LABEL_COMPONENT_GAP_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC, FormSpecs.LABEL_COMPONENT_GAP_ROWSPEC, RowSpec.decode((String)"50px:grow"), FormSpecs.LABEL_COMPONENT_GAP_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC, FormSpecs.LABEL_COMPONENT_GAP_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC, FormSpecs.LABEL_COMPONENT_GAP_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC, FormSpecs.RELATED_GAP_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC, FormSpecs.RELATED_GAP_ROWSPEC, RowSpec.decode((String)"15dlu"), FormSpecs.LABEL_COMPONENT_GAP_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC, FormSpecs.LABEL_COMPONENT_GAP_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC, FormSpecs.LABEL_COMPONENT_GAP_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC, FormSpecs.LABEL_COMPONENT_GAP_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC, FormSpecs.LABEL_COMPONENT_GAP_ROWSPEC, RowSpec.decode((String)"fill:50dlu:grow"), FormSpecs.LABEL_COMPONENT_GAP_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC, FormSpecs.LABEL_COMPONENT_GAP_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC, FormSpecs.LABEL_COMPONENT_GAP_ROWSPEC, RowSpec.decode((String)"50px"), FormSpecs.LABEL_COMPONENT_GAP_ROWSPEC, RowSpec.decode((String)"fill:default:grow")}));
        JLabel lblTitle = new JLabel(BUNDLE.getString("metatag.title"));
        this.details1Panel.add((Component)lblTitle, "2, 4, right, default");
        this.tfTitle = new JTextField();
        this.details1Panel.add((Component)this.tfTitle, "4, 4, 15, 1, fill, default");
        this.tfTitle.setColumns(10);
        this.lblPoster = new ImageLabel();
        this.lblPoster.setAlternativeText(BUNDLE.getString("image.notfound.poster"));
        this.lblPoster.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                ImageChooserDialog dialog = new ImageChooserDialog(MovieEditorDialog.this.movieToEdit.getIds(), ImageChooserDialog.ImageType.POSTER, MovieEditorDialog.this.movieList.getDefaultArtworkScrapers(), MovieEditorDialog.this.lblPoster, null, null, MediaType.MOVIE);
                dialog.setLocationRelativeTo(MainWindow.getActiveInstance());
                dialog.setVisible(true);
            }
        });
        this.lblPoster.setCursor(Cursor.getPredefinedCursor(12));
        this.details1Panel.add((Component)this.lblPoster, "22, 4, 3, 23, fill, fill");
        JLabel lblOriginalTitle = new JLabel(BUNDLE.getString("metatag.originaltitle"));
        this.details1Panel.add((Component)lblOriginalTitle, "2, 6, right, default");
        this.tfOriginalTitle = new JTextField();
        this.details1Panel.add((Component)this.tfOriginalTitle, "4, 6, 15, 1, fill, top");
        this.tfOriginalTitle.setColumns(10);
        JLabel lblSorttitle = new JLabel(BUNDLE.getString("metatag.sorttitle"));
        this.details1Panel.add((Component)lblSorttitle, "2, 8, right, default");
        this.tfSorttitle = new JTextField();
        this.details1Panel.add((Component)this.tfSorttitle, "4, 8, 15, 1, fill, default");
        this.tfSorttitle.setColumns(10);
        JLabel lblTagline = new JLabel(BUNDLE.getString("metatag.tagline"));
        this.details1Panel.add((Component)lblTagline, "2, 10, right, top");
        JScrollPane scrollPaneTagline = new JScrollPane();
        this.tpTagline = new JTextPane();
        scrollPaneTagline.setViewportView(this.tpTagline);
        this.details1Panel.add((Component)scrollPaneTagline, "4, 10, 15, 1, fill, fill");
        JLabel lblYear = new JLabel(BUNDLE.getString("metatag.year"));
        this.details1Panel.add((Component)lblYear, "2, 12, right, default");
        this.spYear = new YearSpinner();
        this.details1Panel.add((Component)this.spYear, "4, 12, fill, top");
        JLabel lblRuntime = new JLabel(BUNDLE.getString("metatag.runtime"));
        this.details1Panel.add((Component)lblRuntime, "8, 12, right, default");
        this.spRuntime = new JSpinner();
        this.details1Panel.add((Component)this.spRuntime, "10, 12, fill, default");
        JLabel lblMin = new JLabel(BUNDLE.getString("metatag.minutes"));
        this.details1Panel.add((Component)lblMin, "12, 12");
        JLabel lblRating = new JLabel(BUNDLE.getString("metatag.rating"));
        this.details1Panel.add((Component)lblRating, "16, 12, right, default");
        this.spRating = new JSpinner();
        this.details1Panel.add((Component)this.spRating, "18, 12");
        this.spRating.setModel(new SpinnerNumberModel(movie.getRating(), 0.0, 10.0, 0.1));
        JLabel lblReleaseDate = new JLabel(BUNDLE.getString("metatag.releasedate"));
        this.details1Panel.add((Component)lblReleaseDate, "2, 14, right, default");
        this.dpReleaseDate = new DatePicker(movie.getReleaseDate());
        this.details1Panel.add((Component)this.dpReleaseDate, "4, 14");
        JLabel lblCertification = new JLabel(BUNDLE.getString("metatag.certification"));
        this.details1Panel.add((Component)lblCertification, "8, 14, right, default");
        this.cbCertification = new JComboBox();
        this.details1Panel.add((Component)this.cbCertification, "10, 14, 3, 1, fill, default");
        JLabel lblTop = new JLabel(BUNDLE.getString("metatag.top250"));
        this.details1Panel.add((Component)lblTop, "16, 14, right, default");
        this.spTop250 = new JSpinner();
        this.details1Panel.add((Component)this.spTop250, "18, 14");
        this.spTop250.setValue(movie.getTop250());
        JLabel lblIds = new JLabel("Ids");
        this.details1Panel.add((Component)lblIds, "2, 16, right, bottom");
        JScrollPane scrollPaneIds = new JScrollPane();
        this.details1Panel.add((Component)scrollPaneIds, "4, 16, 9, 5, fill, fill");
        this.tableIds = new MediaIdTable(this.ids, ScraperType.MOVIE);
        scrollPaneIds.setViewportView(this.tableIds);
        JButton btnAddId = new JButton("");
        btnAddId.setAction(new AddIdAction());
        btnAddId.setIcon(IconManager.LIST_ADD);
        btnAddId.setMargin(new Insets(2, 2, 2, 2));
        this.details1Panel.add((Component)btnAddId, "2, 18, right, top");
        JButton btnRemoveId = new JButton("");
        btnRemoveId.setAction(new RemoveIdAction());
        btnRemoveId.setIcon(IconManager.LIST_REMOVE);
        btnRemoveId.setMargin(new Insets(2, 2, 2, 2));
        this.details1Panel.add((Component)btnRemoveId, "2, 20, right, top");
        JLabel lblSpokenLanguages = new JLabel(BUNDLE.getString("metatag.spokenlanguages"));
        this.details1Panel.add((Component)lblSpokenLanguages, "2, 22, right, default");
        this.tfSpokenLanguages = new JTextField();
        this.details1Panel.add((Component)this.tfSpokenLanguages, "4, 22, fill, default");
        this.tfSpokenLanguages.setColumns(10);
        JLabel lblCountry = new JLabel(BUNDLE.getString("metatag.country"));
        this.details1Panel.add((Component)lblCountry, "8, 22, right, default");
        this.tfCountry = new JTextField();
        this.details1Panel.add((Component)this.tfCountry, "10, 22, 3, 1, fill, default");
        this.tfCountry.setColumns(10);
        JLabel lblMovieSet = new JLabel(BUNDLE.getString("metatag.movieset"));
        this.details1Panel.add((Component)lblMovieSet, "2, 24, right, default");
        this.cbMovieSet = new JComboBox();
        this.cbMovieSet.addItem("");
        this.details1Panel.add((Component)this.cbMovieSet, "4, 24, 9, 1, fill, default");
        JLabel lblDateAdded = new JLabel(BUNDLE.getString("metatag.dateadded"));
        this.details1Panel.add((Component)lblDateAdded, "2, 26, right, default");
        this.spDateAdded = new JSpinner(new SpinnerDateModel());
        this.details1Panel.add((Component)this.spDateAdded, "4, 26");
        this.spDateAdded.setValue(movie.getDateAdded());
        JLabel lblWatched = new JLabel(BUNDLE.getString("metatag.watched"));
        this.details1Panel.add((Component)lblWatched, "8, 26, right, default");
        this.cbWatched = new JCheckBox("");
        this.details1Panel.add((Component)this.cbWatched, "10, 26");
        this.cbWatched.setSelected(movie.isWatched());
        lblWatched.setLabelFor(this.cbWatched);
        JLabel lblSourceT = new JLabel(BUNDLE.getString("metatag.source"));
        this.details1Panel.add((Component)lblSourceT, "2, 28, right, default");
        this.cbSource = new JComboBox<MediaSource>(MediaSource.values());
        this.details1Panel.add((Component)this.cbSource, "4, 28, fill, default");
        this.cbSource.setSelectedItem((Object)movie.getMediaSource());
        JLabel lblEditionT = new JLabel(BUNDLE.getString("metatag.edition"));
        this.details1Panel.add((Component)lblEditionT, "8, 28, right, default");
        this.cbEdition = new JComboBox<MovieEdition>(MovieEdition.values());
        this.details1Panel.add((Component)this.cbEdition, "10, 28, 3, 1, fill, default");
        JLabel lblVideod = new JLabel(BUNDLE.getString("metatag.3d"));
        this.details1Panel.add((Component)lblVideod, "16, 28, right, default");
        this.chckbxVideo3D = new JCheckBox("");
        this.details1Panel.add((Component)this.chckbxVideo3D, "18, 28");
        this.chckbxVideo3D.setSelected(movie.isVideoIn3D());
        JLabel lblPlot = new JLabel(BUNDLE.getString("metatag.plot"));
        this.details1Panel.add((Component)lblPlot, "2, 30, right, top");
        JScrollPane scrollPanePlot = new JScrollPane();
        this.details1Panel.add((Component)scrollPanePlot, "4, 30, 15, 1, fill, fill");
        this.tpPlot = new JTextPane();
        scrollPanePlot.setViewportView(this.tpPlot);
        this.lblFanart = new ImageLabel();
        this.lblFanart.setAlternativeText(BUNDLE.getString("image.notfound.fanart"));
        this.lblFanart.setCursor(Cursor.getPredefinedCursor(12));
        this.lblFanart.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                ImageChooserDialog dialog = new ImageChooserDialog(MovieEditorDialog.this.movieToEdit.getIds(), ImageChooserDialog.ImageType.FANART, MovieEditorDialog.this.movieList.getDefaultArtworkScrapers(), MovieEditorDialog.this.lblFanart, MovieEditorDialog.this.extrathumbs, MovieEditorDialog.this.extrafanarts, MediaType.MOVIE);
                dialog.setLocationRelativeTo(MainWindow.getActiveInstance());
                dialog.setVisible(true);
            }
        });
        this.details1Panel.add((Component)this.lblFanart, "22, 30, 3, 5, fill, fill");
        this.lblFanart.setImagePath(movie.getArtworkFilename(MediaFileType.FANART));
        JLabel lblDirector = new JLabel(BUNDLE.getString("metatag.director"));
        this.details1Panel.add((Component)lblDirector, "2, 32, right, default");
        this.tfDirector = new JTextField();
        this.details1Panel.add((Component)this.tfDirector, "4, 32, 15, 1, fill, top");
        this.tfDirector.setColumns(10);
        JLabel lblWriter = new JLabel(BUNDLE.getString("metatag.writer"));
        this.details1Panel.add((Component)lblWriter, "2, 34, right, default");
        this.tfWriter = new JTextField();
        this.details1Panel.add((Component)this.tfWriter, "4, 34, 15, 1, fill, top");
        this.tfWriter.setColumns(10);
        JLabel lblCompany = new JLabel(BUNDLE.getString("metatag.production"));
        this.details1Panel.add((Component)lblCompany, "2, 36, right, top");
        JScrollPane scrollPaneProduction = new JScrollPane();
        this.details1Panel.add((Component)scrollPaneProduction, "4, 36, 15, 1, fill, fill");
        this.tfProductionCompanies = new JTextPane();
        scrollPaneProduction.setViewportView(this.tfProductionCompanies);
        tabbedPane.addTab(BUNDLE.getString("metatag.details"), this.details1Panel);
        tabbedPane.addTab(BUNDLE.getString("metatag.details2"), this.details2Panel);
        this.details2Panel.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.details2Panel.setLayout((LayoutManager)new FormLayout(new ColumnSpec[]{FormSpecs.RELATED_GAP_COLSPEC, ColumnSpec.decode((String)"max(40dlu;default)"), FormSpecs.RELATED_GAP_COLSPEC, ColumnSpec.decode((String)"50px:grow"), FormSpecs.RELATED_GAP_COLSPEC, FormSpecs.DEFAULT_COLSPEC, FormSpecs.RELATED_GAP_COLSPEC, ColumnSpec.decode((String)"100px:grow"), FormSpecs.RELATED_GAP_COLSPEC}, new RowSpec[]{FormSpecs.RELATED_GAP_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC, FormSpecs.RELATED_GAP_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC, FormSpecs.RELATED_GAP_ROWSPEC, RowSpec.decode((String)"fill:default"), FormSpecs.RELATED_GAP_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC, FormSpecs.RELATED_GAP_ROWSPEC, RowSpec.decode((String)"default:grow"), FormSpecs.RELATED_GAP_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC, FormSpecs.RELATED_GAP_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC, FormSpecs.RELATED_GAP_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC, FormSpecs.RELATED_GAP_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC, FormSpecs.RELATED_GAP_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC, FormSpecs.RELATED_GAP_ROWSPEC, RowSpec.decode((String)"default:grow"), FormSpecs.RELATED_GAP_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC, FormSpecs.RELATED_GAP_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC, FormSpecs.RELATED_GAP_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC, FormSpecs.RELATED_GAP_ROWSPEC, RowSpec.decode((String)"default:grow"), FormSpecs.RELATED_GAP_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC, FormSpecs.RELATED_GAP_ROWSPEC, RowSpec.decode((String)"default:grow(2)")}));
        JLabel lblActors = new JLabel(BUNDLE.getString("metatag.actors"));
        this.details2Panel.add((Component)lblActors, "2, 2, right, default");
        JScrollPane scrollPane = new JScrollPane();
        this.details2Panel.add((Component)scrollPane, "4, 2, 1, 11");
        this.tableActors = new JTable();
        this.tableActors.putClientProperty("terminateEditOnFocusLost", Boolean.TRUE);
        scrollPane.setViewportView(this.tableActors);
        JLabel lblProducers = new JLabel(BUNDLE.getString("metatag.producers"));
        this.details2Panel.add((Component)lblProducers, "6, 2, right, default");
        scrollPane = new JScrollPane();
        this.details2Panel.add((Component)scrollPane, "8, 2, 1, 11");
        this.tableProducers = new JTable();
        this.tableProducers.putClientProperty("terminateEditOnFocusLost", Boolean.TRUE);
        scrollPane.setViewportView(this.tableProducers);
        JButton btnAddActor = new JButton(BUNDLE.getString("cast.actor.add"));
        btnAddActor.setMargin(new Insets(2, 2, 2, 2));
        btnAddActor.setAction(new AddActorAction());
        btnAddActor.setIcon(IconManager.LIST_ADD);
        this.details2Panel.add((Component)btnAddActor, "2, 4, right, top");
        JButton btnAddProducer = new JButton((String)null);
        btnAddProducer.setMargin(new Insets(2, 2, 2, 2));
        btnAddProducer.setAction(new AddProducerAction());
        btnAddProducer.setIcon(IconManager.LIST_ADD);
        this.details2Panel.add((Component)btnAddProducer, "6, 4, right, top");
        JButton btnRemoveActor = new JButton(BUNDLE.getString("cast.actor.remove"));
        btnRemoveActor.setMargin(new Insets(2, 2, 2, 2));
        btnRemoveActor.setAction(new RemoveActorAction());
        btnRemoveActor.setIcon(IconManager.LIST_REMOVE);
        this.details2Panel.add((Component)btnRemoveActor, "2,6, right, top");
        JButton btnRemoveProducer = new JButton((String)null);
        btnRemoveProducer.setMargin(new Insets(2, 2, 2, 2));
        btnRemoveProducer.setAction(new RemoveProducerAction());
        btnRemoveProducer.setIcon(IconManager.LIST_REMOVE);
        this.details2Panel.add((Component)btnRemoveProducer, "6, 6, right, top");
        JButton btnMoveActorUp = new JButton((String)null);
        btnMoveActorUp.setMargin(new Insets(2, 2, 2, 2));
        btnMoveActorUp.setAction(new MoveActorUpAction());
        btnMoveActorUp.setIcon(IconManager.ARROW_UP);
        this.details2Panel.add((Component)btnMoveActorUp, "2, 8, right, top");
        JButton btnMoveProducerUp = new JButton((String)null);
        btnMoveProducerUp.setMargin(new Insets(2, 2, 2, 2));
        btnMoveProducerUp.setAction(new MoveProducerUpAction());
        btnMoveProducerUp.setIcon(IconManager.ARROW_UP);
        this.details2Panel.add((Component)btnMoveProducerUp, "6, 8, right, top");
        JButton btnMoveActorDown = new JButton((String)null);
        btnMoveActorDown.setMargin(new Insets(2, 2, 2, 2));
        btnMoveActorDown.setAction(new MoveActorDownAction());
        btnMoveActorDown.setIcon(IconManager.ARROW_DOWN);
        this.details2Panel.add((Component)btnMoveActorDown, "2, 10, right, top");
        JButton btnMoveProducerDown = new JButton((String)null);
        btnMoveProducerDown.setMargin(new Insets(2, 2, 2, 2));
        btnMoveProducerDown.setAction(new MoveProducerDownAction());
        btnMoveProducerDown.setIcon(IconManager.ARROW_DOWN);
        this.details2Panel.add((Component)btnMoveProducerDown, "6, 10, right, top");
        JLabel lblGenres = new JLabel(BUNDLE.getString("metatag.genre"));
        this.details2Panel.add((Component)lblGenres, "2, 14, right, default");
        JScrollPane scrollPaneGenres = new JScrollPane();
        this.details2Panel.add((Component)scrollPaneGenres, "4, 14, 1, 9");
        this.listGenres = new JList();
        scrollPaneGenres.setViewportView(this.listGenres);
        JLabel lblTags = new JLabel(BUNDLE.getString("metatag.tags"));
        this.details2Panel.add((Component)lblTags, "6, 14, right, default");
        JScrollPane scrollPaneTags = new JScrollPane();
        this.details2Panel.add((Component)scrollPaneTags, "8, 14, 1, 9");
        this.listTags = new JList();
        scrollPaneTags.setViewportView(this.listTags);
        JButton btnAddGenre = new JButton("");
        btnAddGenre.setAction(new AddGenreAction());
        btnAddGenre.setIcon(IconManager.LIST_ADD);
        btnAddGenre.setMargin(new Insets(2, 2, 2, 2));
        this.details2Panel.add((Component)btnAddGenre, "2, 16, right, top");
        JButton btnAddTag = new JButton("");
        btnAddTag.setAction(new AddTagAction());
        btnAddTag.setIcon(IconManager.LIST_ADD);
        btnAddTag.setMargin(new Insets(2, 2, 2, 2));
        this.details2Panel.add((Component)btnAddTag, "6, 16, right, top");
        JButton btnRemoveGenre = new JButton("");
        btnRemoveGenre.setAction(new RemoveGenreAction());
        btnRemoveGenre.setMargin(new Insets(2, 2, 2, 2));
        btnRemoveGenre.setIcon(IconManager.LIST_REMOVE);
        this.details2Panel.add((Component)btnRemoveGenre, "2, 18, right, top");
        this.cbGenres = new AutocompleteComboBox<MediaGenres>(MediaGenres.values());
        this.cbGenresAutoCompleteSupport = this.cbGenres.getAutoCompleteSupport();
        InputMap im = this.cbGenres.getInputMap(1);
        Object enterAction = im.get(KeyStroke.getKeyStroke(10, 0));
        this.cbGenres.getActionMap().put(enterAction, new AddGenreAction());
        JButton btnRemoveTag = new JButton("");
        btnRemoveTag.setAction(new RemoveTagAction());
        btnRemoveTag.setIcon(IconManager.LIST_REMOVE);
        btnRemoveTag.setMargin(new Insets(2, 2, 2, 2));
        this.details2Panel.add((Component)btnRemoveTag, "6, 18, right, top");
        JButton btnMoveGenreUp = new JButton((String)null);
        btnMoveGenreUp.setMargin(new Insets(2, 2, 2, 2));
        btnMoveGenreUp.setAction(new MoveGenreUpAction());
        btnMoveGenreUp.setIcon(IconManager.ARROW_UP);
        this.details2Panel.add((Component)btnMoveGenreUp, "2, 20, right, top");
        JButton btnMoveTagUp = new JButton((String)null);
        btnMoveTagUp.setMargin(new Insets(2, 2, 2, 2));
        btnMoveTagUp.setAction(new MoveTagUpAction());
        btnMoveTagUp.setIcon(IconManager.ARROW_UP);
        this.details2Panel.add((Component)btnMoveTagUp, "6, 20, right, top");
        JButton btnMoveGenreDown = new JButton((String)null);
        btnMoveGenreDown.setMargin(new Insets(2, 2, 2, 2));
        btnMoveGenreDown.setAction(new MoveGenreDownAction());
        btnMoveGenreDown.setIcon(IconManager.ARROW_DOWN);
        this.details2Panel.add((Component)btnMoveGenreDown, "2, 22, right, top");
        JButton btnMoveTagDown = new JButton((String)null);
        btnMoveTagDown.setMargin(new Insets(2, 2, 2, 2));
        btnMoveTagDown.setAction(new MoveTagDownAction());
        btnMoveTagDown.setIcon(IconManager.ARROW_DOWN);
        this.details2Panel.add((Component)btnMoveTagDown, "6, 22, right, top");
        this.details2Panel.add(this.cbGenres, "4, 24");
        this.cbTags = new AutocompleteComboBox<String>(this.movieList.getTagsInMovies());
        this.cbTagsAutoCompleteSupport = this.cbTags.getAutoCompleteSupport();
        im = this.cbTags.getInputMap(1);
        enterAction = im.get(KeyStroke.getKeyStroke(10, 0));
        this.cbTags.getActionMap().put(enterAction, new AddTagAction());
        this.details2Panel.add(this.cbTags, "8, 24");
        JLabel lblTrailer = new JLabel(BUNDLE.getString("metatag.trailer"));
        this.details2Panel.add((Component)lblTrailer, "2, 26, right, default");
        JScrollPane scrollPaneTrailer = new JScrollPane();
        this.details2Panel.add((Component)scrollPaneTrailer, "4, 26, 5, 5");
        this.tableTrailer = new JTable();
        this.tableTrailer.putClientProperty("terminateEditOnFocusLost", Boolean.TRUE);
        scrollPaneTrailer.setViewportView(this.tableTrailer);
        JButton btnAddTrailer = new JButton("");
        btnAddTrailer.setAction(new AddTrailerAction());
        btnAddTrailer.setIcon(IconManager.LIST_ADD);
        btnAddTrailer.setMargin(new Insets(2, 2, 2, 2));
        this.details2Panel.add((Component)btnAddTrailer, "2, 28, right, top");
        JButton btnRemoveTrailer = new JButton("");
        btnRemoveTrailer.setAction(new RemoveTrailerAction());
        btnRemoveTrailer.setIcon(IconManager.LIST_REMOVE);
        btnRemoveTrailer.setMargin(new Insets(2, 2, 2, 2));
        this.details2Panel.add((Component)btnRemoveTrailer, "2, 30, right, top");
        JPanel artworkPanel = new JPanel();
        tabbedPane.addTab(BUNDLE.getString("metatag.extraartwork"), null, artworkPanel, null);
        artworkPanel.setLayout((LayoutManager)new FormLayout(new ColumnSpec[]{FormSpecs.RELATED_GAP_COLSPEC, ColumnSpec.decode((String)"250px:grow"), FormSpecs.RELATED_GAP_COLSPEC, ColumnSpec.decode((String)"250px:grow"), FormSpecs.RELATED_GAP_COLSPEC, ColumnSpec.decode((String)"150px:grow"), FormSpecs.RELATED_GAP_COLSPEC}, new RowSpec[]{FormSpecs.RELATED_GAP_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC, FormSpecs.RELATED_GAP_ROWSPEC, RowSpec.decode((String)"50px:grow(2)"), FormSpecs.RELATED_GAP_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC, FormSpecs.RELATED_GAP_ROWSPEC, RowSpec.decode((String)"50px:grow(2)"), FormSpecs.RELATED_GAP_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC, FormSpecs.RELATED_GAP_ROWSPEC, RowSpec.decode((String)"200px:grow(2)"), FormSpecs.RELATED_GAP_ROWSPEC, RowSpec.decode((String)"default:grow")}));
        JLabel lblLogoT = new JLabel(BUNDLE.getString("mediafiletype.logo"));
        artworkPanel.add((Component)lblLogoT, "2, 2");
        this.lblLogo = new ImageLabel();
        this.lblLogo.setAlternativeText(BUNDLE.getString("image.notfound.logo"));
        this.lblLogo.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                ImageChooserDialog dialog = new ImageChooserDialog(MovieEditorDialog.this.movieToEdit.getIds(), ImageChooserDialog.ImageType.LOGO, MovieEditorDialog.this.movieList.getDefaultArtworkScrapers(), MovieEditorDialog.this.lblLogo, null, null, MediaType.MOVIE);
                dialog.setLocationRelativeTo(MainWindow.getActiveInstance());
                dialog.setVisible(true);
            }
        });
        this.lblLogo.setCursor(Cursor.getPredefinedCursor(12));
        artworkPanel.add((Component)this.lblLogo, "2, 4, fill, fill");
        JLabel lblClearlogoT = new JLabel(BUNDLE.getString("mediafiletype.clearlogo"));
        artworkPanel.add((Component)lblClearlogoT, "4, 2");
        this.lblClearlogo = new ImageLabel();
        this.lblClearlogo.setAlternativeText(BUNDLE.getString("image.notfound.clearlogo"));
        this.lblClearlogo.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                ImageChooserDialog dialog = new ImageChooserDialog(MovieEditorDialog.this.movieToEdit.getIds(), ImageChooserDialog.ImageType.CLEARLOGO, MovieEditorDialog.this.movieList.getDefaultArtworkScrapers(), MovieEditorDialog.this.lblClearlogo, null, null, MediaType.MOVIE);
                dialog.setLocationRelativeTo(MainWindow.getActiveInstance());
                dialog.setVisible(true);
            }
        });
        this.lblClearlogo.setCursor(Cursor.getPredefinedCursor(12));
        artworkPanel.add((Component)this.lblClearlogo, "4, 4, fill, fill");
        JLabel lblBannerT = new JLabel(BUNDLE.getString("mediafiletype.banner"));
        artworkPanel.add((Component)lblBannerT, "2, 6");
        this.lblBanner = new ImageLabel();
        this.lblBanner.setAlternativeText(BUNDLE.getString("image.notfound.banner"));
        this.lblBanner.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                ImageChooserDialog dialog = new ImageChooserDialog(MovieEditorDialog.this.movieToEdit.getIds(), ImageChooserDialog.ImageType.BANNER, MovieEditorDialog.this.movieList.getDefaultArtworkScrapers(), MovieEditorDialog.this.lblBanner, null, null, MediaType.MOVIE);
                dialog.setLocationRelativeTo(MainWindow.getActiveInstance());
                dialog.setVisible(true);
            }
        });
        this.lblBanner.setCursor(Cursor.getPredefinedCursor(12));
        artworkPanel.add((Component)this.lblBanner, "2, 8, 3, 1, fill, fill");
        JLabel lblClearartT = new JLabel("ClearArt");
        artworkPanel.add((Component)lblClearartT, "2, 10");
        this.lblClearart = new ImageLabel();
        this.lblClearart.setAlternativeText(BUNDLE.getString("image.notfound.clearart"));
        this.lblClearart.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                ImageChooserDialog dialog = new ImageChooserDialog(MovieEditorDialog.this.movieToEdit.getIds(), ImageChooserDialog.ImageType.CLEARART, MovieEditorDialog.this.movieList.getDefaultArtworkScrapers(), MovieEditorDialog.this.lblClearart, null, null, MediaType.MOVIE);
                dialog.setLocationRelativeTo(MainWindow.getActiveInstance());
                dialog.setVisible(true);
            }
        });
        this.lblClearart.setCursor(Cursor.getPredefinedCursor(12));
        artworkPanel.add((Component)this.lblClearart, "2, 12, fill, fill");
        JLabel lblThumbT = new JLabel("Thumb");
        artworkPanel.add((Component)lblThumbT, "4, 10");
        this.lblThumb = new ImageLabel();
        this.lblThumb.setAlternativeText(BUNDLE.getString("image.notfound.thumb"));
        this.lblThumb.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                ImageChooserDialog dialog = new ImageChooserDialog(MovieEditorDialog.this.movieToEdit.getIds(), ImageChooserDialog.ImageType.THUMB, MovieEditorDialog.this.movieList.getDefaultArtworkScrapers(), MovieEditorDialog.this.lblThumb, null, null, MediaType.MOVIE);
                dialog.setLocationRelativeTo(MainWindow.getActiveInstance());
                dialog.setVisible(true);
            }
        });
        this.lblThumb.setCursor(Cursor.getPredefinedCursor(12));
        artworkPanel.add((Component)this.lblThumb, "4, 12, fill, fill");
        JLabel lblDiscT = new JLabel("Disc");
        artworkPanel.add((Component)lblDiscT, "6, 10");
        this.lblDisc = new ImageLabel();
        this.lblDisc.setAlternativeText(BUNDLE.getString("image.notfound.disc"));
        this.lblDisc.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                ImageChooserDialog dialog = new ImageChooserDialog(MovieEditorDialog.this.movieToEdit.getIds(), ImageChooserDialog.ImageType.DISC, MovieEditorDialog.this.movieList.getDefaultArtworkScrapers(), MovieEditorDialog.this.lblDisc, null, null, MediaType.MOVIE);
                dialog.setLocationRelativeTo(MainWindow.getActiveInstance());
                dialog.setVisible(true);
            }
        });
        this.lblDisc.setCursor(Cursor.getPredefinedCursor(12));
        artworkPanel.add((Component)this.lblDisc, "6, 12, fill, fill");
        this.mediaFilesPanel = new MediaFileEditorPanel(this.mediaFiles);
        tabbedPane.addTab(BUNDLE.getString("metatag.mediafiles"), null, this.mediaFilesPanel, null);
        JPanel bottomPane = new JPanel();
        this.getContentPane().add((Component)bottomPane, "South");
        bottomPane.setLayout((LayoutManager)new FormLayout(new ColumnSpec[]{ColumnSpec.decode((String)"371px:grow"), FormFactory.DEFAULT_COLSPEC, FormFactory.RELATED_GAP_COLSPEC}, new RowSpec[]{FormFactory.LINE_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.LINE_GAP_ROWSPEC}));
        JPanel buttonPane = new JPanel();
        bottomPane.add((Component)buttonPane, "2, 2, left, top");
        EqualsLayout layout = new EqualsLayout(5);
        layout.setMinWidth(100);
        buttonPane.setLayout(layout);
        JButton okButton = new JButton(BUNDLE.getString("Button.ok"));
        buttonPane.add((Component)okButton, "2, 1, fill, top");
        okButton.setAction(new ChangeMovieAction());
        okButton.setActionCommand("OK");
        this.getRootPane().setDefaultButton(okButton);
        JButton cancelButton = new JButton(BUNDLE.getString("Button.cancel"));
        buttonPane.add((Component)cancelButton, "4, 1, fill, top");
        cancelButton.setAction(new DiscardAction());
        cancelButton.setActionCommand("Cancel");
        if (inQueue) {
            JButton btnAbort = new JButton(BUNDLE.getString("Button.abortqueue"));
            btnAbort.setAction(new AbortQueueAction());
            buttonPane.add((Component)btnAbort, "6, 1, fill, top");
        }
        this.initDataBindings();
        int year = 0;
        try {
            year = Integer.parseInt(this.movieToEdit.getYear());
        }
        catch (Exception ignored) {
            // empty catch block
        }
        SimpleDateFormat dateFormat = (SimpleDateFormat)DateFormat.getDateInstance(2);
        for (Certification cert : Certification.getCertificationsforCountry((CountryCode)MovieModuleManager.MOVIE_SETTINGS.getCertificationCountry())) {
            this.cbCertification.addItem(cert);
        }
        this.tfTitle.setText(this.movieToEdit.getTitle());
        this.tfOriginalTitle.setText(this.movieToEdit.getOriginalTitle());
        this.tfSorttitle.setText(this.movieToEdit.getSortTitle());
        this.tpTagline.setText(this.movieToEdit.getTagline());
        this.tpPlot.setText(this.movieToEdit.getPlot());
        this.tpPlot.setCaretPosition(0);
        this.tfDirector.setText(this.movieToEdit.getDirector());
        this.tfWriter.setText(this.movieToEdit.getWriter());
        this.lblPoster.setImagePath(this.movieToEdit.getArtworkFilename(MediaFileType.POSTER));
        this.tfProductionCompanies.setText(this.movieToEdit.getProductionCompany());
        this.spRuntime.setValue(this.movieToEdit.getRuntime());
        this.cbEdition.setSelectedItem((Object)this.movieToEdit.getEdition());
        this.tfSpokenLanguages.setText(this.movieToEdit.getSpokenLanguages());
        this.tfCountry.setText(this.movieToEdit.getCountry());
        this.spYear.setValue(year);
        this.cbCertification.setSelectedItem(this.movieToEdit.getCertification());
        this.lblMoviePath.setText(this.movieToEdit.getPath());
        this.lblLogo.setImagePath(this.movieToEdit.getArtworkFilename(MediaFileType.LOGO));
        this.lblClearlogo.setImagePath(this.movieToEdit.getArtworkFilename(MediaFileType.CLEARLOGO));
        this.lblClearart.setImagePath(this.movieToEdit.getArtworkFilename(MediaFileType.CLEARART));
        this.lblThumb.setImagePath(this.movieToEdit.getArtworkFilename(MediaFileType.THUMB));
        this.lblDisc.setImagePath(this.movieToEdit.getArtworkFilename(MediaFileType.DISCART));
        this.lblBanner.setImagePath(this.movieToEdit.getArtworkFilename(MediaFileType.BANNER));
        for (MovieActor origCast : this.movieToEdit.getActors()) {
            MovieActor actor = new MovieActor();
            actor.setName(origCast.getName());
            actor.setCharacter(origCast.getCharacter());
            actor.setThumbUrl(origCast.getThumbUrl());
            this.cast.add(actor);
        }
        for (MovieProducer origProducer : this.movieToEdit.getProducers()) {
            MovieProducer producer = new MovieProducer();
            producer.setName(origProducer.getName());
            producer.setRole(origProducer.getRole());
            producer.setThumbUrl(origProducer.getThumbUrl());
            this.producers.add(producer);
        }
        for (MediaGenres genre : this.movieToEdit.getGenres()) {
            this.genres.add(genre);
        }
        for (MovieTrailer trailer : this.movieToEdit.getTrailer()) {
            this.trailers.add(trailer);
        }
        for (String tag : this.movieToEdit.getTags()) {
            if (!StringUtils.isNotBlank((CharSequence)tag)) continue;
            this.tags.add(tag);
        }
        this.extrathumbs.addAll(this.movieToEdit.getExtraThumbs());
        this.extrafanarts.addAll(this.movieToEdit.getExtraFanarts());
        for (MovieSet movieSet : this.movieList.getSortedMovieSetList()) {
            this.cbMovieSet.addItem(movieSet);
            if (this.movieToEdit.getMovieSet() != movieSet) continue;
            this.cbMovieSet.setSelectedItem(movieSet);
        }
        this.tableActors.getColumnModel().getColumn(0).setHeaderValue(BUNDLE.getString("metatag.name"));
        this.tableActors.getColumnModel().getColumn(1).setHeaderValue(BUNDLE.getString("metatag.role"));
        this.tableProducers.getColumnModel().getColumn(0).setHeaderValue(BUNDLE.getString("metatag.name"));
        this.tableProducers.getColumnModel().getColumn(1).setHeaderValue(BUNDLE.getString("metatag.role"));
        this.tableTrailer.getColumnModel().getColumn(0).setHeaderValue(BUNDLE.getString("metatag.nfo"));
        this.tableTrailer.getColumnModel().getColumn(1).setHeaderValue(BUNDLE.getString("metatag.name"));
        this.tableTrailer.getColumnModel().getColumn(2).setHeaderValue(BUNDLE.getString("metatag.source"));
        this.tableTrailer.getColumnModel().getColumn(3).setHeaderValue(BUNDLE.getString("metatag.quality"));
        this.tableTrailer.getColumnModel().getColumn(4).setHeaderValue(BUNDLE.getString("metatag.url"));
        this.tableTrailer.getColumnModel().getColumn(0).setMaxWidth(55);
        this.tableTrailer.getModel().addTableModelListener(new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent arg0) {
                if (arg0.getColumn() == 0) {
                    int row = arg0.getFirstRow();
                    MovieTrailer changedTrailer = (MovieTrailer)MovieEditorDialog.this.trailers.get(row);
                    if (changedTrailer.getInNfo().booleanValue()) {
                        for (MovieTrailer trailer : MovieEditorDialog.this.trailers) {
                            if (trailer == changedTrailer) continue;
                            trailer.setInNfo(Boolean.FALSE);
                        }
                    }
                }
            }
        });
    }

    public boolean showDialog() {
        this.setLocationRelativeTo(MainWindow.getActiveInstance());
        this.setVisible(true);
        return this.continueQueue;
    }

    @Override
    public void dispose() {
        super.dispose();
        this.jTableBinding.unbind();
        this.jListBinding.unbind();
        this.jTableBinding_1.unbind();
        this.jListBinding_1.unbind();
        this.jTableBinding_2.unbind();
        this.mediaFilesPanel.unbindBindings();
        this.dpReleaseDate.cleanup();
    }

    @Override
    public void pack() {
    }

    protected void initDataBindings() {
        this.jTableBinding = SwingBindings.createJTableBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ, this.cast, (JTable)this.tableActors);
        BeanProperty movieCastBeanProperty = BeanProperty.create((String)"name");
        this.jTableBinding.addColumnBinding((Property)movieCastBeanProperty);
        BeanProperty movieCastBeanProperty_1 = BeanProperty.create((String)"character");
        this.jTableBinding.addColumnBinding((Property)movieCastBeanProperty_1);
        this.jTableBinding.bind();
        this.jListBinding = SwingBindings.createJListBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ, this.genres, this.listGenres);
        this.jListBinding.bind();
        this.jTableBinding_1 = SwingBindings.createJTableBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ, this.trailers, (JTable)this.tableTrailer);
        BeanProperty trailerBeanProperty = BeanProperty.create((String)"inNfo");
        this.jTableBinding_1.addColumnBinding((Property)trailerBeanProperty).setColumnClass(Boolean.class);
        BeanProperty trailerBeanProperty_1 = BeanProperty.create((String)"name");
        this.jTableBinding_1.addColumnBinding((Property)trailerBeanProperty_1);
        BeanProperty trailerBeanProperty_2 = BeanProperty.create((String)"provider");
        this.jTableBinding_1.addColumnBinding((Property)trailerBeanProperty_2);
        BeanProperty trailerBeanProperty_3 = BeanProperty.create((String)"quality");
        this.jTableBinding_1.addColumnBinding((Property)trailerBeanProperty_3);
        BeanProperty trailerBeanProperty_4 = BeanProperty.create((String)"url");
        this.jTableBinding_1.addColumnBinding((Property)trailerBeanProperty_4);
        this.jTableBinding_1.bind();
        this.jListBinding_1 = SwingBindings.createJListBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ, this.tags, this.listTags);
        this.jListBinding_1.bind();
        this.jTableBinding_2 = SwingBindings.createJTableBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ, this.producers, (JTable)this.tableProducers);
        BeanProperty movieProducerBeanProperty = BeanProperty.create((String)"name");
        this.jTableBinding_2.addColumnBinding((Property)movieProducerBeanProperty);
        BeanProperty movieProducerBeanProperty_1 = BeanProperty.create((String)"role");
        this.jTableBinding_2.addColumnBinding((Property)movieProducerBeanProperty_1);
        this.jTableBinding_2.bind();
    }

    private class MoveTagDownAction
    extends AbstractAction {
        private static final long serialVersionUID = -1135108943010008069L;

        public MoveTagDownAction() {
            this.putValue("ShortDescription", BUNDLE.getString("movie.edit.movetagdown"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int row = MovieEditorDialog.this.listTags.getSelectedIndex();
            if (row < MovieEditorDialog.this.tags.size() - 1) {
                Collections.rotate(MovieEditorDialog.this.tags.subList(row, row + 2), -1);
                MovieEditorDialog.this.listTags.getSelectionModel().setSelectionInterval(row + 1, row + 1);
            }
        }
    }

    private class MoveTagUpAction
    extends AbstractAction {
        private static final long serialVersionUID = -6855661707692602266L;

        public MoveTagUpAction() {
            this.putValue("ShortDescription", BUNDLE.getString("movie.edit.movetagup"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int row = MovieEditorDialog.this.listTags.getSelectedIndex();
            if (row > 0) {
                Collections.rotate(MovieEditorDialog.this.tags.subList(row - 1, row + 1), 1);
                MovieEditorDialog.this.listTags.getSelectionModel().setSelectionInterval(row - 1, row - 1);
            }
        }
    }

    private class MoveGenreDownAction
    extends AbstractAction {
        private static final long serialVersionUID = -1135108943010008069L;

        public MoveGenreDownAction() {
            this.putValue("ShortDescription", BUNDLE.getString("movie.edit.movegenredown"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int row = MovieEditorDialog.this.listGenres.getSelectedIndex();
            if (row < MovieEditorDialog.this.genres.size() - 1) {
                Collections.rotate(MovieEditorDialog.this.genres.subList(row, row + 2), -1);
                MovieEditorDialog.this.listGenres.getSelectionModel().setSelectionInterval(row + 1, row + 1);
            }
        }
    }

    private class MoveGenreUpAction
    extends AbstractAction {
        private static final long serialVersionUID = -6855661707692602266L;

        public MoveGenreUpAction() {
            this.putValue("ShortDescription", BUNDLE.getString("movie.edit.movegenreup"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int row = MovieEditorDialog.this.listGenres.getSelectedIndex();
            if (row > 0) {
                Collections.rotate(MovieEditorDialog.this.genres.subList(row - 1, row + 1), 1);
                MovieEditorDialog.this.listGenres.getSelectionModel().setSelectionInterval(row - 1, row - 1);
            }
        }
    }

    private class MoveProducerDownAction
    extends AbstractAction {
        private static final long serialVersionUID = -1135108943010008069L;

        public MoveProducerDownAction() {
            this.putValue("ShortDescription", BUNDLE.getString("movie.edit.moveproducerdown"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int row = MovieEditorDialog.this.tableProducers.getSelectedRow();
            if (row < MovieEditorDialog.this.producers.size() - 1) {
                Collections.rotate(MovieEditorDialog.this.producers.subList(row, row + 2), -1);
                MovieEditorDialog.this.tableProducers.getSelectionModel().setSelectionInterval(row + 1, row + 1);
            }
        }
    }

    private class MoveProducerUpAction
    extends AbstractAction {
        private static final long serialVersionUID = -6855661707692602266L;

        public MoveProducerUpAction() {
            this.putValue("ShortDescription", BUNDLE.getString("movie.edit.moveproducerup"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int row = MovieEditorDialog.this.tableProducers.getSelectedRow();
            if (row > 0) {
                Collections.rotate(MovieEditorDialog.this.producers.subList(row - 1, row + 1), 1);
                MovieEditorDialog.this.tableProducers.getSelectionModel().setSelectionInterval(row - 1, row - 1);
            }
        }
    }

    private class MoveActorDownAction
    extends AbstractAction {
        private static final long serialVersionUID = -6564146895819191932L;

        public MoveActorDownAction() {
            this.putValue("ShortDescription", BUNDLE.getString("movie.edit.moveactordown"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int row = MovieEditorDialog.this.tableActors.getSelectedRow();
            if (row < MovieEditorDialog.this.cast.size() - 1) {
                Collections.rotate(MovieEditorDialog.this.cast.subList(row, row + 2), -1);
                MovieEditorDialog.this.tableActors.getSelectionModel().setSelectionInterval(row + 1, row + 1);
            }
        }
    }

    private class MoveActorUpAction
    extends AbstractAction {
        private static final long serialVersionUID = 5775423424097844658L;

        public MoveActorUpAction() {
            this.putValue("ShortDescription", BUNDLE.getString("movie.edit.moveactorup"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int row = MovieEditorDialog.this.tableActors.getSelectedRow();
            if (row > 0) {
                Collections.rotate(MovieEditorDialog.this.cast.subList(row - 1, row + 1), 1);
                MovieEditorDialog.this.tableActors.getSelectionModel().setSelectionInterval(row - 1, row - 1);
            }
        }
    }

    private class AbortQueueAction
    extends AbstractAction {
        private static final long serialVersionUID = -7652218354710642510L;

        public AbortQueueAction() {
            this.putValue("Name", BUNDLE.getString("Button.abortqueue"));
            this.putValue("ShortDescription", BUNDLE.getString("movie.edit.abortqueue.desc"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            MovieEditorDialog.this.continueQueue = false;
            MovieEditorDialog.this.setVisible(false);
        }
    }

    private class RemoveTagAction
    extends AbstractAction {
        private static final long serialVersionUID = -1580945350962234235L;

        public RemoveTagAction() {
            this.putValue("ShortDescription", BUNDLE.getString("tag.remove"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            List selectedTags = MovieEditorDialog.this.listTags.getSelectedValuesList();
            for (String tag : selectedTags) {
                MovieEditorDialog.this.tags.remove(tag);
            }
        }
    }

    private class AddTagAction
    extends AbstractAction {
        private static final long serialVersionUID = 9160043031922897785L;

        public AddTagAction() {
            this.putValue("ShortDescription", BUNDLE.getString("tag.add"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JTextField tf;
            String selectedText;
            String newTag = (String)MovieEditorDialog.this.cbTags.getSelectedItem();
            if (StringUtils.isBlank((CharSequence)newTag)) {
                return;
            }
            Component editorComponent = MovieEditorDialog.this.cbTags.getEditor().getEditorComponent();
            if (editorComponent instanceof JTextField && (selectedText = (tf = (JTextField)editorComponent).getSelectedText()) != null) {
                tf.setSelectionStart(0);
                tf.setSelectionEnd(0);
                tf.setCaretPosition(tf.getText().length());
                return;
            }
            boolean tagFound = false;
            for (String tag : MovieEditorDialog.this.tags) {
                if (!tag.equals(newTag)) continue;
                tagFound = true;
                break;
            }
            if (!tagFound) {
                MovieEditorDialog.this.tags.add(newTag);
                if (editorComponent instanceof JTextField) {
                    MovieEditorDialog.this.cbTagsAutoCompleteSupport.setFirstItem((Object)"");
                    MovieEditorDialog.this.cbTags.setSelectedIndex(0);
                    MovieEditorDialog.this.cbTagsAutoCompleteSupport.removeFirstItem();
                }
            }
        }
    }

    private class RemoveTrailerAction
    extends AbstractAction {
        private static final long serialVersionUID = -6956921050689930101L;

        public RemoveTrailerAction() {
            this.putValue("ShortDescription", BUNDLE.getString("trailer.remove"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int row = MovieEditorDialog.this.tableTrailer.getSelectedRow();
            if (row > -1) {
                row = MovieEditorDialog.this.tableTrailer.convertRowIndexToModel(row);
                MovieEditorDialog.this.trailers.remove(row);
            }
        }
    }

    private class AddTrailerAction
    extends AbstractAction {
        private static final long serialVersionUID = -4446154040952056823L;

        public AddTrailerAction() {
            this.putValue("ShortDescription", BUNDLE.getString("trailer.add"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            MovieTrailer trailer = new MovieTrailer();
            trailer.setName("unknown");
            trailer.setProvider("unknown");
            trailer.setQuality("unknown");
            trailer.setUrl("http://");
            MovieEditorDialog.this.trailers.add(0, trailer);
        }
    }

    private class RemoveGenreAction
    extends AbstractAction {
        private static final long serialVersionUID = 2733654945906747720L;

        public RemoveGenreAction() {
            this.putValue("ShortDescription", BUNDLE.getString("genre.remove"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            List selectedGenres = MovieEditorDialog.this.listGenres.getSelectedValuesList();
            for (MediaGenres genre : selectedGenres) {
                MovieEditorDialog.this.genres.remove(genre);
            }
        }
    }

    private class AddGenreAction
    extends AbstractAction {
        private static final long serialVersionUID = 176474809593575743L;

        public AddGenreAction() {
            this.putValue("ShortDescription", BUNDLE.getString("genre.add"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JTextField tf;
            String selectedText;
            MediaGenres newGenre = null;
            Object item = MovieEditorDialog.this.cbGenres.getSelectedItem();
            Component editorComponent = MovieEditorDialog.this.cbGenres.getEditor().getEditorComponent();
            if (editorComponent instanceof JTextField && (selectedText = (tf = (JTextField)editorComponent).getSelectedText()) != null) {
                tf.setSelectionStart(0);
                tf.setSelectionEnd(0);
                tf.setCaretPosition(tf.getText().length());
                return;
            }
            if (item instanceof MediaGenres) {
                newGenre = (MediaGenres)item;
            }
            if (item instanceof String) {
                newGenre = MediaGenres.getGenre((String)((String)item));
            }
            if (newGenre != null && !MovieEditorDialog.this.genres.contains(newGenre)) {
                MovieEditorDialog.this.genres.add(newGenre);
                if (editorComponent instanceof JTextField) {
                    MovieEditorDialog.this.cbGenresAutoCompleteSupport.setFirstItem(null);
                    MovieEditorDialog.this.cbGenres.setSelectedIndex(0);
                    MovieEditorDialog.this.cbGenresAutoCompleteSupport.removeFirstItem();
                }
            }
        }
    }

    private class RemoveProducerAction
    extends AbstractAction {
        private static final long serialVersionUID = -3907776089614305086L;

        public RemoveProducerAction() {
            this.putValue("ShortDescription", BUNDLE.getString("cast.producer.remove"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int row = MovieEditorDialog.this.tableProducers.getSelectedRow();
            if (row > -1) {
                row = MovieEditorDialog.this.tableProducers.convertRowIndexToModel(row);
                MovieEditorDialog.this.producers.remove(row);
            }
        }
    }

    private class AddProducerAction
    extends AbstractAction {
        private static final long serialVersionUID = -8834531637996987853L;

        public AddProducerAction() {
            this.putValue("ShortDescription", BUNDLE.getString("cast.producer.add"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            MovieProducer producer = new MovieProducer(BUNDLE.getString("producer.name.unknown"), BUNDLE.getString("producer.role.unknown"));
            MovieEditorDialog.this.producers.add(0, producer);
        }
    }

    private class RemoveActorAction
    extends AbstractAction {
        private static final long serialVersionUID = -7079826970827356996L;

        public RemoveActorAction() {
            this.putValue("ShortDescription", BUNDLE.getString("cast.actor.remove"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int row = MovieEditorDialog.this.tableActors.getSelectedRow();
            if (row > -1) {
                row = MovieEditorDialog.this.tableActors.convertRowIndexToModel(row);
                MovieEditorDialog.this.cast.remove(row);
            }
        }
    }

    private class AddActorAction
    extends AbstractAction {
        private static final long serialVersionUID = 2903255414153349267L;

        public AddActorAction() {
            this.putValue("ShortDescription", BUNDLE.getString("cast.actor.add"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            MovieActor actor = new MovieActor(BUNDLE.getString("cast.actor.unknown"), BUNDLE.getString("cast.role.unknown"));
            MovieEditorDialog.this.cast.add(0, actor);
        }
    }

    private class RemoveIdAction
    extends AbstractAction {
        private static final long serialVersionUID = -7079826950827356996L;

        public RemoveIdAction() {
            this.putValue("ShortDescription", BUNDLE.getString("id.remove"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int row = MovieEditorDialog.this.tableIds.getSelectedRow();
            if (row > -1) {
                row = MovieEditorDialog.this.tableIds.convertRowIndexToModel(row);
                MovieEditorDialog.this.ids.remove(row);
            }
        }
    }

    private class AddIdAction
    extends AbstractAction {
        private static final long serialVersionUID = 2903255414553349267L;

        public AddIdAction() {
            this.putValue("ShortDescription", BUNDLE.getString("id.add"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            MediaIdTable.MediaId Id = new MediaIdTable.MediaId();
            MovieEditorDialog.this.ids.add((Object)Id);
        }
    }

    private class DiscardAction
    extends AbstractAction {
        private static final long serialVersionUID = -5581329896797961536L;

        public DiscardAction() {
            this.putValue("Name", BUNDLE.getString("Button.cancel"));
            this.putValue("ShortDescription", BUNDLE.getString("edit.discard"));
            this.putValue("SmallIcon", IconManager.CANCEL);
            this.putValue("SwingLargeIconKey", IconManager.CANCEL);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            MovieEditorDialog.this.setVisible(false);
        }
    }

    private class ChangeMovieAction
    extends AbstractAction {
        private static final long serialVersionUID = -3767744690599233490L;

        public ChangeMovieAction() {
            this.putValue("Name", BUNDLE.getString("Button.ok"));
            this.putValue("ShortDescription", BUNDLE.getString("movie.change"));
            this.putValue("SmallIcon", IconManager.APPLY);
            this.putValue("SwingLargeIconKey", IconManager.APPLY);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            MovieEditorDialog.this.movieToEdit.setTitle(MovieEditorDialog.this.tfTitle.getText());
            MovieEditorDialog.this.movieToEdit.setOriginalTitle(MovieEditorDialog.this.tfOriginalTitle.getText());
            MovieEditorDialog.this.movieToEdit.setTagline(MovieEditorDialog.this.tpTagline.getText());
            MovieEditorDialog.this.movieToEdit.setPlot(MovieEditorDialog.this.tpPlot.getText());
            MovieEditorDialog.this.movieToEdit.setYear(MovieEditorDialog.this.spYear.getValue().equals(0) ? "" : String.valueOf(MovieEditorDialog.this.spYear.getValue()));
            MovieEditorDialog.this.movieToEdit.setReleaseDate(MovieEditorDialog.this.dpReleaseDate.getDate());
            MovieEditorDialog.this.movieToEdit.setRuntime((Integer)MovieEditorDialog.this.spRuntime.getValue());
            MovieEditorDialog.this.movieToEdit.setTop250((Integer)MovieEditorDialog.this.spTop250.getValue());
            MovieEditorDialog.this.movieToEdit.setWatched(MovieEditorDialog.this.cbWatched.isSelected());
            MovieEditorDialog.this.movieToEdit.setSpokenLanguages(MovieEditorDialog.this.tfSpokenLanguages.getText());
            MovieEditorDialog.this.movieToEdit.setCountry(MovieEditorDialog.this.tfCountry.getText());
            MovieEditorDialog.this.movieToEdit.setMediaSource((MediaSource)((Object)MovieEditorDialog.this.cbSource.getSelectedItem()));
            MovieEditorDialog.this.movieToEdit.setVideoIn3D(MovieEditorDialog.this.chckbxVideo3D.isSelected());
            MovieEditorDialog.this.movieToEdit.setEdition((MovieEdition)((Object)MovieEditorDialog.this.cbEdition.getSelectedItem()));
            for (MediaIdTable.MediaId id : MovieEditorDialog.this.ids) {
                try {
                    Integer value = Integer.parseInt(id.value);
                    MovieEditorDialog.this.movieToEdit.setId(id.key, value);
                }
                catch (NumberFormatException ex) {
                    MovieEditorDialog.this.movieToEdit.setId(id.key, id.value);
                }
            }
            ArrayList<String> removeIds = new ArrayList<String>();
            for (Map.Entry<String, Object> entry : MovieEditorDialog.this.movieToEdit.getIds().entrySet()) {
                MediaIdTable.MediaId id = new MediaIdTable.MediaId(entry.getKey());
                if (MovieEditorDialog.this.ids.contains((Object)id)) continue;
                removeIds.add(entry.getKey());
            }
            for (String id : removeIds) {
                MovieEditorDialog.this.movieToEdit.getIds().remove(id);
            }
            Object certification = MovieEditorDialog.this.cbCertification.getSelectedItem();
            if (certification instanceof Certification) {
                MovieEditorDialog.this.movieToEdit.setCertification((Certification)certification);
            }
            MediaFileEditorPanel.syncMediaFiles(MovieEditorDialog.this.mediaFiles, MovieEditorDialog.this.movieToEdit.getMediaFiles());
            MovieEditorDialog.this.movieToEdit.fireEventForChangedMediaInformation();
            if (!StringUtils.isEmpty((CharSequence)MovieEditorDialog.this.lblPoster.getImageUrl()) && !MovieEditorDialog.this.lblPoster.getImageUrl().equals(MovieEditorDialog.this.movieToEdit.getArtworkUrl(MediaFileType.POSTER))) {
                MovieEditorDialog.this.movieToEdit.setArtworkUrl(MovieEditorDialog.this.lblPoster.getImageUrl(), MediaFileType.POSTER);
                MovieEditorDialog.this.movieToEdit.downloadArtwork(MediaFileType.POSTER);
            }
            if (!StringUtils.isEmpty((CharSequence)MovieEditorDialog.this.lblFanart.getImageUrl()) && !MovieEditorDialog.this.lblFanart.getImageUrl().equals(MovieEditorDialog.this.movieToEdit.getArtworkUrl(MediaFileType.FANART))) {
                MovieEditorDialog.this.movieToEdit.setArtworkUrl(MovieEditorDialog.this.lblFanart.getImageUrl(), MediaFileType.FANART);
                MovieEditorDialog.this.movieToEdit.downloadArtwork(MediaFileType.FANART);
            }
            if (!StringUtils.isEmpty((CharSequence)MovieEditorDialog.this.lblLogo.getImageUrl()) && !MovieEditorDialog.this.lblLogo.getImageUrl().equals(MovieEditorDialog.this.movieToEdit.getArtworkUrl(MediaFileType.LOGO))) {
                MovieEditorDialog.this.movieToEdit.setArtworkUrl(MovieEditorDialog.this.lblLogo.getImageUrl(), MediaFileType.LOGO);
                MovieEditorDialog.this.movieToEdit.downloadArtwork(MediaFileType.LOGO);
            }
            if (!StringUtils.isEmpty((CharSequence)MovieEditorDialog.this.lblClearlogo.getImageUrl()) && !MovieEditorDialog.this.lblClearlogo.getImageUrl().equals(MovieEditorDialog.this.movieToEdit.getArtworkUrl(MediaFileType.CLEARLOGO))) {
                MovieEditorDialog.this.movieToEdit.setArtworkUrl(MovieEditorDialog.this.lblClearlogo.getImageUrl(), MediaFileType.CLEARLOGO);
                MovieEditorDialog.this.movieToEdit.downloadArtwork(MediaFileType.CLEARLOGO);
            }
            if (!StringUtils.isEmpty((CharSequence)MovieEditorDialog.this.lblBanner.getImageUrl()) && !MovieEditorDialog.this.lblBanner.getImageUrl().equals(MovieEditorDialog.this.movieToEdit.getArtworkUrl(MediaFileType.BANNER))) {
                MovieEditorDialog.this.movieToEdit.setArtworkUrl(MovieEditorDialog.this.lblBanner.getImageUrl(), MediaFileType.BANNER);
                MovieEditorDialog.this.movieToEdit.downloadArtwork(MediaFileType.BANNER);
            }
            if (!StringUtils.isEmpty((CharSequence)MovieEditorDialog.this.lblClearart.getImageUrl()) && !MovieEditorDialog.this.lblClearart.getImageUrl().equals(MovieEditorDialog.this.movieToEdit.getArtworkUrl(MediaFileType.CLEARART))) {
                MovieEditorDialog.this.movieToEdit.setArtworkUrl(MovieEditorDialog.this.lblClearart.getImageUrl(), MediaFileType.CLEARART);
                MovieEditorDialog.this.movieToEdit.downloadArtwork(MediaFileType.CLEARART);
            }
            if (!StringUtils.isEmpty((CharSequence)MovieEditorDialog.this.lblThumb.getImageUrl()) && !MovieEditorDialog.this.lblThumb.getImageUrl().equals(MovieEditorDialog.this.movieToEdit.getArtworkUrl(MediaFileType.THUMB))) {
                MovieEditorDialog.this.movieToEdit.setArtworkUrl(MovieEditorDialog.this.lblThumb.getImageUrl(), MediaFileType.THUMB);
                MovieEditorDialog.this.movieToEdit.downloadArtwork(MediaFileType.THUMB);
            }
            if (!StringUtils.isEmpty((CharSequence)MovieEditorDialog.this.lblDisc.getImageUrl()) && !MovieEditorDialog.this.lblDisc.getImageUrl().equals(MovieEditorDialog.this.movieToEdit.getArtworkUrl(MediaFileType.DISCART))) {
                MovieEditorDialog.this.movieToEdit.setArtworkUrl(MovieEditorDialog.this.lblDisc.getImageUrl(), MediaFileType.DISCART);
                MovieEditorDialog.this.movieToEdit.downloadArtwork(MediaFileType.DISCART);
            }
            if (MovieEditorDialog.this.extrathumbs.size() != MovieEditorDialog.this.movieToEdit.getExtraThumbs().size() || !MovieEditorDialog.this.extrathumbs.containsAll(MovieEditorDialog.this.movieToEdit.getExtraThumbs()) || !MovieEditorDialog.this.movieToEdit.getExtraThumbs().containsAll(MovieEditorDialog.this.extrathumbs)) {
                MovieEditorDialog.this.movieToEdit.setExtraThumbs(MovieEditorDialog.this.extrathumbs);
                MovieEditorDialog.this.movieToEdit.downloadArtwork(MediaFileType.EXTRATHUMB);
            }
            if (MovieEditorDialog.this.extrafanarts.size() != MovieEditorDialog.this.movieToEdit.getExtraFanarts().size() || !MovieEditorDialog.this.extrafanarts.containsAll(MovieEditorDialog.this.movieToEdit.getExtraFanarts()) || !MovieEditorDialog.this.movieToEdit.getExtraFanarts().containsAll(MovieEditorDialog.this.extrafanarts)) {
                MovieEditorDialog.this.movieToEdit.setExtraFanarts(MovieEditorDialog.this.extrafanarts);
                MovieEditorDialog.this.movieToEdit.downloadArtwork(MediaFileType.EXTRAFANART);
            }
            MovieEditorDialog.this.movieToEdit.setDirector(MovieEditorDialog.this.tfDirector.getText());
            MovieEditorDialog.this.movieToEdit.setWriter(MovieEditorDialog.this.tfWriter.getText());
            MovieEditorDialog.this.movieToEdit.setProductionCompany(MovieEditorDialog.this.tfProductionCompanies.getText());
            MovieEditorDialog.this.movieToEdit.setActors(MovieEditorDialog.this.cast);
            MovieEditorDialog.this.movieToEdit.setProducers(MovieEditorDialog.this.producers);
            MovieEditorDialog.this.movieToEdit.setGenres(MovieEditorDialog.this.genres);
            MovieEditorDialog.this.movieToEdit.removeAllTrailers();
            for (MovieTrailer trailer : MovieEditorDialog.this.trailers) {
                MovieEditorDialog.this.movieToEdit.addTrailer(trailer);
            }
            MovieEditorDialog.this.movieToEdit.setTags(MovieEditorDialog.this.tags);
            MovieEditorDialog.this.movieToEdit.setDateAdded((Date)MovieEditorDialog.this.spDateAdded.getValue());
            MovieEditorDialog.this.movieToEdit.setSortTitle(MovieEditorDialog.this.tfSorttitle.getText());
            Object obj = MovieEditorDialog.this.cbMovieSet.getSelectedItem();
            if (obj instanceof String) {
                MovieEditorDialog.this.movieToEdit.removeFromMovieSet();
            }
            if (obj instanceof MovieSet) {
                MovieSet movieSet = (MovieSet)obj;
                if (MovieEditorDialog.this.movieToEdit.getMovieSet() != movieSet) {
                    MovieEditorDialog.this.movieToEdit.removeFromMovieSet();
                    MovieEditorDialog.this.movieToEdit.setMovieSet(movieSet);
                    movieSet.insertMovie(MovieEditorDialog.this.movieToEdit);
                }
            }
            double tempRating = (Double)MovieEditorDialog.this.spRating.getValue();
            float rating = (float)tempRating;
            if (MovieEditorDialog.this.movieToEdit.getRating() != rating) {
                MovieEditorDialog.this.movieToEdit.setRating(rating);
                MovieEditorDialog.this.movieToEdit.setVotes(1);
            }
            MovieEditorDialog.this.movieToEdit.writeNFO();
            MovieEditorDialog.this.movieToEdit.saveToDb();
            if (MovieModuleManager.MOVIE_SETTINGS.getSyncTrakt()) {
                SyncTraktTvTask task = new SyncTraktTvTask(Arrays.asList(MovieEditorDialog.this.movieToEdit), null);
                TmmTaskManager.getInstance().addUnnamedTask(task);
            }
            MovieEditorDialog.this.setVisible(false);
        }
    }
}

