/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.movies.actions;

import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.ResourceBundle;
import javax.swing.AbstractAction;
import javax.swing.JOptionPane;
import org.tinymediamanager.core.movie.MovieList;
import org.tinymediamanager.core.movie.entities.Movie;
import org.tinymediamanager.ui.IconManager;
import org.tinymediamanager.ui.MainWindow;
import org.tinymediamanager.ui.UTF8Control;
import org.tinymediamanager.ui.movies.MovieUIModule;

public class MovieDeleteAction
extends AbstractAction {
    private static final long serialVersionUID = -984567332370801730L;
    private static final ResourceBundle BUNDLE = ResourceBundle.getBundle("messages", new UTF8Control());

    public MovieDeleteAction() {
        this.putValue("SmallIcon", IconManager.DELETE);
        this.putValue("Name", BUNDLE.getString("movie.delete"));
        this.putValue("ShortDescription", BUNDLE.getString("movie.delete.hint"));
    }

    @Override
    public void actionPerformed(ActionEvent arg0) {
        ArrayList<Movie> selectedMovies = new ArrayList<Movie>(MovieUIModule.getInstance().getSelectionModel().getSelectedMovies());
        int answer = JOptionPane.showConfirmDialog(MainWindow.getActiveInstance(), BUNDLE.getString("movie.delete.desc"), BUNDLE.getString("movie.delete"), 0);
        if (answer != 0) {
            return;
        }
        MovieList.getInstance().deleteMovies(selectedMovies);
    }
}

