/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.dialogs;

import hu.kazocsaba.imageviewer.ImageViewer;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.image.BufferedImage;
import java.util.ResourceBundle;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.SwingWorker;
import javax.swing.border.EmptyBorder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.core.ImageCache;
import org.tinymediamanager.scraper.http.Url;
import org.tinymediamanager.ui.MainWindow;
import org.tinymediamanager.ui.TmmFontHelper;
import org.tinymediamanager.ui.UTF8Control;
import org.tinymediamanager.ui.dialogs.TmmDialog;

public class ImagePreviewDialog
extends TmmDialog {
    private static final long serialVersionUID = -7479476493187235867L;
    private static final ResourceBundle BUNDLE = ResourceBundle.getBundle("messages", new UTF8Control());
    private static final Logger LOGGER = LoggerFactory.getLogger(ImagePreviewDialog.class);
    private String imageUrl;
    private SwingWorker<BufferedImage, Void> worker;
    private ImageViewer imgViewer = new ImageViewer();
    private JLabel lblLoadingInfo;

    public ImagePreviewDialog(String urlToImage) {
        super("", "imagePreview");
        this.imageUrl = urlToImage;
        this.getContentPane().setLayout(new BorderLayout());
        this.lblLoadingInfo = new JLabel(BUNDLE.getString("image.download"));
        this.lblLoadingInfo.setBorder(new EmptyBorder(10, 10, 10, 10));
        TmmFontHelper.changeFont((JComponent)this.lblLoadingInfo, 1.5);
        this.getContentPane().add((Component)this.lblLoadingInfo, "Center");
        this.worker = new ImageFetcher();
        this.worker.execute();
    }

    @Override
    public void setVisible(boolean visible) {
        if (visible) {
            this.pack();
            this.setLocationRelativeTo(MainWindow.getActiveInstance());
            super.setVisible(true);
        } else {
            if (this.worker != null && !this.worker.isDone()) {
                this.worker.cancel(true);
            }
            super.setVisible(false);
            this.dispose();
        }
    }

    protected class ImageFetcher
    extends SwingWorker<BufferedImage, Void> {
        protected ImageFetcher() {
        }

        @Override
        protected BufferedImage doInBackground() throws Exception {
            try {
                Url url = new Url(ImagePreviewDialog.this.imageUrl);
                return ImageCache.createImage(url.getBytes());
            }
            catch (Exception e) {
                LOGGER.warn("fetch image: " + e.getMessage());
                return null;
            }
        }

        @Override
        protected void done() {
            try {
                BufferedImage image = (BufferedImage)this.get();
                if (image == null) {
                    ImagePreviewDialog.this.lblLoadingInfo.setText(BUNDLE.getString("image.download.failed"));
                    ImagePreviewDialog.this.pack();
                    return;
                }
                ImagePreviewDialog.this.imgViewer.setImage(image);
                JComponent comp = ImagePreviewDialog.this.imgViewer.getComponent();
                ImagePreviewDialog.this.getContentPane().removeAll();
                ImagePreviewDialog.this.getContentPane().add((Component)comp, "Center");
                ImagePreviewDialog.this.pack();
                ImagePreviewDialog.this.setLocationRelativeTo(MainWindow.getActiveInstance());
            }
            catch (Exception e) {
                LOGGER.warn("fetch image: " + e.getMessage());
            }
        }
    }
}

