/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui;

import com.jtattoo.plaf.BaseTreeUI;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.tree.TreePath;

public class TreeUI
extends BaseTreeUI {
    private RowSelectionListener sf = new RowSelectionListener();

    protected void paintRow(Graphics g, Rectangle clipBounds, Insets insets, Rectangle bounds, TreePath path, int row, boolean isExpanded, boolean hasBeenExpanded, boolean isLeaf) {
        if (this.editingComponent != null && this.editingRow == row) {
            return;
        }
        super.paintRow(g, clipBounds, insets, bounds, path, row, isExpanded, hasBeenExpanded, isLeaf);
    }

    protected void installListeners() {
        super.installListeners();
        this.tree.addMouseListener(this.sf);
    }

    protected void uninstallListeners() {
        this.tree.removeMouseListener(this.sf);
        super.uninstallListeners();
    }

    private class RowSelectionListener
    extends MouseAdapter {
        private RowSelectionListener() {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            if (!TreeUI.this.tree.isEnabled()) {
                return;
            }
            TreePath closestPath = TreeUI.this.tree.getClosestPathForLocation(e.getX(), e.getY());
            if (closestPath == null) {
                return;
            }
            Rectangle bounds = TreeUI.this.tree.getPathBounds(closestPath);
            if (e.getY() >= bounds.y && e.getY() < bounds.y + bounds.height && (e.getX() < bounds.x || e.getX() > bounds.x + bounds.width)) {
                if (TreeUI.this.isLocationInExpandControl(closestPath, e.getX(), e.getY())) {
                    return;
                }
                TreeUI.this.selectPathForEvent(closestPath, e);
            }
        }
    }
}

