/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.core;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.SystemUtils;
import org.jdesktop.observablecollections.ObservableCollections;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.ReleaseInfo;
import org.tinymediamanager.core.AbstractModelObject;
import org.tinymediamanager.core.EncryptedStringXmlAdapter;
import org.tinymediamanager.core.ImageCache;
import org.tinymediamanager.core.Message;
import org.tinymediamanager.core.MessageManager;
import org.tinymediamanager.core.Utils;
import org.tinymediamanager.core.WolDevice;
import org.tinymediamanager.core.movie.MovieFanartNaming;
import org.tinymediamanager.core.movie.MovieNfoNaming;
import org.tinymediamanager.core.movie.MoviePosterNaming;
import org.tinymediamanager.core.movie.MovieScraperMetadataConfig;
import org.tinymediamanager.core.movie.MovieSettings;
import org.tinymediamanager.core.tvshow.TvShowScraperMetadataConfig;
import org.tinymediamanager.core.tvshow.TvShowSettings;
import org.tinymediamanager.scraper.MediaScraper;
import org.tinymediamanager.scraper.ScraperType;
import org.tinymediamanager.scraper.entities.CountryCode;
import org.tinymediamanager.scraper.entities.MediaLanguages;
import org.tinymediamanager.scraper.http.ProxySettings;
import org.tinymediamanager.scraper.util.StrgUtils;

@XmlRootElement(name="tinyMediaManager")
public class Settings
extends AbstractModelObject {
    private static final Logger LOGGER = LoggerFactory.getLogger(Settings.class);
    private static final String DEFAULT_CONFIG_FOLDER = "data";
    private static final String DEFAULT_CONFIG_FILE = "config.xml";
    private static String settingsFolder = "data";
    private static String configFile = "config.xml";
    private static Settings instance;
    private static final String TITLE_PREFIX = "titlePrefix";
    private static final String PREFIX = "prefix";
    private static final String VIDEO_FILE_TYPE = "videoFileTypes";
    private static final String AUDIO_FILE_TYPE = "audioFileTypes";
    private static final String SUBTITLE_FILE_TYPE = "subtitleFileTypes";
    private static final String FILETYPE = "filetype";
    private static final String PROXY_HOST = "proxyHost";
    private static final String PROXY_PORT = "proxyPort";
    private static final String PROXY_USERNAME = "proxyUsername";
    private static final String PROXY_PASSWORD = "proxyPassword";
    private static final String IMAGE_CACHE = "imageCache";
    private static final String IMAGE_CACHE_TYPE = "imageCacheType";
    private static final String LANGUAGE = "language";
    private static final String WOL_DEVICES = "wolDevices";
    private static final String ENABLE_ANALYTICS = "enableAnalytics";
    private static final String UPNP_SHARE_LIBRARY = "upnpShareLibrary";
    private static final String UPNP_PLAY_ON_REMOTE = "upnpRemotePlay";
    @XmlElementWrapper(name="titlePrefix")
    @XmlElement(name="prefix")
    private final List<String> titlePrefix = ObservableCollections.observableList(new ArrayList());
    @XmlElementWrapper(name="videoFileTypes")
    @XmlElement(name="filetype")
    private final List<String> videoFileTypes = ObservableCollections.observableList(new ArrayList());
    @XmlElementWrapper(name="audioFileTypes")
    @XmlElement(name="filetype")
    private final List<String> audioFileTypes = ObservableCollections.observableList(new ArrayList());
    @XmlElementWrapper(name="subtitleFileTypes")
    @XmlElement(name="filetype")
    private final List<String> subtitleFileTypes = ObservableCollections.observableList(new ArrayList());
    @XmlElementWrapper(name="wolDevices")
    private final List<WolDevice> wolDevices = ObservableCollections.observableList(new ArrayList());
    @XmlAttribute
    private String version = "";
    private String proxyHost;
    private String proxyPort;
    private String proxyUsername;
    private String proxyPassword;
    private String traktAccessToken = "";
    private String traktRefreshToken = "";
    private String xbmcHost = "";
    private String xbmcUsername = "";
    private String xbmcPassword = "";
    private boolean imageCache = true;
    private ImageCache.CacheType imageCacheType = ImageCache.CacheType.SMOOTH;
    private boolean dirty = false;
    private MovieSettings movieSettings = null;
    private TvShowSettings tvShowSettings = null;
    private MovieScraperMetadataConfig movieScraperMetadataConfig = null;
    private TvShowScraperMetadataConfig tvShowScraperMetadataConfig = null;
    private String language;
    private String mediaPlayer = "";
    private int fontSize = 12;
    private String fontFamily = "Dialog";
    private boolean deleteTrashOnExit = false;
    private boolean enableAnalytics = true;
    private PropertyChangeListener propertyChangeListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            Settings.this.setDirty();
        }
    };
    @XmlTransient
    public boolean newConfig = false;
    private boolean upnpShareLibrary = false;
    private boolean upnpRemotePlay = false;

    private Settings() {
        this.addPropertyChangeListener(this.propertyChangeListener);
        this.movieSettings = new MovieSettings();
        this.movieSettings.addPropertyChangeListener(this.propertyChangeListener);
        this.tvShowSettings = new TvShowSettings();
        this.tvShowSettings.addPropertyChangeListener(this.propertyChangeListener);
        this.movieScraperMetadataConfig = new MovieScraperMetadataConfig();
        this.movieScraperMetadataConfig.addPropertyChangeListener(this.propertyChangeListener);
        this.tvShowScraperMetadataConfig = new TvShowScraperMetadataConfig();
        this.tvShowScraperMetadataConfig.addPropertyChangeListener(this.propertyChangeListener);
    }

    public String getSettingsFolder() {
        return settingsFolder;
    }

    public static synchronized Settings getInstance() {
        return Settings.getInstance(settingsFolder);
    }

    public static synchronized Settings getInstance(String folder) {
        return Settings.getInstance(folder, configFile);
    }

    public static synchronized Settings getInstance(String folder, String configFile) {
        if (instance == null) {
            Path oldCfg;
            Path cfgFolder = Paths.get("config", new String[0]);
            if (Files.isDirectory(cfgFolder, new LinkOption[0])) {
                try {
                    Utils.moveDirectorySafe(cfgFolder, Paths.get(DEFAULT_CONFIG_FOLDER, new String[0]));
                }
                catch (IOException e) {
                    LOGGER.warn("error migrating config folder");
                }
            }
            if (!Files.exists(cfgFolder = Paths.get(folder, new String[0]), new LinkOption[0])) {
                try {
                    Files.createDirectories(cfgFolder, new FileAttribute[0]);
                }
                catch (IOException e) {
                    // empty catch block
                }
            }
            if (Utils.isRegularFile(oldCfg = Paths.get(DEFAULT_CONFIG_FILE, new String[0]))) {
                try {
                    Utils.moveFileSafe(oldCfg, cfgFolder.resolve(DEFAULT_CONFIG_FILE));
                }
                catch (IOException e) {
                    LOGGER.warn("error migrating config.xml");
                }
            }
            try {
                JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{Settings.class});
                Unmarshaller um = context.createUnmarshaller();
                try {
                    LOGGER.debug("Loading settings from " + folder + "/" + configFile);
                    InputStreamReader in = new InputStreamReader((InputStream)new FileInputStream(new File(folder, configFile)), "UTF-8");
                    instance = (Settings)um.unmarshal((Reader)in);
                    settingsFolder = folder;
                    Settings.configFile = configFile;
                }
                catch (Exception e) {
                    LOGGER.warn("could not load settings - creating default ones...");
                    instance = new Settings();
                    Settings.instance.newConfig = true;
                    settingsFolder = folder;
                    Settings.configFile = configFile;
                    instance.writeDefaultSettings();
                }
                instance.clearDirty();
            }
            catch (Exception e) {
                LOGGER.error("getInstance", (Throwable)e);
                MessageManager.instance.pushMessage(new Message(Message.MessageLevel.ERROR, "tmm.settings", "message.config.loadsettingserror"));
            }
        }
        return instance;
    }

    public boolean isCurrentVersion() {
        return StrgUtils.compareVersion((String)this.version, (String)ReleaseInfo.getVersion()) == 0;
    }

    public String getVersion() {
        return this.version;
    }

    public void setCurrentVersion() {
        this.version = ReleaseInfo.getVersion();
        this.setDirty();
    }

    private void setDirty() {
        this.dirty = true;
    }

    private void clearDirty() {
        this.dirty = false;
    }

    public void addTitlePrefix(String prfx) {
        if (!this.titlePrefix.contains(prfx)) {
            this.titlePrefix.add(prfx);
            this.firePropertyChange(TITLE_PREFIX, null, this.titlePrefix);
        }
    }

    public void removeTitlePrefix(String prfx) {
        this.titlePrefix.remove(prfx);
        this.firePropertyChange(TITLE_PREFIX, null, this.titlePrefix);
    }

    public List<String> getTitlePrefix() {
        return this.titlePrefix;
    }

    public void addVideoFileTypes(String type) {
        if (!type.startsWith(".")) {
            type = "." + type;
        }
        if (!this.videoFileTypes.contains(type)) {
            this.videoFileTypes.add(type);
            this.firePropertyChange(VIDEO_FILE_TYPE, null, this.videoFileTypes);
        }
    }

    public void removeVideoFileType(String type) {
        this.videoFileTypes.remove(type);
        this.firePropertyChange(VIDEO_FILE_TYPE, null, this.videoFileTypes);
    }

    public List<String> getVideoFileType() {
        return this.videoFileTypes;
    }

    public void addAudioFileTypes(String type) {
        if (!type.startsWith(".")) {
            type = "." + type;
        }
        if (!this.audioFileTypes.contains(type)) {
            this.audioFileTypes.add(type);
            this.firePropertyChange(AUDIO_FILE_TYPE, null, this.audioFileTypes);
        }
    }

    public void removeAudioFileType(String type) {
        this.audioFileTypes.remove(type);
        this.firePropertyChange(AUDIO_FILE_TYPE, null, this.audioFileTypes);
    }

    public List<String> getAudioFileType() {
        return this.audioFileTypes;
    }

    public void addSubtitleFileTypes(String type) {
        if (!type.startsWith(".")) {
            type = "." + type;
        }
        if (!this.subtitleFileTypes.contains(type)) {
            this.subtitleFileTypes.add(type);
            this.firePropertyChange(SUBTITLE_FILE_TYPE, null, this.subtitleFileTypes);
        }
    }

    public void removeSubtitleFileType(String type) {
        if (!type.startsWith(".")) {
            type = "." + type;
        }
        this.subtitleFileTypes.remove(type);
        this.firePropertyChange(SUBTITLE_FILE_TYPE, null, this.subtitleFileTypes);
    }

    public List<String> getSubtitleFileType() {
        return this.subtitleFileTypes;
    }

    public List<String> getAllSupportedFileTypes() {
        ArrayList<String> list = new ArrayList<String>();
        list.addAll(this.getAudioFileType());
        list.addAll(this.getVideoFileType());
        list.addAll(this.getSubtitleFileType());
        list.add(".nfo");
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveSettings() {
        if (!this.dirty) {
            return;
        }
        Writer w = null;
        try {
            JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{Settings.class});
            Marshaller m = context.createMarshaller();
            m.setProperty("jaxb.encoding", (Object)"UTF-8");
            m.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
            w = new StringWriter();
            m.marshal((Object)this, w);
            StringBuilder sb = new StringBuilder(w.toString());
            w.close();
            if (SystemUtils.IS_OS_WINDOWS) {
                sb = new StringBuilder(sb.toString().replaceAll("(?<!\r)\n", "\r\n"));
            }
            w = new FileWriter(new File(settingsFolder, configFile));
            String xml = sb.toString();
            IOUtils.write((String)xml, (Writer)w);
        }
        catch (Exception e) {
            LOGGER.error("saveSettings", (Throwable)e);
            MessageManager.instance.pushMessage(new Message(Message.MessageLevel.ERROR, "tmm.settings", "message.config.savesettingserror"));
        }
        finally {
            try {
                w.close();
            }
            catch (Exception e) {
                LOGGER.error("saveSettings", (Throwable)e);
                MessageManager.instance.pushMessage(new Message(Message.MessageLevel.ERROR, "tmm.settings", "message.config.savesettingserror"));
            }
        }
        this.setProxy();
        this.clearDirty();
    }

    public void writeDefaultSettings() {
        this.version = ReleaseInfo.getVersion();
        this.addVideoFileTypes(".3gp");
        this.addVideoFileTypes(".asf");
        this.addVideoFileTypes(".asx");
        this.addVideoFileTypes(".avc");
        this.addVideoFileTypes(".avi");
        this.addVideoFileTypes(".bdmv");
        this.addVideoFileTypes(".bin");
        this.addVideoFileTypes(".bivx");
        this.addVideoFileTypes(".dat");
        this.addVideoFileTypes(".divx");
        this.addVideoFileTypes(".dv");
        this.addVideoFileTypes(".dvr-ms");
        this.addVideoFileTypes(".disc");
        this.addVideoFileTypes(".fli");
        this.addVideoFileTypes(".flv");
        this.addVideoFileTypes(".h264");
        this.addVideoFileTypes(".img");
        this.addVideoFileTypes(".iso");
        this.addVideoFileTypes(".mts");
        this.addVideoFileTypes(".mt2s");
        this.addVideoFileTypes(".m2ts");
        this.addVideoFileTypes(".m2v");
        this.addVideoFileTypes(".m4v");
        this.addVideoFileTypes(".mkv");
        this.addVideoFileTypes(".mov");
        this.addVideoFileTypes(".mp4");
        this.addVideoFileTypes(".mpeg");
        this.addVideoFileTypes(".mpg");
        this.addVideoFileTypes(".nrg");
        this.addVideoFileTypes(".nsv");
        this.addVideoFileTypes(".nuv");
        this.addVideoFileTypes(".ogm");
        this.addVideoFileTypes(".pva");
        this.addVideoFileTypes(".qt");
        this.addVideoFileTypes(".rm");
        this.addVideoFileTypes(".rmvb");
        this.addVideoFileTypes(".strm");
        this.addVideoFileTypes(".svq3");
        this.addVideoFileTypes(".ts");
        this.addVideoFileTypes(".ty");
        this.addVideoFileTypes(".viv");
        this.addVideoFileTypes(".vob");
        this.addVideoFileTypes(".vp3");
        this.addVideoFileTypes(".wmv");
        this.addVideoFileTypes(".xvid");
        Collections.sort(this.videoFileTypes);
        this.addAudioFileTypes(".a52");
        this.addAudioFileTypes(".aa3");
        this.addAudioFileTypes(".aac");
        this.addAudioFileTypes(".ac3");
        this.addAudioFileTypes(".adt");
        this.addAudioFileTypes(".adts");
        this.addAudioFileTypes(".aif");
        this.addAudioFileTypes(".aiff");
        this.addAudioFileTypes(".alac");
        this.addAudioFileTypes(".ape");
        this.addAudioFileTypes(".at3");
        this.addAudioFileTypes(".atrac");
        this.addAudioFileTypes(".au");
        this.addAudioFileTypes(".dts");
        this.addAudioFileTypes(".flac");
        this.addAudioFileTypes(".m4a");
        this.addAudioFileTypes(".m4b");
        this.addAudioFileTypes(".m4p");
        this.addAudioFileTypes(".mid");
        this.addAudioFileTypes(".midi");
        this.addAudioFileTypes(".mka");
        this.addAudioFileTypes(".mp3");
        this.addAudioFileTypes(".mpa");
        this.addAudioFileTypes(".oga");
        this.addAudioFileTypes(".ogg");
        this.addAudioFileTypes(".pcm");
        this.addAudioFileTypes(".ra");
        this.addAudioFileTypes(".ram");
        this.addAudioFileTypes(".rm");
        this.addAudioFileTypes(".tta");
        this.addAudioFileTypes(".wav");
        this.addAudioFileTypes(".wave");
        this.addAudioFileTypes(".wma");
        Collections.sort(this.audioFileTypes);
        this.addSubtitleFileTypes(".aqt");
        this.addSubtitleFileTypes(".cvd");
        this.addSubtitleFileTypes(".dks");
        this.addSubtitleFileTypes(".jss");
        this.addSubtitleFileTypes(".sub");
        this.addSubtitleFileTypes(".ttxt");
        this.addSubtitleFileTypes(".mpl");
        this.addSubtitleFileTypes(".pjs");
        this.addSubtitleFileTypes(".psb");
        this.addSubtitleFileTypes(".rt");
        this.addSubtitleFileTypes(".srt");
        this.addSubtitleFileTypes(".smi");
        this.addSubtitleFileTypes(".ssf");
        this.addSubtitleFileTypes(".ssa");
        this.addSubtitleFileTypes(".svcd");
        this.addSubtitleFileTypes(".usf");
        this.addSubtitleFileTypes(".ass");
        this.addSubtitleFileTypes(".pgs");
        this.addSubtitleFileTypes(".vobsub");
        Collections.sort(this.subtitleFileTypes);
        this.addTitlePrefix("A");
        this.addTitlePrefix("An");
        this.addTitlePrefix("The");
        this.addTitlePrefix("Der");
        this.addTitlePrefix("Die");
        this.addTitlePrefix("Das");
        this.addTitlePrefix("Ein");
        this.addTitlePrefix("Eine");
        this.addTitlePrefix("Le");
        this.addTitlePrefix("La");
        this.addTitlePrefix("Les");
        this.addTitlePrefix("L'");
        this.addTitlePrefix("L\u00b4");
        this.addTitlePrefix("L`");
        this.addTitlePrefix("Un");
        this.addTitlePrefix("Une");
        this.addTitlePrefix("Des");
        this.addTitlePrefix("Du");
        this.addTitlePrefix("D'");
        this.addTitlePrefix("D\u00b4");
        this.addTitlePrefix("D`");
        Collections.sort(this.titlePrefix);
        this.movieSettings.addMovieNfoFilename(MovieNfoNaming.MOVIE_NFO);
        this.movieSettings.addMoviePosterFilename(MoviePosterNaming.POSTER_JPG);
        this.movieSettings.addMoviePosterFilename(MoviePosterNaming.POSTER_PNG);
        this.movieSettings.addMovieFanartFilename(MovieFanartNaming.FANART_JPG);
        this.movieSettings.addMovieFanartFilename(MovieFanartNaming.FANART_PNG);
        for (MediaScraper ms : MediaScraper.getMediaScrapers(ScraperType.MOVIE_ARTWORK)) {
            this.movieSettings.addMovieArtworkScraper(ms.getId());
        }
        for (MediaScraper ms : MediaScraper.getMediaScrapers(ScraperType.MOVIE_TRAILER)) {
            this.movieSettings.addMovieTrailerScraper(ms.getId());
        }
        for (MediaScraper ms : MediaScraper.getMediaScrapers(ScraperType.SUBTITLE)) {
            this.movieSettings.addMovieSubtitleScraper(ms.getId());
            this.tvShowSettings.addTvShowSubtitleScraper(ms.getId());
        }
        for (MediaScraper ms : MediaScraper.getMediaScrapers(ScraperType.TV_SHOW_ARTWORK)) {
            this.tvShowSettings.addTvShowArtworkScraper(ms.getId());
        }
        String defaultLang = Locale.getDefault().getLanguage();
        CountryCode cc = CountryCode.getByCode((String)defaultLang.toUpperCase(Locale.ROOT));
        if (cc != null) {
            this.movieSettings.setCertificationCountry(cc);
            this.tvShowSettings.setCertificationCountry(cc);
        }
        for (MediaLanguages ml : MediaLanguages.values()) {
            if (!ml.name().equals(defaultLang)) continue;
            this.movieSettings.setScraperLanguage(ml);
            this.tvShowSettings.setScraperLanguage(ml);
        }
        this.setProxyFromSystem();
        this.saveSettings();
    }

    @XmlElement(name="proxyHost")
    public String getProxyHost() {
        return this.proxyHost;
    }

    public void setProxyHost(String newValue) {
        String oldValue = this.proxyHost;
        this.proxyHost = newValue;
        this.firePropertyChange(PROXY_HOST, oldValue, newValue);
    }

    @XmlElement(name="proxyPort")
    public String getProxyPort() {
        return this.proxyPort;
    }

    public void setProxyPort(String newValue) {
        String oldValue = this.proxyPort;
        this.proxyPort = newValue;
        this.firePropertyChange(PROXY_PORT, oldValue, newValue);
    }

    @XmlElement(name="proxyUsername")
    public String getProxyUsername() {
        return this.proxyUsername;
    }

    public void setProxyUsername(String newValue) {
        String oldValue = this.proxyUsername;
        this.proxyUsername = newValue;
        this.firePropertyChange(PROXY_USERNAME, oldValue, newValue);
    }

    @XmlElement(name="proxyPassword")
    @XmlJavaTypeAdapter(value=EncryptedStringXmlAdapter.class)
    public String getProxyPassword() {
        return StringEscapeUtils.unescapeXml((String)this.proxyPassword);
    }

    public void setProxyPassword(String newValue) {
        newValue = StringEscapeUtils.escapeXml10((String)newValue);
        String oldValue = this.proxyPassword;
        this.proxyPassword = newValue;
        this.firePropertyChange(PROXY_PASSWORD, oldValue, newValue);
    }

    public void setProxyFromSystem() {
        String[] proxyPortEnvs;
        String[] proxyEnvs;
        String val = "";
        for (String pe : proxyEnvs = new String[]{"http.proxyHost", "https.proxyHost", PROXY_HOST, "socksProxyHost"}) {
            if (!StringUtils.isEmpty((CharSequence)this.getProxyHost()) || (val = System.getProperty(pe, "")).isEmpty()) continue;
            this.setProxyHost(val);
        }
        for (String ppe : proxyPortEnvs = new String[]{"http.proxyPort", "https.proxyPort", PROXY_PORT, "socksProxyPort"}) {
            if (!StringUtils.isEmpty((CharSequence)this.getProxyPort()) || (val = System.getProperty(ppe, "")).isEmpty()) continue;
            this.setProxyPort(val);
        }
    }

    public void setProxy() {
        if (this.useProxy()) {
            System.setProperty(PROXY_HOST, this.getProxyHost());
            if (StringUtils.isNotEmpty((CharSequence)this.getProxyPort())) {
                System.setProperty(PROXY_PORT, this.getProxyPort());
            }
            if (StringUtils.isNotEmpty((CharSequence)this.getProxyUsername())) {
                System.setProperty("http.proxyUser", this.getProxyUsername());
                System.setProperty("https.proxyUser", this.getProxyUsername());
            }
            if (StringUtils.isNotEmpty((CharSequence)this.getProxyPassword())) {
                System.setProperty("http.proxyPassword", this.getProxyPassword());
                System.setProperty("https.proxyPassword", this.getProxyPassword());
            }
        }
        try {
            ProxySettings.setProxySettings((String)this.getProxyHost(), (int)(this.getProxyPort() == null ? 0 : Integer.parseInt(this.getProxyPort().trim())), (String)this.getProxyUsername(), (String)this.getProxyPassword());
        }
        catch (NumberFormatException e) {
            LOGGER.error("could not parse proxy port: " + e.getMessage());
        }
    }

    public boolean useProxy() {
        return StringUtils.isNotBlank((CharSequence)this.getProxyHost());
    }

    public void setMovieSettings(MovieSettings movieSettings) {
        this.movieSettings = movieSettings;
        this.movieSettings.addPropertyChangeListener(this.propertyChangeListener);
    }

    public MovieSettings getMovieSettings() {
        return this.movieSettings;
    }

    public void setTvShowSettings(TvShowSettings tvShowSettings) {
        this.tvShowSettings = tvShowSettings;
        this.tvShowSettings.addPropertyChangeListener(this.propertyChangeListener);
    }

    public TvShowSettings getTvShowSettings() {
        return this.tvShowSettings;
    }

    public MovieScraperMetadataConfig getMovieScraperMetadataConfig() {
        return this.movieScraperMetadataConfig;
    }

    public void setMovieScraperMetadataConfig(MovieScraperMetadataConfig scraperMetadataConfig) {
        this.movieScraperMetadataConfig = scraperMetadataConfig;
        this.movieScraperMetadataConfig.addPropertyChangeListener(this.propertyChangeListener);
    }

    public TvShowScraperMetadataConfig getTvShowScraperMetadataConfig() {
        return this.tvShowScraperMetadataConfig;
    }

    public void setTvShowScraperMetadataConfig(TvShowScraperMetadataConfig scraperMetadataConfig) {
        this.tvShowScraperMetadataConfig = scraperMetadataConfig;
        this.tvShowScraperMetadataConfig.addPropertyChangeListener(this.propertyChangeListener);
    }

    public boolean isImageCache() {
        return this.imageCache;
    }

    public void setImageCache(boolean newValue) {
        boolean oldValue = this.imageCache;
        this.imageCache = newValue;
        this.firePropertyChange(IMAGE_CACHE, oldValue, newValue);
    }

    public ImageCache.CacheType getImageCacheType() {
        return this.imageCacheType;
    }

    public void setImageCacheType(ImageCache.CacheType newValue) {
        ImageCache.CacheType oldValue = this.imageCacheType;
        this.imageCacheType = newValue;
        this.firePropertyChange(IMAGE_CACHE_TYPE, (Object)oldValue, (Object)newValue);
    }

    public boolean isUpnpShareLibrary() {
        return this.upnpShareLibrary;
    }

    public void setUpnpShareLibrary(boolean upnpShareLibrary) {
        boolean old = this.upnpShareLibrary;
        this.upnpShareLibrary = upnpShareLibrary;
        this.firePropertyChange(UPNP_SHARE_LIBRARY, old, upnpShareLibrary);
    }

    public boolean isUpnpRemotePlay() {
        return this.upnpRemotePlay;
    }

    public void setUpnpRemotePlay(boolean upnpRemotePlay) {
        boolean old = this.upnpRemotePlay;
        this.upnpRemotePlay = upnpRemotePlay;
        this.firePropertyChange(UPNP_PLAY_ON_REMOTE, old, upnpRemotePlay);
    }

    @XmlElement(name="language")
    public String getLanguage() {
        if (this.language == null || this.language.isEmpty()) {
            return Locale.getDefault().getLanguage();
        }
        return this.language;
    }

    public void setLanguage(String language) {
        String oldValue = this.language;
        this.language = language;
        Locale.setDefault(Utils.getLocaleFromLanguage(language));
        this.firePropertyChange(LANGUAGE, oldValue, language);
    }

    public void addWolDevice(WolDevice newDevice) {
        this.wolDevices.add(newDevice);
        this.firePropertyChange(WOL_DEVICES, null, this.wolDevices.size());
    }

    public void removeWolDevice(WolDevice device) {
        this.wolDevices.remove(device);
        this.firePropertyChange(WOL_DEVICES, null, this.wolDevices.size());
    }

    public List<WolDevice> getWolDevices() {
        return this.wolDevices;
    }

    @XmlJavaTypeAdapter(value=EncryptedStringXmlAdapter.class)
    public String getTraktAccessToken() {
        return this.traktAccessToken;
    }

    public void setTraktAccessToken(String newValue) {
        String oldValue = this.traktAccessToken;
        this.traktAccessToken = newValue.trim();
        this.firePropertyChange("traktAccessToken", oldValue, newValue);
    }

    @XmlJavaTypeAdapter(value=EncryptedStringXmlAdapter.class)
    public String getTraktRefreshToken() {
        return this.traktRefreshToken;
    }

    public void setTraktRefreshToken(String newValue) {
        String oldValue = this.traktRefreshToken;
        this.traktRefreshToken = newValue;
        this.firePropertyChange("traktRefreshToken", oldValue, newValue);
    }

    public String getXbmcHost() {
        return this.xbmcHost;
    }

    public void setXbmcHost(String newValue) {
        String oldValue = this.xbmcHost;
        this.xbmcHost = newValue;
        this.firePropertyChange("xbmcHost", oldValue, newValue);
    }

    public String getXbmcUsername() {
        return this.xbmcUsername;
    }

    public void setXbmcUsername(String newValue) {
        String oldValue = this.xbmcUsername;
        this.xbmcUsername = newValue;
        this.firePropertyChange("xbmcUsername", oldValue, newValue);
    }

    @XmlJavaTypeAdapter(value=EncryptedStringXmlAdapter.class)
    public String getXbmcPassword() {
        return this.xbmcPassword;
    }

    public void setXbmcPassword(String newValue) {
        String oldValue = this.xbmcPassword;
        this.xbmcPassword = newValue;
        this.firePropertyChange("xbmcPassword", oldValue, newValue);
    }

    public void setMediaPlayer(String newValue) {
        String oldValue = this.mediaPlayer;
        this.mediaPlayer = newValue;
        this.firePropertyChange("mediaPlayer", oldValue, newValue);
    }

    public String getMediaPlayer() {
        return this.mediaPlayer;
    }

    public void setFontSize(int newValue) {
        int oldValue = this.fontSize;
        this.fontSize = newValue;
        this.firePropertyChange("fontSize", oldValue, newValue);
    }

    public int getFontSize() {
        return this.fontSize;
    }

    public void setFontFamily(String newValue) {
        String oldValue = this.fontFamily;
        this.fontFamily = newValue;
        this.firePropertyChange("fontFamily", oldValue, newValue);
    }

    public String getFontFamily() {
        return this.fontFamily;
    }

    public void setDeleteTrashOnExit(boolean newValue) {
        boolean oldValue = this.deleteTrashOnExit;
        this.deleteTrashOnExit = newValue;
        this.firePropertyChange("deleteTrashOnExit", oldValue, newValue);
    }

    public boolean isDeleteTrashOnExit() {
        return this.deleteTrashOnExit;
    }

    public boolean isEnableAnalytics() {
        return this.enableAnalytics;
    }

    public void setEnableAnalytics(boolean newValue) {
        boolean oldValue = this.enableAnalytics;
        this.enableAnalytics = newValue;
        this.firePropertyChange(ENABLE_ANALYTICS, oldValue, newValue);
    }
}

