/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.core;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringReader;
import java.net.HttpURLConnection;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.URL;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Properties;
import okhttp3.OkUrlFactory;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.Globals;
import org.tinymediamanager.core.AesUtil;
import org.tinymediamanager.scraper.http.TmmHttpClient;

public class License {
    private static final Logger LOGGER = LoggerFactory.getLogger(License.class);
    private static final String LICENSE_FILE = "tmm.lic";
    private static final String UNKNOWN_MAC = "UNKNOWN_MAC";

    public static String getMac() {
        String macAddress;
        NetworkInterface ni;
        try {
            InetAddress ip = InetAddress.getLocalHost();
            if (ip != null) {
                ni = NetworkInterface.getByInetAddress(ip);
                if (ni == null) {
                    Enumeration<NetworkInterface> networkInterfaces = NetworkInterface.getNetworkInterfaces();
                    while (networkInterfaces.hasMoreElements()) {
                        NetworkInterface network = networkInterfaces.nextElement();
                        if (network.isLoopback()) continue;
                        ni = network;
                        break;
                    }
                }
                if ((macAddress = License.formatMac(ni.getHardwareAddress())) != null && !macAddress.isEmpty()) {
                    return macAddress;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            LOGGER.warn("Error getting MAC from LocalHost IP - not connected to internet/router?");
        }
        try {
            Enumeration<NetworkInterface> nif = NetworkInterface.getNetworkInterfaces();
            while (nif.hasMoreElements()) {
                ni = null;
                try {
                    ni = nif.nextElement();
                    macAddress = License.formatMac(ni.getHardwareAddress());
                    if (macAddress == null || macAddress.isEmpty()) continue;
                    return macAddress;
                }
                catch (Exception e2) {
                    LOGGER.warn("Error getting MAC of " + ni);
                }
            }
            return UNKNOWN_MAC;
        }
        catch (Exception e) {
            LOGGER.warn("I/O Error on getting network interfaces");
            return UNKNOWN_MAC;
        }
    }

    private static List<String> getAllMacAddresses() {
        ArrayList<String> m = new ArrayList<String>();
        m.add(UNKNOWN_MAC);
        try {
            Enumeration<NetworkInterface> e = NetworkInterface.getNetworkInterfaces();
            while (e.hasMoreElements()) {
                NetworkInterface ni = e.nextElement();
                String macAddress = License.formatMac(ni.getHardwareAddress());
                if (macAddress == null || macAddress.isEmpty()) continue;
                m.add(macAddress);
            }
        }
        catch (Exception e) {
            LOGGER.warn("Error getting MAC of all interfaces");
        }
        return m;
    }

    private static String formatMac(byte[] mac) {
        if (mac == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < mac.length; ++i) {
            sb.append(String.format("%02X%s", mac[i], i < mac.length - 1 ? "-" : ""));
        }
        return sb.toString();
    }

    @Deprecated
    public static boolean isValid() {
        Properties lic;
        if (License.getLicenseFile() != null && (lic = License.decrypt()) != null) {
            String pleaseDoNotCrack = "";
            pleaseDoNotCrack = pleaseDoNotCrack + "Ok, you found it.";
            pleaseDoNotCrack = pleaseDoNotCrack + "This is the real deal.";
            pleaseDoNotCrack = pleaseDoNotCrack + "One char away from 'the full thing'.";
            pleaseDoNotCrack = pleaseDoNotCrack + "[...]";
            pleaseDoNotCrack = pleaseDoNotCrack + "If you are reading this, you're probably a java developer.";
            pleaseDoNotCrack = pleaseDoNotCrack + "If so, you know how much work can be in such a project like TMM.";
            pleaseDoNotCrack = pleaseDoNotCrack + "So please, be kind and support the developers for your free License :)";
            pleaseDoNotCrack = pleaseDoNotCrack + "http://www.tinymediamanager.org/donate/";
            pleaseDoNotCrack = pleaseDoNotCrack + "It gives you a warm and fuzzy feeling - i swear ;)";
            return true;
        }
        return false;
    }

    public static boolean exists() {
        return License.getLicenseFile() != null;
    }

    private static File getLicenseFile() {
        File f = new File(LICENSE_FILE);
        if (!(f.exists() || (f = new File(System.getProperty("user.home") + File.separator + ".tmm", LICENSE_FILE)).exists() || (f = new File(System.getProperty("user.home"), LICENSE_FILE)).exists())) {
            return null;
        }
        return f;
    }

    public static Properties decrypt() {
        try {
            FileInputStream input = new FileInputStream(License.getLicenseFile());
            byte[] fileData = new byte[input.available()];
            input.read(fileData);
            input.close();
            String lic = new String(fileData, "UTF-8");
            String iv = "F27D5C9927726BCEFE7510B1BDD3D137";
            String salt = "3FF2EC019C627B945225DEBAD71A01B6985FE84C95A70EB132882F88C0A59A55";
            AesUtil util = new AesUtil(128, 100);
            Properties prop = new Properties();
            try {
                String decrypt = util.decrypt(salt, iv, License.getMac(), lic);
                StringReader reader = new StringReader(decrypt);
                prop.load(reader);
            }
            catch (Exception e) {
                for (String mac : License.getAllMacAddresses()) {
                    try {
                        String decrypt = util.decrypt(salt, iv, mac, lic);
                        StringReader reader = new StringReader(decrypt);
                        prop.load(reader);
                    }
                    catch (Exception e2) {}
                }
            }
            return prop.size() > 0 ? prop : null;
        }
        catch (Exception e) {
            LOGGER.error("Error decrypting license file", (Throwable)e);
            return null;
        }
    }

    public static boolean encrypt(Properties props) {
        try {
            if (props == null || props.size() == 0) {
                return false;
            }
            String request = "https://script.google.com/macros/s/AKfycbz7gu6I046KesXCHJJe6OEPX2tx18RcfiMS5Id-7NXsNYYMnLvK/exec";
            String urlParameters = "mac=" + License.getMac();
            for (String key : props.stringPropertyNames()) {
                String value = props.getProperty(key);
                urlParameters = urlParameters + "&" + key + "=" + URLEncoder.encode(value, "UTF-8");
            }
            HttpURLConnection connection = new OkUrlFactory(TmmHttpClient.getHttpClient()).open(new URL(request));
            connection.setDoOutput(true);
            connection.setDoInput(true);
            connection.setInstanceFollowRedirects(true);
            connection.setRequestMethod("POST");
            connection.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
            connection.setRequestProperty("charset", "utf-8");
            connection.setRequestProperty("Content-Length", "" + Integer.toString(urlParameters.getBytes().length));
            connection.setUseCaches(false);
            OutputStreamWriter writer = new OutputStreamWriter(connection.getOutputStream(), "UTF-8");
            writer.write(urlParameters);
            writer.flush();
            String response = IOUtils.toString((Reader)new InputStreamReader(connection.getInputStream(), "UTF-8"));
            writer.close();
            if (response != null && response.isEmpty()) {
                LOGGER.warn("empty response at license generation; code " + connection.getResponseCode());
                return false;
            }
            File f = new File(LICENSE_FILE);
            if (Globals.isRunningJavaWebStart() && !(f = new File(System.getProperty("user.home") + File.separator + ".tmm", LICENSE_FILE)).getParentFile().exists()) {
                f.getParentFile().mkdir();
            }
            FileUtils.writeStringToFile((File)f, (String)response);
            return true;
        }
        catch (Exception e) {
            LOGGER.error("Error generating license", (Throwable)e);
            return false;
        }
    }
}

