/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.scraper.imdb;

import java.io.InputStream;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.nodes.TextNode;
import org.jsoup.select.Elements;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.scraper.MediaMetadata;
import org.tinymediamanager.scraper.MediaScrapeOptions;
import org.tinymediamanager.scraper.entities.MediaCastMember;
import org.tinymediamanager.scraper.entities.MediaEpisode;
import org.tinymediamanager.scraper.entities.MediaType;
import org.tinymediamanager.scraper.http.CachedUrl;
import org.tinymediamanager.scraper.imdb.ImdbMetadataProvider;
import org.tinymediamanager.scraper.imdb.ImdbParser;
import org.tinymediamanager.scraper.imdb.ImdbSiteDefinition;
import org.tinymediamanager.scraper.util.MetadataUtil;

public class ImdbTvShowParser
extends ImdbParser {
    private static final Logger LOGGER = LoggerFactory.getLogger(ImdbTvShowParser.class);
    private static final Pattern UNWANTED_SEARCH_RESULTS = Pattern.compile(".*\\((TV Movies|TV Episode|Short|Video Game)\\).*");
    private ImdbSiteDefinition imdbSite;

    public ImdbTvShowParser(ImdbSiteDefinition imdbSite) {
        super(MediaType.TV_SHOW);
        this.imdbSite = imdbSite;
    }

    @Override
    protected Pattern getUnwantedSearchResultPattern() {
        if (ImdbMetadataProvider.providerInfo.getConfig().getValueAsBool("filterUnwantedCategories").booleanValue()) {
            return UNWANTED_SEARCH_RESULTS;
        }
        return null;
    }

    @Override
    protected Logger getLogger() {
        return LOGGER;
    }

    @Override
    protected ImdbSiteDefinition getImdbSite() {
        return this.imdbSite;
    }

    @Override
    protected MediaMetadata getMetadata(MediaScrapeOptions options) throws Exception {
        switch (options.getType()) {
            case TV_SHOW: {
                return this.getTvShowMetadata(options);
            }
            case TV_EPISODE: {
                return this.getEpisodeMetadata(options);
            }
        }
        return new MediaMetadata(ImdbMetadataProvider.providerInfo.getId());
    }

    @Override
    protected String getSearchCategory() {
        return "&s=tt&ttype=tv&ref_=fn_tv";
    }

    MediaMetadata getTvShowMetadata(MediaScrapeOptions options) throws Exception {
        MediaMetadata md = new MediaMetadata(ImdbMetadataProvider.providerInfo.getId());
        String imdbId = "";
        if (options.getResult() != null) {
            imdbId = options.getResult().getIMDBId();
        }
        if (!MetadataUtil.isValidImdbId((String)imdbId)) {
            imdbId = options.getImdbId();
        }
        if (!MetadataUtil.isValidImdbId((String)imdbId)) {
            return md;
        }
        LOGGER.debug("IMDB: getMetadata(imdbId): " + imdbId);
        CachedUrl url = new CachedUrl(this.imdbSite.getSite() + "/title/" + imdbId + "/combined");
        url.addHeader("Accept-Language", ImdbTvShowParser.getAcceptLanguage(options.getLanguage().getLanguage(), options.getCountry().getAlpha2()));
        Document doc = Jsoup.parse((InputStream)url.getInputStream(), (String)this.imdbSite.getCharset().displayName(), (String)"");
        this.parseCombinedPage(doc, options, md);
        url = new CachedUrl(this.imdbSite.getSite() + "/title/" + imdbId + "/plotsummary");
        url.addHeader("Accept-Language", ImdbTvShowParser.getAcceptLanguage(options.getLanguage().getLanguage(), options.getCountry().getAlpha2()));
        doc = Jsoup.parse((InputStream)url.getInputStream(), (String)this.imdbSite.getCharset().displayName(), (String)"");
        this.parsePlotsummaryPage(doc, options, md);
        md.setId(ImdbMetadataProvider.providerInfo.getId(), (Object)imdbId);
        return md;
    }

    MediaMetadata getEpisodeMetadata(MediaScrapeOptions options) throws Exception {
        MediaMetadata md = new MediaMetadata(ImdbMetadataProvider.providerInfo.getId());
        String imdbId = options.getImdbId();
        if (StringUtils.isBlank((CharSequence)imdbId)) {
            return md;
        }
        int seasonNr = -1;
        int episodeNr = -1;
        try {
            seasonNr = Integer.parseInt(options.getId("seasonNr"));
            episodeNr = Integer.parseInt(options.getId("episodeNr"));
        }
        catch (Exception e) {
            LOGGER.warn("error parsing season/episode number");
        }
        if (seasonNr == -1 || episodeNr == -1) {
            return md;
        }
        List<MediaEpisode> episodes = this.getEpisodeList(options);
        MediaEpisode wantedEpisode = null;
        for (MediaEpisode episode : episodes) {
            if (episode.season != seasonNr || episode.episode != episodeNr) continue;
            wantedEpisode = episode;
            break;
        }
        if (wantedEpisode == null) {
            return md;
        }
        CachedUrl url = new CachedUrl(this.imdbSite.getSite() + "/title/" + imdbId + "/epcast");
        url.addHeader("Accept-Language", ImdbTvShowParser.getAcceptLanguage(options.getLanguage().getLanguage(), options.getCountry().getAlpha2()));
        Document doc = Jsoup.parse((InputStream)url.getInputStream(), (String)this.imdbSite.getCharset().displayName(), (String)"");
        Element content = doc.getElementById("tn15content");
        Elements episodeStart = content.getElementsByTag("h4");
        block5: for (Element h4 : episodeStart) {
            Elements anchors = h4.getElementsByAttributeValueStarting("href", "/title/tt");
            if (anchors == null || anchors.isEmpty() || !((Element)anchors.get(0)).attr("href").endsWith(wantedEpisode.ids.get(ImdbMetadataProvider.providerInfo.getId()) + "/")) continue;
            md.setId(ImdbMetadataProvider.providerInfo.getId(), wantedEpisode.ids.get(ImdbMetadataProvider.providerInfo.getId()));
            md.setEpisodeNumber(wantedEpisode.episode);
            md.setSeasonNumber(wantedEpisode.season);
            md.setTitle(wantedEpisode.title);
            md.setRating(wantedEpisode.rating);
            md.setVoteCount(wantedEpisode.voteCount);
            md.setPlot("");
            Element releaseDate = h4.nextElementSibling();
            if (releaseDate.tag().getName().equals("b")) {
                try {
                    SimpleDateFormat sdf = new SimpleDateFormat("d MMMM yyyy", Locale.US);
                    Date parsedDate = sdf.parse(releaseDate.ownText());
                    md.setReleaseDate(parsedDate);
                }
                catch (ParseException ignored) {
                    ignored.printStackTrace();
                }
                Element b = releaseDate.nextElementSibling();
                for (TextNode node : content.textNodes()) {
                    if (node.previousSibling() != b) continue;
                    md.setPlot(node.text());
                    break;
                }
            }
            Element next = h4.nextElementSibling();
            while (true) {
                if (next.tag().getName().equals("div")) {
                    Elements rows = next.getElementsByTag("tr");
                    for (Element row : rows) {
                        MediaCastMember cm = this.parseCastMember(row);
                        if (!StringUtils.isNotEmpty((CharSequence)cm.getName()) || !StringUtils.isNotEmpty((CharSequence)cm.getCharacter())) continue;
                        cm.setType(MediaCastMember.CastType.ACTOR);
                        md.addCastMember(cm);
                    }
                    break block5;
                }
                next = next.nextElementSibling();
            }
        }
        return md;
    }

    List<MediaEpisode> getEpisodeList(MediaScrapeOptions options) throws Exception {
        ArrayList<MediaEpisode> episodes = new ArrayList<MediaEpisode>();
        String imdbId = options.getImdbId();
        if (StringUtils.isBlank((CharSequence)imdbId)) {
            return episodes;
        }
        CachedUrl url = new CachedUrl(this.imdbSite.getSite() + "/title/" + imdbId + "/epdate");
        url.addHeader("Accept-Language", ImdbTvShowParser.getAcceptLanguage(options.getLanguage().getLanguage(), options.getCountry().getAlpha2()));
        Document doc = Jsoup.parse((InputStream)url.getInputStream(), (String)this.imdbSite.getCharset().displayName(), (String)"");
        Pattern rowPattern = Pattern.compile("([0-9]*)\\.([0-9]*)");
        Elements tables = doc.getElementsByTag("table");
        for (Element table : tables) {
            Elements rows = table.getElementsByTag("tr");
            for (Element row : rows) {
                Matcher matcher = rowPattern.matcher(row.text());
                if (!matcher.find() || matcher.groupCount() < 2) continue;
                try {
                    Elements cols;
                    MediaEpisode ep = new MediaEpisode(ImdbMetadataProvider.providerInfo.getId());
                    ep.season = Integer.parseInt(matcher.group(1));
                    ep.episode = Integer.parseInt(matcher.group(2));
                    Elements anchors = row.getElementsByAttributeValueStarting("href", "/title/tt");
                    ep.title = ((Element)anchors.get(0)).text();
                    String id = "";
                    Matcher idMatcher = IMDB_ID_PATTERN.matcher(((Element)anchors.get(0)).attr("href"));
                    while (idMatcher.find()) {
                        if (idMatcher.group(1) == null) continue;
                        id = idMatcher.group(1);
                    }
                    if (StringUtils.isNotBlank((CharSequence)id)) {
                        ep.ids.put(ImdbMetadataProvider.providerInfo.getId(), id);
                    }
                    if ((cols = row.getElementsByTag("td")) != null && cols.size() >= 4) {
                        try {
                            ep.rating = Float.parseFloat(((Element)cols.get(2)).ownText());
                            String voteCount = ((Element)cols.get(3)).ownText().replace(".", "").replace(",", "");
                            ep.voteCount = Integer.parseInt(voteCount);
                        }
                        catch (Exception ignored) {
                            // empty catch block
                        }
                    }
                    episodes.add(ep);
                }
                catch (Exception e) {
                    LOGGER.warn("failed parsing: " + row.text() + " for ep data; " + e.getMessage());
                }
            }
        }
        return episodes;
    }
}

