/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.scraper.trakt;

import com.uwetrottmann.trakt5.TraktV2;
import com.uwetrottmann.trakt5.entities.CastMember;
import com.uwetrottmann.trakt5.entities.Credits;
import com.uwetrottmann.trakt5.entities.CrewMember;
import com.uwetrottmann.trakt5.entities.Episode;
import com.uwetrottmann.trakt5.entities.SearchResult;
import com.uwetrottmann.trakt5.entities.Season;
import com.uwetrottmann.trakt5.entities.Show;
import com.uwetrottmann.trakt5.entities.Translation;
import com.uwetrottmann.trakt5.enums.Extended;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.scraper.MediaMetadata;
import org.tinymediamanager.scraper.MediaScrapeOptions;
import org.tinymediamanager.scraper.MediaSearchOptions;
import org.tinymediamanager.scraper.MediaSearchResult;
import org.tinymediamanager.scraper.UnsupportedMediaTypeException;
import org.tinymediamanager.scraper.entities.Certification;
import org.tinymediamanager.scraper.entities.MediaCastMember;
import org.tinymediamanager.scraper.entities.MediaEpisode;
import org.tinymediamanager.scraper.entities.MediaGenres;
import org.tinymediamanager.scraper.entities.MediaType;
import org.tinymediamanager.scraper.trakt.TraktMetadataProvider;
import org.tinymediamanager.scraper.util.ListUtils;
import org.tinymediamanager.scraper.util.MetadataUtil;
import org.tinymediamanager.scraper.util.TvUtils;

class TraktTVShowMetadataProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(TraktTVShowMetadataProvider.class);
    private final TraktV2 api;

    TraktTVShowMetadataProvider(TraktV2 api) {
        this.api = api;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<MediaSearchResult> search(MediaSearchOptions options) throws Exception {
        LOGGER.debug("search() " + options.toString());
        if (options.getMediaType() != MediaType.TV_SHOW) {
            throw new UnsupportedMediaTypeException(options.getMediaType());
        }
        String searchString = "";
        int year = 0;
        if (StringUtils.isEmpty((CharSequence)searchString) && StringUtils.isNotEmpty((CharSequence)options.getQuery())) {
            searchString = options.getQuery();
        }
        if (options.getYear() != 0) {
            try {
                year = options.getYear();
            }
            catch (Exception e) {
                year = 0;
            }
        }
        ArrayList<MediaSearchResult> results = new ArrayList<MediaSearchResult>();
        List searchResults = null;
        String lang = options.getLanguage().getLanguage();
        lang = lang + ",en";
        TraktV2 traktV2 = this.api;
        synchronized (traktV2) {
            try {
                searchResults = year != 0 ? (List)this.api.search().textQueryShow(searchString, String.valueOf(year), null, lang, null, null, null, null, null, null, Extended.FULL, Integer.valueOf(1), Integer.valueOf(25)).execute().body() : (List)this.api.search().textQueryShow(searchString, null, null, lang, null, null, null, null, null, null, Extended.FULL, Integer.valueOf(1), Integer.valueOf(25)).execute().body();
            }
            catch (Exception e) {
                LOGGER.debug("failed to search: " + e.getMessage());
            }
        }
        if (searchResults == null || searchResults.isEmpty()) {
            LOGGER.info("nothing found");
            return results;
        }
        for (SearchResult result : searchResults) {
            MediaSearchResult mediaSearchResult = new MediaSearchResult(TraktMetadataProvider.providerInfo.getId(), MediaType.TV_SHOW);
            mediaSearchResult.setTitle(result.show.title);
            mediaSearchResult.setYear(result.show.year);
            mediaSearchResult.setId(result.show.ids.trakt.toString());
            mediaSearchResult.setIMDBId(result.show.ids.imdb);
            mediaSearchResult.setScore(MetadataUtil.calculateScore((String)searchString, (String)mediaSearchResult.getTitle()));
            results.add(mediaSearchResult);
        }
        return results;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<MediaEpisode> getEpisodeList(MediaScrapeOptions options) throws Exception {
        LOGGER.debug("getEpisodeList() " + options.toString());
        ArrayList<MediaEpisode> episodes = new ArrayList<MediaEpisode>();
        String id = options.getId(TraktMetadataProvider.providerInfo.getId());
        if (StringUtils.isBlank((CharSequence)id)) {
            id = options.getId("imdb");
        }
        if (StringUtils.isBlank((CharSequence)id)) {
            return episodes;
        }
        List seasons = null;
        TraktV2 traktV2 = this.api;
        synchronized (traktV2) {
            try {
                seasons = (List)this.api.seasons().summary(id, Extended.FULLEPISODES).execute().body();
            }
            catch (Exception e) {
                LOGGER.debug("failed to get episode list: " + e.getMessage());
            }
        }
        for (Season season : ListUtils.nullSafe((Iterable)seasons)) {
            for (Episode episode : season.episodes) {
                MediaEpisode ep = new MediaEpisode(TraktMetadataProvider.providerInfo.getId());
                ep.episode = TvUtils.getEpisodeNumber((Object[])new Object[]{episode.number});
                ep.season = TvUtils.getSeasonNumber((Object[])new Object[]{episode.season});
                ep.title = episode.title;
                if (episode.rating != null) {
                    ep.rating = episode.rating.floatValue();
                }
                ep.voteCount = TvUtils.parseInt((Object[])new Object[]{episode.votes});
                if (episode.first_aired != null) {
                    SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd");
                    ep.firstAired = formatter.format((Object)episode.first_aired.toDate());
                }
                if (episode.ids != null) {
                    ep.ids.put(TraktMetadataProvider.providerInfo.getId(), episode.ids.trakt);
                    if (episode.ids.tvdb != null && episode.ids.tvdb > 0) {
                        ep.ids.put("tvdb", episode.ids.tvdb);
                    }
                    if (episode.ids.tvdb != null && episode.ids.tmdb > 0) {
                        ep.ids.put("tmdb", episode.ids.tmdb);
                    }
                    if (episode.ids.tvrage != null && episode.ids.tvrage > 0) {
                        ep.ids.put("tvrage", episode.ids.tvrage);
                    }
                    if (StringUtils.isNotBlank((CharSequence)episode.ids.imdb)) {
                        ep.ids.put("imdb", episode.ids.imdb);
                    }
                }
                episodes.add(ep);
            }
        }
        return episodes;
    }

    MediaMetadata scrape(MediaScrapeOptions options) throws Exception {
        switch (options.getType()) {
            case TV_SHOW: {
                return this.getTvShowMetadata(options);
            }
            case TV_EPISODE: {
                return this.getEpisodeMetadata(options);
            }
        }
        throw new Exception("unsupported media type");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MediaMetadata getTvShowMetadata(MediaScrapeOptions options) throws Exception {
        Translation trans;
        LOGGER.debug("getTvShowMetadata() " + options.toString());
        MediaMetadata md = new MediaMetadata(TraktMetadataProvider.providerInfo.getId());
        String id = options.getId(TraktMetadataProvider.providerInfo.getId());
        if (StringUtils.isBlank((CharSequence)id) && options.getResult() != null) {
            id = options.getResult().getId();
        }
        if (StringUtils.isBlank((CharSequence)id)) {
            id = options.getId("imdb");
        }
        if (StringUtils.isBlank((CharSequence)id)) {
            return md;
        }
        String lang = options.getLanguage().getLanguage();
        List translations = null;
        Show show = null;
        Credits credits = null;
        TraktV2 traktV2 = this.api;
        synchronized (traktV2) {
            try {
                show = (Show)this.api.shows().summary(id, Extended.FULL).execute().body();
                if (!"en".equals(lang)) {
                    translations = (List)this.api.shows().translation(id, lang).execute().body();
                }
                credits = (Credits)this.api.shows().people(id).execute().body();
            }
            catch (Exception e) {
                LOGGER.debug("failed to get meta data: " + e.getMessage());
            }
        }
        if (show == null) {
            return md;
        }
        md.setId(TraktMetadataProvider.providerInfo.getId(), (Object)show.ids.trakt);
        if (show.ids.tvdb != null && show.ids.tvdb > 0) {
            md.setId("tvdb", (Object)show.ids.tvdb);
        }
        if (show.ids.tmdb != null && show.ids.tmdb > 0) {
            md.setId("tmdb", (Object)show.ids.tmdb);
        }
        if (show.ids.tvrage != null && show.ids.tvrage > 0) {
            md.setId("tvrage", (Object)show.ids.tvrage);
        }
        if (StringUtils.isNotBlank((CharSequence)show.ids.imdb)) {
            md.setId("imdb", (Object)show.ids.imdb);
        }
        Translation translation = trans = translations == null ? null : (Translation)translations.get(0);
        if (trans != null) {
            md.setTitle(trans.title.isEmpty() ? show.title : trans.title);
            md.setPlot(trans.overview.isEmpty() ? show.overview : trans.overview);
        } else {
            md.setTitle(show.title);
            md.setPlot(show.overview);
        }
        md.setYear(show.year);
        md.setRating(show.rating);
        md.setVoteCount(show.votes);
        md.addCertification(Certification.findCertification((String)show.certification));
        md.addCountry(show.country);
        md.setReleaseDate(show.first_aired);
        if (show.status != null) {
            md.setStatus(show.status.toString());
        }
        md.setRuntime(show.runtime);
        md.addProductionCompany(show.network);
        for (String genreAsString : ListUtils.nullSafe((Iterable)show.genres)) {
            md.addGenre(MediaGenres.getGenre((String)genreAsString));
        }
        if (credits != null) {
            MediaCastMember cm;
            for (CastMember cast : ListUtils.nullSafe((Iterable)credits.cast)) {
                cm = new MediaCastMember(MediaCastMember.CastType.ACTOR);
                cm.setName(cast.person.name);
                cm.setCharacter(cast.character);
                md.addCastMember(cm);
            }
            if (credits.crew != null) {
                for (CrewMember crew : ListUtils.nullSafe((Iterable)credits.crew.directing)) {
                    cm = new MediaCastMember(MediaCastMember.CastType.DIRECTOR);
                    cm.setName(crew.person.name);
                    cm.setPart(crew.job);
                    md.addCastMember(cm);
                }
                for (CrewMember crew : ListUtils.nullSafe((Iterable)credits.crew.production)) {
                    cm = new MediaCastMember(MediaCastMember.CastType.PRODUCER);
                    cm.setName(crew.person.name);
                    cm.setPart(crew.job);
                    md.addCastMember(cm);
                }
                for (CrewMember crew : ListUtils.nullSafe((Iterable)credits.crew.writing)) {
                    cm = new MediaCastMember(MediaCastMember.CastType.WRITER);
                    cm.setName(crew.person.name);
                    cm.setPart(crew.job);
                    md.addCastMember(cm);
                }
                for (CrewMember crew : ListUtils.nullSafe((Iterable)credits.crew.costumeAndMakeUp)) {
                    cm = new MediaCastMember(MediaCastMember.CastType.OTHER);
                    cm.setName(crew.person.name);
                    cm.setPart(crew.job);
                    md.addCastMember(cm);
                }
                for (CrewMember crew : ListUtils.nullSafe((Iterable)credits.crew.sound)) {
                    cm = new MediaCastMember(MediaCastMember.CastType.OTHER);
                    cm.setName(crew.person.name);
                    cm.setPart(crew.job);
                    md.addCastMember(cm);
                }
                for (CrewMember crew : ListUtils.nullSafe((Iterable)credits.crew.camera)) {
                    cm = new MediaCastMember(MediaCastMember.CastType.OTHER);
                    cm.setName(crew.person.name);
                    cm.setPart(crew.job);
                    md.addCastMember(cm);
                }
                for (CrewMember crew : ListUtils.nullSafe((Iterable)credits.crew.art)) {
                    cm = new MediaCastMember(MediaCastMember.CastType.OTHER);
                    cm.setName(crew.person.name);
                    cm.setPart(crew.job);
                    md.addCastMember(cm);
                }
            }
        }
        return md;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MediaMetadata getEpisodeMetadata(MediaScrapeOptions options) throws Exception {
        LOGGER.debug("getEpisodeMetadata() " + options.toString());
        MediaMetadata md = new MediaMetadata(TraktMetadataProvider.providerInfo.getId());
        String id = options.getId(TraktMetadataProvider.providerInfo.getId());
        if (StringUtils.isBlank((CharSequence)id)) {
            id = options.getId("imdb");
        }
        if (StringUtils.isBlank((CharSequence)id)) {
            return md;
        }
        int seasonNr = -1;
        int episodeNr = -1;
        try {
            seasonNr = Integer.parseInt(options.getId("seasonNr"));
            episodeNr = Integer.parseInt(options.getId("episodeNr"));
        }
        catch (Exception e) {
            LOGGER.warn("error parsing season/episode number");
        }
        String aired = "";
        if (options.getMetadata() != null && options.getMetadata().getReleaseDate() != null) {
            SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd");
            aired = formatter.format((Object)options.getMetadata().getReleaseDate());
        }
        if (aired.isEmpty() && (seasonNr == -1 || episodeNr == -1)) {
            return md;
        }
        Episode episode = null;
        List seasons = null;
        TraktV2 traktV2 = this.api;
        synchronized (traktV2) {
            try {
                seasons = (List)this.api.seasons().summary(id, Extended.FULLEPISODES).execute().body();
            }
            catch (Exception e) {
                LOGGER.debug("failed to get meta data: " + e.getMessage());
            }
        }
        block7: for (Season season : ListUtils.nullSafe((Iterable)seasons)) {
            for (Episode ep : season.episodes) {
                if (ep.season != seasonNr || ep.number != episodeNr) continue;
                episode = ep;
                continue block7;
            }
        }
        if (episode == null && !aired.isEmpty()) {
            block9: for (Season season : ListUtils.nullSafe((Iterable)seasons)) {
                for (Episode ep : season.episodes) {
                    SimpleDateFormat formatter;
                    String epAired;
                    if (ep.first_aired == null || !(epAired = (formatter = new SimpleDateFormat("yyyy-MM-dd")).format((Object)ep.first_aired.toDate())).equals(aired)) continue;
                    episode = ep;
                    continue block9;
                }
            }
        }
        if (episode == null) {
            return md;
        }
        md.setEpisodeNumber(TvUtils.getEpisodeNumber((Object[])new Object[]{episode.number}));
        md.setAbsoluteNumber(TvUtils.getEpisodeNumber((Object[])new Object[]{episode.number_abs}));
        md.setSeasonNumber(TvUtils.getSeasonNumber((Object[])new Object[]{episode.season}));
        md.setId(TraktMetadataProvider.providerInfo.getId(), (Object)episode.ids.trakt);
        if (episode.ids.tvdb != null && episode.ids.tvdb > 0) {
            md.setId("tvdb", (Object)episode.ids.tvdb);
        }
        if (episode.ids.tmdb != null && episode.ids.tmdb > 0) {
            md.setId("tmdb", (Object)episode.ids.tmdb);
        }
        if (StringUtils.isNotBlank((CharSequence)episode.ids.imdb)) {
            md.setId("imdb", (Object)episode.ids.imdb);
        }
        if (episode.ids.tvrage != null && episode.ids.tvrage > 0) {
            md.setId("tvrage", (Object)episode.ids.tvrage);
        }
        md.setTitle(episode.title);
        md.setPlot(episode.overview);
        md.setRating(episode.rating);
        md.setVoteCount(episode.votes);
        md.setReleaseDate(episode.first_aired);
        return md;
    }
}

