/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.scraper.trakt;

import com.uwetrottmann.trakt5.TraktV2;
import com.uwetrottmann.trakt5.TraktV2Interceptor;
import java.util.List;
import net.xeoh.plugins.base.annotations.PluginImplementation;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import org.tinymediamanager.scraper.MediaMetadata;
import org.tinymediamanager.scraper.MediaProviderInfo;
import org.tinymediamanager.scraper.MediaScrapeOptions;
import org.tinymediamanager.scraper.MediaSearchOptions;
import org.tinymediamanager.scraper.MediaSearchResult;
import org.tinymediamanager.scraper.UnsupportedMediaTypeException;
import org.tinymediamanager.scraper.entities.MediaEpisode;
import org.tinymediamanager.scraper.http.TmmHttpClient;
import org.tinymediamanager.scraper.mediaprovider.IMovieMetadataProvider;
import org.tinymediamanager.scraper.mediaprovider.ITvShowMetadataProvider;
import org.tinymediamanager.scraper.trakt.TraktMovieMetadataProvider;
import org.tinymediamanager.scraper.trakt.TraktTVShowMetadataProvider;

@PluginImplementation
public class TraktMetadataProvider
implements IMovieMetadataProvider,
ITvShowMetadataProvider {
    private static final String CLIENT_ID = "a8e7e30fd7fd3f397b6e079f9f023e790f9cbd80a2be57c104089174fa8c6d89";
    static final MediaProviderInfo providerInfo = TraktMetadataProvider.createMediaProviderInfo();
    private static TraktV2 api;

    private static MediaProviderInfo createMediaProviderInfo() {
        MediaProviderInfo providerInfo = new MediaProviderInfo("trakt", "Trakt.tv", "<html><h3>Trakt.tv</h3><br />Trakt.tv is a platform that does many things, but primarily keeps track of TV shows and movies you watch. It also provides meta data for movies and TV shows<br /><br />Available languages: EN</html>", TraktMetadataProvider.class.getResource("/trakt_tv.png"));
        providerInfo.setVersion(TraktMetadataProvider.class);
        return providerInfo;
    }

    private static synchronized void initAPI() throws Exception {
        if (api == null) {
            api = new TraktV2(CLIENT_ID){

                protected synchronized OkHttpClient okHttpClient() {
                    OkHttpClient.Builder builder = TmmHttpClient.newBuilder((boolean)true);
                    builder.addInterceptor((Interceptor)new TraktV2Interceptor((TraktV2)this));
                    return builder.build();
                }
            };
        }
    }

    public MediaProviderInfo getProviderInfo() {
        return providerInfo;
    }

    public List<MediaSearchResult> search(MediaSearchOptions options) throws Exception {
        TraktMetadataProvider.initAPI();
        switch (options.getMediaType()) {
            case MOVIE: {
                return new TraktMovieMetadataProvider(api).search(options);
            }
            case TV_SHOW: {
                return new TraktTVShowMetadataProvider(api).search(options);
            }
        }
        throw new UnsupportedMediaTypeException(options.getMediaType());
    }

    public MediaMetadata getMetadata(MediaScrapeOptions options) throws Exception {
        TraktMetadataProvider.initAPI();
        switch (options.getType()) {
            case MOVIE: {
                return new TraktMovieMetadataProvider(api).scrape(options);
            }
            case TV_SHOW: {
                return new TraktTVShowMetadataProvider(api).scrape(options);
            }
            case TV_EPISODE: {
                return new TraktTVShowMetadataProvider(api).scrape(options);
            }
        }
        throw new UnsupportedMediaTypeException(options.getType());
    }

    public List<MediaEpisode> getEpisodeList(MediaScrapeOptions mediaScrapeOptions) throws Exception {
        TraktMetadataProvider.initAPI();
        switch (mediaScrapeOptions.getType()) {
            case TV_SHOW: {
                return new TraktTVShowMetadataProvider(api).getEpisodeList(mediaScrapeOptions);
            }
        }
        throw new UnsupportedMediaTypeException(mediaScrapeOptions.getType());
    }
}

