/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.scraper.kodi;

import java.io.ByteArrayInputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.scraper.MediaMetadata;
import org.tinymediamanager.scraper.MediaProviderInfo;
import org.tinymediamanager.scraper.MediaScrapeOptions;
import org.tinymediamanager.scraper.MediaSearchOptions;
import org.tinymediamanager.scraper.MediaSearchResult;
import org.tinymediamanager.scraper.entities.MediaArtwork;
import org.tinymediamanager.scraper.entities.MediaCastMember;
import org.tinymediamanager.scraper.entities.MediaGenres;
import org.tinymediamanager.scraper.kodi.KodiAddonProcessor;
import org.tinymediamanager.scraper.kodi.KodiScraper;
import org.tinymediamanager.scraper.kodi.KodiScraperParser;
import org.tinymediamanager.scraper.kodi.KodiUrl;
import org.tinymediamanager.scraper.kodi.KodiUtil;
import org.tinymediamanager.scraper.mediaprovider.IKodiMetadataProvider;
import org.tinymediamanager.scraper.util.DOMUtils;
import org.tinymediamanager.scraper.util.MetadataUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public abstract class AbstractKodiMetadataProvider
implements IKodiMetadataProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractKodiMetadataProvider.class);
    private final DocumentBuilderFactory factory;
    public KodiScraper scraper;

    public AbstractKodiMetadataProvider(KodiScraper scraper) {
        KodiScraperParser parser = new KodiScraperParser();
        try {
            scraper = parser.parseScraper(scraper, KodiUtil.commonXmls);
        }
        catch (Exception e) {
            LOGGER.error("Failed to Load Kodi Scraper: " + scraper);
            throw new RuntimeException("Failed to Load Kodi Scraper: " + scraper, e);
        }
        this.scraper = scraper;
        this.factory = DocumentBuilderFactory.newInstance();
    }

    public MediaProviderInfo getProviderInfo() {
        return this.scraper.getProviderInfo();
    }

    protected List<MediaSearchResult> _search(MediaSearchOptions options) throws Exception {
        ArrayList<MediaSearchResult> l = new ArrayList<MediaSearchResult>();
        String arg = options.getQuery();
        if (StringUtils.isBlank((CharSequence)arg)) {
            return l;
        }
        String[] args = this.parseTitle(arg);
        String title = args[0];
        int year = 0;
        if (options.getYear() != 0) {
            year = options.getYear();
        }
        KodiAddonProcessor processor = new KodiAddonProcessor(this.scraper);
        KodiUrl url = processor.getSearchUrl(title, String.valueOf(year));
        String xmlString = processor.getSearchResults(url);
        LOGGER.trace("========= BEGIN Kodi Scraper Search Xml Results: Url: " + url);
        LOGGER.trace(xmlString);
        LOGGER.trace("========= End Kodi Scraper Search Xml Results: Url: " + url);
        Document xml = this.parseXmlString(xmlString);
        NodeList nl = xml.getElementsByTagName("entity");
        for (int i = 0; i < nl.getLength(); ++i) {
            try {
                Element el = (Element)nl.item(i);
                NodeList titleList = el.getElementsByTagName("title");
                String t = titleList.item(0).getTextContent();
                NodeList yearList = el.getElementsByTagName("year");
                String y = yearList == null || yearList.getLength() == 0 ? "" : yearList.item(0).getTextContent();
                NodeList urlList = el.getElementsByTagName("url");
                KodiUrl u = new KodiUrl((Element)urlList.item(0));
                MediaSearchResult sr = new MediaSearchResult(this.scraper.getProviderInfo().getId(), options.getMediaType());
                String id = DOMUtils.getElementValue((Element)el, (String)"id");
                sr.setId(id);
                sr.setUrl(u.toExternalForm());
                sr.setProviderId(this.scraper.getProviderInfo().getId());
                if (u.toExternalForm().contains("imdb")) {
                    sr.setIMDBId(id);
                }
                sr.setTitle(t);
                try {
                    sr.setYear(Integer.parseInt(y));
                }
                catch (Exception ignored) {
                    // empty catch block
                }
                float score = MetadataUtil.calculateScore((String)arg, (String)t);
                if (this.yearDiffers(sr.getYear(), year)) {
                    float diff = (float)Math.abs(year - sr.getYear()) / 100.0f;
                    LOGGER.debug("parsed year does not match search result year - downgrading score by " + diff);
                    score -= diff;
                }
                sr.setScore(score);
                l.add(sr);
                continue;
            }
            catch (Exception e) {
                LOGGER.error("Error process an xml node!  Ignoring it from the search results.");
            }
        }
        Collections.sort(l);
        Collections.reverse(l);
        return l;
    }

    private boolean yearDiffers(Integer i1, Integer i2) {
        return i1 != null && i1 != 0 && i2 != null && i2 != 0 && i1 != i2;
    }

    protected MediaMetadata _getMetadata(MediaScrapeOptions options) throws Exception {
        MediaMetadata md = new MediaMetadata(this.scraper.getProviderInfo().getId());
        MediaSearchResult result = options.getResult();
        if (result.getIMDBId() != null && result.getIMDBId().contains("tt")) {
            md.setId("imdb", (Object)result.getIMDBId());
        }
        KodiAddonProcessor processor = new KodiAddonProcessor(this.scraper);
        String xmlDetails = processor.getDetails(new KodiUrl(result.getUrl()), result.getId());
        xmlDetails = xmlDetails.replace("&nbsp;", " ");
        this.processXmlContent(xmlDetails, md, result);
        if (!StringUtils.isEmpty((CharSequence)result.getUrl()) && md.getId("imdb") != null) {
            md.setId("imdb", (Object)this.parseIMDBID(result.getUrl()));
        }
        return md;
    }

    private String parseIMDBID(String url) {
        if (url == null) {
            return null;
        }
        Pattern p = Pattern.compile("/(tt[0-9]+)/");
        Matcher m = p.matcher(url);
        if (m.find()) {
            return m.group(1);
        }
        return "";
    }

    protected Document parseXmlString(String xml) throws Exception {
        DocumentBuilder parser = this.factory.newDocumentBuilder();
        xml = StringEscapeUtils.unescapeHtml4((String)xml);
        xml = StringEscapeUtils.unescapeXml((String)xml);
        xml = StringEscapeUtils.unescapeXml((String)xml);
        xml = StringEscapeUtils.unescapeXml((String)xml);
        xml = xml.replaceAll("\\&", "\\&amp;");
        Document doc = null;
        for (String charset : new String[]{"UTF-8", "ISO-8859-1", "US-ASCII"}) {
            try {
                doc = parser.parse(new ByteArrayInputStream(xml.getBytes(charset)));
                break;
            }
            catch (Throwable t) {
                LOGGER.error("Failed to parse xml using charset: " + charset + " - " + t.getMessage());
                System.out.println("*********** BEGIN");
                System.out.println(xml);
                System.out.println("*********** END");
            }
        }
        if (doc == null) {
            LOGGER.error("Unabled to parse xml string");
            LOGGER.error(xml);
            throw new Exception("Unable to parse xml!");
        }
        return doc;
    }

    protected void addMetadata(MediaMetadata md, Element details) {
        Element el;
        MediaCastMember cm;
        int i;
        String runtime;
        String set;
        String tagline;
        String year;
        String plot;
        String originalTitle;
        LOGGER.debug("Processing <details> node....");
        NodeList subDetails = details.getElementsByTagName("details");
        String title = this.getInfoFromScraperFunctionOrBase("title", details, subDetails);
        if (StringUtils.isNotBlank((CharSequence)title)) {
            md.setTitle(title);
        }
        if (StringUtils.isNotBlank((CharSequence)(originalTitle = this.getInfoFromScraperFunctionOrBase("originaltitle", details, subDetails)))) {
            md.setOriginalTitle(originalTitle);
        }
        if (StringUtils.isNotBlank((CharSequence)(plot = this.getInfoFromScraperFunctionOrBase("plot", details, subDetails)))) {
            md.setPlot(plot);
        }
        if (StringUtils.isNotBlank((CharSequence)(year = this.getInfoFromScraperFunctionOrBase("year", details, subDetails)))) {
            try {
                md.setYear(Integer.parseInt(year));
            }
            catch (Exception ignored) {
                // empty catch block
            }
        }
        if (StringUtils.isNotBlank((CharSequence)(tagline = this.getInfoFromScraperFunctionOrBase("tagline", details, subDetails)))) {
            md.setTagline(tagline);
        }
        if (StringUtils.isNotBlank((CharSequence)(set = this.getInfoFromScraperFunctionOrBase("set", details, subDetails)))) {
            md.setCollectionName(set);
        }
        if (StringUtils.isNotBlank((CharSequence)(runtime = this.getInfoFromScraperFunctionOrBase("runtime", details, subDetails)))) {
            try {
                md.setRuntime(Integer.parseInt(runtime));
            }
            catch (NumberFormatException ignored) {
                // empty catch block
            }
        }
        NodeList nl = details.getElementsByTagName("fanart");
        for (i = 0; i < nl.getLength(); ++i) {
            Element fanart = (Element)nl.item(i);
            String url = fanart.getAttribute("url");
            NodeList thumbs = fanart.getElementsByTagName("thumb");
            if (thumbs != null && thumbs.getLength() > 0) {
                this.processMediaArt(md, MediaArtwork.MediaArtworkType.BACKGROUND, "Backgrounds", thumbs, url);
                continue;
            }
            if (StringUtils.isEmpty((CharSequence)url)) continue;
            this.processMediaArt(md, MediaArtwork.MediaArtworkType.BACKGROUND, "Background", url);
        }
        nl = details.getElementsByTagName("thumb");
        for (i = 0; i < nl.getLength(); ++i) {
            Element poster = (Element)nl.item(i);
            if (poster.getParentNode().getNodeName() != "details") continue;
            this.processMediaArt(md, MediaArtwork.MediaArtworkType.POSTER, "Poster", poster, null);
        }
        nl = details.getElementsByTagName("actor");
        for (i = 0; i < nl.getLength(); ++i) {
            Element actor = (Element)nl.item(i);
            cm = new MediaCastMember();
            cm.setType(MediaCastMember.CastType.ACTOR);
            cm.setName(DOMUtils.getElementValue((Element)actor, (String)"name"));
            cm.setCharacter(DOMUtils.getElementValue((Element)actor, (String)"role"));
            md.addCastMember(cm);
        }
        nl = details.getElementsByTagName("director");
        for (i = 0; i < nl.getLength(); ++i) {
            el = (Element)nl.item(i);
            cm = new MediaCastMember();
            cm.setType(MediaCastMember.CastType.DIRECTOR);
            cm.setName(StringUtils.trim((String)el.getTextContent()));
            LOGGER.debug("Adding Director: " + cm.getName());
            cm.setPart("Director");
            md.addCastMember(cm);
        }
        nl = details.getElementsByTagName("credits");
        for (i = 0; i < nl.getLength(); ++i) {
            el = (Element)nl.item(i);
            cm = new MediaCastMember();
            cm.setType(MediaCastMember.CastType.WRITER);
            cm.setName(StringUtils.trim((String)el.getTextContent()));
            cm.setPart("Writer");
            md.addCastMember(cm);
        }
        nl = details.getElementsByTagName("genre");
        for (i = 0; i < nl.getLength(); ++i) {
            el = (Element)nl.item(i);
            MediaGenres genre = MediaGenres.getGenre((String)StringUtils.trim((String)el.getTextContent()));
            if (genre == null) continue;
            md.addGenre(genre);
        }
    }

    private String getInfoFromScraperFunctionOrBase(String tag, Element details, NodeList subDetails) {
        String info = "";
        for (int i = 0; i < subDetails.getLength(); ++i) {
            int j = 0;
            Element subDetail = (Element)subDetails.item(i);
            NodeList nl = subDetail.getElementsByTagName(tag);
            if (j < nl.getLength()) {
                Element el = (Element)nl.item(j);
                info = el.getTextContent();
            }
            if (info != null) break;
        }
        if (StringUtils.isBlank((CharSequence)info)) {
            info = DOMUtils.getElementValue((Element)details, (String)tag);
        }
        return info;
    }

    private void processMediaArt(MediaMetadata md, MediaArtwork.MediaArtworkType type, String label, NodeList els, String baseUrl) {
        for (int i = 0; i < els.getLength(); ++i) {
            Element e = (Element)els.item(i);
            String image = e.getTextContent();
            if (image != null) {
                image = image.trim();
            }
            if (baseUrl != null) {
                baseUrl = baseUrl.trim();
                image = baseUrl + image;
            }
            this.processMediaArt(md, type, label, image);
        }
    }

    private void processMediaArt(MediaMetadata md, MediaArtwork.MediaArtworkType type, String label, Element e, String baseUrl) {
        String image = e.getTextContent();
        if (image != null) {
            image = image.trim();
        }
        if (baseUrl != null) {
            baseUrl = baseUrl.trim();
            image = baseUrl + image;
        }
        this.processMediaArt(md, type, label, image);
    }

    private void processMediaArt(MediaMetadata md, MediaArtwork.MediaArtworkType type, String label, String image) {
        MediaArtwork ma = new MediaArtwork(md.getProviderId(), type);
        ma.setPreviewUrl(image);
        ma.setDefaultUrl(image);
        md.addMediaArt(ma);
    }

    private String[] parseTitle(String title) {
        String[] v = new String[]{"", ""};
        if (title == null) {
            return v;
        }
        Pattern p = Pattern.compile("(.*)\\s+\\(?([0-9]{4})\\)?", 2);
        Matcher m = p.matcher(title);
        if (m.find()) {
            v[0] = m.group(1);
            v[1] = m.group(2);
        } else {
            v[0] = title;
        }
        return v;
    }

    protected abstract void processXmlContent(String var1, MediaMetadata var2, MediaSearchResult var3) throws Exception;
}

