/*
 * Decompiled with CFR 0.152.
 */
package com.floreysoft.jmte.util;

import java.util.ArrayList;
import java.util.List;

public final class MiniParser {
    public static final char DEFAULT_ESCAPE_CHAR = '\\';
    public static final char DEFAULT_QUOTE_CHAR = '\"';
    private final char escapeChar;
    private final char quoteChar;
    private final boolean ignoreCase;
    private final boolean trim;
    private final boolean rawOutput;
    private transient boolean escaped = false;
    private transient boolean quoted = false;

    public static MiniParser defaultInstance() {
        return new MiniParser('\\', '\"', false, false, false);
    }

    public static MiniParser trimmedInstance() {
        return new MiniParser('\\', '\"', false, true, false);
    }

    public static MiniParser ignoreCaseInstance() {
        return new MiniParser('\\', '\"', true, false, false);
    }

    public static MiniParser fullRawInstance() {
        return new MiniParser('\uffff', '\uffff', false, false, true);
    }

    public static MiniParser rawOutputInstance() {
        return new MiniParser('\\', '\"', false, false, true);
    }

    public MiniParser(char escapeChar, char quoteChar, boolean ignoreCase, boolean trim, boolean rawOutput) {
        this.escapeChar = escapeChar;
        this.quoteChar = quoteChar;
        this.ignoreCase = ignoreCase;
        this.trim = trim;
        this.rawOutput = rawOutput;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String replace(String input, String oldString, String newString) {
        try {
            if (oldString == null || oldString.equals("")) {
                String string = input;
                return string;
            }
            StringBuilder buffer = new StringBuilder();
            for (int index = 0; index < input.length(); ++index) {
                if (input.regionMatches(this.ignoreCase, index, oldString, 0, oldString.length())) {
                    buffer.append(newString);
                    index += oldString.length() - 1;
                    continue;
                }
                char c = input.charAt(index);
                this.append(buffer, c);
            }
            String string = buffer.toString();
            return string;
        }
        finally {
            this.escaped = false;
            this.quoted = false;
        }
    }

    public List<String> split(String input, char separator) {
        return this.split(input, separator, Integer.MAX_VALUE);
    }

    public List<String> split(String input, char separator, int maxSegments) {
        return this.splitInternal(input, false, separator, null, maxSegments);
    }

    public List<String> split(String input, String separatorSet) {
        return this.split(input, separatorSet, Integer.MAX_VALUE);
    }

    public List<String> split(String input, String separatorSet, int maxSegments) {
        return this.splitInternal(input, false, '\uffff', separatorSet, maxSegments);
    }

    public List<String> splitOnWhitespace(String input, int maxSegments) {
        return this.splitInternal(input, true, '\uffff', null, maxSegments);
    }

    public List<String> splitOnWhitespace(String input) {
        return this.splitOnWhitespace(input, Integer.MAX_VALUE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<String> splitInternal(String input, boolean splitOnWhitespace, char separator, String separatorSet, int maxSegments) {
        if (input == null) {
            return null;
        }
        try {
            ArrayList<String> segments = new ArrayList<String>();
            StringBuilder buffer = new StringBuilder();
            for (int index = 0; index < input.length(); ++index) {
                boolean separates;
                char c = input.charAt(index);
                boolean separatedByWhitespace = false;
                if (splitOnWhitespace) {
                    while (index < input.length() && Character.isWhitespace(input.charAt(index))) {
                        separatedByWhitespace = true;
                        ++index;
                    }
                    if (separatedByWhitespace) {
                        --index;
                    }
                }
                boolean bl = separatedByWhitespace || (separatorSet != null ? separatorSet.indexOf(c) != -1 : c == separator) ? true : (separates = false);
                if (segments.size() != maxSegments - 1 && separates && !this.isEscaped()) {
                    this.finish(segments, buffer);
                    buffer = new StringBuilder();
                    continue;
                }
                this.append(buffer, c);
            }
            if (!splitOnWhitespace || buffer.length() != 0) {
                this.finish(segments, buffer);
            }
            ArrayList<String> arrayList = segments;
            return arrayList;
        }
        finally {
            this.escaped = false;
            this.quoted = false;
        }
    }

    private void finish(List<String> segments, StringBuilder buffer) {
        String string = buffer.toString();
        segments.add(this.trim ? string.trim() : string);
    }

    public int lastIndexOf(String input, String substring) {
        return this.indexOfInternal(input, substring, true);
    }

    public int indexOf(String input, String substring) {
        return this.indexOfInternal(input, substring, false);
    }

    private int indexOfInternal(String input, String substring, boolean last) {
        int resultIndex = -1;
        for (int index = 0; index < input.length(); ++index) {
            if (!input.regionMatches(this.ignoreCase, index, substring, 0, substring.length()) || this.isEscaped()) continue;
            resultIndex = index;
            if (!last) break;
        }
        return resultIndex;
    }

    public List<String> scan(String input, String splitStart, String splitEnd) {
        return this.scan(input, splitStart, splitEnd, false);
    }

    public List<String> greedyScan(String input, String splitStart, String splitEnd) {
        return this.scan(input, splitStart, splitEnd, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> scan(String input, String splitStart, String splitEnd, boolean greedy) {
        if (input == null) {
            return null;
        }
        try {
            int lastIndexOfEnd;
            ArrayList<String> segments = new ArrayList<String>();
            StringBuilder buffer = new StringBuilder();
            boolean started = false;
            lastIndexOfEnd = greedy ? (lastIndexOfEnd = this.lastIndexOf(input, splitEnd)) : -1;
            int index = 0;
            while (index < input.length()) {
                String separator;
                char c = input.charAt(index);
                boolean greedyCond = !started || !greedy || index == lastIndexOfEnd;
                String string = separator = started ? splitEnd : splitStart;
                if (input.regionMatches(this.ignoreCase, index, separator, 0, separator.length()) && !this.isEscaped() && greedyCond) {
                    this.finish(segments, buffer);
                    buffer = new StringBuilder();
                    started = !started;
                    index += separator.length();
                    continue;
                }
                this.append(buffer, c);
                ++index;
            }
            if (buffer.length() != 0) {
                this.finish(segments, buffer);
            }
            ArrayList<String> arrayList = segments;
            return arrayList;
        }
        finally {
            this.escaped = false;
            this.quoted = false;
        }
    }

    public String unescape(String input) {
        StringBuilder unescaped = new StringBuilder();
        for (int i = 0; i < input.length(); ++i) {
            char c = input.charAt(i);
            this.append(unescaped, c);
        }
        return unescaped.toString();
    }

    private void append(StringBuilder buffer, char c) {
        if (c == this.escapeChar) {
            if (this.escaped || this.rawOutput) {
                buffer.append(c);
            }
            this.escaped = !this.escaped;
        } else if (c == this.quoteChar) {
            if (this.escaped) {
                buffer.append(c);
                this.escaped = false;
            } else {
                boolean bl = this.quoted = !this.quoted;
                if (this.rawOutput) {
                    buffer.append(c);
                }
            }
        } else {
            buffer.append(c);
            this.escaped = false;
        }
    }

    private boolean isEscaped() {
        return this.escaped || this.quoted;
    }
}

