/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.scraper.moviemeter;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import net.xeoh.plugins.base.annotations.PluginImplementation;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.scraper.MediaMetadata;
import org.tinymediamanager.scraper.MediaProviderInfo;
import org.tinymediamanager.scraper.MediaScrapeOptions;
import org.tinymediamanager.scraper.MediaSearchOptions;
import org.tinymediamanager.scraper.MediaSearchResult;
import org.tinymediamanager.scraper.entities.MediaArtwork;
import org.tinymediamanager.scraper.entities.MediaCastMember;
import org.tinymediamanager.scraper.entities.MediaGenres;
import org.tinymediamanager.scraper.entities.MediaType;
import org.tinymediamanager.scraper.mediaprovider.IMovieMetadataProvider;
import org.tinymediamanager.scraper.moviemeter.MovieMeter;
import org.tinymediamanager.scraper.moviemeter.entities.MMActor;
import org.tinymediamanager.scraper.moviemeter.entities.MMFilm;
import org.tinymediamanager.scraper.util.ApiKey;
import org.tinymediamanager.scraper.util.LanguageUtils;
import org.tinymediamanager.scraper.util.MetadataUtil;
import retrofit.RetrofitError;

@PluginImplementation
public class MovieMeterMetadataProvider
implements IMovieMetadataProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(MovieMeterMetadataProvider.class);
    private static MovieMeter api;
    private static MediaProviderInfo providerInfo;

    private static MediaProviderInfo createMediaProviderInfo() {
        MediaProviderInfo providerInfo = new MediaProviderInfo("moviemeter", "moviemeter.nl", "<html><h3>Moviemeter.nl</h3><br />A dutch movie database.<br /><br />Available languages: NL</html>", MovieMeterMetadataProvider.class.getResource("/moviemeter_nl.png"));
        providerInfo.setVersion(MovieMeterMetadataProvider.class);
        providerInfo.getConfig().addBoolean("scrapeLanguageNames", true);
        providerInfo.getConfig().load();
        return providerInfo;
    }

    private static synchronized void initAPI() throws Exception {
        if (api == null) {
            try {
                api = new MovieMeter(ApiKey.decryptApikey((String)"GK5bRYdcKs3WZzOCa1fOQfIeAJVsBP7buUYjc0q4x2/jX66BlSUDKDAcgN/L0JnM"));
            }
            catch (Exception e) {
                LOGGER.error("MoviemeterMetadataProvider", (Throwable)e);
                throw e;
            }
        }
    }

    public MediaProviderInfo getProviderInfo() {
        return providerInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MediaMetadata getMetadata(MediaScrapeOptions options) throws Exception {
        MediaCastMember cm;
        String imdbId;
        MovieMeterMetadataProvider.initAPI();
        LOGGER.debug("getMetadata() " + options.toString());
        if (options.getResult() != null && options.getResult().getMediaMetadata() != null) {
            LOGGER.debug("MovieMeter: getMetadata from cache: " + options.getResult());
            return options.getResult().getMediaMetadata();
        }
        MediaMetadata md = new MediaMetadata(providerInfo.getId());
        int mmId = 0;
        if (options.getResult() != null) {
            mmId = Integer.parseInt(options.getResult().getId());
        }
        if (StringUtils.isNotBlank((CharSequence)options.getId(providerInfo.getId()))) {
            try {
                mmId = Integer.parseInt(options.getId(providerInfo.getId()));
            }
            catch (Exception ignored) {
                // empty catch block
            }
        }
        if (StringUtils.isBlank((CharSequence)(imdbId = options.getImdbId())) && mmId == 0) {
            LOGGER.warn("not possible to scrape from Moviemeter.bl - no mmId/imdbId found");
            return md;
        }
        MMFilm fd = null;
        MovieMeter movieMeter = api;
        synchronized (movieMeter) {
            if (mmId != 0) {
                LOGGER.debug("MovieMeter: getMetadata(mmId): " + mmId);
                try {
                    fd = api.getFilmService().getMovieInfo(mmId);
                }
                catch (RetrofitError e) {
                    LOGGER.warn("Error getting movie via MovieMeter id: " + e.getBodyAs(MovieMeter.ErrorResponse.class));
                }
            } else if (StringUtils.isNotBlank((CharSequence)imdbId)) {
                LOGGER.debug("MovieMeter: filmSearchImdb(imdbId): " + imdbId);
                try {
                    fd = api.getFilmService().getMovieInfoByImdbId(imdbId);
                }
                catch (RetrofitError e) {
                    LOGGER.warn("Error getting movie via IMDB id: " + e.getBodyAs(MovieMeter.ErrorResponse.class));
                }
            }
        }
        if (fd == null) {
            return md;
        }
        md.setId("imdb", (Object)fd.imdb);
        md.setTitle(fd.title);
        md.setYear(fd.year);
        md.setPlot(fd.plot);
        md.setTagline(fd.plot.length() > 150 ? fd.plot.substring(0, 150) : fd.plot);
        try {
            md.setRating((float)fd.average);
        }
        catch (Exception e) {
            md.setRating(0.0f);
        }
        md.setId(providerInfo.getId(), (Object)fd.id);
        try {
            md.setRuntime(fd.duration);
        }
        catch (Exception e) {
            md.setRuntime(0);
        }
        md.setVoteCount(fd.votes_count);
        for (String g : fd.genres) {
            md.addGenre(this.getTmmGenre(g));
        }
        MediaArtwork ma = new MediaArtwork(providerInfo.getId(), MediaArtwork.MediaArtworkType.POSTER);
        ma.setPreviewUrl(fd.posters.small);
        ma.setDefaultUrl(fd.posters.large);
        ma.setLanguage(options.getLanguage().getLanguage());
        md.addMediaArt(ma);
        for (String country : fd.countries) {
            if (providerInfo.getConfig().getValueAsBool("scrapeLanguageNames").booleanValue()) {
                md.addCountry(LanguageUtils.getLocalizedCountryForLanguage((Locale)options.getLanguage(), (String[])new String[]{country}));
                continue;
            }
            md.addCountry(country);
        }
        for (MMActor a : fd.actors) {
            cm = new MediaCastMember();
            cm.setName(a.name);
            cm.setType(MediaCastMember.CastType.ACTOR);
            md.addCastMember(cm);
        }
        for (String d : fd.directors) {
            cm = new MediaCastMember();
            cm.setName(d);
            cm.setType(MediaCastMember.CastType.DIRECTOR);
            md.addCastMember(cm);
        }
        return md;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<MediaSearchResult> search(MediaSearchOptions query) throws Exception {
        MovieMeterMetadataProvider.initAPI();
        LOGGER.debug("search() " + query.toString());
        ArrayList<MediaSearchResult> resultList = new ArrayList<MediaSearchResult>();
        String imdb = query.getImdbId();
        String searchString = "";
        int myear = query.getYear();
        if (query.getMediaType() != MediaType.MOVIE) {
            throw new Exception("wrong media type for this scraper");
        }
        if (StringUtils.isEmpty((CharSequence)searchString) && StringUtils.isNotEmpty((CharSequence)query.getQuery())) {
            searchString = query.getQuery();
        }
        if (StringUtils.isEmpty((CharSequence)searchString)) {
            LOGGER.debug("Moviemeter Scraper: empty searchString");
            return resultList;
        }
        if (MetadataUtil.isValidImdbId((String)(searchString = MetadataUtil.removeNonSearchCharacters((String)searchString)))) {
            imdb = searchString;
        }
        ArrayList<MMFilm> moviesFound = new ArrayList<MMFilm>();
        MMFilm fd = null;
        MovieMeter movieMeter = api;
        synchronized (movieMeter) {
            if (StringUtils.isNotEmpty((CharSequence)imdb)) {
                try {
                    fd = api.getFilmService().getMovieInfoByImdbId(imdb);
                    LOGGER.debug("found result with IMDB id");
                }
                catch (RetrofitError e) {
                    LOGGER.warn("Error searching by IMDB id: " + e.getBodyAs(MovieMeter.ErrorResponse.class));
                }
            }
            if (fd == null) {
                try {
                    moviesFound.addAll(api.getSearchService().searchFilm(searchString));
                    LOGGER.debug("found " + moviesFound.size() + " results");
                }
                catch (RetrofitError e) {
                    LOGGER.warn("Error searching: " + e.getBodyAs(MovieMeter.ErrorResponse.class));
                }
            }
        }
        if (fd != null) {
            MediaSearchResult sr = new MediaSearchResult(providerInfo.getId(), query.getMediaType());
            sr.setId(String.valueOf(fd.id));
            sr.setIMDBId(imdb);
            sr.setTitle(fd.title);
            sr.setUrl(fd.url);
            sr.setYear(fd.year);
            sr.setScore(1.0f);
            resultList.add(sr);
        }
        for (MMFilm film : moviesFound) {
            MediaSearchResult sr = new MediaSearchResult(providerInfo.getId(), query.getMediaType());
            sr.setId(String.valueOf(film.id));
            sr.setIMDBId(imdb);
            sr.setTitle(film.title);
            sr.setUrl(film.url);
            sr.setYear(film.year);
            float score = MetadataUtil.calculateScore((String)searchString, (String)film.title);
            if (this.yearDiffers(myear, sr.getYear())) {
                float diff = (float)Math.abs(myear - sr.getYear()) / 100.0f;
                LOGGER.debug("parsed year does not match search result year - downgrading score by " + diff);
                score -= diff;
            }
            sr.setScore(score);
            resultList.add(sr);
        }
        Collections.sort(resultList);
        Collections.reverse(resultList);
        return resultList;
    }

    private boolean yearDiffers(Integer i1, Integer i2) {
        return i1 != null && i1 != 0 && i2 != null && i2 != 0 && i1 != i2;
    }

    private MediaGenres getTmmGenre(String genre) {
        MediaGenres g = null;
        if (genre.isEmpty()) {
            return g;
        }
        if (genre.equals("Actie")) {
            g = MediaGenres.ACTION;
        } else if (genre.equals("Animatie")) {
            g = MediaGenres.ANIMATION;
        } else if (genre.equals("Avontuur")) {
            g = MediaGenres.ADVENTURE;
        } else if (genre.equals("Documentaire")) {
            g = MediaGenres.DOCUMENTARY;
        } else if (genre.equals("Drama")) {
            g = MediaGenres.DRAMA;
        } else if (genre.equals("Erotiek")) {
            g = MediaGenres.EROTIC;
        } else if (genre.equals("Familie")) {
            g = MediaGenres.FAMILY;
        } else if (genre.equals("Fantasy")) {
            g = MediaGenres.FANTASY;
        } else if (genre.equals("Film noir")) {
            g = MediaGenres.FILM_NOIR;
        } else if (genre.equals("Horror")) {
            g = MediaGenres.HORROR;
        } else if (genre.equals("Komedie")) {
            g = MediaGenres.COMEDY;
        } else if (genre.equals("Misdaad")) {
            g = MediaGenres.CRIME;
        } else if (genre.equals("Muziek")) {
            g = MediaGenres.MUSIC;
        } else if (genre.equals("Mystery")) {
            g = MediaGenres.MYSTERY;
        } else if (genre.equals("Oorlog")) {
            g = MediaGenres.WAR;
        } else if (genre.equals("Roadmovie")) {
            g = MediaGenres.ROAD_MOVIE;
        } else if (genre.equals("Romantiek")) {
            g = MediaGenres.ROMANCE;
        } else if (genre.equals("Sciencefiction")) {
            g = MediaGenres.SCIENCE_FICTION;
        } else if (genre.equals("Thriller")) {
            g = MediaGenres.THRILLER;
        } else if (genre.equals("Western")) {
            g = MediaGenres.WESTERN;
        }
        if (g == null) {
            g = MediaGenres.getGenre((String)genre);
        }
        return g;
    }

    static {
        providerInfo = MovieMeterMetadataProvider.createMediaProviderInfo();
    }
}

