/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.scraper.tmdb;

import com.uwetrottmann.tmdb2.Tmdb;
import com.uwetrottmann.tmdb2.entities.Videos;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.scraper.MediaScrapeOptions;
import org.tinymediamanager.scraper.entities.MediaTrailer;
import org.tinymediamanager.scraper.tmdb.TmdbConnectionCounter;
import org.tinymediamanager.scraper.tmdb.TmdbMovieMetadataProvider;
import org.tinymediamanager.scraper.util.ListUtils;

class TmdbTrailerProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(TmdbTrailerProvider.class);
    private Tmdb api;

    public TmdbTrailerProvider(Tmdb api) {
        this.api = api;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<MediaTrailer> getTrailers(MediaScrapeOptions options) throws Exception {
        LOGGER.debug("getTrailers() " + options.toString());
        ArrayList<MediaTrailer> trailers = new ArrayList<MediaTrailer>();
        int tmdbId = options.getTmdbId();
        String imdbId = options.getImdbId();
        if (tmdbId == 0 && StringUtils.isNotEmpty((CharSequence)imdbId)) {
            tmdbId = new TmdbMovieMetadataProvider(this.api).getTmdbIdFromImdbId(imdbId);
        }
        if (tmdbId == 0) {
            LOGGER.warn("not possible to scrape from TMDB - no tmdbId found");
            return trailers;
        }
        String language = options.getLanguage().getLanguage();
        if (StringUtils.isNotBlank((CharSequence)options.getLanguage().getCountry())) {
            language = language + "-" + options.getLanguage().getCountry();
        }
        LOGGER.debug("TMDB: getTrailers(tmdbId): " + tmdbId);
        ArrayList<Videos.Video> videos = new ArrayList<Videos.Video>();
        Tmdb tmdb = this.api;
        synchronized (tmdb) {
            TmdbConnectionCounter.trackConnections();
            try {
                Videos tmdbVideos = (Videos)this.api.moviesService().videos(tmdbId, language).execute().body();
                TmdbConnectionCounter.trackConnections();
                Videos tmdbVideosWoLang = (Videos)this.api.moviesService().videos(tmdbId, "").execute().body();
                videos.addAll(tmdbVideos.results);
                videos.addAll(tmdbVideosWoLang.results);
            }
            catch (Exception e) {
                LOGGER.debug("failed to get trailer: " + e.getMessage());
            }
        }
        for (Videos.Video video : ListUtils.nullSafe(videos)) {
            if (!"trailer".equalsIgnoreCase(video.type)) continue;
            MediaTrailer trailer = new MediaTrailer();
            trailer.setName(video.name);
            trailer.setQuality(String.valueOf(video.size) + "p");
            trailer.setProvider(video.site);
            trailer.setUrl(video.key);
            if ("youtube".equalsIgnoreCase(video.site)) {
                StringBuilder sb = new StringBuilder();
                sb.append("http://www.youtube.com/watch?v=");
                sb.append(video.key);
                if (video.size >= 720) {
                    sb.append("&hd=1");
                }
                trailer.setUrl(sb.toString());
            }
            if (trailers.contains(trailer)) continue;
            trailers.add(trailer);
        }
        return trailers;
    }
}

