/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.scraper.tmdb;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.scraper.util.RingBuffer;

public class TmdbConnectionCounter {
    private static final Logger LOGGER = LoggerFactory.getLogger(TmdbConnectionCounter.class);
    private static final RingBuffer<Long> CONNECTION_COUNTER = new RingBuffer(29);

    public static void trackConnections() {
        Long oldestConnection;
        Long currentTime = System.currentTimeMillis();
        if (CONNECTION_COUNTER.count() == CONNECTION_COUNTER.maxSize() && (oldestConnection = (Long)CONNECTION_COUNTER.getTailItem()) > currentTime - 10000L) {
            LOGGER.debug("connection limit reached, throttling " + CONNECTION_COUNTER);
            try {
                Thread.sleep(11000L - (currentTime - oldestConnection));
            }
            catch (InterruptedException e) {
                LOGGER.warn(e.getMessage());
            }
        }
        currentTime = System.currentTimeMillis();
        CONNECTION_COUNTER.add((Object)currentTime);
    }
}

