/*
 * Decompiled with CFR 0.152.
 */
package org.japura.gui;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import javax.swing.JComponent;
import javax.swing.JLabel;
import org.japura.gui.renderer.HorizontalLineFactory;
import org.japura.gui.renderer.HorizontalLineRenderer;

public class LabelSeparator
extends JComponent {
    public static final Align LEFT = Align.LEFT;
    public static final Align RIGHT = Align.RIGHT;
    private JLabel label;
    private int leftSeparatorWidth = 10;
    private int rightSeparatorWidth = 30;
    private int separatorGap = 5;
    private Align align = Align.LEFT;
    private HorizontalLineRenderer lineRenderer;

    public LabelSeparator(String text) {
        this();
        this.label.setText(text);
    }

    public void setText(String text) {
        this.label.setText(text);
        this.revalidate();
    }

    public LabelSeparator() {
        this.setLayout(null);
        this.setOpaque(false);
        this.label = new JLabel();
        this.add(this.label);
        this.lineRenderer = HorizontalLineFactory.createLoweredEtchedLine();
    }

    @Override
    public final void setForeground(Color fg) {
        this.label.setForeground(fg);
    }

    @Override
    public final void setFont(Font font) {
        this.label.setFont(font);
    }

    @Override
    public final Font getFont() {
        return this.label.getFont();
    }

    @Override
    public final FontMetrics getFontMetrics(Font font) {
        return this.label.getFontMetrics(font);
    }

    public HorizontalLineRenderer getLineRenderer() {
        return this.lineRenderer;
    }

    public void setLineRenderer(HorizontalLineRenderer lineRenderer) {
        this.lineRenderer = lineRenderer;
    }

    public int getLeftSeparatorWidth() {
        return this.leftSeparatorWidth;
    }

    public final void setLeftSeparatorWidth(int leftSeparatorWidth) {
        this.leftSeparatorWidth = Math.max(0, leftSeparatorWidth);
    }

    public int getRightSeparatorWidth() {
        return this.rightSeparatorWidth;
    }

    public final void setRightSeparatorWidth(int rightSeparatorWidth) {
        this.rightSeparatorWidth = Math.max(0, rightSeparatorWidth);
    }

    public int getSeparatorGap() {
        return this.separatorGap;
    }

    public final void setSeparatorGap(int separatorGap) {
        this.separatorGap = Math.max(0, separatorGap);
    }

    public Align getAlign() {
        return this.align;
    }

    public void setAlign(Align align) {
        this.align = align;
    }

    @Override
    public Dimension getMinimumSize() {
        if (this.isMinimumSizeSet()) {
            return super.getMinimumSize();
        }
        boolean hasText = true;
        if (this.label.getText() == null || this.label.getText().length() == 0) {
            hasText = false;
        }
        Dimension dim = this.label.getMinimumSize();
        if (this.leftSeparatorWidth > 0) {
            dim.width += this.leftSeparatorWidth;
            if (hasText) {
                dim.width += this.separatorGap;
            }
        }
        if (this.rightSeparatorWidth > 0) {
            dim.width += this.rightSeparatorWidth;
            if (hasText) {
                dim.width += this.separatorGap;
            }
        }
        return dim;
    }

    @Override
    public final void doLayout() {
        int x = 0;
        if (this.align.equals((Object)Align.LEFT)) {
            if (this.leftSeparatorWidth > 0) {
                x = this.leftSeparatorWidth + this.separatorGap;
            }
        } else if (this.align.equals((Object)Align.RIGHT)) {
            x = this.getWidth();
            Font font = this.label.getFont();
            FontMetrics fm = this.label.getFontMetrics(font);
            x -= fm.stringWidth(this.label.getText());
            if (this.rightSeparatorWidth > 0) {
                x -= this.rightSeparatorWidth + this.separatorGap;
            }
        }
        this.label.setBounds(x, 0, this.getWidth(), this.getHeight());
    }

    @Override
    protected final void paintComponent(Graphics g) {
        Graphics2D g2d = (Graphics2D)g;
        if (this.isOpaque()) {
            g2d.setColor(this.getBackground());
            g2d.fillRect(0, 0, this.getWidth(), this.getHeight());
        }
        if (this.lineRenderer == null) {
            return;
        }
        boolean hasText = true;
        if (this.label.getText() == null || this.label.getText().length() == 0) {
            hasText = false;
        }
        Font font = this.label.getFont();
        FontMetrics fm = this.label.getFontMetrics(font);
        int y = this.getHeight() / 2;
        if (hasText) {
            int x = 0;
            if (this.align.equals((Object)Align.LEFT)) {
                if (this.leftSeparatorWidth > 0) {
                    x = this.leftSeparatorWidth;
                }
            } else if (this.align.equals((Object)Align.RIGHT)) {
                x = this.getWidth();
                x -= fm.stringWidth(this.label.getText());
                if (this.rightSeparatorWidth > 0) {
                    x -= this.separatorGap;
                    x -= this.rightSeparatorWidth;
                }
                if (this.getWidth() - x > 0) {
                    x -= this.separatorGap;
                }
            }
            if (x > 0) {
                this.lineRenderer.drawLine(g2d, 0, x, y);
                x += this.separatorGap;
            }
            this.lineRenderer.drawLine(g2d, x += this.separatorGap + fm.stringWidth(this.label.getText()), this.getWidth(), y);
        } else {
            this.lineRenderer.drawLine(g2d, 0, this.getWidth(), y);
        }
    }

    @Override
    public final Dimension getPreferredSize() {
        if (this.isPreferredSizeSet()) {
            return super.getPreferredSize();
        }
        boolean hasText = true;
        if (this.label.getText() == null || this.label.getText().length() == 0) {
            hasText = false;
        }
        Dimension dim = this.label.getPreferredSize();
        if (this.leftSeparatorWidth > 0) {
            dim.width += this.leftSeparatorWidth;
            if (hasText) {
                dim.width += this.separatorGap;
            }
        }
        if (this.rightSeparatorWidth > 0) {
            dim.width += this.separatorGap + this.rightSeparatorWidth;
            if (hasText) {
                dim.width += this.separatorGap;
            }
        }
        return dim;
    }

    public static enum Align {
        LEFT,
        RIGHT;

    }
}

