/*
 * Decompiled with CFR 0.152.
 */
package org.japura.gui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.util.LinkedHashMap;
import java.util.Random;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JScrollPane;
import org.japura.gui.Anchor;

public class Decorator
extends JLayeredPane {
    private static final long serialVersionUID = -3654610014150907569L;
    public static final Direction VERTICAL = Direction.VERTICAL;
    public static final Direction HORIZONTAL = Direction.HORIZONTAL;
    private LinkedHashMap<String, Component> decorations = new LinkedHashMap();
    private Component component;
    private Anchor anchor;
    private Direction direction;
    private Insets margin;
    private int gap = 3;

    public Decorator(Component component) {
        this(component, Anchor.SOUTH_EAST, Direction.HORIZONTAL);
    }

    public Decorator(Component component, Anchor anchor) {
        this(component, anchor, Direction.HORIZONTAL);
    }

    public Decorator(Component component, Anchor anchor, Direction direction) {
        this.component = component;
        this.anchor = anchor;
        this.direction = direction;
        this.margin = new Insets(0, 0, 0, 0);
        super.add(component);
        if (component instanceof JScrollPane) {
            JScrollPane sp = (JScrollPane)component;
            sp.getViewport().addComponentListener(new ComponentAdapter(){

                @Override
                public void componentResized(ComponentEvent arg0) {
                    Decorator.this.revalidate();
                }
            });
        }
    }

    public final Direction getDirection() {
        return this.direction;
    }

    public final void setDecorationVisible(String id, boolean visibled) {
        if (this.decorations.containsKey(id)) {
            this.decorations.get(id).setVisible(visibled);
        }
    }

    public final void setDecorationsVisible(boolean visibled) {
        for (String id : this.decorations.keySet()) {
            this.decorations.get(id).setVisible(visibled);
        }
    }

    public final void addDecoration(String id, ImageIcon image) {
        this.put(id, new JLabel(image));
    }

    public final String addDecoration(ImageIcon image) {
        return this.addWithRandomID(new JLabel(image));
    }

    public final void addDecoration(String id, Component component) {
        this.put(id, component);
    }

    public final String addDecoration(Component component) {
        return this.addWithRandomID(component);
    }

    public final void removeDecoration(String id) {
        if (this.decorations.containsKey(id)) {
            Component comp = (Component)this.decorations.remove(id);
            super.remove(comp);
        }
    }

    public final void removeDecorations() {
        for (Component c : this.decorations.values()) {
            super.remove(c);
        }
        this.decorations.clear();
    }

    private void put(String key, Component component) {
        if (key != null && !this.decorations.containsKey(key)) {
            this.decorations.put(key, component);
            super.add(component, (Object)(JLayeredPane.MODAL_LAYER - 1));
        }
    }

    public Component getComponent() {
        return this.component;
    }

    public Insets getMargin() {
        return this.margin;
    }

    public Anchor getAnchor() {
        return this.anchor;
    }

    public final void setMargin(Insets margin) {
        if (margin != null) {
            margin.bottom = Math.max(0, margin.bottom);
            margin.left = Math.max(0, margin.left);
            margin.right = Math.max(0, margin.right);
            margin.top = Math.max(0, margin.top);
            this.margin = margin;
        } else {
            this.margin = new Insets(0, 0, 0, 0);
        }
    }

    @Override
    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    @Override
    public final Dimension getPreferredSize() {
        Dimension dim = this.component.getPreferredSize();
        dim.height += this.margin.bottom + this.margin.top;
        dim.width += this.margin.left + this.margin.right;
        return dim;
    }

    @Override
    public final Component add(Component comp, int index) {
        this.addWithRandomID(comp);
        return null;
    }

    @Override
    public final void add(Component comp, Object constraints, int index) {
        this.addWithRandomID(comp);
    }

    @Override
    public final void add(Component comp, Object constraints) {
        this.addWithRandomID(comp);
    }

    @Override
    public final Component add(Component comp) {
        this.addWithRandomID(comp);
        return null;
    }

    @Override
    public final Component add(String name, Component comp) {
        this.addWithRandomID(comp);
        return null;
    }

    private String addWithRandomID(Component comp) {
        Random random = new Random();
        String id = Long.toString(random.nextLong());
        while (this.decorations.containsKey(id)) {
            id = Long.toString(random.nextLong());
        }
        this.addDecoration(id, comp);
        return id;
    }

    @Override
    public final void remove(Component comp) {
    }

    @Override
    public final void removeAll() {
    }

    @Override
    public final void doLayout() {
        block42: {
            Dimension cdim;
            Dimension dim;
            block40: {
                block49: {
                    block48: {
                        block47: {
                            Dimension cdim2;
                            int width;
                            block46: {
                                block45: {
                                    block44: {
                                        block43: {
                                            block41: {
                                                dim = this.getSize();
                                                this.component.setBounds(this.margin.left, this.margin.top, dim.width - (this.margin.left + this.margin.right), dim.height - (this.margin.bottom + this.margin.top));
                                                if (this.component instanceof JScrollPane) {
                                                    JScrollPane sp = (JScrollPane)this.component;
                                                    dim = sp.getSize();
                                                    if (sp.getVerticalScrollBar().isShowing()) {
                                                        dim.width -= sp.getVerticalScrollBar().getSize().width;
                                                    }
                                                    if (sp.getHorizontalScrollBar().isShowing()) {
                                                        dim.height -= sp.getHorizontalScrollBar().getSize().height;
                                                    }
                                                }
                                                if (!this.direction.equals((Object)Direction.HORIZONTAL)) break block40;
                                                int count = 0;
                                                width = 0;
                                                for (Component c : this.decorations.values()) {
                                                    if (!c.isVisible()) continue;
                                                    cdim2 = c.getPreferredSize();
                                                    width += cdim2.width;
                                                    ++count;
                                                }
                                                width += this.gap * (count - 1);
                                                if (!this.anchor.equals((Object)Anchor.CENTER)) break block41;
                                                int x = (dim.width - width) / 2;
                                                for (Component c : this.decorations.values()) {
                                                    if (!c.isVisible()) continue;
                                                    Dimension cdim3 = c.getPreferredSize();
                                                    int y = (dim.height - cdim3.height) / 2;
                                                    c.setBounds(x, y, cdim3.width, cdim3.height);
                                                    x += this.gap + cdim3.width;
                                                }
                                                break block42;
                                            }
                                            if (!this.anchor.equals((Object)Anchor.NORTH)) break block43;
                                            int x = (dim.width - width) / 2;
                                            for (Component c : this.decorations.values()) {
                                                if (!c.isVisible()) continue;
                                                Dimension cdim4 = c.getPreferredSize();
                                                c.setBounds(x, 0, cdim4.width, cdim4.height);
                                                x += this.gap + cdim4.width;
                                            }
                                            break block42;
                                        }
                                        if (!this.anchor.equals((Object)Anchor.SOUTH)) break block44;
                                        int x = (dim.width - width) / 2;
                                        for (Component c : this.decorations.values()) {
                                            if (!c.isVisible()) continue;
                                            Dimension cdim5 = c.getPreferredSize();
                                            c.setBounds(x, dim.height - cdim5.height - 1, cdim5.width, cdim5.height);
                                            x += this.gap + cdim5.width;
                                        }
                                        break block42;
                                    }
                                    if (!this.anchor.equals((Object)Anchor.EAST)) break block45;
                                    for (Component c : this.decorations.values()) {
                                        if (!c.isVisible()) continue;
                                        cdim2 = c.getPreferredSize();
                                        int x = dim.width - width - 1;
                                        int y = (dim.height - cdim2.height) / 2;
                                        c.setBounds(x, y, cdim2.width, cdim2.height);
                                        width -= this.gap + cdim2.width;
                                    }
                                    break block42;
                                }
                                if (!this.anchor.equals((Object)Anchor.NORTH_EAST)) break block46;
                                for (Component c : this.decorations.values()) {
                                    if (!c.isVisible()) continue;
                                    cdim2 = c.getPreferredSize();
                                    int x = dim.width - width - 1;
                                    c.setBounds(x, 0, cdim2.width, cdim2.height);
                                    width -= this.gap + cdim2.width;
                                }
                                break block42;
                            }
                            if (!this.anchor.equals((Object)Anchor.SOUTH_EAST)) break block47;
                            for (Component c : this.decorations.values()) {
                                if (!c.isVisible()) continue;
                                cdim2 = c.getPreferredSize();
                                int x = dim.width - width - 1;
                                int y = dim.height - cdim2.height - 1;
                                c.setBounds(x, y, cdim2.width, cdim2.height);
                                width -= this.gap + cdim2.width;
                            }
                            break block42;
                        }
                        if (!this.anchor.equals((Object)Anchor.WEST)) break block48;
                        int x = 0;
                        for (Component c : this.decorations.values()) {
                            if (!c.isVisible()) continue;
                            Dimension cdim6 = c.getPreferredSize();
                            int y = (dim.height - cdim6.height) / 2;
                            c.setBounds(x, y, cdim6.width, cdim6.height);
                            x += this.gap + cdim6.width;
                        }
                        break block42;
                    }
                    if (!this.anchor.equals((Object)Anchor.NORTH_WEST)) break block49;
                    int x = 0;
                    for (Component c : this.decorations.values()) {
                        if (!c.isVisible()) continue;
                        Dimension cdim7 = c.getPreferredSize();
                        c.setBounds(x, 0, cdim7.width, cdim7.height);
                        x += this.gap + cdim7.width;
                    }
                    break block42;
                }
                if (!this.anchor.equals((Object)Anchor.SOUTH_WEST)) break block42;
                int x = 0;
                for (Component c : this.decorations.values()) {
                    if (!c.isVisible()) continue;
                    Dimension cdim8 = c.getPreferredSize();
                    c.setBounds(x, dim.height - cdim8.height - 1, cdim8.width, cdim8.height);
                    x += this.gap + cdim8.width;
                }
                break block42;
            }
            int count = 0;
            int height = 0;
            for (Component c : this.decorations.values()) {
                if (!c.isVisible()) continue;
                cdim = c.getPreferredSize();
                height += cdim.height;
                ++count;
            }
            height += this.gap * (count - 1);
            if (this.anchor.equals((Object)Anchor.SOUTH_EAST)) {
                for (Component c : this.decorations.values()) {
                    if (!c.isVisible()) continue;
                    cdim = c.getPreferredSize();
                    c.setBounds(dim.width - cdim.width - 1, dim.height - height - 1, cdim.width, cdim.height);
                    height -= this.gap + cdim.height;
                }
            } else if (this.anchor.equals((Object)Anchor.EAST)) {
                int y = (dim.height - height) / 2;
                for (Component c : this.decorations.values()) {
                    if (!c.isVisible()) continue;
                    Dimension cdim9 = c.getPreferredSize();
                    c.setBounds(dim.width - cdim9.width - 1, y, cdim9.width, cdim9.height);
                    y += this.gap + cdim9.height;
                }
            } else if (this.anchor.equals((Object)Anchor.NORTH_EAST)) {
                int y = 0;
                for (Component c : this.decorations.values()) {
                    if (!c.isVisible()) continue;
                    Dimension cdim10 = c.getPreferredSize();
                    c.setBounds(dim.width - cdim10.width - 1, y, cdim10.width, cdim10.height);
                    y += this.gap + cdim10.height;
                }
            } else if (this.anchor.equals((Object)Anchor.SOUTH)) {
                for (Component c : this.decorations.values()) {
                    if (!c.isVisible()) continue;
                    cdim = c.getPreferredSize();
                    int x = (dim.width - cdim.width) / 2;
                    c.setBounds(x, dim.height - height - 1, cdim.width, cdim.height);
                    height -= this.gap + cdim.height;
                }
            } else if (this.anchor.equals((Object)Anchor.CENTER)) {
                int y = (dim.height - height) / 2;
                for (Component c : this.decorations.values()) {
                    if (!c.isVisible()) continue;
                    Dimension cdim11 = c.getPreferredSize();
                    int x = (dim.width - cdim11.width) / 2;
                    c.setBounds(x, y, cdim11.width, cdim11.height);
                    y += this.gap + cdim11.height;
                }
            } else if (this.anchor.equals((Object)Anchor.NORTH)) {
                int y = 0;
                for (Component c : this.decorations.values()) {
                    if (!c.isVisible()) continue;
                    Dimension cdim12 = c.getPreferredSize();
                    int x = (dim.width - cdim12.width) / 2;
                    c.setBounds(x, y, cdim12.width, cdim12.height);
                    y += this.gap + cdim12.height;
                }
            } else if (this.anchor.equals((Object)Anchor.SOUTH_WEST)) {
                for (Component c : this.decorations.values()) {
                    if (!c.isVisible()) continue;
                    cdim = c.getPreferredSize();
                    c.setBounds(0, dim.height - height - 1, cdim.width, cdim.height);
                    height -= this.gap + cdim.height;
                }
            } else if (this.anchor.equals((Object)Anchor.WEST)) {
                int y = (dim.height - height) / 2;
                for (Component c : this.decorations.values()) {
                    if (!c.isVisible()) continue;
                    Dimension cdim13 = c.getPreferredSize();
                    c.setBounds(0, y, cdim13.width, cdim13.height);
                    y += this.gap + cdim13.height;
                }
            } else if (this.anchor.equals((Object)Anchor.NORTH_WEST)) {
                int y = 0;
                for (Component c : this.decorations.values()) {
                    if (!c.isVisible()) continue;
                    Dimension cdim14 = c.getPreferredSize();
                    c.setBounds(0, y, cdim14.width, cdim14.height);
                    y += this.gap + cdim14.height;
                }
            }
        }
    }

    public static enum Direction {
        VERTICAL,
        HORIZONTAL;

    }
}

