/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.getdown.util;

import com.a.c.s;
import com.threerings.getdown.Log;
import com.threerings.getdown.util.FileUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConfigUtil {
    public static List<String[]> parsePairs(File file, boolean bl) throws IOException {
        return ConfigUtil.parsePairs(new InputStreamReader((InputStream)new FileInputStream(file), "UTF-8"), bl);
    }

    public static List<String[]> parsePairs(Reader reader, boolean bl) throws IOException {
        return ConfigUtil.parsePairs(reader, bl ? s.c(System.getProperty("os.name")).toLowerCase() : null, bl ? s.c(System.getProperty("os.arch")).toLowerCase() : null);
    }

    public static Map<String, Object> parseConfig(File object, boolean bl) throws IOException {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        for (String[] stringArray : ConfigUtil.parsePairs((File)object, bl)) {
            Object object2 = hashMap.get(stringArray[0]);
            if (object2 == null) {
                hashMap.put(stringArray[0], stringArray[1]);
                continue;
            }
            if (object2 instanceof String) {
                hashMap.put(stringArray[0], new String[]{(String)object2, stringArray[1]});
                continue;
            }
            if (!(object2 instanceof String[])) continue;
            object2 = (String[])object2;
            String[] stringArray2 = new String[((String[])object2).length + 1];
            System.arraycopy(object2, 0, stringArray2, 0, ((V)object2).length);
            stringArray2[((V)object2).length] = stringArray[1];
            hashMap.put(stringArray[0], stringArray2);
        }
        return hashMap;
    }

    public static String[] getMultiValue(Map<String, Object> object, String string) {
        if ((object = object.get(string)) instanceof String) {
            return new String[]{(String)object};
        }
        return (String[])object;
    }

    protected static List<String[]> parsePairs(Reader object, String string, String string2) throws IOException {
        ArrayList<String[]> arrayList = new ArrayList<String[]>();
        for (String string3 : FileUtil.readLines((Reader)object)) {
            int n2 = string3.indexOf("#");
            if (n2 != -1) {
                string3 = string3.substring(0, n2);
            }
            if (s.a(string3 = string3.trim())) continue;
            String[] stringArray = new String[2];
            int n3 = string3.indexOf("=");
            if (n3 != -1) {
                stringArray[0] = string3.substring(0, n3).trim();
                stringArray[1] = string3.substring(n3 + 1).trim();
            } else {
                stringArray[0] = string3;
                stringArray[1] = "";
            }
            if (stringArray[1].startsWith("[")) {
                int n4 = stringArray[1].indexOf("]");
                if (n4 == -1) {
                    Log.log.b("Bogus platform specifier", "key", stringArray[0], "value", stringArray[1]);
                    continue;
                }
                String string4 = stringArray[1].substring(1, n4);
                if (string != null && !ConfigUtil.checkQualifiers(string4, string, string2)) {
                    Log.log.a("Skipping", "quals", string4, "osname", string, "osarch", string2, "key", stringArray[0], "value", stringArray[1]);
                    continue;
                }
                stringArray[1] = stringArray[1].substring(n4 + 1).trim();
            }
            arrayList.add(stringArray);
        }
        return arrayList;
    }

    protected static boolean checkQualifiers(String stringArray, String string, String string2) {
        if (stringArray.startsWith("!")) {
            if (stringArray.indexOf(",") != -1) {
                Log.log.b("Multiple qualifiers cannot be used when one of the qualifiers is negative", "quals", stringArray);
                return false;
            }
            return !ConfigUtil.checkQualifier(stringArray.substring(1), string, string2);
        }
        for (String string3 : stringArray.split(",")) {
            if (!ConfigUtil.checkQualifier(string3, string, string2)) continue;
            return true;
        }
        return false;
    }

    protected static boolean checkQualifier(String object, String string, String string2) {
        object = object.trim().toLowerCase().split("-");
        String string3 = object[0];
        Object object2 = object = ((String[])object).length > 1 ? object[1] : "";
        return string.indexOf(string3) != -1 && string2.indexOf((String)object) != -1;
    }
}

