/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.scraper;

import java.lang.reflect.Field;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.ReflectionToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.tinymediamanager.scraper.MediaMetadata;
import org.tinymediamanager.scraper.entities.MediaType;
import org.tinymediamanager.scraper.util.MetadataUtil;
import org.tinymediamanager.scraper.util.StrgUtils;

public class MediaSearchResult
implements Comparable<MediaSearchResult> {
    private String providerId;
    private String url;
    private String title;
    private int year;
    private String originalTitle;
    private String id;
    private float score;
    private String imdbId;
    private MediaMetadata metadata = null;
    private MediaType type;
    private String posterUrl;

    public MediaSearchResult(String providerId, MediaType type) {
        this.providerId = providerId;
        this.type = type;
    }

    public MediaSearchResult(String providerId, MediaType type, float score) {
        this.providerId = providerId;
        this.type = type;
        this.score = score;
    }

    public MediaSearchResult(String providerId, MediaType type, String id, String title, int year, float score) {
        this.providerId = providerId;
        this.type = type;
        this.id = StrgUtils.getNonNullString(id);
        this.title = StrgUtils.getNonNullString(title);
        this.year = year;
        this.score = score;
    }

    public void mergeFrom(MediaSearchResult msr) {
        if (msr == null) {
            return;
        }
        this.url = StringUtils.isEmpty((CharSequence)this.url) ? msr.getUrl() : this.url;
        this.title = StringUtils.isEmpty((CharSequence)this.title) ? msr.getTitle() : this.title;
        this.year = this.year == 0 ? msr.getYear() : this.year;
        this.originalTitle = StringUtils.isEmpty((CharSequence)this.originalTitle) ? msr.getOriginalTitle() : this.originalTitle;
        this.id = StringUtils.isEmpty((CharSequence)this.id) ? msr.getId() : this.id;
        this.imdbId = StringUtils.isEmpty((CharSequence)this.imdbId) ? msr.getIMDBId() : this.imdbId;
        String string = this.posterUrl = StringUtils.isEmpty((CharSequence)this.posterUrl) ? msr.getPosterUrl() : this.posterUrl;
        if (this.metadata == null) {
            this.metadata = msr.getMediaMetadata();
        } else {
            this.metadata.mergeFrom(msr.getMediaMetadata());
        }
    }

    public String getOriginalTitle() {
        return this.originalTitle;
    }

    public void setOriginalTitle(String originalTitle) {
        this.originalTitle = StrgUtils.getNonNullString(originalTitle);
    }

    public String getProviderId() {
        return this.providerId;
    }

    public void setProviderId(String providerId) {
        this.providerId = providerId;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = StrgUtils.getNonNullString(title);
    }

    public int getYear() {
        return this.year;
    }

    public void setYear(int year) {
        this.year = year;
    }

    public void setYear(Integer year) {
        if (year != null) {
            this.setYear((int)year);
        }
    }

    public float getScore() {
        return this.score;
    }

    public void setScore(float score) {
        this.score = score;
    }

    public void setScore(Float score) {
        if (score != null) {
            this.setScore(score.floatValue());
        }
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = StrgUtils.getNonNullString(url);
    }

    public MediaType getMediaType() {
        return this.type;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = StrgUtils.getNonNullString(id);
    }

    public String getIMDBId() {
        return this.imdbId;
    }

    public void setIMDBId(String imdbid) {
        if (MetadataUtil.isValidImdbId(imdbid)) {
            this.imdbId = imdbid;
        }
    }

    public MediaMetadata getMediaMetadata() {
        return this.metadata;
    }

    public void setMetadata(MediaMetadata md) {
        this.metadata = md;
    }

    public String getPosterUrl() {
        return this.posterUrl;
    }

    public void setPosterUrl(String posterUrl) {
        this.posterUrl = StrgUtils.getNonNullString(posterUrl);
    }

    @Override
    public int compareTo(MediaSearchResult arg0) {
        if (this.getScore() < arg0.getScore()) {
            return -1;
        }
        if (this.getScore() == arg0.getScore()) {
            int y2;
            int y1 = this.getYear();
            if (y1 > (y2 = arg0.getYear())) {
                return 1;
            }
            return -1;
        }
        return 1;
    }

    public String toString() {
        return new ReflectionToStringBuilder(this, ToStringStyle.SHORT_PREFIX_STYLE){

            protected boolean accept(Field f) {
                return super.accept(f) && !f.getName().equals("metadata");
            }
        }.toString();
    }
}

