/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.scraper;

import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Comparator;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DynaComparator
implements Comparator,
Serializable {
    private static final long serialVersionUID = -1L;
    private static final Logger LOGGER = LoggerFactory.getLogger(DynaComparator.class);
    private static final int LESSER = -1;
    private static final int EQUAL = 0;
    private static final int GREATER = 1;
    private String targetMethod;
    private boolean sortAscending;

    public DynaComparator(boolean sortAscending) {
        this.targetMethod = null;
        this.sortAscending = sortAscending;
    }

    public DynaComparator(String getterMethod) {
        this.targetMethod = getterMethod;
        this.sortAscending = true;
    }

    public DynaComparator(String getterMethod, boolean sortAscending) {
        this.targetMethod = getterMethod;
        this.sortAscending = sortAscending;
    }

    public int compare(Object o1, Object o2) {
        int response = -1;
        try {
            Object v1 = null == this.targetMethod ? o1 : this.getValue(o1);
            Object v2 = null == this.targetMethod ? o2 : this.getValue(o2);
            CompareMode cm = this.findCompareMode(v1, v2);
            if (!cm.equals((Object)CompareMode.DEFAULT)) {
                return this.compareAlternate(cm);
            }
            String returnType = null == this.targetMethod ? o1.getClass().getName() : this.getMethod(o1).getReturnType().getName();
            response = this.compareActual(v1, v2, returnType);
        }
        catch (NoSuchMethodException nsme) {
            LOGGER.error("NoSuchMethodException occurred while comparing", (Throwable)nsme);
        }
        catch (IllegalAccessException iae) {
            LOGGER.error("IllegalAccessException occurred while comparing", (Throwable)iae);
        }
        catch (InvocationTargetException ite) {
            LOGGER.error("InvocationTargetException occurred while comparing", (Throwable)ite);
        }
        return response;
    }

    private int compareAlternate(CompareMode cm) {
        int compareState = -1;
        switch (cm) {
            case LESS_THAN: {
                compareState = -1 * this.determinePosition();
                break;
            }
            case GREATER_THAN: {
                compareState = 1 * this.determinePosition();
                break;
            }
            case EQUAL: {
                compareState = 0 * this.determinePosition();
            }
        }
        return compareState;
    }

    private int compareActual(Object v1, Object v2, String returnType) {
        int acutal = -1;
        switch (returnType) {
            case "int": 
            case "java.lang.Integer": {
                acutal = ((Integer)v1).compareTo((Integer)v2) * this.determinePosition();
                break;
            }
            case "boolean": 
            case "java.lang.Boolean": {
                acutal = ((Boolean)v1).compareTo((Boolean)v2) * this.determinePosition();
                break;
            }
            case "java.lang.String": {
                acutal = ((String)v1).compareTo((String)v2) * this.determinePosition();
                break;
            }
            case "java.util.Date": {
                acutal = ((Date)v1).compareTo((Date)v2) * this.determinePosition();
                break;
            }
            case "java.lang.Long": {
                acutal = ((Long)v1).compareTo((Long)v2) * this.determinePosition();
                break;
            }
            case "java.lang.Float": {
                acutal = ((Float)v1).compareTo((Float)v2) * this.determinePosition();
                break;
            }
            case "java.lang.Double": {
                acutal = ((Double)v1).compareTo((Double)v2) * this.determinePosition();
                break;
            }
        }
        return acutal;
    }

    private final Method getMethod(Object obj) throws NoSuchMethodException {
        return obj.getClass().getMethod(this.targetMethod, null);
    }

    private static final Object invoke(Method method, Object obj) throws InvocationTargetException, IllegalAccessException {
        return method.invoke(obj, null);
    }

    private Object getValue(Object obj) throws InvocationTargetException, IllegalAccessException, NoSuchMethodException {
        return DynaComparator.invoke(this.getMethod(obj), obj);
    }

    private CompareMode findCompareMode(Object o1, Object o2) {
        CompareMode cm = CompareMode.LESS_THAN;
        if (null != o1 & null != o2) {
            cm = CompareMode.DEFAULT;
        } else if (null == o1 & null != o2) {
            cm = CompareMode.LESS_THAN;
        } else if (null != o1 & null == o2) {
            cm = CompareMode.GREATER_THAN;
        } else if (null == o1 & null == o2) {
            cm = CompareMode.EQUAL;
        }
        return cm;
    }

    private int determinePosition() {
        return this.sortAscending ? 1 : -1;
    }

    private static enum CompareMode {
        EQUAL,
        LESS_THAN,
        GREATER_THAN,
        DEFAULT;

    }
}

