/*
 * Decompiled with CFR 0.152.
 */
package net.xeoh.plugins.informationbroker.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Logger;
import net.xeoh.plugins.base.Option;
import net.xeoh.plugins.base.annotations.PluginImplementation;
import net.xeoh.plugins.base.annotations.meta.Author;
import net.xeoh.plugins.base.util.OptionUtils;
import net.xeoh.plugins.informationbroker.InformationBroker;
import net.xeoh.plugins.informationbroker.InformationItem;
import net.xeoh.plugins.informationbroker.InformationListener;
import net.xeoh.plugins.informationbroker.options.PublishOption;
import net.xeoh.plugins.informationbroker.options.SubscribeOption;
import net.xeoh.plugins.informationbroker.options.publish.OptionSilentPublish;
import net.xeoh.plugins.informationbroker.options.subscribe.OptionInstantRequest;

@Author(name="Ralf Biedert")
@PluginImplementation
public class InformationBrokerImpl
implements InformationBroker {
    final Map<Class<? extends InformationItem<?>>, KeyEntry> items = new HashMap();
    final Lock itemsLock = new ReentrantLock();
    final Logger logger = Logger.getLogger(this.getClass().getName());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> void publish(Class<? extends InformationItem<T>> channel, T item, PublishOption ... options) {
        if (channel == null || item == null) {
            return;
        }
        OptionUtils ou = new OptionUtils((Option[])options);
        boolean silentPublish = ou.contains(OptionSilentPublish.class);
        KeyEntry keyEntry = this.getKeyEntry(channel);
        try {
            keyEntry.entryLock.lock();
            keyEntry.lastItem = item;
            if (!silentPublish) {
                for (InformationListener<?> listener : keyEntry.allListeners) {
                    try {
                        listener.update(item);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        finally {
            keyEntry.entryLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> void subscribe(Class<? extends InformationItem<T>> id, InformationListener<T> listener, SubscribeOption ... options) {
        if (id == null || listener == null) {
            return;
        }
        OptionUtils ou = new OptionUtils((Option[])options);
        boolean instantRequest = ou.contains(OptionInstantRequest.class);
        KeyEntry keyEntry = this.getKeyEntry(id);
        try {
            keyEntry.entryLock.lock();
            if (!instantRequest) {
                keyEntry.allListeners.add(listener);
            }
            if (keyEntry.lastItem != null) {
                listener.update(keyEntry.lastItem);
            }
        }
        finally {
            keyEntry.entryLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unsubscribe(InformationListener<?> listener) {
        if (listener == null) {
            return;
        }
        this.itemsLock.lock();
        try {
            Set<Class<InformationItem<?>>> keySet = this.items.keySet();
            for (Class<? extends InformationItem<?>> clazz : keySet) {
                KeyEntry keyEntry = this.items.get(clazz);
                keyEntry.entryLock.lock();
                try {
                    keyEntry.allListeners.remove(listener);
                }
                finally {
                    keyEntry.entryLock.unlock();
                }
            }
        }
        finally {
            this.itemsLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private KeyEntry getKeyEntry(Class<? extends InformationItem<?>> id) {
        KeyEntry keyEntry = null;
        this.itemsLock.lock();
        try {
            keyEntry = this.items.get(id);
            if (keyEntry == null) {
                keyEntry = new KeyEntry();
                this.items.put(id, keyEntry);
            }
        }
        finally {
            this.itemsLock.unlock();
        }
        return keyEntry;
    }

    class KeyEntry {
        final Lock entryLock = new ReentrantLock();
        final Collection<InformationListener<?>> allListeners = new ArrayList();
        Object lastItem = null;

        KeyEntry() {
        }
    }
}

