/*
 * Decompiled with CFR 0.152.
 */
package net.xeoh.nexus;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import net.xeoh.nexus.Nexus;
import net.xeoh.nexus.Service;
import net.xeoh.nexus.ServiceListener;

public class DefaultNexus
implements Nexus {
    final ConcurrentLinkedQueue<Service> services = new ConcurrentLinkedQueue();
    final ConcurrentLinkedQueue<ServiceListener> serviceListeners = new ConcurrentLinkedQueue();
    final Map<Class<?>, ConcurrentLinkedQueue<Service>> cache = new ConcurrentHashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ConcurrentLinkedQueue<Service> queueFor(Class<?> clazz) {
        Map<Class<?>, ConcurrentLinkedQueue<Service>> map = this.cache;
        synchronized (map) {
            ConcurrentLinkedQueue<Service> concurrentLinkedQueue = this.cache.get(clazz);
            if (concurrentLinkedQueue != null) {
                return concurrentLinkedQueue;
            }
            ConcurrentLinkedQueue<Service> concurrentLinkedQueue2 = new ConcurrentLinkedQueue<Service>();
            this.cache.put(clazz, concurrentLinkedQueue2);
            return concurrentLinkedQueue2;
        }
    }

    private static boolean satisfiesCondition(Service service, Class<?> clazz, Nexus.Get ... getArray) {
        return clazz == null || clazz.isAssignableFrom(service.getService().getClass());
    }

    private static Service findService(ConcurrentLinkedQueue<Service> concurrentLinkedQueue, Class<?> clazz, Nexus.Get ... getArray) {
        if (clazz == null && (getArray == null || getArray.length == 0)) {
            return concurrentLinkedQueue.peek();
        }
        for (Service service : concurrentLinkedQueue) {
            if (!DefaultNexus.satisfiesCondition(service, clazz, getArray)) continue;
            return service;
        }
        return null;
    }

    private static Collection<Service> findServices(ConcurrentLinkedQueue<Service> concurrentLinkedQueue, Class<?> clazz, Nexus.Get ... getArray) {
        if (clazz == null && (getArray == null || getArray.length == 0)) {
            return concurrentLinkedQueue;
        }
        LinkedList<Service> linkedList = new LinkedList<Service>();
        for (Service service : concurrentLinkedQueue) {
            if (!DefaultNexus.satisfiesCondition(service, clazz, getArray)) continue;
            linkedList.add(service);
        }
        return linkedList;
    }

    public Nexus register(Service service) {
        this.services.add(service);
        for (ServiceListener serviceListener : this.serviceListeners) {
            serviceListener.serviceRegistered(service);
        }
        return this;
    }

    public Nexus deregister(Service service) {
        this.services.remove(service);
        for (ConcurrentLinkedQueue<Service> object : this.cache.values()) {
            Iterator<Service> iterator = object.iterator();
            while (iterator.hasNext()) {
                Service service2 = iterator.next();
                if (!service2.equals(service)) continue;
                iterator.remove();
            }
        }
        for (ServiceListener serviceListener : this.serviceListeners) {
            serviceListener.serviceDeregistered(service);
        }
        return this;
    }

    @Override
    public Collection<Service> list() {
        return new ArrayList<Service>(this.services);
    }

    @Override
    public Nexus register(Collection<? extends Service> collection) {
        for (Service service : collection) {
            this.register(service);
        }
        return this;
    }

    @Override
    public Nexus deregister(Collection<? extends Service> collection) {
        for (Service service : collection) {
            this.deregister(service);
        }
        return this;
    }

    @Override
    public <T> T get(Class<T> clazz, Nexus.Get ... getArray) {
        ConcurrentLinkedQueue<Service> concurrentLinkedQueue = this.queueFor(clazz);
        Service service = DefaultNexus.findService(concurrentLinkedQueue, null, getArray);
        if (service != null) {
            return (T)service.getService();
        }
        Service service2 = DefaultNexus.findService(this.services, clazz, getArray);
        if (service2 == null) {
            return null;
        }
        concurrentLinkedQueue.add(service2);
        return (T)service2.getService();
    }

    @Override
    public Nexus addServiceListener(ServiceListener serviceListener) {
        this.serviceListeners.add(serviceListener);
        return this;
    }

    @Override
    public Nexus removeServiceListener(ServiceListener serviceListener) {
        this.serviceListeners.remove(serviceListener);
        return this;
    }

    @Override
    public <T> Collection<T> getAll(Class<T> clazz, Nexus.Get ... getArray) {
        Collection<Service> collection = DefaultNexus.findServices(this.services, clazz, getArray);
        ArrayList<Object> arrayList = new ArrayList<Object>(collection.size());
        for (Service service : collection) {
            arrayList.add(service.getService());
        }
        return arrayList;
    }
}

