/*
 * Decompiled with CFR 0.152.
 */
package net.jcores.jre.utils.internal;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.lang.reflect.Field;
import java.nio.ByteBuffer;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import net.jcores.jre.CommonCore;
import net.jcores.jre.cores.Core;
import net.jcores.jre.cores.CoreObject;
import net.jcores.jre.options.MessageType;

public class Streams {
    public static void doUnzip(InputStream inputStream, String string) throws IOException {
        ArrayList<String> arrayList = new ArrayList<String>();
        File file = new File(string);
        file.mkdirs();
        ZipInputStream zipInputStream = (ZipInputStream)(inputStream instanceof ZipInputStream ? inputStream : new ZipInputStream(inputStream));
        ZipEntry zipEntry = zipInputStream.getNextEntry();
        while (zipEntry != null) {
            String string2 = zipEntry.getName();
            File file2 = new File(file, string2);
            if (string2.endsWith(".zip")) {
                arrayList.add(file2.getAbsolutePath());
            }
            File file3 = file2.getParentFile();
            file3.mkdirs();
            try {
                if (!zipEntry.isDirectory()) {
                    int n;
                    BufferedInputStream bufferedInputStream = new BufferedInputStream(zipInputStream);
                    byte[] byArray = new byte[8192];
                    FileOutputStream fileOutputStream = new FileOutputStream(file2);
                    BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(fileOutputStream, 8192);
                    while ((n = bufferedInputStream.read(byArray, 0, 8192)) != -1) {
                        bufferedOutputStream.write(byArray, 0, n);
                    }
                    bufferedOutputStream.flush();
                    bufferedOutputStream.close();
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            zipEntry = zipInputStream.getNextEntry();
        }
        zipInputStream.close();
    }

    public static String readText(CommonCore commonCore, InputStream inputStream) {
        try {
            String string;
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream, "UTF-8"));
            StringBuilder stringBuilder = new StringBuilder();
            while ((string = bufferedReader.readLine()) != null) {
                stringBuilder.append(string);
                stringBuilder.append("\n");
            }
            return stringBuilder.toString();
        }
        catch (IOException iOException) {
            commonCore.report(MessageType.EXCEPTION, "Error reading from stream " + inputStream);
            return null;
        }
    }

    public static InputStream getInputStream(ZipInputStream zipInputStream, String string) throws IOException {
        ZipEntry zipEntry = zipInputStream.getNextEntry();
        while (zipEntry != null) {
            String string2 = zipEntry.getName();
            if (!string2.equals(string)) {
                zipEntry = zipInputStream.getNextEntry();
                continue;
            }
            return new BufferedInputStream(zipInputStream);
        }
        return null;
    }

    public static List<String> list(ZipInputStream zipInputStream) throws IOException {
        ArrayList<String> arrayList = new ArrayList<String>();
        ZipEntry zipEntry = zipInputStream.getNextEntry();
        while (zipEntry != null) {
            arrayList.add(zipEntry.getName());
            zipEntry = zipInputStream.getNextEntry();
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String generateHash(InputStream inputStream, String string) {
        try {
            MessageDigest messageDigest = MessageDigest.getInstance(string);
            byte[] byArray = new byte[0x100000];
            int n = inputStream.available();
            while (n > 0) {
                n = Math.min(n, byArray.length);
                inputStream.read(byArray, 0, n);
                messageDigest.update(byArray, 0, n);
                n = inputStream.available();
            }
            byte[] byArray2 = messageDigest.digest();
            StringBuilder stringBuilder = new StringBuilder();
            Object object = byArray2;
            int n2 = ((byte[])object).length;
            int n3 = 0;
            while (true) {
                if (n3 >= n2) {
                    inputStream.close();
                    object = stringBuilder.toString().substring(0, stringBuilder.toString().length());
                    return object;
                }
                byte by = object[n3];
                String string2 = String.format("%02x", by);
                stringBuilder.append(string2);
                ++n3;
            }
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            noSuchAlgorithmException.printStackTrace();
            return null;
        }
        catch (FileNotFoundException fileNotFoundException) {
            return null;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return null;
        }
    }

    public static void saveTo(InputStream inputStream, File file) {
        FileOutputStream fileOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream(file);
        }
        catch (FileNotFoundException fileNotFoundException) {
            return;
        }
        byte[] byArray = new byte[0x100000];
        int n = 1;
        while (n > 0) {
            try {
                n = inputStream.read(byArray, 0, byArray.length);
                if (n <= 0) break;
                fileOutputStream.write(byArray, 0, n);
            }
            catch (IOException iOException) {
                n = 0;
            }
        }
        try {
            fileOutputStream.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static ByteBuffer getByteData(InputStream inputStream) {
        byte[] byArray = new byte[0x100000];
        byte[] byArray2 = new byte[0x100000];
        try {
            int n = 0;
            int n2 = inputStream.read(byArray2);
            while (n2 > 0) {
                if (n + n2 > byArray.length) {
                    byte[] byArray3 = new byte[n + 0x100000];
                    System.arraycopy(byArray, 0, byArray3, 0, n);
                    byArray = byArray3;
                }
                System.arraycopy(byArray, n, byArray2, 0, n2);
                n += n2;
                n2 = inputStream.read(byArray2);
            }
            return ByteBuffer.wrap(byArray, 0, n);
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public static void serializeCore(CoreObject<?> coreObject, FileOutputStream fileOutputStream) {
        try {
            GZIPOutputStream gZIPOutputStream = new GZIPOutputStream(fileOutputStream);
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(gZIPOutputStream);
            objectOutputStream.writeObject(coreObject);
            objectOutputStream.close();
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public static <T> CoreObject<T> deserializeCore(Class<T> clazz, InputStream inputStream, CommonCore commonCore) {
        try {
            GZIPInputStream gZIPInputStream = new GZIPInputStream(inputStream);
            ObjectInputStream objectInputStream = new ObjectInputStream(gZIPInputStream);
            CoreObject coreObject = (CoreObject)objectInputStream.readObject();
            Field field = Core.class.getDeclaredField("commonCore");
            field.setAccessible(true);
            field.set(coreObject, commonCore);
            return coreObject;
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        catch (ClassNotFoundException classNotFoundException) {
            classNotFoundException.printStackTrace();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            illegalArgumentException.printStackTrace();
        }
        catch (IllegalAccessException illegalAccessException) {
            illegalAccessException.printStackTrace();
        }
        catch (SecurityException securityException) {
            securityException.printStackTrace();
        }
        catch (NoSuchFieldException noSuchFieldException) {
            noSuchFieldException.printStackTrace();
        }
        return null;
    }
}

