/*
 * Decompiled with CFR 0.152.
 */
package net.jcores.jre.utils.internal;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.SourceDataLine;
import javax.sound.sampled.UnsupportedAudioFileException;
import net.jcores.jre.utils.internal.Options;

public class Sound {
    private static final int EXTERNAL_BUFFER_SIZE = 524288;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void playSound(AudioInputStream audioInputStream, Options options) {
        AudioFormat audioFormat = audioInputStream.getFormat();
        SourceDataLine sourceDataLine = null;
        DataLine.Info info = new DataLine.Info(SourceDataLine.class, audioFormat);
        try {
            sourceDataLine = (SourceDataLine)AudioSystem.getLine(info);
            sourceDataLine.open(audioFormat);
        }
        catch (LineUnavailableException lineUnavailableException) {
            options.failure(null, lineUnavailableException, "playsound:noline", "Error opening output line.");
            return;
        }
        catch (Exception exception) {
            options.failure(null, exception, "playsound:unknown", "General error opening output line.");
            return;
        }
        sourceDataLine.start();
        int n = 0;
        byte[] byArray = new byte[524288];
        try {
            while (n != -1) {
                n = audioInputStream.read(byArray, 0, byArray.length);
                if (n < 0) continue;
                sourceDataLine.write(byArray, 0, n);
            }
        }
        catch (IOException iOException) {
            options.failure(audioInputStream, iOException, "playsound:read", "Error getting sound data.");
            return;
        }
        finally {
            sourceDataLine.drain();
            sourceDataLine.close();
        }
    }

    public static AudioInputStream getStream(File file) {
        try {
            return Sound.getStream(new BufferedInputStream(new FileInputStream(file)));
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return null;
        }
    }

    public static AudioInputStream getStream(InputStream inputStream) {
        try {
            return AudioSystem.getAudioInputStream(new BufferedInputStream(inputStream));
        }
        catch (UnsupportedAudioFileException unsupportedAudioFileException) {
            unsupportedAudioFileException.printStackTrace();
            return null;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return null;
        }
    }
}

