/*
 * Decompiled with CFR 0.152.
 */
package net.jcores.jre.cores.commons;

import java.io.File;
import java.io.IOException;
import java.util.UUID;
import java.util.concurrent.Future;
import java.util.prefs.Preferences;
import net.jcores.jre.CommonCore;
import net.jcores.jre.annotations.SupportsOption;
import net.jcores.jre.cores.commons.CommonNamespace;
import net.jcores.jre.interfaces.functions.F0;
import net.jcores.jre.options.ID;
import net.jcores.jre.options.KillSwitch;
import net.jcores.jre.options.Option;
import net.jcores.jre.utils.internal.Options;

public class CommonSys
extends CommonNamespace {
    public CommonSys(CommonCore commonCore) {
        super(commonCore);
    }

    public File tempfile(Option ... optionArray) {
        try {
            return File.createTempFile("jcores.", ".tmp");
        }
        catch (IOException iOException) {
            Options options = Options.$(this.commonCore, optionArray);
            options.failure(null, iOException, "tempfile:create", "Unable to create temp file.");
            return new File("/tmp/jcores.failedtmp." + System.nanoTime() + ".tmp");
        }
    }

    public File tempdir(Option ... optionArray) {
        File file = new File(this.tempfile(optionArray).getAbsoluteFile() + ".dir/");
        if (!file.mkdirs()) {
            Options options = Options.$(this.commonCore, optionArray);
            options.failure(null, null, "tempdir:create", "Unable to create temp dir.");
        }
        return file;
    }

    @SupportsOption(options={KillSwitch.class})
    public void manyTimes(final F0 f0, final long l, final Option ... optionArray) {
        final Options options = Options.$(this.commonCore, optionArray);
        final KillSwitch killSwitch = options.killswitch();
        Future<?> future = this.commonCore.executor().getExecutor().submit(new Runnable(){

            @Override
            public void run() {
                do {
                    try {
                        f0.f();
                        CommonSys.this.sleep(l, optionArray);
                    }
                    catch (Exception exception) {
                        options.failure(f0, exception, "manytimes:run", "Exception while executing f().");
                    }
                } while (killSwitch == null || !killSwitch.terminated());
            }
        });
        if (killSwitch != null) {
            killSwitch.register(future);
        }
    }

    @SupportsOption(options={KillSwitch.class})
    public void oneTime(final F0 f0, final long l, final Option ... optionArray) {
        final Options options = Options.$(this.commonCore, optionArray);
        final KillSwitch killSwitch = options.killswitch();
        Future<?> future = this.commonCore.executor().getExecutor().submit(new Runnable(){

            @Override
            public void run() {
                try {
                    CommonSys.this.sleep(l, optionArray);
                    if (killSwitch != null && killSwitch.terminated()) {
                        return;
                    }
                    f0.f();
                }
                catch (Exception exception) {
                    options.failure(f0, exception, "onetime:run", "Exception while executing f().");
                }
            }
        });
        if (killSwitch != null) {
            killSwitch.register(future);
        }
    }

    public long sleep(long l, Option ... optionArray) {
        long l2 = System.currentTimeMillis();
        try {
            Thread.sleep(l);
        }
        catch (InterruptedException interruptedException) {
            Options.$(this.commonCore, optionArray).failure(null, interruptedException, "sleep:interrupt", "Sleep interrupted");
            return l - (System.currentTimeMillis() - l2);
        }
        return 0L;
    }

    @SupportsOption(options={ID.class})
    public String uniqueID(Option ... optionArray) {
        ID iD = Options.$(this.commonCore, optionArray).ID();
        if (iD == ID.SYSTEM || iD == ID.USER) {
            try {
                Preferences preferences = iD == ID.SYSTEM ? Preferences.systemNodeForPackage(this.getClass()) : Preferences.userNodeForPackage(this.getClass());
                String string = preferences.get("system.id", "UNAVAILABLE");
                if ("UNAVAILABLE".equals(string)) {
                    String string2 = UUID.randomUUID().toString();
                    preferences.put("system.id", string2);
                    preferences.sync();
                    return string2;
                }
                return string;
            }
            catch (Exception exception) {
                Options.$(this.commonCore, optionArray).failure(null, exception, "uniqueid:create", "Error getting the ID " + iD.getClass() + " (on Lion this might be a bug).");
                return "UNAVAILABLE";
            }
        }
        return UUID.randomUUID().toString();
    }
}

