/*
 * Decompiled with CFR 0.152.
 */
package net.jcores.jre.cores;

import java.awt.image.BufferedImage;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.List;
import java.util.jar.Manifest;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.imageio.ImageIO;
import javax.sound.sampled.AudioInputStream;
import net.jcores.jre.CommonCore;
import net.jcores.jre.CoreKeeper;
import net.jcores.jre.cores.CoreAudioInputStream;
import net.jcores.jre.cores.CoreBufferedImage;
import net.jcores.jre.cores.CoreByteBuffer;
import net.jcores.jre.cores.CoreInputStream;
import net.jcores.jre.cores.CoreNumber;
import net.jcores.jre.cores.CoreObject;
import net.jcores.jre.cores.CoreString;
import net.jcores.jre.cores.CoreURI;
import net.jcores.jre.cores.adapter.AbstractAdapter;
import net.jcores.jre.interfaces.functions.F1;
import net.jcores.jre.interfaces.functions.F1Object2Bool;
import net.jcores.jre.options.ListDirectories;
import net.jcores.jre.options.MessageType;
import net.jcores.jre.options.Option;
import net.jcores.jre.utils.internal.Files;
import net.jcores.jre.utils.internal.Options;
import net.jcores.jre.utils.internal.Sound;
import net.jcores.jre.utils.internal.Streams;

public class CoreFile
extends CoreObject<File> {
    private static final long serialVersionUID = -8743359735096052185L;

    public CoreFile(CommonCore commonCore, File ... fileArray) {
        super(commonCore, fileArray);
    }

    public CoreFile(CommonCore commonCore, AbstractAdapter<File> abstractAdapter) {
        super(commonCore, abstractAdapter);
    }

    public CoreFile append(Object object, final Option ... optionArray) {
        if (object == null) {
            return this;
        }
        final CommonCore commonCore = this.commonCore;
        final String string = object.toString();
        this.map(new F1<File, Object>(){

            @Override
            public Object f(File file) {
                try {
                    PrintWriter printWriter = new PrintWriter(new OutputStreamWriter((OutputStream)new BufferedOutputStream(new FileOutputStream(file, true)), "UTF-8"));
                    printWriter.append(string);
                    printWriter.flush();
                    printWriter.close();
                }
                catch (FileNotFoundException fileNotFoundException) {
                    Options.$(commonCore, optionArray).failure(file, fileNotFoundException, "append:filenotfound", "File could not be found.");
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    Options.$(commonCore, optionArray).failure(file, unsupportedEncodingException, "append:badencoding", "Encoding not supported.");
                }
                return null;
            }
        }, new Option[0]);
        return this;
    }

    public CoreFile appendln(Object object, Option ... optionArray) {
        if (object == null) {
            return this;
        }
        return this.append(object.toString() + "\n", optionArray);
    }

    public CoreAudioInputStream audio() {
        return new CoreAudioInputStream(this.commonCore, this.map(new F1<File, AudioInputStream>(){

            @Override
            public AudioInputStream f(File file) {
                return Sound.getStream(file);
            }
        }, new Option[0]).array(AudioInputStream.class));
    }

    public CoreFile copy(String string) {
        if (string == null) {
            this.commonCore.report(MessageType.MISUSE, "Destination null for copy().");
            return this;
        }
        final File file = new File(string);
        final CommonCore commonCore = this.commonCore;
        return new CoreFile(this.commonCore, this.map(new F1<File, File[]>(){

            @Override
            public File[] f(File file2) {
                return Files.copy(commonCore, file2, file);
            }
        }, new Option[0]).expand(File.class).array(File.class));
    }

    public CoreByteBuffer data() {
        final CommonCore commonCore = this.commonCore;
        return new CoreByteBuffer(this.commonCore, this.map(new F1<File, ByteBuffer>(){

            @Override
            public ByteBuffer f(File file) {
                try {
                    FileChannel fileChannel = new FileInputStream(file).getChannel();
                    long l = fileChannel.size();
                    ByteBuffer byteBuffer = ByteBuffer.allocate((int)l);
                    int n = fileChannel.read(byteBuffer);
                    if ((long)n != l) {
                        commonCore.report(MessageType.EXCEPTION, "Error reading data() from " + file + ". Size mismatch (" + n + " != " + l + ")");
                        return null;
                    }
                    fileChannel.close();
                    return byteBuffer;
                }
                catch (FileNotFoundException fileNotFoundException) {
                    commonCore.report(MessageType.EXCEPTION, "Error reading data() from " + file + ". File not found!");
                    return null;
                }
                catch (IOException iOException) {
                    commonCore.report(MessageType.EXCEPTION, "Error reading data() from " + file + ". IOException!");
                    return null;
                }
            }
        }, new Option[0]).array(ByteBuffer.class));
    }

    public CoreFile delete() {
        final CommonCore commonCore = this.commonCore;
        this.map(new F1<File, Void>(){

            @Override
            public Void f(File file) {
                int n = Integer.MAX_VALUE;
                List list = CoreKeeper.$(file).dir(ListDirectories.DO).list();
                while (list.size() < n) {
                    n = list.size();
                    for (File file2 : list) {
                        file2.delete();
                    }
                    list = CoreKeeper.$(file).dir(ListDirectories.DO).list();
                }
                if (!file.delete()) {
                    commonCore.report(MessageType.EXCEPTION, "Unable to delete " + file);
                }
                return null;
            }
        }, new Option[0]);
        return this;
    }

    public <T> CoreObject<T> deserialize(Class<T> clazz, Option ... optionArray) {
        if (this.size() > 1) {
            this.commonCore.report(MessageType.MISUSE, "deserialize() should not be used on cores with more than one class!");
        }
        try {
            CoreObject<T> coreObject = Streams.deserializeCore(clazz, new FileInputStream((File)this.get(false)), this.commonCore);
            if (coreObject != null) {
                return coreObject;
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
        }
        catch (SecurityException securityException) {
            securityException.printStackTrace();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            illegalArgumentException.printStackTrace();
        }
        return new CoreObject<Object>(this.commonCore, clazz, null);
    }

    public CoreFile dir(Option ... optionArray) {
        final boolean bl = CoreKeeper.$(optionArray).contains(ListDirectories.DO);
        return this.map(new F1<File, File[]>(){

            @Override
            public File[] f(File file) {
                return Files.dir(file, bl);
            }
        }, new Option[0]).expand(File.class).unique().as(CoreFile.class);
    }

    public CoreNumber filesize() {
        return new CoreNumber(this.commonCore, this.map(new F1<File, Long>(){

            @Override
            public Long f(File file) {
                return file.length();
            }
        }, new Option[0]).array(Long.class));
    }

    public CoreFile filter(String string, Option ... optionArray) {
        final Pattern pattern = Pattern.compile(string);
        return new CoreFile(this.commonCore, this.filter(new F1Object2Bool<File>(){

            @Override
            public boolean f(File file) {
                Matcher matcher = pattern.matcher(file.getAbsolutePath());
                return matcher.matches();
            }
        }, optionArray).array(File.class));
    }

    public CoreBufferedImage image() {
        final CommonCore commonCore = this.commonCore;
        return new CoreBufferedImage(this.commonCore, this.map(new F1<File, BufferedImage>(){

            @Override
            public BufferedImage f(File file) {
                try {
                    return ImageIO.read(file);
                }
                catch (IOException iOException) {
                    commonCore.report(MessageType.EXCEPTION, "Error loading image " + file);
                    return null;
                }
            }
        }, new Option[0]).array(BufferedImage.class));
    }

    public CoreInputStream input() {
        return new CoreInputStream(this.commonCore, this.map(new F1<File, InputStream>(){

            @Override
            public InputStream f(File file) {
                try {
                    return new BufferedInputStream(new FileInputStream(file));
                }
                catch (FileNotFoundException fileNotFoundException) {
                    return null;
                }
            }
        }, new Option[0]).array(InputStream.class));
    }

    public CoreFile jar(String string, Manifest manifest, Option ... optionArray) {
        Files.jarFiles(new File(string), manifest, (File[])this.unsafeadapter().array());
        return this;
    }

    public CoreFile mkdir() {
        for (int i = 0; i < this.size(); ++i) {
            File file = (File)this.get(i);
            if (file == null) continue;
            file.mkdirs();
        }
        return this;
    }

    public CoreString text() {
        final CommonCore commonCore = this.commonCore;
        return new CoreString(this.commonCore, this.map(new F1<File, String>(){

            @Override
            public String f(File file) {
                return Files.readText(commonCore, file);
            }
        }, new Option[0]).array(String.class));
    }

    public CoreURI uri() {
        return new CoreURI(this.commonCore, this.map(new F1<File, URI>(){

            @Override
            public URI f(File file) {
                return file.toURI();
            }
        }, new Option[0]).array(URI.class));
    }

    public CoreFile zip(String string, Option ... optionArray) {
        Files.zipFiles(new File(string), (File[])this.adapter.array());
        return this;
    }
}

