/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.wizard;

import com.jgoodies.forms.layout.ColumnSpec;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.forms.layout.FormSpecs;
import com.jgoodies.forms.layout.RowSpec;
import java.awt.Color;
import java.awt.Component;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.DefaultComboBoxModel;
import javax.swing.Icon;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTable;
import javax.swing.JTextPane;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableCellRenderer;
import javax.swing.text.html.HTMLEditorKit;
import org.jdesktop.beansbinding.AutoBinding;
import org.jdesktop.beansbinding.BeanProperty;
import org.jdesktop.beansbinding.Bindings;
import org.jdesktop.beansbinding.Property;
import org.jdesktop.observablecollections.ObservableCollections;
import org.jdesktop.swingbinding.JTableBinding;
import org.jdesktop.swingbinding.SwingBindings;
import org.tinymediamanager.Globals;
import org.tinymediamanager.core.tvshow.TvShowList;
import org.tinymediamanager.core.tvshow.TvShowModuleManager;
import org.tinymediamanager.core.tvshow.TvShowSettings;
import org.tinymediamanager.scraper.MediaScraper;
import org.tinymediamanager.scraper.entities.CountryCode;
import org.tinymediamanager.scraper.entities.MediaLanguages;
import org.tinymediamanager.ui.TableColumnResizer;
import org.tinymediamanager.ui.UTF8Control;
import org.tinymediamanager.ui.tvshows.settings.TvShowScraperSettingsPanel;

class TvShowScraperPanel
extends JPanel {
    private static final long serialVersionUID = -2639391458779374972L;
    private static final ResourceBundle BUNDLE = ResourceBundle.getBundle("messages", new UTF8Control());
    private final TvShowSettings settings = TvShowModuleManager.SETTINGS;
    private final List<TvShowScraperSettingsPanel.TvShowScraper> scrapers = ObservableCollections.observableList(new ArrayList());
    private JTable tableScraper;
    private JComboBox<MediaLanguages> cbScraperLanguage;
    private JComboBox<CountryCode> cbCertificationCountry;
    private JTextPane tpScraperDescription;
    private JLabel lblTvShowScraper;

    public TvShowScraperPanel() {
        MediaScraper defaultMediaScraper = TvShowList.getInstance().getDefaultMediaScraper();
        int selectedIndex = 0;
        int counter = 0;
        for (MediaScraper scraper : TvShowList.getInstance().getAvailableMediaScrapers()) {
            TvShowScraperSettingsPanel.TvShowScraper tvShowScraper = new TvShowScraperSettingsPanel.TvShowScraper(scraper);
            if (scraper.equals(defaultMediaScraper)) {
                tvShowScraper.setDefaultScraper(true);
                selectedIndex = counter;
            }
            this.scrapers.add(tvShowScraper);
            ++counter;
        }
        this.initComponents();
        this.initDataBindings();
        TableColumnResizer.setMaxWidthForColumn(this.tableScraper, 0, 2);
        TableColumnResizer.setMaxWidthForColumn(this.tableScraper, 1, 2);
        TableColumnResizer.adjustColumnPreferredWidths(this.tableScraper, 5);
        this.tableScraper.getModel().addTableModelListener(new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent arg0) {
                if (arg0.getColumn() == 0) {
                    int row = arg0.getFirstRow();
                    TvShowScraperSettingsPanel.TvShowScraper changedScraper = (TvShowScraperSettingsPanel.TvShowScraper)TvShowScraperPanel.this.scrapers.get(row);
                    if (changedScraper.getDefaultScraper().booleanValue()) {
                        TvShowScraperPanel.this.settings.setTvShowScraper(changedScraper.getScraperId());
                        for (TvShowScraperSettingsPanel.TvShowScraper scraper : TvShowScraperPanel.this.scrapers) {
                            if (scraper == changedScraper) continue;
                            scraper.setDefaultScraper(Boolean.FALSE);
                        }
                    }
                }
            }
        });
        if (counter > 0) {
            this.tableScraper.getSelectionModel().setSelectionInterval(selectedIndex, selectedIndex);
        }
    }

    private void initComponents() {
        this.setLayout((LayoutManager)new FormLayout(new ColumnSpec[]{FormSpecs.RELATED_GAP_COLSPEC, ColumnSpec.decode((String)"default:grow"), FormSpecs.RELATED_GAP_COLSPEC}, new RowSpec[]{FormSpecs.LINE_GAP_ROWSPEC, RowSpec.decode((String)"default:grow"), FormSpecs.LINE_GAP_ROWSPEC}));
        JPanel panelTvShowScrapers = new JPanel();
        this.add((Component)panelTvShowScrapers, "2, 2, fill, fill");
        panelTvShowScrapers.setLayout((LayoutManager)new FormLayout(new ColumnSpec[]{FormSpecs.RELATED_GAP_COLSPEC, FormSpecs.DEFAULT_COLSPEC, FormSpecs.RELATED_GAP_COLSPEC, FormSpecs.DEFAULT_COLSPEC, FormSpecs.RELATED_GAP_COLSPEC, ColumnSpec.decode((String)"20dlu:grow"), FormSpecs.RELATED_GAP_COLSPEC, FormSpecs.DEFAULT_COLSPEC, FormSpecs.RELATED_GAP_COLSPEC, FormSpecs.DEFAULT_COLSPEC, FormSpecs.RELATED_GAP_COLSPEC, ColumnSpec.decode((String)"200dlu:grow"), FormSpecs.RELATED_GAP_COLSPEC}, new RowSpec[]{FormSpecs.RELATED_GAP_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC, FormSpecs.RELATED_GAP_ROWSPEC, RowSpec.decode((String)"80dlu:grow"), FormSpecs.LABEL_COMPONENT_GAP_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC, FormSpecs.LINE_GAP_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC, FormSpecs.RELATED_GAP_ROWSPEC, RowSpec.decode((String)"default:grow(3)"), FormSpecs.LINE_GAP_ROWSPEC}));
        this.lblTvShowScraper = new JLabel(BUNDLE.getString("wizard.tvshow.scraper"));
        panelTvShowScrapers.add((Component)this.lblTvShowScraper, "2, 2, 11, 1");
        JScrollPane scrollPaneScraper = new JScrollPane();
        panelTvShowScrapers.add((Component)scrollPaneScraper, "2, 4, 5, 1, fill, fill");
        this.tableScraper = new JTable(){
            private static final long serialVersionUID = -144223066269069772L;

            @Override
            public Component prepareRenderer(TableCellRenderer renderer, int row, int col) {
                Component comp = super.prepareRenderer(renderer, row, col);
                String value = this.getModel().getValueAt(row, 2).toString();
                if (!Globals.isDonator() && value.startsWith("Kodi")) {
                    comp.setBackground(Color.lightGray);
                    comp.setEnabled(false);
                } else {
                    comp.setBackground(Color.white);
                    comp.setEnabled(true);
                }
                return comp;
            }
        };
        this.tableScraper.setRowHeight(29);
        scrollPaneScraper.setViewportView(this.tableScraper);
        JPanel panelScraperDetails = new JPanel();
        panelTvShowScrapers.add((Component)panelScraperDetails, "8, 4, 5, 1, fill, fill");
        panelScraperDetails.setLayout((LayoutManager)new FormLayout(new ColumnSpec[]{FormSpecs.RELATED_GAP_COLSPEC, ColumnSpec.decode((String)"default:grow"), FormSpecs.RELATED_GAP_COLSPEC}, new RowSpec[]{FormSpecs.RELATED_GAP_ROWSPEC, RowSpec.decode((String)"default:grow"), FormSpecs.RELATED_GAP_ROWSPEC}));
        this.tpScraperDescription = new JTextPane();
        this.tpScraperDescription.setOpaque(false);
        this.tpScraperDescription.setEditorKit(new HTMLEditorKit());
        panelScraperDetails.add((Component)this.tpScraperDescription, "2, 2, default, top");
        panelTvShowScrapers.add((Component)new JSeparator(), "2, 6, 11, 1");
        JLabel lblScraperLanguage = new JLabel(BUNDLE.getString("Settings.preferredLanguage"));
        panelTvShowScrapers.add((Component)lblScraperLanguage, "2, 7, right, default");
        this.cbScraperLanguage = new JComboBox();
        this.cbScraperLanguage.setModel(new DefaultComboBoxModel<MediaLanguages>(MediaLanguages.values()));
        panelTvShowScrapers.add(this.cbScraperLanguage, "4, 7");
        JLabel lblCountry = new JLabel(BUNDLE.getString("Settings.certificationCountry"));
        panelTvShowScrapers.add((Component)lblCountry, "2, 9, right, default");
        this.cbCertificationCountry = new JComboBox();
        this.cbCertificationCountry.setModel(new DefaultComboBoxModel<CountryCode>(CountryCode.values()));
        panelTvShowScrapers.add(this.cbCertificationCountry, "4, 9, fill, default");
    }

    protected void initDataBindings() {
        BeanProperty settingsBeanProperty_8 = BeanProperty.create((String)"scraperLanguage");
        BeanProperty jComboBoxBeanProperty = BeanProperty.create((String)"selectedItem");
        AutoBinding autoBinding_7 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.settings, (Property)settingsBeanProperty_8, this.cbScraperLanguage, (Property)jComboBoxBeanProperty);
        autoBinding_7.bind();
        BeanProperty settingsBeanProperty_9 = BeanProperty.create((String)"certificationCountry");
        AutoBinding autoBinding_8 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.settings, (Property)settingsBeanProperty_9, this.cbCertificationCountry, (Property)jComboBoxBeanProperty);
        autoBinding_8.bind();
        JTableBinding jTableBinding = SwingBindings.createJTableBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, this.scrapers, (JTable)this.tableScraper);
        BeanProperty tvShowScraperBeanProperty = BeanProperty.create((String)"defaultScraper");
        jTableBinding.addColumnBinding((Property)tvShowScraperBeanProperty).setColumnName("Default").setColumnClass(Boolean.class);
        BeanProperty tvShowScraperBeanProperty_1 = BeanProperty.create((String)"scraperLogo");
        jTableBinding.addColumnBinding((Property)tvShowScraperBeanProperty_1).setColumnName("Logo").setColumnClass(Icon.class);
        BeanProperty tvShowScraperBeanProperty_2 = BeanProperty.create((String)"scraperName");
        jTableBinding.addColumnBinding((Property)tvShowScraperBeanProperty_2).setColumnName("Name").setEditable(false);
        jTableBinding.bind();
        BeanProperty jTableBeanProperty = BeanProperty.create((String)"selectedElement.scraperDescription");
        BeanProperty jTextPaneBeanProperty = BeanProperty.create((String)"text");
        AutoBinding autoBinding_3 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ, (Object)this.tableScraper, (Property)jTableBeanProperty, (Object)this.tpScraperDescription, (Property)jTextPaneBeanProperty);
        autoBinding_3.bind();
    }
}

