/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.tvshows.dialogs;

import ca.odell.glazedlists.BasicEventList;
import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.swing.AutoCompleteSupport;
import com.jgoodies.forms.factories.FormFactory;
import com.jgoodies.forms.layout.ColumnSpec;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.forms.layout.FormSpecs;
import com.jgoodies.forms.layout.RowSpec;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import javax.swing.AbstractAction;
import javax.swing.DefaultComboBoxModel;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.KeyStroke;
import javax.swing.SpinnerDateModel;
import javax.swing.SpinnerNumberModel;
import javax.swing.border.EmptyBorder;
import org.apache.commons.lang3.StringUtils;
import org.jdesktop.beansbinding.AutoBinding;
import org.jdesktop.beansbinding.BeanProperty;
import org.jdesktop.beansbinding.Property;
import org.jdesktop.observablecollections.ObservableCollections;
import org.jdesktop.swingbinding.JListBinding;
import org.jdesktop.swingbinding.JTableBinding;
import org.jdesktop.swingbinding.SwingBindings;
import org.tinymediamanager.core.MediaFileType;
import org.tinymediamanager.core.entities.MediaFile;
import org.tinymediamanager.core.threading.TmmTaskManager;
import org.tinymediamanager.core.tvshow.TvShowList;
import org.tinymediamanager.core.tvshow.TvShowModuleManager;
import org.tinymediamanager.core.tvshow.entities.TvShow;
import org.tinymediamanager.core.tvshow.entities.TvShowActor;
import org.tinymediamanager.core.tvshow.entities.TvShowEpisode;
import org.tinymediamanager.scraper.ScraperType;
import org.tinymediamanager.scraper.entities.Certification;
import org.tinymediamanager.scraper.entities.CountryCode;
import org.tinymediamanager.scraper.entities.MediaGenres;
import org.tinymediamanager.scraper.entities.MediaType;
import org.tinymediamanager.scraper.trakttv.SyncTraktTvTask;
import org.tinymediamanager.ui.EqualsLayout;
import org.tinymediamanager.ui.IconManager;
import org.tinymediamanager.ui.MainWindow;
import org.tinymediamanager.ui.TableColumnResizer;
import org.tinymediamanager.ui.TableSpinnerEditor;
import org.tinymediamanager.ui.TmmFontHelper;
import org.tinymediamanager.ui.UTF8Control;
import org.tinymediamanager.ui.components.AutocompleteComboBox;
import org.tinymediamanager.ui.components.ImageLabel;
import org.tinymediamanager.ui.components.MediaIdTable;
import org.tinymediamanager.ui.components.datepicker.DatePicker;
import org.tinymediamanager.ui.components.datepicker.YearSpinner;
import org.tinymediamanager.ui.dialogs.ImageChooserDialog;
import org.tinymediamanager.ui.dialogs.TmmDialog;

public class TvShowEditorDialog
extends TmmDialog {
    private static final long serialVersionUID = 3270218410302989845L;
    private static final ResourceBundle BUNDLE = ResourceBundle.getBundle("messages", new UTF8Control());
    private TvShow tvShowToEdit;
    private TvShowList tvShowList = TvShowList.getInstance();
    private List<TvShowActor> actors = ObservableCollections.observableList(new ArrayList());
    private List<MediaGenres> genres = ObservableCollections.observableList(new ArrayList());
    private EventList<MediaIdTable.MediaId> ids = new BasicEventList();
    private List<String> tags = ObservableCollections.observableList(new ArrayList());
    private List<TvShowEpisodeEditorContainer> episodes = ObservableCollections.observableList(new ArrayList());
    private boolean continueQueue = true;
    private final JPanel details1Panel = new JPanel();
    private final JPanel details2Panel = new JPanel();
    private final JPanel episodesPanel = new JPanel();
    private JTextField tfTitle;
    private YearSpinner spYear;
    private JTextPane tpPlot;
    private JTable tableActors;
    private JLabel lvlTvShowPath;
    private ImageLabel lblPoster;
    private ImageLabel lblFanart;
    private ImageLabel lblBanner;
    private JSpinner spRuntime;
    private JTextField tfStudio;
    private JList<MediaGenres> listGenres;
    private AutocompleteComboBox<MediaGenres> cbGenres;
    private AutoCompleteSupport<MediaGenres> cbGenresAutoCompleteSupport;
    private JSpinner spRating;
    private JComboBox cbCertification;
    private JComboBox cbStatus;
    private AutocompleteComboBox<String> cbTags;
    private AutoCompleteSupport<String> cbTagsAutoCompleteSupport;
    private JList<String> listTags;
    private JSpinner spDateAdded;
    private DatePicker dpPremiered;
    private JTable tableEpisodes;
    private JTextField tfSorttitle;
    private ImageLabel lblLogo;
    private ImageLabel lblClearlogo;
    private ImageLabel lblClearart;
    private ImageLabel lblThumb;
    private JTableBinding<TvShowActor, List<TvShowActor>, JTable> jTableBinding;
    private JListBinding<MediaGenres, List<MediaGenres>, JList> jListBinding;
    private JListBinding<String, List<String>, JList> jListBinding_1;
    private JTableBinding<TvShowEpisodeEditorContainer, List<TvShowEpisodeEditorContainer>, JTable> jTableBinding_2;
    private JTable tableIds;

    public TvShowEditorDialog(TvShow tvShow, boolean inQueue) {
        super(BUNDLE.getString("tvshow.edit"), "tvShowEditor");
        this.setBounds(5, 5, 950, 700);
        this.tvShowToEdit = tvShow;
        this.ids = MediaIdTable.convertIdMapToEventList(this.tvShowToEdit.getIds());
        this.getContentPane().setLayout(new BorderLayout());
        JPanel panelPath = new JPanel();
        this.getContentPane().add((Component)panelPath, "North");
        panelPath.setLayout((LayoutManager)new FormLayout(new ColumnSpec[]{FormFactory.RELATED_GAP_COLSPEC, FormFactory.DEFAULT_COLSPEC, FormFactory.DEFAULT_COLSPEC, FormFactory.RELATED_GAP_COLSPEC, FormFactory.DEFAULT_COLSPEC, FormFactory.RELATED_GAP_COLSPEC}, new RowSpec[]{FormFactory.LINE_GAP_ROWSPEC, RowSpec.decode((String)"15px"), FormFactory.RELATED_GAP_ROWSPEC}));
        JLabel lblTvShowPathT = new JLabel(BUNDLE.getString("metatag.path"));
        panelPath.add((Component)lblTvShowPathT, "2, 2, left, top");
        this.lvlTvShowPath = new JLabel("");
        TmmFontHelper.changeFont(lblTvShowPathT, 1.166, 1);
        panelPath.add((Component)this.lvlTvShowPath, "5, 2, left, top");
        JTabbedPane tabbedPane = new JTabbedPane(1);
        tabbedPane.addTab(BUNDLE.getString("metatag.details"), this.details1Panel);
        this.getContentPane().add((Component)tabbedPane, "Center");
        this.details1Panel.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.details1Panel.setLayout((LayoutManager)new FormLayout(new ColumnSpec[]{FormSpecs.RELATED_GAP_COLSPEC, ColumnSpec.decode((String)"max(40dlu;default)"), FormSpecs.RELATED_GAP_COLSPEC, ColumnSpec.decode((String)"default:grow"), FormSpecs.RELATED_GAP_COLSPEC, ColumnSpec.decode((String)"50px:grow"), FormSpecs.RELATED_GAP_COLSPEC, FormSpecs.DEFAULT_COLSPEC, FormSpecs.RELATED_GAP_COLSPEC, FormSpecs.DEFAULT_COLSPEC, FormSpecs.RELATED_GAP_COLSPEC, ColumnSpec.decode((String)"50px:grow"), FormSpecs.RELATED_GAP_COLSPEC, FormSpecs.DEFAULT_COLSPEC, FormSpecs.RELATED_GAP_COLSPEC, ColumnSpec.decode((String)"30dlu"), FormSpecs.RELATED_GAP_COLSPEC, FormSpecs.DEFAULT_COLSPEC, FormSpecs.RELATED_GAP_COLSPEC, FormSpecs.RELATED_GAP_COLSPEC, FormSpecs.UNRELATED_GAP_COLSPEC, FormSpecs.DEFAULT_COLSPEC, FormSpecs.RELATED_GAP_COLSPEC, ColumnSpec.decode((String)"250px:grow"), FormSpecs.RELATED_GAP_COLSPEC}, new RowSpec[]{FormSpecs.RELATED_GAP_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC, FormSpecs.RELATED_GAP_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC, FormSpecs.RELATED_GAP_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC, FormSpecs.RELATED_GAP_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC, FormSpecs.RELATED_GAP_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC, FormSpecs.RELATED_GAP_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC, FormSpecs.RELATED_GAP_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC, FormSpecs.RELATED_GAP_ROWSPEC, RowSpec.decode((String)"15dlu:grow"), FormSpecs.RELATED_GAP_ROWSPEC, RowSpec.decode((String)"top:max(30dlu;default)"), FormSpecs.RELATED_GAP_ROWSPEC, RowSpec.decode((String)"20dlu:grow"), FormSpecs.RELATED_GAP_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC, FormSpecs.LABEL_COMPONENT_GAP_ROWSPEC, RowSpec.decode((String)"default:grow"), FormSpecs.RELATED_GAP_ROWSPEC, RowSpec.decode((String)"fill:30px:grow(2)")}));
        JLabel lblTitle = new JLabel(BUNDLE.getString("metatag.title"));
        this.details1Panel.add((Component)lblTitle, "2, 2, right, default");
        this.tfTitle = new JTextField();
        this.details1Panel.add((Component)this.tfTitle, "4, 2, 15, 1, fill, default");
        this.tfTitle.setColumns(10);
        this.lblPoster = new ImageLabel();
        this.lblPoster.setAlternativeText(BUNDLE.getString("image.notfound.poster"));
        this.lblPoster.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                ImageChooserDialog dialog = new ImageChooserDialog(TvShowEditorDialog.this.tvShowToEdit.getIds(), ImageChooserDialog.ImageType.POSTER, TvShowEditorDialog.this.tvShowList.getAvailableArtworkScrapers(), TvShowEditorDialog.this.lblPoster, null, null, MediaType.TV_SHOW);
                dialog.setLocationRelativeTo(MainWindow.getActiveInstance());
                dialog.setVisible(true);
            }
        });
        this.lblPoster.setCursor(Cursor.getPredefinedCursor(12));
        this.details1Panel.add((Component)this.lblPoster, "22, 2, 3, 19, fill, fill");
        JLabel lblSortTitle = new JLabel(BUNDLE.getString("metatag.sorttitle"));
        this.details1Panel.add((Component)lblSortTitle, "2, 4, right, default");
        this.tfSorttitle = new JTextField();
        this.details1Panel.add((Component)this.tfSorttitle, "4, 4, 15, 1, fill, default");
        this.tfSorttitle.setColumns(10);
        JLabel lblYear = new JLabel(BUNDLE.getString("metatag.year"));
        this.details1Panel.add((Component)lblYear, "2, 6, right, default");
        this.spYear = new YearSpinner();
        this.details1Panel.add((Component)this.spYear, "4, 6, fill, top");
        JLabel lblpremiered = new JLabel(BUNDLE.getString("metatag.premiered"));
        this.details1Panel.add((Component)lblpremiered, "8, 6, right, default");
        this.dpPremiered = new DatePicker(tvShow.getFirstAired());
        this.details1Panel.add((Component)this.dpPremiered, "10, 6, fill, default");
        JLabel lblRuntime = new JLabel(BUNDLE.getString("metatag.runtime"));
        this.details1Panel.add((Component)lblRuntime, "14, 6, right, default");
        this.spRuntime = new JSpinner();
        this.details1Panel.add((Component)this.spRuntime, "16, 6, fill, default");
        this.spRuntime.setValue(tvShow.getRuntime());
        JLabel lblMin = new JLabel(BUNDLE.getString("metatag.minutes"));
        this.details1Panel.add((Component)lblMin, "18, 6");
        JLabel lblRating = new JLabel(BUNDLE.getString("metatag.rating"));
        this.details1Panel.add((Component)lblRating, "2, 8, right, default");
        this.spRating = new JSpinner();
        this.details1Panel.add((Component)this.spRating, "4, 8");
        this.spRating.setModel(new SpinnerNumberModel(tvShow.getRating(), 0.0, 10.0, 0.1));
        JLabel lblCertification = new JLabel(BUNDLE.getString("metatag.certification"));
        this.details1Panel.add((Component)lblCertification, "8, 8, right, default");
        this.cbCertification = new JComboBox();
        for (Certification cert : Certification.getCertificationsforCountry((CountryCode)TvShowModuleManager.SETTINGS.getCertificationCountry())) {
            this.cbCertification.addItem(cert);
        }
        this.details1Panel.add((Component)this.cbCertification, "10, 8, fill, default");
        this.cbCertification.setSelectedItem(tvShow.getCertification());
        JLabel lblStatus = new JLabel(BUNDLE.getString("metatag.status"));
        this.details1Panel.add((Component)lblStatus, "14, 8, right, default");
        this.cbStatus = new JComboBox<String>(new String[]{"", "Continuing", "Ended"});
        this.details1Panel.add((Component)this.cbStatus, "16, 8, 3, 1, fill, default");
        this.cbStatus.setSelectedItem(tvShow.getStatus());
        JLabel lblDateAdded = new JLabel(BUNDLE.getString("metatag.dateadded"));
        this.details1Panel.add((Component)lblDateAdded, "2, 10, right, default");
        this.spDateAdded = new JSpinner(new SpinnerDateModel());
        this.details1Panel.add((Component)this.spDateAdded, "4, 10");
        JLabel lblIds = new JLabel("Ids");
        this.details1Panel.add((Component)lblIds, "2, 12, right, default");
        JScrollPane scrollPaneIds = new JScrollPane();
        this.details1Panel.add((Component)scrollPaneIds, "4, 12, 9, 5, fill, fill");
        this.tableIds = new MediaIdTable(this.ids, ScraperType.TV_SHOW);
        scrollPaneIds.setViewportView(this.tableIds);
        JButton btnAddId = new JButton("");
        btnAddId.setAction(new AddIdAction());
        btnAddId.setIcon(IconManager.LIST_ADD);
        btnAddId.setMargin(new Insets(2, 2, 2, 2));
        this.details1Panel.add((Component)btnAddId, "2, 14, right, top");
        JButton btnRemoveId = new JButton("RemoveId");
        btnRemoveId.setAction(new RemoveIdAction());
        btnRemoveId.setIcon(IconManager.LIST_REMOVE);
        btnRemoveId.setMargin(new Insets(2, 2, 2, 2));
        this.details1Panel.add((Component)btnRemoveId, "2, 16, right, top");
        JLabel lblPlot = new JLabel(BUNDLE.getString("metatag.plot"));
        this.details1Panel.add((Component)lblPlot, "2, 18, right, top");
        JScrollPane scrollPanePlot = new JScrollPane();
        this.details1Panel.add((Component)scrollPanePlot, "4, 18, 15, 3, fill, fill");
        this.tpPlot = new JTextPane();
        scrollPanePlot.setViewportView(this.tpPlot);
        JLabel lblStudio = new JLabel(BUNDLE.getString("metatag.studio"));
        this.details1Panel.add((Component)lblStudio, "2, 22, right, top");
        this.tfStudio = new JTextField();
        this.details1Panel.add((Component)this.tfStudio, "4, 22, 15, 1");
        tabbedPane.addTab(BUNDLE.getString("metatag.details2"), this.details2Panel);
        this.details2Panel.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.details2Panel.setLayout((LayoutManager)new FormLayout(new ColumnSpec[]{FormFactory.RELATED_GAP_COLSPEC, ColumnSpec.decode((String)"max(40dlu;default)"), FormFactory.RELATED_GAP_COLSPEC, ColumnSpec.decode((String)"100px:grow(2)"), FormFactory.RELATED_GAP_COLSPEC, FormFactory.DEFAULT_COLSPEC, FormFactory.RELATED_GAP_COLSPEC, ColumnSpec.decode((String)"100px:grow"), FormFactory.RELATED_GAP_COLSPEC}, new RowSpec[]{FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, RowSpec.decode((String)"fill:30px:grow"), FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, RowSpec.decode((String)"default:grow"), FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, RowSpec.decode((String)"default:grow(2)")}));
        JLabel lblActors = new JLabel(BUNDLE.getString("metatag.actors"));
        this.details2Panel.add((Component)lblActors, "2, 2, right, default");
        JScrollPane scrollPane = new JScrollPane();
        this.details2Panel.add((Component)scrollPane, "4, 2, 1, 7");
        this.tableActors = new JTable();
        this.tableActors.putClientProperty("terminateEditOnFocusLost", Boolean.TRUE);
        scrollPane.setViewportView(this.tableActors);
        JLabel lblGenres = new JLabel(BUNDLE.getString("metatag.genre"));
        this.details2Panel.add((Component)lblGenres, "6, 2");
        JButton btnAddActor = new JButton("Add Actor");
        btnAddActor.setMargin(new Insets(2, 2, 2, 2));
        btnAddActor.setAction(new AddActorAction());
        btnAddActor.setIcon(IconManager.LIST_ADD);
        this.details2Panel.add((Component)btnAddActor, "2, 4, right, top");
        JScrollPane scrollPaneGenres = new JScrollPane();
        this.details2Panel.add((Component)scrollPaneGenres, "8, 2, 1, 5");
        this.listGenres = new JList();
        scrollPaneGenres.setViewportView(this.listGenres);
        JButton btnAddGenre = new JButton("");
        btnAddGenre.setAction(new AddGenreAction());
        btnAddGenre.setIcon(IconManager.LIST_ADD);
        btnAddGenre.setMargin(new Insets(2, 2, 2, 2));
        this.details2Panel.add((Component)btnAddGenre, "6, 4, right, top");
        JButton btnRemoveActor = new JButton(BUNDLE.getString("cast.actor.remove"));
        btnRemoveActor.setMargin(new Insets(2, 2, 2, 2));
        btnRemoveActor.setAction(new RemoveActorAction());
        btnRemoveActor.setIcon(IconManager.LIST_REMOVE);
        this.details2Panel.add((Component)btnRemoveActor, "2,6, right, top");
        JButton btnRemoveGenre = new JButton("");
        btnRemoveGenre.setAction(new RemoveGenreAction());
        btnRemoveGenre.setMargin(new Insets(2, 2, 2, 2));
        btnRemoveGenre.setIcon(IconManager.LIST_REMOVE);
        this.details2Panel.add((Component)btnRemoveGenre, "6, 6, right, top");
        this.cbGenres = new AutocompleteComboBox<MediaGenres>(MediaGenres.values());
        this.cbGenresAutoCompleteSupport = this.cbGenres.getAutoCompleteSupport();
        InputMap im = this.cbGenres.getInputMap(1);
        Object enterAction = im.get(KeyStroke.getKeyStroke(10, 0));
        this.cbGenres.getActionMap().put(enterAction, new AddGenreAction());
        this.details2Panel.add(this.cbGenres, "8,8");
        JLabel lblTags = new JLabel(BUNDLE.getString("metatag.tags"));
        this.details2Panel.add((Component)lblTags, "2, 10, right, default");
        JScrollPane scrollPaneTags = new JScrollPane();
        this.details2Panel.add((Component)scrollPaneTags, "4, 10, 1, 5");
        this.listTags = new JList();
        scrollPaneTags.setViewportView(this.listTags);
        JButton btnAddTag = new JButton("");
        btnAddTag.setAction(new AddTagAction());
        btnAddTag.setIcon(IconManager.LIST_ADD);
        btnAddTag.setMargin(new Insets(2, 2, 2, 2));
        this.details2Panel.add((Component)btnAddTag, "2, 12, right, top");
        JButton btnRemoveTag = new JButton("");
        btnRemoveTag.setAction(new RemoveTagAction());
        btnRemoveTag.setIcon(IconManager.LIST_REMOVE);
        btnRemoveTag.setMargin(new Insets(2, 2, 2, 2));
        this.details2Panel.add((Component)btnRemoveTag, "2, 14, right, top");
        this.cbTags = new AutocompleteComboBox<String>(this.tvShowList.getTagsInTvShows());
        this.cbTagsAutoCompleteSupport = this.cbTags.getAutoCompleteSupport();
        im = this.cbTags.getInputMap(1);
        enterAction = im.get(KeyStroke.getKeyStroke(10, 0));
        this.cbTags.getActionMap().put(enterAction, new AddTagAction());
        this.details2Panel.add(this.cbTags, "4, 16");
        JPanel artworkPanel = new JPanel();
        tabbedPane.addTab(BUNDLE.getString("metatag.extraartwork"), null, artworkPanel, null);
        artworkPanel.setLayout((LayoutManager)new FormLayout(new ColumnSpec[]{FormFactory.RELATED_GAP_COLSPEC, ColumnSpec.decode((String)"250px:grow"), FormFactory.RELATED_GAP_COLSPEC, ColumnSpec.decode((String)"250px:grow"), FormFactory.RELATED_GAP_COLSPEC}, new RowSpec[]{FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, RowSpec.decode((String)"50px:grow(2)"), FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, RowSpec.decode((String)"200px:grow(2)"), FormFactory.RELATED_GAP_ROWSPEC, RowSpec.decode((String)"default:grow")}));
        JLabel lblLogoT = new JLabel(BUNDLE.getString("mediafiletype.logo"));
        artworkPanel.add((Component)lblLogoT, "2, 2");
        this.lblLogo = new ImageLabel();
        this.lblLogo.setAlternativeText(BUNDLE.getString("image.notfound.logo"));
        this.lblLogo.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                ImageChooserDialog dialog = new ImageChooserDialog(TvShowEditorDialog.this.tvShowToEdit.getIds(), ImageChooserDialog.ImageType.LOGO, TvShowEditorDialog.this.tvShowList.getAvailableArtworkScrapers(), TvShowEditorDialog.this.lblLogo, null, null, MediaType.TV_SHOW);
                dialog.setLocationRelativeTo(MainWindow.getActiveInstance());
                dialog.setVisible(true);
            }
        });
        JLabel lblClearlogoT = new JLabel(BUNDLE.getString("mediafiletype.clearlogo"));
        artworkPanel.add((Component)lblClearlogoT, "4, 2");
        this.lblLogo.setCursor(Cursor.getPredefinedCursor(12));
        artworkPanel.add((Component)this.lblLogo, "2, 4, fill, fill");
        this.lblClearlogo = new ImageLabel();
        this.lblClearlogo.setAlternativeText(BUNDLE.getString("image.notfound.clearlogo"));
        this.lblClearlogo.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                ImageChooserDialog dialog = new ImageChooserDialog(TvShowEditorDialog.this.tvShowToEdit.getIds(), ImageChooserDialog.ImageType.CLEARLOGO, TvShowEditorDialog.this.tvShowList.getAvailableArtworkScrapers(), TvShowEditorDialog.this.lblClearlogo, null, null, MediaType.TV_SHOW);
                dialog.setLocationRelativeTo(MainWindow.getActiveInstance());
                dialog.setVisible(true);
            }
        });
        this.lblClearlogo.setCursor(Cursor.getPredefinedCursor(12));
        artworkPanel.add((Component)this.lblClearlogo, "4, 4, fill, fill");
        JLabel lblClearartT = new JLabel(BUNDLE.getString("mediafiletype.clearart"));
        artworkPanel.add((Component)lblClearartT, "2, 6");
        this.lblClearart = new ImageLabel();
        this.lblClearart.setAlternativeText(BUNDLE.getString("image.notfound.clearart"));
        this.lblClearart.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                ImageChooserDialog dialog = new ImageChooserDialog(TvShowEditorDialog.this.tvShowToEdit.getIds(), ImageChooserDialog.ImageType.CLEARART, TvShowEditorDialog.this.tvShowList.getAvailableArtworkScrapers(), TvShowEditorDialog.this.lblClearart, null, null, MediaType.TV_SHOW);
                dialog.setLocationRelativeTo(MainWindow.getActiveInstance());
                dialog.setVisible(true);
            }
        });
        this.lblClearart.setCursor(Cursor.getPredefinedCursor(12));
        artworkPanel.add((Component)this.lblClearart, "2, 8, fill, fill");
        JLabel lblThumbT = new JLabel(BUNDLE.getString("mediafiletype.thumb"));
        artworkPanel.add((Component)lblThumbT, "4, 6");
        this.lblThumb = new ImageLabel();
        this.lblThumb.setAlternativeText(BUNDLE.getString("image.notfound.thumb"));
        this.lblThumb.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                ImageChooserDialog dialog = new ImageChooserDialog(TvShowEditorDialog.this.tvShowToEdit.getIds(), ImageChooserDialog.ImageType.THUMB, TvShowEditorDialog.this.tvShowList.getAvailableArtworkScrapers(), TvShowEditorDialog.this.lblThumb, null, null, MediaType.TV_SHOW);
                dialog.setLocationRelativeTo(MainWindow.getActiveInstance());
                dialog.setVisible(true);
            }
        });
        this.lblThumb.setCursor(Cursor.getPredefinedCursor(12));
        artworkPanel.add((Component)this.lblThumb, "4, 8, fill, fill");
        tabbedPane.addTab(BUNDLE.getString("metatag.episodes"), this.episodesPanel);
        this.episodesPanel.setLayout((LayoutManager)new FormLayout(new ColumnSpec[]{FormFactory.RELATED_GAP_COLSPEC, FormFactory.DEFAULT_COLSPEC, FormFactory.RELATED_GAP_COLSPEC, ColumnSpec.decode((String)"default:grow"), FormFactory.RELATED_GAP_COLSPEC}, new RowSpec[]{FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, RowSpec.decode((String)"default:grow")}));
        JButton btnCloneEpisode = new JButton("");
        btnCloneEpisode.setAction(new CloneEpisodeAction());
        this.episodesPanel.add((Component)btnCloneEpisode, "2, 2");
        JScrollPane scrollPaneEpisodes = new JScrollPane();
        this.episodesPanel.add((Component)scrollPaneEpisodes, "4, 2, 1, 3, fill, fill");
        this.tableEpisodes = new JTable();
        scrollPaneEpisodes.setViewportView(this.tableEpisodes);
        JButton btnRemoveEpisode = new JButton("");
        btnRemoveEpisode.setAction(new RemoveEpisodeAction());
        btnRemoveEpisode.setIcon(IconManager.LIST_REMOVE);
        this.episodesPanel.add((Component)btnRemoveEpisode, "2, 4, default, top");
        JPanel bottomPane = new JPanel();
        this.getContentPane().add((Component)bottomPane, "South");
        bottomPane.setLayout((LayoutManager)new FormLayout(new ColumnSpec[]{ColumnSpec.decode((String)"371px:grow"), FormFactory.DEFAULT_COLSPEC, FormFactory.RELATED_GAP_COLSPEC}, new RowSpec[]{FormFactory.LINE_GAP_ROWSPEC, RowSpec.decode((String)"25px"), FormFactory.RELATED_GAP_ROWSPEC}));
        JPanel buttonPane = new JPanel();
        bottomPane.add((Component)buttonPane, "2, 2, left, top");
        EqualsLayout layout = new EqualsLayout(5);
        layout.setMinWidth(100);
        buttonPane.setLayout(layout);
        JButton okButton = new JButton(BUNDLE.getString("Button.ok"));
        buttonPane.add(okButton);
        okButton.setAction(new OKAction());
        okButton.setActionCommand("OK");
        this.getRootPane().setDefaultButton(okButton);
        JButton cancelButton = new JButton(BUNDLE.getString("Button.cancel"));
        buttonPane.add(cancelButton);
        cancelButton.setAction(new CancelAction());
        cancelButton.setActionCommand("Cancel");
        if (inQueue) {
            JButton btnAbort = new JButton(BUNDLE.getString("Button.abortqueue"));
            btnAbort.setAction(new AbortAction());
            buttonPane.add(btnAbort);
        }
        this.initDataBindings();
        this.lvlTvShowPath.setText(tvShow.getPath());
        this.tfTitle.setText(tvShow.getTitle());
        this.tfSorttitle.setText(tvShow.getSortTitle());
        this.tpPlot.setText(tvShow.getPlot());
        this.lblPoster.setImagePath(tvShow.getArtworkFilename(MediaFileType.POSTER));
        this.lblThumb.setImagePath(this.tvShowToEdit.getArtworkFilename(MediaFileType.THUMB));
        this.lblLogo.setImagePath(this.tvShowToEdit.getArtworkFilename(MediaFileType.LOGO));
        this.lblClearlogo.setImagePath(this.tvShowToEdit.getArtworkFilename(MediaFileType.CLEARLOGO));
        this.lblClearart.setImagePath(this.tvShowToEdit.getArtworkFilename(MediaFileType.CLEARART));
        this.tfStudio.setText(tvShow.getProductionCompany());
        int year = 0;
        try {
            year = Integer.parseInt(tvShow.getYear());
        }
        catch (Exception e) {
            // empty catch block
        }
        this.spYear.setValue(year);
        this.spDateAdded.setValue(tvShow.getDateAdded());
        for (TvShowActor origCast : tvShow.getActors()) {
            TvShowActor actor = new TvShowActor();
            actor.setName(origCast.getName());
            actor.setCharacter(origCast.getCharacter());
            actor.setThumbUrl(origCast.getThumbUrl());
            this.actors.add(actor);
        }
        for (MediaGenres genre : tvShow.getGenres()) {
            this.genres.add(genre);
        }
        for (String tag : this.tvShowToEdit.getTags()) {
            this.tags.add(tag);
        }
        ArrayList<TvShowEpisode> epl = new ArrayList<TvShowEpisode>(this.tvShowToEdit.getEpisodes());
        Collections.sort(epl, new Comparator<TvShowEpisode>(){

            @Override
            public int compare(TvShowEpisode s1, TvShowEpisode s2) {
                return s1.getMediaFiles(MediaFileType.VIDEO).get(0).getFile().compareTo(s2.getMediaFiles(MediaFileType.VIDEO).get(0).getFile());
            }
        });
        for (TvShowEpisode episode : epl) {
            TvShowEpisodeEditorContainer container = new TvShowEpisodeEditorContainer();
            container.tvShowEpisode = episode;
            container.dvdOrder = episode.isDvdOrder();
            container.season = episode.getSeason();
            container.episode = episode.getEpisode();
            this.episodes.add(container);
        }
        if (((DefaultComboBoxModel)this.cbCertification.getModel()).getIndexOf(tvShow.getCertification()) == -1) {
            this.cbCertification.addItem(tvShow.getCertification());
        }
        this.lblBanner = new ImageLabel();
        this.lblBanner.setAlternativeText(BUNDLE.getString("image.notfound.banner"));
        this.lblBanner.setCursor(Cursor.getPredefinedCursor(12));
        this.lblBanner.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                ImageChooserDialog dialog = new ImageChooserDialog(TvShowEditorDialog.this.tvShowToEdit.getIds(), ImageChooserDialog.ImageType.BANNER, TvShowEditorDialog.this.tvShowList.getAvailableArtworkScrapers(), TvShowEditorDialog.this.lblBanner, null, null, MediaType.TV_SHOW);
                dialog.setLocationRelativeTo(MainWindow.getActiveInstance());
                dialog.setVisible(true);
            }
        });
        this.details1Panel.add((Component)this.lblBanner, "4, 24, 15, 3, fill, fill");
        this.lblBanner.setImagePath(tvShow.getArtworkFilename(MediaFileType.BANNER));
        this.lblFanart = new ImageLabel();
        this.lblFanart.setAlternativeText(BUNDLE.getString("image.notfound.fanart"));
        this.lblFanart.setCursor(Cursor.getPredefinedCursor(12));
        this.lblFanart.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                ImageChooserDialog dialog = new ImageChooserDialog(TvShowEditorDialog.this.tvShowToEdit.getIds(), ImageChooserDialog.ImageType.FANART, TvShowEditorDialog.this.tvShowList.getAvailableArtworkScrapers(), TvShowEditorDialog.this.lblFanart, null, null, MediaType.TV_SHOW);
                dialog.setLocationRelativeTo(MainWindow.getActiveInstance());
                dialog.setVisible(true);
            }
        });
        this.details1Panel.add((Component)this.lblFanart, "22, 22, 3, 5, fill, fill");
        this.lblFanart.setImagePath(tvShow.getArtworkFilename(MediaFileType.FANART));
        this.tableActors.getColumnModel().getColumn(0).setHeaderValue(BUNDLE.getString("metatag.name"));
        this.tableActors.getColumnModel().getColumn(1).setHeaderValue(BUNDLE.getString("metatag.role"));
        this.tableEpisodes.getColumnModel().getColumn(0).setHeaderValue(BUNDLE.getString("metatag.title"));
        this.tableEpisodes.getColumnModel().getColumn(1).setHeaderValue(BUNDLE.getString("metatag.filename"));
        this.tableEpisodes.getColumnModel().getColumn(2).setHeaderValue(BUNDLE.getString("metatag.season"));
        this.tableEpisodes.getColumnModel().getColumn(3).setHeaderValue(BUNDLE.getString("metatag.episode"));
        this.tableEpisodes.getColumnModel().getColumn(4).setHeaderValue(BUNDLE.getString("metatag.dvdorder"));
        this.tableEpisodes.getColumnModel().getColumn(2).setMaxWidth(150);
        this.tableEpisodes.getColumnModel().getColumn(3).setMaxWidth(150);
        this.tableEpisodes.getColumnModel().getColumn(2).setCellEditor(new TableSpinnerEditor());
        this.tableEpisodes.getColumnModel().getColumn(3).setCellEditor(new TableSpinnerEditor());
        TableColumnResizer.adjustColumnPreferredWidths(this.tableActors, 6);
        TableColumnResizer.adjustColumnPreferredWidths(this.tableEpisodes, 6);
    }

    public boolean showDialog() {
        this.setVisible(true);
        return this.continueQueue;
    }

    protected void initDataBindings() {
        this.jTableBinding = SwingBindings.createJTableBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ, this.actors, (JTable)this.tableActors);
        BeanProperty castBeanProperty = BeanProperty.create((String)"name");
        this.jTableBinding.addColumnBinding((Property)castBeanProperty);
        BeanProperty castBeanProperty_1 = BeanProperty.create((String)"character");
        this.jTableBinding.addColumnBinding((Property)castBeanProperty_1);
        this.jTableBinding.bind();
        this.jListBinding = SwingBindings.createJListBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ, this.genres, this.listGenres);
        this.jListBinding.bind();
        this.jListBinding_1 = SwingBindings.createJListBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ, this.tags, this.listTags);
        this.jListBinding_1.bind();
        this.jTableBinding_2 = SwingBindings.createJTableBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ, this.episodes, (JTable)this.tableEpisodes);
        BeanProperty tvShowEpisodeEditorContainerBeanProperty = BeanProperty.create((String)"episodeTitle");
        this.jTableBinding_2.addColumnBinding((Property)tvShowEpisodeEditorContainerBeanProperty);
        BeanProperty tvShowEpisodeEditorContainerBeanProperty_1 = BeanProperty.create((String)"mediaFilename");
        this.jTableBinding_2.addColumnBinding((Property)tvShowEpisodeEditorContainerBeanProperty_1);
        BeanProperty tvShowEpisodeEditorContainerBeanProperty_2 = BeanProperty.create((String)"season");
        this.jTableBinding_2.addColumnBinding((Property)tvShowEpisodeEditorContainerBeanProperty_2);
        BeanProperty tvShowEpisodeEditorContainerBeanProperty_3 = BeanProperty.create((String)"episode");
        this.jTableBinding_2.addColumnBinding((Property)tvShowEpisodeEditorContainerBeanProperty_3);
        BeanProperty tvShowEpisodeEditorContainerBeanProperty_4 = BeanProperty.create((String)"dvdOrder");
        this.jTableBinding_2.addColumnBinding((Property)tvShowEpisodeEditorContainerBeanProperty_4).setColumnClass(Boolean.class);
        this.jTableBinding_2.bind();
    }

    @Override
    public void dispose() {
        super.dispose();
        this.jTableBinding.unbind();
        this.jListBinding.unbind();
        this.jListBinding_1.unbind();
        this.jTableBinding_2.unbind();
        this.dpPremiered.cleanup();
    }

    @Override
    public void pack() {
    }

    private class RemoveEpisodeAction
    extends AbstractAction {
        private static final long serialVersionUID = -8233854057648972649L;

        public RemoveEpisodeAction() {
            this.putValue("ShortDescription", BUNDLE.getString("tvshowepisode.remove"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int row = TvShowEditorDialog.this.tableEpisodes.getSelectedRow();
            if (row > -1) {
                row = TvShowEditorDialog.this.tableEpisodes.convertRowIndexToModel(row);
                TvShowEditorDialog.this.episodes.remove(row);
            }
        }
    }

    private class CloneEpisodeAction
    extends AbstractAction {
        private static final long serialVersionUID = -3255090541823134232L;

        public CloneEpisodeAction() {
            this.putValue("ShortDescription", BUNDLE.getString("tvshowepisode.clone"));
            this.putValue("SmallIcon", IconManager.COPY);
            this.putValue("SwingLargeIconKey", IconManager.COPY);
        }

        @Override
        public void actionPerformed(ActionEvent arg0) {
            int row = TvShowEditorDialog.this.tableEpisodes.getSelectedRow();
            if (row > -1) {
                row = TvShowEditorDialog.this.tableEpisodes.convertRowIndexToModel(row);
                TvShowEpisodeEditorContainer origContainer = (TvShowEpisodeEditorContainer)TvShowEditorDialog.this.episodes.get(row);
                TvShowEpisodeEditorContainer newContainer = new TvShowEpisodeEditorContainer();
                newContainer.tvShowEpisode = new TvShowEpisode(origContainer.tvShowEpisode);
                newContainer.tvShowEpisode.setTitle(origContainer.tvShowEpisode.getTitle() + " (clone)");
                newContainer.episode = -1;
                newContainer.season = newContainer.tvShowEpisode.getSeason();
                TvShowEditorDialog.this.episodes.add(row + 1, newContainer);
            }
        }
    }

    public class TvShowEpisodeEditorContainer {
        TvShowEpisode tvShowEpisode;
        int season;
        int episode;
        boolean dvdOrder = false;

        public String getEpisodeTitle() {
            return this.tvShowEpisode.getTitle();
        }

        public String getMediaFilename() {
            List<MediaFile> mfs = this.tvShowEpisode.getMediaFiles(MediaFileType.VIDEO);
            if (mfs != null && mfs.size() > 0) {
                return mfs.get(0).getFile().getAbsolutePath();
            }
            return "";
        }

        public int getEpisode() {
            return this.episode;
        }

        public void setEpisode(int episode) {
            this.episode = episode;
        }

        public int getSeason() {
            return this.season;
        }

        public void setSeason(int season) {
            this.season = season;
        }

        public boolean isDvdOrder() {
            return this.dvdOrder;
        }

        public void setDvdOrder(boolean dvdOrder) {
            this.dvdOrder = dvdOrder;
        }
    }

    private class AbortAction
    extends AbstractAction {
        private static final long serialVersionUID = -7652218354710642510L;

        public AbortAction() {
            this.putValue("Name", BUNDLE.getString("Button.abortqueue"));
            this.putValue("ShortDescription", BUNDLE.getString("tvshow.edit.abortqueue.desc"));
            this.putValue("SmallIcon", IconManager.PROCESS_STOP);
            this.putValue("SwingLargeIconKey", IconManager.PROCESS_STOP);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            TvShowEditorDialog.this.continueQueue = false;
            TvShowEditorDialog.this.setVisible(false);
        }
    }

    private class RemoveTagAction
    extends AbstractAction {
        private static final long serialVersionUID = -1580945350962234235L;

        public RemoveTagAction() {
            this.putValue("ShortDescription", BUNDLE.getString("tag.remove"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            List selectedTags = TvShowEditorDialog.this.listTags.getSelectedValuesList();
            for (String tag : selectedTags) {
                TvShowEditorDialog.this.tags.remove(tag);
            }
        }
    }

    private class RemoveIdAction
    extends AbstractAction {
        private static final long serialVersionUID = -7079826950827356996L;

        public RemoveIdAction() {
            this.putValue("ShortDescription", BUNDLE.getString("id.remove"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int row = TvShowEditorDialog.this.tableIds.getSelectedRow();
            if (row > -1) {
                row = TvShowEditorDialog.this.tableIds.convertRowIndexToModel(row);
                TvShowEditorDialog.this.ids.remove(row);
            }
        }
    }

    private class AddIdAction
    extends AbstractAction {
        private static final long serialVersionUID = 2903255414553349267L;

        public AddIdAction() {
            this.putValue("ShortDescription", BUNDLE.getString("id.add"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            MediaIdTable.MediaId Id = new MediaIdTable.MediaId();
            TvShowEditorDialog.this.ids.add((Object)Id);
        }
    }

    private class AddTagAction
    extends AbstractAction {
        private static final long serialVersionUID = 9160043031922897785L;

        public AddTagAction() {
            this.putValue("ShortDescription", BUNDLE.getString("tag.add"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JTextField tf;
            String selectedText;
            String newTag = (String)TvShowEditorDialog.this.cbTags.getSelectedItem();
            if (StringUtils.isBlank((CharSequence)newTag)) {
                return;
            }
            Component editorComponent = TvShowEditorDialog.this.cbTags.getEditor().getEditorComponent();
            if (editorComponent instanceof JTextField && (selectedText = (tf = (JTextField)editorComponent).getSelectedText()) != null) {
                tf.setSelectionStart(0);
                tf.setSelectionEnd(0);
                tf.setCaretPosition(tf.getText().length());
                return;
            }
            boolean tagFound = false;
            for (String tag : TvShowEditorDialog.this.tags) {
                if (!tag.equals(newTag)) continue;
                tagFound = true;
                break;
            }
            if (!tagFound) {
                TvShowEditorDialog.this.tags.add(newTag);
                if (editorComponent instanceof JTextField) {
                    TvShowEditorDialog.this.cbTagsAutoCompleteSupport.setFirstItem((Object)"");
                    TvShowEditorDialog.this.cbTags.setSelectedIndex(0);
                    TvShowEditorDialog.this.cbTagsAutoCompleteSupport.removeFirstItem();
                }
            }
        }
    }

    private class RemoveGenreAction
    extends AbstractAction {
        private static final long serialVersionUID = -5459615776560234688L;

        public RemoveGenreAction() {
            this.putValue("ShortDescription", BUNDLE.getString("genre.remove"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            List selectedGenres = TvShowEditorDialog.this.listGenres.getSelectedValuesList();
            for (MediaGenres genre : selectedGenres) {
                TvShowEditorDialog.this.genres.remove(genre);
            }
        }
    }

    private class AddGenreAction
    extends AbstractAction {
        private static final long serialVersionUID = 6666302391216952247L;

        public AddGenreAction() {
            this.putValue("ShortDescription", BUNDLE.getString("genre.add"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JTextField tf;
            String selectedText;
            MediaGenres newGenre = null;
            Object item = TvShowEditorDialog.this.cbGenres.getSelectedItem();
            Component editorComponent = TvShowEditorDialog.this.cbGenres.getEditor().getEditorComponent();
            if (editorComponent instanceof JTextField && (selectedText = (tf = (JTextField)editorComponent).getSelectedText()) != null) {
                tf.setSelectionStart(0);
                tf.setSelectionEnd(0);
                tf.setCaretPosition(tf.getText().length());
                return;
            }
            if (item instanceof MediaGenres) {
                newGenre = (MediaGenres)item;
            }
            if (item instanceof String) {
                newGenre = MediaGenres.getGenre((String)((String)item));
            }
            if (newGenre != null && !TvShowEditorDialog.this.genres.contains(newGenre)) {
                TvShowEditorDialog.this.genres.add(newGenre);
                if (editorComponent instanceof JTextField) {
                    TvShowEditorDialog.this.cbGenresAutoCompleteSupport.setFirstItem(null);
                    TvShowEditorDialog.this.cbGenres.setSelectedIndex(0);
                    TvShowEditorDialog.this.cbGenresAutoCompleteSupport.removeFirstItem();
                }
            }
        }
    }

    private class RemoveActorAction
    extends AbstractAction {
        private static final long serialVersionUID = 6970920169867315771L;

        public RemoveActorAction() {
            this.putValue("ShortDescription", BUNDLE.getString("cast.actor.remove"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int row = TvShowEditorDialog.this.tableActors.getSelectedRow();
            if (row > -1) {
                row = TvShowEditorDialog.this.tableActors.convertRowIndexToModel(row);
                TvShowEditorDialog.this.actors.remove(row);
            }
        }
    }

    private class AddActorAction
    extends AbstractAction {
        private static final long serialVersionUID = -5879601617842300526L;

        public AddActorAction() {
            this.putValue("ShortDescription", BUNDLE.getString("cast.actor.add"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            TvShowActor actor = new TvShowActor(BUNDLE.getString("cast.actor.unknown"), BUNDLE.getString("cast.role.unknown"));
            TvShowEditorDialog.this.actors.add(0, actor);
        }
    }

    private class CancelAction
    extends AbstractAction {
        private static final long serialVersionUID = -4617793684152607277L;

        public CancelAction() {
            this.putValue("Name", BUNDLE.getString("Button.cancel"));
            this.putValue("ShortDescription", BUNDLE.getString("edit.discard"));
            this.putValue("SmallIcon", IconManager.CANCEL);
            this.putValue("SwingLargeIconKey", IconManager.CANCEL);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            TvShowEditorDialog.this.setVisible(false);
        }
    }

    private class OKAction
    extends AbstractAction {
        private static final long serialVersionUID = 6699599213348390696L;

        public OKAction() {
            this.putValue("Name", BUNDLE.getString("Button.ok"));
            this.putValue("ShortDescription", BUNDLE.getString("tvshow.change"));
            this.putValue("SmallIcon", IconManager.APPLY);
            this.putValue("SwingLargeIconKey", IconManager.APPLY);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            TvShowEditorDialog.this.tvShowToEdit.setTitle(TvShowEditorDialog.this.tfTitle.getText());
            TvShowEditorDialog.this.tvShowToEdit.setSortTitle(TvShowEditorDialog.this.tfSorttitle.getText());
            TvShowEditorDialog.this.tvShowToEdit.setYear(String.valueOf(TvShowEditorDialog.this.spYear.getValue()));
            TvShowEditorDialog.this.tvShowToEdit.setPlot(TvShowEditorDialog.this.tpPlot.getText());
            TvShowEditorDialog.this.tvShowToEdit.setRuntime((Integer)TvShowEditorDialog.this.spRuntime.getValue());
            for (MediaIdTable.MediaId id : TvShowEditorDialog.this.ids) {
                try {
                    Integer value = Integer.parseInt(id.value);
                    TvShowEditorDialog.this.tvShowToEdit.setId(id.key, value);
                }
                catch (NumberFormatException ex) {
                    TvShowEditorDialog.this.tvShowToEdit.setId(id.key, id.value);
                }
            }
            ArrayList<String> removeIds = new ArrayList<String>();
            for (Map.Entry<String, Object> entry : TvShowEditorDialog.this.tvShowToEdit.getIds().entrySet()) {
                MediaIdTable.MediaId id = new MediaIdTable.MediaId(entry.getKey());
                if (TvShowEditorDialog.this.ids.contains((Object)id)) continue;
                removeIds.add(entry.getKey());
            }
            for (String id : removeIds) {
                TvShowEditorDialog.this.tvShowToEdit.getIds().remove(id);
            }
            Object certification = TvShowEditorDialog.this.cbCertification.getSelectedItem();
            if (certification instanceof Certification) {
                TvShowEditorDialog.this.tvShowToEdit.setCertification((Certification)certification);
            }
            if (!StringUtils.isEmpty((CharSequence)TvShowEditorDialog.this.lblPoster.getImageUrl()) && !TvShowEditorDialog.this.lblPoster.getImageUrl().equals(TvShowEditorDialog.this.tvShowToEdit.getArtworkUrl(MediaFileType.POSTER))) {
                TvShowEditorDialog.this.tvShowToEdit.setArtworkUrl(TvShowEditorDialog.this.lblPoster.getImageUrl(), MediaFileType.POSTER);
                TvShowEditorDialog.this.tvShowToEdit.downloadArtwork(MediaFileType.POSTER);
            }
            if (!StringUtils.isEmpty((CharSequence)TvShowEditorDialog.this.lblFanart.getImageUrl()) && !TvShowEditorDialog.this.lblFanart.getImageUrl().equals(TvShowEditorDialog.this.tvShowToEdit.getArtworkUrl(MediaFileType.FANART))) {
                TvShowEditorDialog.this.tvShowToEdit.setArtworkUrl(TvShowEditorDialog.this.lblFanart.getImageUrl(), MediaFileType.FANART);
                TvShowEditorDialog.this.tvShowToEdit.downloadArtwork(MediaFileType.FANART);
            }
            if (!StringUtils.isEmpty((CharSequence)TvShowEditorDialog.this.lblBanner.getImageUrl()) && !TvShowEditorDialog.this.lblBanner.getImageUrl().equals(TvShowEditorDialog.this.tvShowToEdit.getArtworkUrl(MediaFileType.BANNER))) {
                TvShowEditorDialog.this.tvShowToEdit.setArtworkUrl(TvShowEditorDialog.this.lblBanner.getImageUrl(), MediaFileType.BANNER);
                TvShowEditorDialog.this.tvShowToEdit.downloadArtwork(MediaFileType.BANNER);
            }
            if (!StringUtils.isEmpty((CharSequence)TvShowEditorDialog.this.lblLogo.getImageUrl()) && !TvShowEditorDialog.this.lblLogo.getImageUrl().equals(TvShowEditorDialog.this.tvShowToEdit.getArtworkUrl(MediaFileType.LOGO))) {
                TvShowEditorDialog.this.tvShowToEdit.setArtworkUrl(TvShowEditorDialog.this.lblLogo.getImageUrl(), MediaFileType.LOGO);
                TvShowEditorDialog.this.tvShowToEdit.downloadArtwork(MediaFileType.LOGO);
            }
            if (!StringUtils.isEmpty((CharSequence)TvShowEditorDialog.this.lblClearlogo.getImageUrl()) && !TvShowEditorDialog.this.lblClearlogo.getImageUrl().equals(TvShowEditorDialog.this.tvShowToEdit.getArtworkUrl(MediaFileType.CLEARLOGO))) {
                TvShowEditorDialog.this.tvShowToEdit.setArtworkUrl(TvShowEditorDialog.this.lblClearlogo.getImageUrl(), MediaFileType.CLEARLOGO);
                TvShowEditorDialog.this.tvShowToEdit.downloadArtwork(MediaFileType.CLEARLOGO);
            }
            if (!StringUtils.isEmpty((CharSequence)TvShowEditorDialog.this.lblClearart.getImageUrl()) && !TvShowEditorDialog.this.lblClearart.getImageUrl().equals(TvShowEditorDialog.this.tvShowToEdit.getArtworkUrl(MediaFileType.CLEARART))) {
                TvShowEditorDialog.this.tvShowToEdit.setArtworkUrl(TvShowEditorDialog.this.lblClearart.getImageUrl(), MediaFileType.CLEARART);
                TvShowEditorDialog.this.tvShowToEdit.downloadArtwork(MediaFileType.CLEARART);
            }
            if (!StringUtils.isEmpty((CharSequence)TvShowEditorDialog.this.lblThumb.getImageUrl()) && !TvShowEditorDialog.this.lblThumb.getImageUrl().equals(TvShowEditorDialog.this.tvShowToEdit.getArtworkUrl(MediaFileType.THUMB))) {
                TvShowEditorDialog.this.tvShowToEdit.setArtworkUrl(TvShowEditorDialog.this.lblThumb.getImageUrl(), MediaFileType.THUMB);
                TvShowEditorDialog.this.tvShowToEdit.downloadArtwork(MediaFileType.THUMB);
            }
            TvShowEditorDialog.this.tvShowToEdit.setProductionCompany(TvShowEditorDialog.this.tfStudio.getText());
            TvShowEditorDialog.this.tvShowToEdit.setActors(TvShowEditorDialog.this.actors);
            TvShowEditorDialog.this.tvShowToEdit.setGenres(TvShowEditorDialog.this.genres);
            TvShowEditorDialog.this.tvShowToEdit.setTags(TvShowEditorDialog.this.tags);
            TvShowEditorDialog.this.tvShowToEdit.setDateAdded((Date)TvShowEditorDialog.this.spDateAdded.getValue());
            TvShowEditorDialog.this.tvShowToEdit.setFirstAired(TvShowEditorDialog.this.dpPremiered.getDate());
            TvShowEditorDialog.this.tvShowToEdit.setStatus(TvShowEditorDialog.this.cbStatus.getSelectedItem().toString());
            double tempRating = (Double)TvShowEditorDialog.this.spRating.getValue();
            float rating = (float)tempRating;
            if (TvShowEditorDialog.this.tvShowToEdit.getRating() != rating) {
                TvShowEditorDialog.this.tvShowToEdit.setRating(rating);
                TvShowEditorDialog.this.tvShowToEdit.setVotes(1);
            }
            for (int i = TvShowEditorDialog.this.tvShowToEdit.getEpisodeCount() - 1; i >= 0; --i) {
                boolean found = false;
                TvShowEpisode episode = TvShowEditorDialog.this.tvShowToEdit.getEpisodes().get(i);
                for (TvShowEpisodeEditorContainer container : TvShowEditorDialog.this.episodes) {
                    if (container.tvShowEpisode != episode) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                TvShowEditorDialog.this.tvShowToEdit.removeEpisode(episode);
            }
            for (TvShowEpisodeEditorContainer container : TvShowEditorDialog.this.episodes) {
                boolean found = false;
                boolean shouldStore = false;
                if (container.dvdOrder != container.tvShowEpisode.isDvdOrder()) {
                    container.tvShowEpisode.setDvdOrder(container.dvdOrder);
                    shouldStore = true;
                }
                if (container.episode != container.tvShowEpisode.getEpisode()) {
                    if (container.dvdOrder) {
                        container.tvShowEpisode.setDvdEpisode(container.episode);
                    } else {
                        container.tvShowEpisode.setAiredEpisode(container.episode);
                    }
                    shouldStore = true;
                }
                if (container.season != container.tvShowEpisode.getSeason()) {
                    if (container.dvdOrder) {
                        container.tvShowEpisode.setDvdSeason(container.season);
                    } else {
                        container.tvShowEpisode.setAiredSeason(container.season);
                    }
                    shouldStore = true;
                }
                for (TvShowEpisode episode : TvShowEditorDialog.this.tvShowToEdit.getEpisodes()) {
                    if (container.tvShowEpisode != episode) continue;
                    found = true;
                    break;
                }
                if (!found) {
                    container.tvShowEpisode.writeNFO();
                    container.tvShowEpisode.saveToDb();
                    TvShowEditorDialog.this.tvShowToEdit.addEpisode(container.tvShowEpisode);
                    continue;
                }
                if (!shouldStore) continue;
                container.tvShowEpisode.writeNFO();
                container.tvShowEpisode.saveToDb();
            }
            TvShowEditorDialog.this.tvShowToEdit.writeNFO();
            TvShowEditorDialog.this.tvShowToEdit.saveToDb();
            if (TvShowModuleManager.SETTINGS.getSyncTrakt()) {
                SyncTraktTvTask task = new SyncTraktTvTask(null, Arrays.asList(TvShowEditorDialog.this.tvShowToEdit));
                TmmTaskManager.getInstance().addUnnamedTask(task);
            }
            TvShowEditorDialog.this.setVisible(false);
        }
    }
}

