/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.tvshows.actions;

import java.awt.event.ActionEvent;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.AbstractAction;
import javax.swing.JOptionPane;
import org.tinymediamanager.core.threading.TmmTaskManager;
import org.tinymediamanager.core.tvshow.entities.TvShow;
import org.tinymediamanager.core.tvshow.tasks.TvShowUpdateDatasourceTask2;
import org.tinymediamanager.ui.IconManager;
import org.tinymediamanager.ui.UTF8Control;
import org.tinymediamanager.ui.tvshows.TvShowUIModule;

public class TvShowUpdateAction
extends AbstractAction {
    private static final long serialVersionUID = 7216738427209633666L;
    private static final ResourceBundle BUNDLE = ResourceBundle.getBundle("messages", new UTF8Control());

    public TvShowUpdateAction() {
        this.putValue("Name", BUNDLE.getString("tvshow.update"));
        this.putValue("SwingLargeIconKey", IconManager.REFRESH);
        this.putValue("SmallIcon", IconManager.REFRESH);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        List<TvShow> selectedTvShows = TvShowUIModule.getInstance().getSelectionModel().getSelectedTvShows();
        ArrayList<Path> tvShowFolders = new ArrayList<Path>();
        if (selectedTvShows.isEmpty()) {
            return;
        }
        for (TvShow tvShow : selectedTvShows) {
            tvShowFolders.add(tvShow.getPathNIO());
        }
        TvShowUpdateDatasourceTask2 task = new TvShowUpdateDatasourceTask2(tvShowFolders);
        if (TmmTaskManager.getInstance().addMainTask(task)) {
            JOptionPane.showMessageDialog(null, BUNDLE.getString("onlyoneoperation"));
        }
    }
}

