/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.tvshows.actions;

import java.awt.event.ActionEvent;
import java.util.Iterator;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.AbstractAction;
import org.tinymediamanager.core.tvshow.entities.TvShow;
import org.tinymediamanager.ui.IconManager;
import org.tinymediamanager.ui.UTF8Control;
import org.tinymediamanager.ui.tvshows.TvShowUIModule;
import org.tinymediamanager.ui.tvshows.dialogs.TvShowChooserDialog;

public class TvShowSingleScrapeAction
extends AbstractAction {
    private static final long serialVersionUID = 641704453374845709L;
    private static final ResourceBundle BUNDLE = ResourceBundle.getBundle("messages", new UTF8Control());

    public TvShowSingleScrapeAction(boolean withTitle) {
        if (withTitle) {
            this.putValue("Name", BUNDLE.getString("tvshow.scrape.selected"));
        }
        this.putValue("SwingLargeIconKey", IconManager.SEARCH);
        this.putValue("SmallIcon", IconManager.SEARCH);
        this.putValue("ShortDescription", BUNDLE.getString("tvshow.scrape.selected"));
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        TvShow tvShow;
        TvShowChooserDialog chooser;
        List<TvShow> selectedTvShows = TvShowUIModule.getInstance().getSelectionModel().getSelectedTvShows();
        Iterator<TvShow> i$ = selectedTvShows.iterator();
        while (i$.hasNext() && (chooser = new TvShowChooserDialog(tvShow = i$.next(), selectedTvShows.size() > 1)).showDialog()) {
        }
    }
}

