/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.tvshows.actions;

import java.awt.event.ActionEvent;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.AbstractAction;
import org.tinymediamanager.core.threading.TmmTaskManager;
import org.tinymediamanager.core.tvshow.TvShowList;
import org.tinymediamanager.core.tvshow.entities.TvShowEpisode;
import org.tinymediamanager.core.tvshow.tasks.TvShowEpisodeScrapeTask;
import org.tinymediamanager.ui.IconManager;
import org.tinymediamanager.ui.UTF8Control;
import org.tinymediamanager.ui.tvshows.TvShowUIModule;

public class TvShowScrapeEpisodesAction
extends AbstractAction {
    private static final long serialVersionUID = -75916665265142730L;
    private static final ResourceBundle BUNDLE = ResourceBundle.getBundle("messages", new UTF8Control());
    private boolean withArtwork;

    public TvShowScrapeEpisodesAction(boolean withArtwork) {
        this.withArtwork = withArtwork;
        if (this.withArtwork) {
            this.putValue("Name", BUNDLE.getString("tvshowepisode.scrape"));
        } else {
            this.putValue("Name", BUNDLE.getString("tvshowepisode.scrape.withoutartwork"));
        }
        this.putValue("SwingLargeIconKey", IconManager.SEARCH);
        this.putValue("SmallIcon", IconManager.SEARCH);
    }

    @Override
    public void actionPerformed(ActionEvent arg0) {
        List<TvShowEpisode> episodes = TvShowUIModule.getInstance().getSelectionModel().getSelectedEpisodes();
        TvShowEpisodeScrapeTask task = new TvShowEpisodeScrapeTask(episodes, TvShowList.getInstance().getDefaultMediaScraper(), this.withArtwork);
        TmmTaskManager.getInstance().addUnnamedTask(task);
    }
}

