/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.tvshows.actions;

import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.AbstractAction;
import javax.swing.JOptionPane;
import org.tinymediamanager.core.tvshow.TvShowList;
import org.tinymediamanager.core.tvshow.entities.TvShow;
import org.tinymediamanager.core.tvshow.entities.TvShowEpisode;
import org.tinymediamanager.core.tvshow.entities.TvShowSeason;
import org.tinymediamanager.ui.IconManager;
import org.tinymediamanager.ui.MainWindow;
import org.tinymediamanager.ui.UTF8Control;
import org.tinymediamanager.ui.tvshows.TvShowUIModule;

public class TvShowDeleteAction
extends AbstractAction {
    private static final long serialVersionUID = -2355545751433709417L;
    private static final ResourceBundle BUNDLE = ResourceBundle.getBundle("messages", new UTF8Control());

    public TvShowDeleteAction(boolean withTitle) {
        if (withTitle) {
            this.putValue("Name", BUNDLE.getString("tvshow.delete"));
        }
        this.putValue("SwingLargeIconKey", IconManager.DELETE);
        this.putValue("SmallIcon", IconManager.DELETE);
        this.putValue("ShortDescription", BUNDLE.getString("tvshow.delete.hint"));
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        List<Object> selectedObjects = TvShowUIModule.getInstance().getSelectionModel().getSelectedObjects();
        int answer = JOptionPane.showConfirmDialog(MainWindow.getActiveInstance(), BUNDLE.getString("tvshow.delete.desc"), BUNDLE.getString("tvshow.delete"), 0);
        if (answer != 0) {
            return;
        }
        for (Object obj : selectedObjects) {
            if (obj instanceof TvShow) {
                TvShow tvShow = (TvShow)obj;
                TvShowList.getInstance().deleteTvShow(tvShow);
            }
            if (obj instanceof TvShowSeason) {
                TvShowSeason season = (TvShowSeason)obj;
                ArrayList<TvShowEpisode> episodes = new ArrayList<TvShowEpisode>();
                for (TvShowEpisode episode : season.getEpisodes()) {
                    episodes.add(episode);
                }
                for (TvShowEpisode episode : episodes) {
                    season.getTvShow().deleteEpisode(episode);
                }
            }
            if (!(obj instanceof TvShowEpisode)) continue;
            TvShowEpisode tvShowEpisode = (TvShowEpisode)obj;
            tvShowEpisode.getTvShow().deleteEpisode(tvShowEpisode);
        }
    }
}

