/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.tvshows.actions;

import java.awt.event.ActionEvent;
import java.util.HashMap;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.AbstractAction;
import org.apache.commons.lang3.StringUtils;
import org.tinymediamanager.core.tvshow.TvShowList;
import org.tinymediamanager.core.tvshow.entities.TvShowSeason;
import org.tinymediamanager.scraper.entities.MediaType;
import org.tinymediamanager.ui.IconManager;
import org.tinymediamanager.ui.MainWindow;
import org.tinymediamanager.ui.UTF8Control;
import org.tinymediamanager.ui.components.ImageLabel;
import org.tinymediamanager.ui.dialogs.ImageChooserDialog;
import org.tinymediamanager.ui.tvshows.TvShowUIModule;

public class TvShowChangeSeasonPosterAction
extends AbstractAction {
    private static final long serialVersionUID = 8356413227405772558L;
    private static final ResourceBundle BUNDLE = ResourceBundle.getBundle("messages", new UTF8Control());

    public TvShowChangeSeasonPosterAction(boolean withTitle) {
        if (withTitle) {
            this.putValue("Name", BUNDLE.getString("tvshow.changeseasonposter"));
        }
        this.putValue("SwingLargeIconKey", IconManager.EDIT);
        this.putValue("SmallIcon", IconManager.EDIT);
        this.putValue("ShortDescription", BUNDLE.getString("tvshow.changeseasonposter"));
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        List<Object> selectedObjects = TvShowUIModule.getInstance().getSelectionModel().getSelectedObjects();
        for (Object obj : selectedObjects) {
            if (!(obj instanceof TvShowSeason)) continue;
            TvShowSeason season = (TvShowSeason)obj;
            ImageLabel imageLabel = new ImageLabel();
            HashMap<String, Object> ids = season.getTvShow().getIds();
            ids.put("tvShowSeason", season.getSeason());
            ImageChooserDialog dialog = new ImageChooserDialog(ids, ImageChooserDialog.ImageType.SEASON, TvShowList.getInstance().getAvailableArtworkScrapers(), imageLabel, null, null, MediaType.TV_SHOW);
            dialog.setLocationRelativeTo(MainWindow.getActiveInstance());
            dialog.setVisible(true);
            if (!StringUtils.isNotBlank((CharSequence)imageLabel.getImageUrl())) continue;
            season.setPosterUrl(imageLabel.getImageUrl());
            season.getTvShow().downloadSeasonPoster(season.getSeason());
        }
    }
}

